/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifySounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LeafSheepEntity
extends WaterAnimal
implements GeoEntity,
Bucketable {
    private static final double CLIMB_SPEED = 0.1;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private Vec3 prevPosition = Vec3.f_82478_;
    private double actualMovementSpeed = 0.0;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private BlockPos lastClimbPos;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(LeafSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(LeafSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public LeafSheepEntity(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new WaterBoundRandomStrollGoal(this, 1.0));
    }

    public static boolean canSpawn(EntityType<LeafSheepEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_6425_(pos).m_205070_(FluidTags.f_13131_) && pos.m_123342_() >= world.m_5736_() - 64 && pos.m_123342_() <= world.m_5736_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public void m_8119_() {
        BlockPos currentPos;
        boolean shouldClimb;
        super.m_8119_();
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.f_19862_ && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.isClimbing()) {
            currentPos = this.m_20183_();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.m_9236_().f_46443_) {
                    this.f_21344_.m_26573_();
                    this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
                }
            } else if (this.f_19862_) {
                boolean hasBlockAbove;
                Vec3 deltaMovement = this.m_20184_();
                boolean shouldApplyClimbMovement = true;
                if (this.m_20096_() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.m_20334_(deltaMovement.f_82479_, 0.1, deltaMovement.f_82481_);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.m_20182_();
        this.actualMovementSpeed = currentPos.m_82554_(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(shouldClimb);
        }
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_ && this.m_20069_() && this.isCollidingWithBlock());
        }
        if (!this.m_20069_()) {
            this.m_20301_(this.m_20146_() - 1);
            if (this.m_20146_() <= -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_9236_().m_269111_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isClimbing() && this.m_20069_()) {
            Vec3 reducedVector = travelVector.m_82490_(0.4);
            super.m_7023_(reducedVector);
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.LEAFSHEEP_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.LEAFSHEEP_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<LeafSheepEntity> event) {
        boolean climbing = this.isClimbing();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.m_20096_();
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("PosX", this.m_20185_());
        tag.m_128347_("PosY", this.m_20186_());
        tag.m_128347_("PosZ", this.m_20189_());
        tag.m_128379_("FromBucket", this.m_27487_());
        tag.m_128405_("ClimbingTime", this.climbingTime);
        tag.m_128405_("ClimbCooldown", this.climbCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.climbingTime = tag.m_128451_("ClimbingTime");
        this.climbCooldown = tag.m_128451_("ClimbCooldown");
        if (tag.m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ")) {
            double posX = tag.m_128459_("PosX");
            double posY = tag.m_128459_("PosY");
            double posZ = tag.m_128459_("PosZ");
            this.m_6034_(posX, posY, posZ);
        }
        this.m_27497_(tag.m_128471_("FromBucket"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(ItemStack bucket) {
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FaunifyItems.LEAF_SHEEP_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean isActuallyMoving() {
        Vec3 delta = this.m_20184_();
        double horizontalSpeed = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return true;
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean bl = hasAdjacentAtCurrentLevel = !this.m_9236_().m_8055_(north).m_60795_() && !this.m_9236_().m_8055_(north).m_247087_() || !this.m_9236_().m_8055_(south).m_60795_() && !this.m_9236_().m_8055_(south).m_247087_() || !this.m_9236_().m_8055_(east).m_60795_() && !this.m_9236_().m_8055_(east).m_247087_() || !this.m_9236_().m_8055_(west).m_60795_() && !this.m_9236_().m_8055_(west).m_247087_();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockPos northBelow = posBelow.m_122012_();
        BlockPos southBelow = posBelow.m_122019_();
        BlockPos eastBelow = posBelow.m_122029_();
        BlockPos westBelow = posBelow.m_122024_();
        return !this.m_9236_().m_8055_(northBelow).m_60795_() && !this.m_9236_().m_8055_(northBelow).m_247087_() || !this.m_9236_().m_8055_(southBelow).m_60795_() && !this.m_9236_().m_8055_(southBelow).m_247087_() || !this.m_9236_().m_8055_(eastBelow).m_60795_() && !this.m_9236_().m_8055_(eastBelow).m_247087_() || !this.m_9236_().m_8055_(westBelow).m_60795_() && !this.m_9236_().m_8055_(westBelow).m_247087_();
    }

    static class WaterBoundRandomStrollGoal
    extends RandomStrollGoal {
        private final LeafSheepEntity leafSheep;

        public WaterBoundRandomStrollGoal(LeafSheepEntity mob, double speedModifier) {
            super((PathfinderMob)mob, speedModifier);
            this.leafSheep = mob;
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)7);
            for (int i = 0; vec3 != null && i < 10; ++i) {
                BlockPos targetPos = BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_);
                if (this.leafSheep.m_9236_().m_6425_(targetPos).m_205070_(FluidTags.f_13131_)) {
                    return vec3;
                }
                vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)7);
            }
            return null;
        }
    }
}

