/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.BeeflyEntity;
import com.pepper.faunify.entity.BeetleEntity;
import com.pepper.faunify.entity.GrasshopperEntity;
import com.pepper.faunify.entity.LacewingEntity;
import com.pepper.faunify.entity.LadybugEntity;
import com.pepper.faunify.entity.LeafInsectEntity;
import com.pepper.faunify.entity.MillipedeBodyEntity;
import com.pepper.faunify.entity.MillipedeHeadEntity;
import com.pepper.faunify.entity.MillipedeTailEntity;
import com.pepper.faunify.entity.RolyPolyEntity;
import com.pepper.faunify.entity.SilkMothEntity;
import com.pepper.faunify.entity.SilkwormEntity;
import com.pepper.faunify.entity.StickbugEntity;
import com.pepper.faunify.entity.WeevilEntity;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MantisEntity
extends Animal
implements GeoEntity {
    private static final int ATTACK_ANIMATION_DURATION = 10;
    private static final int ATTACK_HIT_DELAY = 10;
    private static final float BUOYANCY = 0.03f;
    private static final double CLIMB_SPEED = 0.04;
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(MantisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ORCHID_VARIANT = SynchedEntityData.m_135353_(MantisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(MantisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(MantisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STALKING = SynchedEntityData.m_135353_(MantisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int attackAnimationTick = 0;
    private Entity pendingAttackTarget = null;

    public MantisEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new StalkGoal(this, 0.6, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new GroundLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, BeetleEntity.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LadybugEntity.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, SilkMothEntity.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, SilkwormEntity.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, WeevilEntity.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LacewingEntity.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, StickbugEntity.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, LeafInsectEntity.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, GrasshopperEntity.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, BeeflyEntity.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, RolyPolyEntity.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, MillipedeHeadEntity.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, MillipedeBodyEntity.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, MillipedeTailEntity.class, true));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Bee.class, true));
    }

    public static boolean canSpawn(EntityType<MantisEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(Variant.GREEN);
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (this.isInCherryGrove()) {
            this.setOrchidVariant(true);
        } else {
            this.setOrchidVariant(false);
        }
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.03f, motion.f_82481_);
        }
        if (this.isClimbing() && this.f_19862_) {
            boolean hasBlockAbove;
            Vec3 deltaMovement = this.m_20184_();
            boolean shouldApplyClimbMovement = true;
            if (this.m_20096_() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                shouldApplyClimbMovement = false;
            }
            if (shouldApplyClimbMovement) {
                this.m_20334_(deltaMovement.f_82479_, 0.04, deltaMovement.f_82481_);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_ && this.isCollidingWithBlock());
            LivingEntity target = this.m_5448_();
            boolean shouldStalk = target != null && (double)this.m_20270_((Entity)target) > 2.0 && !this.isAttacking();
            this.setStalking(shouldStalk);
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
            if (this.attackAnimationTick == 0 && this.pendingAttackTarget != null) {
                this.m_5496_((SoundEvent)FaunifySounds.MANTIS_ATTACK.get(), 1.0f, 1.0f);
                this.pendingAttackTarget.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                this.pendingAttackTarget = null;
            }
            if (this.attackAnimationTick == 0) {
                this.setAttacking(false);
                this.pendingAttackTarget = null;
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isClimbing()) {
            Vec3 reducedVector = travelVector.m_82490_(0.4);
            super.m_7023_(reducedVector);
        } else {
            super.m_7023_(travelVector);
        }
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    public boolean m_7327_(Entity target) {
        this.setAttacking(true);
        this.attackAnimationTick = 10;
        this.pendingAttackTarget = target;
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_6710_((LivingEntity)player);
        }
        return result;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "armController", 3, this::armPredicate)});
    }

    private PlayState predicate(AnimationState<MantisEntity> event) {
        boolean moving = this.isActuallyMoving();
        boolean climbing = this.isClimbing();
        if (this.isAttacking()) {
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (event.getController().getAnimationState() == AnimationController.State.RUNNING && event.getController().getCurrentAnimation() != null && event.getController().getCurrentAnimation().animation().name().equals("attack")) {
            return PlayState.CONTINUE;
        }
        if (this.isStalking()) {
            event.getController().setAnimation(RawAnimation.begin().then("sneak", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (climbing || moving) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState armPredicate(AnimationState<MantisEntity> event) {
        if (this.isAttacking()) {
            event.getController().setAnimation(RawAnimation.begin().then("attackarms", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (event.getController().getAnimationState() == AnimationController.State.RUNNING && event.getController().getCurrentAnimation() != null && event.getController().getCurrentAnimation().animation().name().equals("attackarms")) {
            return PlayState.CONTINUE;
        }
        if (this.isStalking()) {
            event.getController().setAnimation(RawAnimation.begin().then("sneakarms", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("IsOrchidVariant", ((Boolean)this.f_19804_.m_135370_(ORCHID_VARIANT)).booleanValue());
        tag.m_128379_("Attacking", this.isAttacking());
        tag.m_128379_("Stalking", this.isStalking());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.f_19804_.m_135381_(ORCHID_VARIANT, (Object)tag.m_128471_("IsOrchidVariant"));
        this.setAttacking(tag.m_128471_("Attacking"));
        this.setStalking(tag.m_128471_("Stalking"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ORCHID_VARIANT, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(STALKING, (Object)false);
    }

    public boolean m_6094_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isInCherryGrove() {
        Holder biomeHolder = this.m_9236_().m_204166_(this.m_20183_());
        return biomeHolder.m_203565_(Biomes.f_271432_);
    }

    public boolean isOrchidVariant() {
        return this.f_19804_.m_135370_(ORCHID_VARIANT) != null && (Boolean)this.f_19804_.m_135370_(ORCHID_VARIANT) != false;
    }

    public void setOrchidVariant(boolean isOrchid) {
        this.f_19804_.m_135381_(ORCHID_VARIANT, (Object)isOrchid);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    public boolean isActuallyMoving() {
        return this.m_20184_().m_165924_() > 0.003;
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isStalking() {
        return (Boolean)this.f_19804_.m_135370_(STALKING);
    }

    public void setStalking(boolean stalking) {
        this.f_19804_.m_135381_(STALKING, (Object)stalking);
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return true;
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean bl = hasAdjacentAtCurrentLevel = !this.m_9236_().m_8055_(north).m_60795_() && !this.m_9236_().m_8055_(north).m_247087_() || !this.m_9236_().m_8055_(south).m_60795_() && !this.m_9236_().m_8055_(south).m_247087_() || !this.m_9236_().m_8055_(east).m_60795_() && !this.m_9236_().m_8055_(east).m_247087_() || !this.m_9236_().m_8055_(west).m_60795_() && !this.m_9236_().m_8055_(west).m_247087_();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockPos northBelow = posBelow.m_122012_();
        BlockPos southBelow = posBelow.m_122019_();
        BlockPos eastBelow = posBelow.m_122029_();
        BlockPos westBelow = posBelow.m_122024_();
        return !this.m_9236_().m_8055_(northBelow).m_60795_() && !this.m_9236_().m_8055_(northBelow).m_247087_() || !this.m_9236_().m_8055_(southBelow).m_60795_() && !this.m_9236_().m_8055_(southBelow).m_247087_() || !this.m_9236_().m_8055_(eastBelow).m_60795_() && !this.m_9236_().m_8055_(eastBelow).m_247087_() || !this.m_9236_().m_8055_(westBelow).m_60795_() && !this.m_9236_().m_8055_(westBelow).m_247087_();
    }

    private static class StalkGoal
    extends MeleeAttackGoal {
        public StalkGoal(MantisEntity mantis, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)mantis, speedModifier, followingTargetEvenIfNotSeen);
        }

        protected double m_6639_(LivingEntity target) {
            return 2.0 + (double)target.m_20205_();
        }
    }

    public static enum Variant implements StringRepresentable
    {
        GREEN(0, "green"),
        ORCHID(1, "orchid");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

