/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.MillipedeBodyEntity;
import com.pepper.faunify.entity.MillipedeSegmentEntity;
import com.pepper.faunify.entity.MillipedeTailEntity;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MillipedeHeadEntity
extends PathfinderMob
implements GeoEntity {
    private static final int BODY_SEGMENT_COUNT = 5;
    private static final float BUOYANCY = 0.03f;
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(MillipedeHeadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(MillipedeHeadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private PathNavigation groundNavigation;
    private MillipedeSegmentEntity[] segments;
    private int segmentSpawnDelay = 0;
    public final float[] ringBuffer = new float[64];
    public int ringBufferIndex = -1;

    public MillipedeHeadEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canMillipedeSpawn(EntityType<? extends MillipedeHeadEntity> entity, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        int seaLevel;
        int yLevel = pos.m_123342_();
        if (yLevel >= (seaLevel = level.m_5736_())) {
            return false;
        }
        boolean randomCheck = random.m_188499_();
        int maxLightLevel = random.m_188503_(8);
        int actualLightLevel = level.m_46803_(pos);
        boolean lightCheck = actualLightLevel <= maxLightLevel;
        boolean mobRules = MillipedeHeadEntity.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)random);
        boolean canSpawn = randomCheck && lightCheck && mobRules;
        return canSpawn;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return super.m_5545_(worldIn, spawnReasonIn);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.segmentSpawnDelay = 5;
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        return super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19817_ = false;
        this.f_20885_ = this.f_20883_ = Mth.m_14036_((float)this.m_146908_(), (float)(this.f_20883_ - 2.0f), (float)(this.f_20883_ + 2.0f));
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.03f, motion.f_82481_);
        }
        if (this.ringBufferIndex < 0) {
            Arrays.fill(this.ringBuffer, this.f_20883_);
        }
        if (this.updateRingBuffer() || this.ringBufferIndex < 0) {
            ++this.ringBufferIndex;
        }
        if (this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        this.ringBuffer[this.ringBufferIndex] = this.m_146908_();
        if (!this.m_9236_().f_46443_) {
            if (this.shouldRebuildSegments()) {
                this.rebuildSegmentsArray();
            }
            if (this.segmentSpawnDelay > 0) {
                --this.segmentSpawnDelay;
                if (this.segmentSpawnDelay == 0) {
                    this.spawnSegments();
                }
            }
            if (this.f_19797_ > 1 && this.segments != null) {
                Vec3 prev = this.m_20182_();
                float xRot = this.m_146909_();
                float parentYRot = this.m_146908_();
                float backOffset = 0.08f;
                for (int i = 0; i < this.segments.length; ++i) {
                    if (this.segments[i] == null || !this.segments[i].m_6084_()) continue;
                    float reqRot = this.getYawForPart(i);
                    prev = this.segments[i].tickMultipartPosition(backOffset, prev, xRot, reqRot, true);
                    xRot = this.segments[i].m_146909_();
                    parentYRot = this.segments[i].m_146908_();
                    backOffset = this.segments[i].getBackOffset();
                }
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        return this.groundNavigation;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || super.m_6673_(source);
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<MillipedeHeadEntity> event) {
        boolean isMoving;
        boolean bl = isMoving = this.m_20184_().m_165925_() > 1.0E-4;
        if (isMoving && this.m_20096_()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        UUID childId = this.getChildId();
        if (childId != null) {
            tag.m_128362_("ChildUUID", childId);
        }
        tag.m_128405_("Variant", this.getVariant().id);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("ChildUUID")) {
            UUID childUUID = tag.m_128342_("ChildUUID");
            this.f_19804_.m_135381_(CHILD_UUID, Optional.of(childUUID));
        }
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.m_9236_().f_46443_ && this.segments != null) {
            for (MillipedeSegmentEntity segment : this.segments) {
                if (segment == null) continue;
                segment.m_146870_();
            }
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity entity) {
        MillipedeSegmentEntity segment;
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfThisMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.m_7324_(entity);
    }

    public void m_7334_(Entity entity) {
        MillipedeSegmentEntity segment;
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfThisMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.m_7334_(entity);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    private boolean updateRingBuffer() {
        return this.m_20184_().m_82556_() >= 0.005;
    }

    private float getYawForPart(int i) {
        return this.getRingBuffer(4 + i * 4, 1.0f);
    }

    public float getRingBuffer(int bufferOffset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int bufferIndex = this.ringBufferIndex - bufferOffset & 0x3F;
        int j = this.ringBufferIndex - bufferOffset - 1 & 0x3F;
        float d0 = this.ringBuffer[bufferIndex];
        float d1 = this.ringBuffer[j] - d0;
        return Mth.m_14177_((float)(d0 + d1 * partialTicks));
    }

    private void spawnSegments() {
        if (this.m_9236_().f_46443_ || this.segments != null) {
            return;
        }
        PathfinderMob partParent = this;
        this.segments = new MillipedeSegmentEntity[6];
        Vec3 prevPos = this.m_20182_();
        float backOffset = 0.3f;
        float parentYRot = this.m_146908_();
        float parentXRot = this.m_146909_();
        for (int i = 0; i < 5; ++i) {
            MillipedeBodyEntity bodySegment = new MillipedeBodyEntity((EntityType<MillipedeBodyEntity>)((EntityType)FaunifyEntities.MILLIPEDE_BODY.get()), this.m_9236_());
            bodySegment.setParentSegment((Entity)partParent);
            bodySegment.setBodyIndex(i);
            if (partParent == this) {
                bodySegment.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.setChildId(bodySegment.m_20148_());
            }
            if (partParent instanceof MillipedeSegmentEntity) {
                MillipedeSegmentEntity prevSegment = (MillipedeSegmentEntity)partParent;
                prevSegment.setChildId(bodySegment.m_20148_());
            }
            bodySegment.m_146884_(bodySegment.tickMultipartPosition(backOffset, prevPos, parentXRot, parentYRot, false));
            this.m_9236_().m_7967_((Entity)bodySegment);
            this.segments[i] = bodySegment;
            partParent = bodySegment;
            backOffset = bodySegment.getBackOffset();
            prevPos = bodySegment.m_20182_();
            parentYRot = bodySegment.m_146908_();
            parentXRot = bodySegment.m_146909_();
        }
        MillipedeTailEntity tailSegment = new MillipedeTailEntity((EntityType<MillipedeTailEntity>)((EntityType)FaunifyEntities.MILLIPEDE_TAIL.get()), this.m_9236_());
        tailSegment.setParentSegment((Entity)partParent);
        tailSegment.setBodyIndex(5);
        if (partParent instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity prevSegment = (MillipedeSegmentEntity)partParent;
            prevSegment.setChildId(tailSegment.m_20148_());
        }
        tailSegment.m_146884_(tailSegment.tickMultipartPosition(backOffset, prevPos, this.m_146909_(), parentYRot, false));
        this.m_9236_().m_7967_((Entity)tailSegment);
        this.segments[5] = tailSegment;
    }

    private boolean shouldRebuildSegments() {
        if (this.segmentSpawnDelay > 0) {
            return false;
        }
        if (this.segments == null) {
            return this.getChildId() != null;
        }
        if (this.segments.length != 6) {
            return true;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] != null && this.segments[i].m_6084_()) continue;
            return true;
        }
        return false;
    }

    private void rebuildSegmentsArray() {
        this.segments = new MillipedeSegmentEntity[6];
        UUID childId = this.getChildId();
        if (childId == null || this.m_9236_().f_46443_) {
            return;
        }
        Entity current = ((ServerLevel)this.m_9236_()).m_8791_(childId);
        if (current == null) {
            return;
        }
        int index = 0;
        while (current instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
            if (index >= this.segments.length) break;
            this.segments[index] = segment;
            segment.setParentSegment((Entity)(index == 0 ? this : this.segments[index - 1]));
            ++index;
            UUID nextChildId = segment.getChildId();
            if (nextChildId != null && (current = ((ServerLevel)this.m_9236_()).m_8791_(nextChildId)) != null) continue;
            break;
        }
    }

    private boolean isPartOfThisMillipede(MillipedeSegmentEntity segment) {
        if (this.segments == null) {
            return false;
        }
        for (MillipedeSegmentEntity s : this.segments) {
            if (s != segment) continue;
            return true;
        }
        return false;
    }

    public static enum Variant implements StringRepresentable
    {
        GIANT(0, "giant"),
        TWISTEDCLAW(1, "twistedclaw"),
        NARCEUS(2, "narceus");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

