/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.MillipedeHeadEntity;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;

public abstract class MillipedeSegmentEntity
extends PathfinderMob
implements GeoEntity {
    private static final float WATER_BUOYANCY = 0.03f;
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(MillipedeSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(MillipedeSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> BODY_XROT = SynchedEntityData.m_135353_(MillipedeSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> BODY_INDEX = SynchedEntityData.m_135353_(MillipedeSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Entity parentSegment;
    private double prevHeight = 0.0;
    private float smoothedPitch = 0.0f;

    public MillipedeSegmentEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.f_19794_ = false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(Vec3.f_82478_);
        this.f_19817_ = false;
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            if (motion.f_82480_ <= 0.05) {
                this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.03f, motion.f_82481_);
            }
        }
        if (this.f_19797_ > 1) {
            Entity parent = this.getParentSegment();
            if (parent != null && !this.m_9236_().f_46443_) {
                if (parent instanceof LivingEntity) {
                    LivingEntity parentEntity = (LivingEntity)parent;
                    if (parentEntity.f_20916_ > 0 || parentEntity.f_20919_ > 0) {
                        this.f_20916_ = parentEntity.f_20916_;
                        this.f_20919_ = parentEntity.f_20919_;
                    }
                }
                if (parent.m_213877_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else if (!this.m_9236_().f_46443_ && this.f_19797_ > 20) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268613_) || super.m_6673_(source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity parent = this.getParentSegment();
        if (parent instanceof Mob) {
            Mob mob = (Mob)parent;
            return mob.m_6469_(source, amount);
        }
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        UUID childId;
        super.m_7380_(tag);
        UUID parentId = ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
        if (parentId != null) {
            tag.m_128362_("ParentUUID", parentId);
        }
        if ((childId = (UUID)((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null)) != null) {
            tag.m_128362_("ChildUUID", childId);
        }
        tag.m_128405_("BodyIndex", this.getBodyIndex());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("ParentUUID")) {
            this.f_19804_.m_135381_(PARENT_UUID, Optional.of(tag.m_128342_("ParentUUID")));
        }
        if (tag.m_128403_("ChildUUID")) {
            this.f_19804_.m_135381_(CHILD_UUID, Optional.of(tag.m_128342_("ChildUUID")));
        }
        this.setBodyIndex(tag.m_128451_("BodyIndex"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(BODY_XROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BODY_INDEX, (Object)0);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public float m_146909_() {
        return ((Float)this.f_19804_.m_135370_(BODY_XROT)).floatValue();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    protected void m_7324_(Entity entity) {
        MillipedeSegmentEntity segment;
        MillipedeHeadEntity head;
        if (entity instanceof MillipedeHeadEntity && this.isPartOfMillipede(head = (MillipedeHeadEntity)entity)) {
            return;
        }
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfSameMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.m_7324_(entity);
    }

    public void m_7334_(Entity entity) {
        MillipedeSegmentEntity segment;
        MillipedeHeadEntity head;
        if (entity instanceof MillipedeHeadEntity && this.isPartOfMillipede(head = (MillipedeHeadEntity)entity)) {
            return;
        }
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfSameMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.m_7334_(entity);
    }

    public void setParentSegment(Entity parent) {
        this.parentSegment = parent;
        if (parent != null) {
            this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(parent.m_20148_()));
        }
    }

    @Nullable
    public Entity getParentSegment() {
        if (this.parentSegment != null && this.parentSegment.m_6084_()) {
            return this.parentSegment;
        }
        UUID parentId = ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
        if (parentId != null) {
            if (this.m_9236_().f_46443_) {
                List entities = this.m_9236_().m_6249_((Entity)null, this.m_20191_().m_82400_(50.0), entity -> entity.m_20148_().equals(parentId));
                Iterator iterator = entities.iterator();
                if (iterator.hasNext()) {
                    Entity entity2;
                    this.parentSegment = entity2 = (Entity)iterator.next();
                    return entity2;
                }
            } else {
                Entity parent = ((ServerLevel)this.m_9236_()).m_8791_(parentId);
                if (parent != null && parent.m_6084_()) {
                    this.parentSegment = parent;
                    return parent;
                }
            }
        }
        return null;
    }

    public MillipedeHeadEntity.Variant getMillipedeVariant() {
        MillipedeHeadEntity head = this.getMillipedeHead();
        if (head != null) {
            return head.getVariant();
        }
        return MillipedeHeadEntity.Variant.GIANT;
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public void setBodyIndex(int index) {
        this.f_19804_.m_135381_(BODY_INDEX, (Object)index);
    }

    public int getBodyIndex() {
        return (Integer)this.f_19804_.m_135370_(BODY_INDEX);
    }

    public Vec3 tickMultipartPosition(float parentOffset, Vec3 parentPosition, float parentXRot, float parentYRot, boolean doHeight) {
        boolean parentInWater = false;
        Entity parent = this.getParentSegment();
        if (parent instanceof LivingEntity) {
            LivingEntity livingParent = (LivingEntity)parent;
            parentInWater = livingParent.m_20069_();
        }
        float yDif = doHeight && !parentInWater ? 1.0f - 0.95f * (float)Math.min(Math.abs(parentPosition.f_82480_ - this.m_20186_()), 1.0) : 1.0f;
        float segmentSpacing = (this.getBackOffset() + 0.5f * this.m_20205_()) * this.m_6134_();
        Vec3 parentButt = parentPosition.m_82549_(this.calcOffsetVec(yDif * parentOffset * this.m_6134_(), 0.0f, parentYRot));
        Vec3 desiredPos = parentButt.m_82549_(this.calcOffsetVec(yDif * segmentSpacing, 0.0f, parentYRot));
        double d0 = parentButt.f_82479_ - desiredPos.f_82479_;
        double d2 = parentButt.f_82481_ - desiredPos.f_82481_;
        double horizontalDist = Math.sqrt(d0 * d0 + d2 * d2);
        Vec3 finalPos = new Vec3(desiredPos.f_82479_, desiredPos.f_82480_, desiredPos.f_82481_);
        if (doHeight && !this.m_20069_() && !parentInWater) {
            double heightCheck;
            double groundCheck;
            double checkY = finalPos.f_82480_;
            if (this.isOpaqueBlockAt(finalPos.f_82479_, checkY + 0.1, finalPos.f_82481_)) {
                for (groundCheck = 0.0; groundCheck < 1.0 && this.isOpaqueBlockAt(finalPos.f_82479_, checkY + groundCheck, finalPos.f_82481_); groundCheck += 0.1) {
                }
            } else {
                double airGap;
                for (airGap = 0.0; airGap < 1.0 && !this.isOpaqueBlockAt(finalPos.f_82479_, checkY - airGap - 0.1, finalPos.f_82481_); airGap += 0.1) {
                }
                if (airGap > 0.5) {
                    groundCheck = -Math.min(airGap - 0.3, 0.3);
                }
            }
            double segmentHeight = this.m_20206_();
            boolean hasVerticalClearance = true;
            for (heightCheck = 0.2; heightCheck < segmentHeight; heightCheck += 0.2) {
                if (!this.isOpaqueBlockAt(finalPos.f_82479_, checkY + groundCheck + heightCheck, finalPos.f_82481_)) continue;
                hasVerticalClearance = false;
                break;
            }
            block3: while (!hasVerticalClearance && groundCheck > -1.0) {
                groundCheck -= 0.1;
                hasVerticalClearance = true;
                for (heightCheck = 0.2; heightCheck < segmentHeight; heightCheck += 0.2) {
                    if (!this.isOpaqueBlockAt(finalPos.f_82479_, checkY + groundCheck + heightCheck, finalPos.f_82481_)) continue;
                    hasVerticalClearance = false;
                    continue block3;
                }
            }
            double heightDiff = groundCheck - this.prevHeight;
            this.prevHeight = Math.abs(heightDiff) > 0.2 ? (this.prevHeight += Mth.m_14008_((double)heightDiff, (double)-0.05, (double)0.05)) : (this.prevHeight += heightDiff * 0.5);
            if (Math.abs(groundCheck) < 0.1 && Math.abs(this.prevHeight) > 0.05) {
                this.prevHeight *= 0.9;
            }
            double clampedHeight = Mth.m_14008_((double)this.prevHeight, (double)-0.3f, (double)0.3f);
            finalPos = new Vec3(finalPos.f_82479_, finalPos.f_82480_ + clampedHeight, finalPos.f_82481_);
        }
        double actualVerticalDist = parentButt.f_82480_ - finalPos.f_82480_;
        float rawAngle = this.m_20069_() || parentInWater ? Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)actualVerticalDist, (double)horizontalDist) * 57.2957763671875)))) * 0.3f : Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)actualVerticalDist, (double)horizontalDist) * 57.2957763671875))));
        float parentPitch = parentXRot;
        Entity entity = this.getParentSegment();
        if (entity instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity parentSeg = (MillipedeSegmentEntity)entity;
            parentPitch = parentSeg.getSmoothedPitch();
        }
        float interpolationFactor = this.m_20069_() || parentInWater ? 0.5f : 0.3f;
        float targetPitch = Mth.m_14179_((float)interpolationFactor, (float)rawAngle, (float)parentPitch);
        float maxPitchChange = 50.0f;
        this.smoothedPitch = this.limitAngle(this.smoothedPitch, targetPitch, maxPitchChange);
        float yaw = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        this.m_146926_(this.smoothedPitch);
        this.f_19804_.m_135381_(BODY_XROT, (Object)Float.valueOf(this.smoothedPitch));
        this.m_146922_(yaw);
        this.f_20885_ = yaw;
        this.m_7678_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, yaw, this.smoothedPitch);
        Vec3 returnPos = new Vec3(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_);
        return returnPos;
    }

    public float getSmoothedPitch() {
        return this.smoothedPitch;
    }

    public float getBackOffset() {
        return 0.115f;
    }

    public double getLowPartHeight(double x, double yIn, double z) {
        double checkAt;
        if (this.isFluidAt(x, yIn, z)) {
            return 0.0;
        }
        for (checkAt = 0.0; checkAt > -0.5 && !this.isOpaqueBlockAt(x, yIn + checkAt, z); checkAt -= 0.1) {
        }
        return checkAt;
    }

    public double getHighPartHeight(double x, double yIn, double z) {
        double checkAt;
        if (this.isFluidAt(x, yIn, z)) {
            return 0.0;
        }
        for (checkAt = 0.0; checkAt <= 0.5 && this.isOpaqueBlockAt(x, yIn + checkAt, z); checkAt += 0.1) {
        }
        return checkAt;
    }

    protected Vec3 calcOffsetVec(float distance, float xRot, float yRot) {
        float f = Mth.m_14089_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = Mth.m_14089_((float)(-xRot * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-xRot * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2 * distance), (double)(f3 * distance), (double)(f * f2 * distance));
    }

    protected float limitAngle(float sourceAngle, float targetAngle, float maximumChange) {
        float f = Mth.m_14177_((float)(targetAngle - sourceAngle));
        if (f > maximumChange) {
            f = maximumChange;
        }
        if (f < -maximumChange) {
            f = -maximumChange;
        }
        return sourceAngle + f;
    }

    public boolean isFluidAt(double x, double y, double z) {
        if (this.f_19794_) {
            return false;
        }
        return !this.m_9236_().m_6425_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_76178_();
    }

    public boolean isOpaqueBlockAt(double x, double y, double z) {
        if (this.f_19794_) {
            return false;
        }
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockState blockState = this.m_9236_().m_8055_(blockpos);
        if (blockState.m_60795_()) {
            return false;
        }
        return !blockState.m_60812_((BlockGetter)this.m_9236_(), blockpos).m_83281_();
    }

    private boolean isPartOfMillipede(MillipedeHeadEntity head) {
        Entity current = this.getParentSegment();
        while (current != null) {
            if (current == head) {
                return true;
            }
            if (current instanceof MillipedeSegmentEntity) {
                MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
                current = segment.getParentSegment();
                continue;
            }
            if (!(current instanceof MillipedeHeadEntity)) break;
            return current == head;
        }
        return false;
    }

    private boolean isPartOfSameMillipede(MillipedeSegmentEntity otherSegment) {
        MillipedeHeadEntity myHead = this.getMillipedeHead();
        MillipedeHeadEntity otherHead = otherSegment.getMillipedeHead();
        return myHead != null && myHead == otherHead;
    }

    private MillipedeHeadEntity getMillipedeHead() {
        Entity current = this.getParentSegment();
        while (current != null) {
            if (current instanceof MillipedeHeadEntity) {
                MillipedeHeadEntity head = (MillipedeHeadEntity)current;
                return head;
            }
            if (!(current instanceof MillipedeSegmentEntity)) break;
            MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
            current = segment.getParentSegment();
        }
        return null;
    }
}

