/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RolyPolyEntity
extends PathfinderMob
implements GeoEntity {
    private static final float BUOYANCY = 0.02f;
    private static final double CLIMB_SPEED = 0.06;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final long DAMAGE_COOLDOWN = 20L;
    private static final int BLOCK_PROCESS_INTERVAL = 100;
    private static final int CROP_GROWTH_INTERVAL = 400;
    private static final int CROP_RADIUS = 2;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(RolyPolyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(RolyPolyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CURLED = SynchedEntityData.m_135353_(RolyPolyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLIPPED = SynchedEntityData.m_135353_(RolyPolyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private PathNavigation groundNavigation;
    private Vec3 prevPosition = Vec3.f_82478_;
    private double actualMovementSpeed = 0.0;
    private boolean hurt;
    private int hurtCooldown = 100;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private BlockPos lastClimbPos;
    private Map<LivingEntity, Long> lastDamageTime = new HashMap<LivingEntity, Long>();
    private boolean hasFlipped = false;
    private int blockProcessTimer = 0;
    private int cropGrowthTimer = 0;

    public RolyPolyEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.f_21342_ = new RolyPolyMoveControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.125).m_22268_(Attributes.f_22284_, 0.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CurlUpGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<RolyPolyEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        int yLevel = position.m_123342_();
        int seaLevel = level.m_5736_();
        int deepCave = seaLevel - 35;
        if (yLevel >= seaLevel) {
            return false;
        }
        if (yLevel > deepCave) {
            return false;
        }
        if (level.m_45524_(position, 0) > 7) {
            return false;
        }
        boolean randomCheck = random.m_188499_();
        boolean mobRules = RolyPolyEntity.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
        boolean canSpawn = randomCheck && mobRules;
        return canSpawn;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        Variant selectedVariant = (Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_()));
        this.setVariant(selectedVariant);
        return super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void m_8119_() {
        BlockPos currentPos;
        boolean shouldClimb;
        super.m_8119_();
        if (this.hurt) {
            --this.hurtCooldown;
            if (this.hurtCooldown <= 0) {
                this.hurt = false;
                this.f_19804_.m_135381_(CURLED, (Object)false);
            }
        }
        if (this.isFlipped() && !this.m_9236_().f_46443_) {
            ++this.blockProcessTimer;
            if (this.blockProcessTimer >= 100) {
                this.blockProcessTimer = 0;
                this.processBlocksBelow();
            }
            ++this.cropGrowthTimer;
            if (this.cropGrowthTimer >= 400) {
                this.cropGrowthTimer = 0;
                this.accelerateCropGrowth();
            }
        } else {
            this.blockProcessTimer = 0;
            this.cropGrowthTimer = 0;
        }
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.02f, motion.f_82481_);
            if (this.isFlipped() && !this.m_9236_().f_46443_) {
                this.setFlipped(false);
                this.hasFlipped = false;
            }
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = !this.isFlipped() && this.f_19862_ && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.isClimbing()) {
            currentPos = this.m_20183_();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.m_9236_().f_46443_) {
                    this.f_21344_.m_26573_();
                    this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
                }
            } else if (this.f_19862_) {
                Vec3 deltaMovement = this.m_20184_();
                boolean shouldApplyClimbMovement = true;
                if (this.m_20096_()) {
                    BlockPos above = this.m_20183_().m_7494_();
                    boolean hasBlockAbove = this.isCollidingWithBlock();
                    if (!hasBlockAbove) {
                        shouldApplyClimbMovement = false;
                    }
                }
                if (shouldApplyClimbMovement) {
                    this.m_20334_(deltaMovement.f_82479_, 0.06, deltaMovement.f_82481_);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.m_20182_();
        this.actualMovementSpeed = currentPos.m_82554_(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(shouldClimb);
        }
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_7023_(Vec3 travelVector) {
        super.m_7023_(travelVector);
    }

    public void m_6478_(MoverType moverType, Vec3 movement) {
        super.m_6478_(moverType, movement);
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, level);
        navigation.m_7008_(true);
        this.groundNavigation = navigation;
        return navigation;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && this.isFlipped()) {
            this.setFlipped(false);
            this.hasFlipped = false;
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (result && !(source.m_7639_() instanceof RolyPolyEntity)) {
            this.hurt = true;
            this.hurtCooldown = 100;
        }
        return result;
    }

    public void m_7334_(Entity entity) {
        Player player;
        super.m_7334_(entity);
        if (entity instanceof Player && (player = (Player)entity).m_20142_() && !this.m_9236_().f_46443_) {
            if (this.isFlipped()) {
                this.setFlipped(false);
                this.hasFlipped = false;
            } else {
                this.setFlipped(true);
                this.hasFlipped = false;
            }
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<RolyPolyEntity> event) {
        boolean climbing = this.isClimbing();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.m_20096_();
        if (this.isCurledUp()) {
            event.getController().setAnimation(RawAnimation.begin().then("curl", Animation.LoopType.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        if (this.isFlipped()) {
            if (!this.hasFlipped) {
                event.getController().setAnimation(RawAnimation.begin().then("flip", Animation.LoopType.PLAY_ONCE));
                if (event.getController().hasAnimationFinished()) {
                    this.hasFlipped = true;
                }
            } else {
                event.getController().setAnimation(RawAnimation.begin().then("struggle", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Curled", this.isCurledUp());
        tag.m_128379_("Flipped", this.isFlipped());
        tag.m_128405_("ClimbingTime", this.climbingTime);
        tag.m_128405_("ClimbCooldown", this.climbCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.setCurled(tag.m_128471_("Curled"));
        this.setFlipped(tag.m_128471_("Flipped"));
        this.climbingTime = tag.m_128451_("ClimbingTime");
        this.climbCooldown = tag.m_128451_("ClimbCooldown");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(CURLED, (Object)false);
        this.f_19804_.m_135372_(FLIPPED, (Object)false);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    public boolean isCurledUp() {
        return (Boolean)this.f_19804_.m_135370_(CURLED);
    }

    public void setCurled(boolean curled) {
        this.f_19804_.m_135381_(CURLED, (Object)curled);
        if (!this.m_9236_().f_46443_) {
            if (curled) {
                this.m_21051_(Attributes.f_22284_).m_22100_(15.0);
            } else {
                this.m_21051_(Attributes.f_22284_).m_22100_(0.0);
            }
        }
    }

    public boolean isFlipped() {
        return (Boolean)this.f_19804_.m_135370_(FLIPPED);
    }

    public void setFlipped(boolean flipped) {
        this.f_19804_.m_135381_(FLIPPED, (Object)flipped);
        if (!this.m_9236_().f_46443_ && flipped) {
            this.m_21573_().m_26573_();
            this.setClimbing(false);
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        Vec3 delta = this.m_20184_();
        double horizontalSpeed = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return true;
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean bl = hasAdjacentAtCurrentLevel = !this.m_9236_().m_8055_(north).m_60795_() && !this.m_9236_().m_8055_(north).m_247087_() || !this.m_9236_().m_8055_(south).m_60795_() && !this.m_9236_().m_8055_(south).m_247087_() || !this.m_9236_().m_8055_(east).m_60795_() && !this.m_9236_().m_8055_(east).m_247087_() || !this.m_9236_().m_8055_(west).m_60795_() && !this.m_9236_().m_8055_(west).m_247087_();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockPos northBelow = posBelow.m_122012_();
        BlockPos southBelow = posBelow.m_122019_();
        BlockPos eastBelow = posBelow.m_122029_();
        BlockPos westBelow = posBelow.m_122024_();
        return !this.m_9236_().m_8055_(northBelow).m_60795_() && !this.m_9236_().m_8055_(northBelow).m_247087_() || !this.m_9236_().m_8055_(southBelow).m_60795_() && !this.m_9236_().m_8055_(southBelow).m_247087_() || !this.m_9236_().m_8055_(eastBelow).m_60795_() && !this.m_9236_().m_8055_(eastBelow).m_247087_() || !this.m_9236_().m_8055_(westBelow).m_60795_() && !this.m_9236_().m_8055_(westBelow).m_247087_();
    }

    private void processBlocksBelow() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos centerPos = this.m_20183_().m_7495_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos targetPos;
                BlockState currentState;
                BlockState newState;
                if (!(this.f_19796_.m_188501_() < 0.15f) || (newState = this.getDecomposedBlock(currentState = serverLevel.m_8055_(targetPos = centerPos.m_7918_(x, 0, z)))) == null || newState == currentState) continue;
                serverLevel.m_7731_(targetPos, newState, 3);
                double particleX = (double)targetPos.m_123341_() + 0.5;
                double particleY = (double)targetPos.m_123342_() + 1.0;
                double particleZ = (double)targetPos.m_123343_() + 0.5;
                for (int i = 0; i < 3; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, currentState), particleX + offsetX, particleY, particleZ + offsetZ, 1, 0.0, 0.05, 0.0, 0.0);
                }
                serverLevel.m_5594_(null, targetPos, SoundEvents.f_144206_, this.m_5720_(), 0.3f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
    }

    private void accelerateCropGrowth() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos centerPos = this.m_20183_();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    int currentLevel;
                    BonemealableBlock bonemealable;
                    Block block;
                    BlockPos targetPos = centerPos.m_7918_(x, y, z);
                    BlockState state = serverLevel.m_8055_(targetPos);
                    if (this.f_19796_.m_188501_() < 0.03f && state.m_204336_(BlockTags.f_13073_) && (block = state.m_60734_()) instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).m_7370_((LevelReader)serverLevel, targetPos, state, serverLevel.f_46443_)) {
                        BlockState beforeState = state;
                        bonemealable.m_214148_(serverLevel, this.f_19796_, targetPos, state);
                        BlockState afterState = serverLevel.m_8055_(targetPos);
                        if (!beforeState.equals(afterState)) {
                            double particleX = (double)targetPos.m_123341_() + 0.5;
                            double particleY = (double)targetPos.m_123342_() + 0.5;
                            double particleZ = (double)targetPos.m_123343_() + 0.5;
                            for (int i = 0; i < 5; ++i) {
                                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                                double offsetY = this.f_19796_.m_188500_() * 0.5;
                                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, particleX + offsetX, particleY + offsetY, particleZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                    if (!(this.f_19796_.m_188501_() < 0.02f) || !(state.m_60734_() instanceof ComposterBlock) || (currentLevel = ((Integer)state.m_61143_((Property)ComposterBlock.f_51913_)).intValue()) >= 8) continue;
                    BlockState newState = (BlockState)state.m_61124_((Property)ComposterBlock.f_51913_, (Comparable)Integer.valueOf(currentLevel + 1));
                    serverLevel.m_7731_(targetPos, newState, 3);
                    double particleX = (double)targetPos.m_123341_() + 0.5;
                    double particleY = (double)targetPos.m_123342_() + 0.7;
                    double particleZ = (double)targetPos.m_123343_() + 0.5;
                    for (int i = 0; i < 3; ++i) {
                        double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                        double offsetY = this.f_19796_.m_188500_() * 0.3;
                        double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, particleX + offsetX, particleY + offsetY, particleZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    serverLevel.m_5594_(null, targetPos, SoundEvents.f_11765_, this.m_5720_(), 0.5f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
            }
        }
    }

    @Nullable
    private BlockState getDecomposedBlock(BlockState currentState) {
        if (currentState.m_204336_(BlockTags.f_144274_) && !currentState.m_60713_(Blocks.f_50546_) && !currentState.m_60713_(Blocks.f_152549_)) {
            if (currentState.m_60713_(Blocks.f_50493_)) {
                return Blocks.f_50546_.m_49966_();
            }
            return Blocks.f_50493_.m_49966_();
        }
        if (currentState.m_60713_(Blocks.f_50546_)) {
            return Blocks.f_152549_.m_49966_();
        }
        if (currentState.m_60713_(Blocks.f_152549_)) {
            return Blocks.f_50493_.m_49966_();
        }
        return null;
    }

    static class RolyPolyMoveControl
    extends MoveControl {
        private final RolyPolyEntity rolyPoly;

        public RolyPolyMoveControl(RolyPolyEntity rolyPolyEntity) {
            super((Mob)rolyPolyEntity);
            this.rolyPoly = rolyPolyEntity;
        }

        public void m_8126_() {
            if (!this.rolyPoly.isCurledUp() && !this.rolyPoly.isFlipped()) {
                super.m_8126_();
            }
        }
    }

    public class CurlUpGoal
    extends Goal {
        private final RolyPolyEntity rolyPoly;
        private int timer;

        public CurlUpGoal(RolyPolyEntity rolyPoly) {
            this.rolyPoly = rolyPoly;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return this.rolyPoly.hurt && !this.rolyPoly.isCurledUp() && !this.rolyPoly.isFlipped();
        }

        public boolean m_8045_() {
            return this.rolyPoly.hurt && this.rolyPoly.isCurledUp();
        }

        public void m_8056_() {
            this.rolyPoly.setCurled(true);
            this.timer = 0;
            this.rolyPoly.m_21573_().m_26573_();
            this.rolyPoly.m_21563_().m_24946_(this.rolyPoly.m_20185_(), this.rolyPoly.m_20186_(), this.rolyPoly.m_20189_());
        }

        public void m_8037_() {
            ++this.timer;
            if (this.timer >= 300) {
                this.uncurlRolyPoly();
            }
        }

        public void m_8041_() {
            this.uncurlRolyPoly();
        }

        private void uncurlRolyPoly() {
            if (this.rolyPoly.isCurledUp()) {
                this.rolyPoly.setCurled(false);
            }
        }
    }

    public static enum Variant implements StringRepresentable
    {
        BLACK(0, "black"),
        WHITE(1, "white"),
        RUBBERDUCKY(2, "rubberducky"),
        DAIRYCOW(3, "dairycow"),
        WHITESHARK(4, "whiteshark"),
        CAPPUCCINO(5, "cappuccino");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

