/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.SilkwormEntity;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifyBlocks;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SilkMothEntity
extends Animal
implements GeoEntity,
FlyingAnimal {
    private static final double PLAYER_DETECTION_RANGE = 4.0;
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(SilkMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_SILKWORM = SynchedEntityData.m_135353_(SilkMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PREGNANT = SynchedEntityData.m_135353_(SilkMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LAYING_EGG = SynchedEntityData.m_135353_(SilkMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    public boolean landingFlag;

    public SilkMothEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new SilkMothMoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SilkMothLayEggGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new LightAttractionGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 0.8, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151079_}), false));
        this.f_21345_.m_25352_(5, (Goal)new SilkMothFlightGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<SilkMothEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        boolean isDay = level.m_6018_().m_46461_();
        if (isDay) {
            return false;
        }
        boolean canSeeSky = level.m_45527_(position);
        if (!canSeeSky) {
            return false;
        }
        int blockLight = level.m_45517_(LightLayer.BLOCK, position);
        if (blockLight > 7) {
            return false;
        }
        BlockPos below = position.m_7495_();
        BlockState belowState = level.m_8055_(below);
        boolean validSpawn = belowState.m_60643_((BlockGetter)level, below, entityType);
        return validSpawn;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
        if (!this.m_9236_().f_46443_ && !this.isLayingEgg() && !this.m_29443_() && this.m_20096_()) {
            boolean isBeingTempted = false;
            AABB searchBox = this.m_20191_().m_82400_(10.0);
            List nearbyPlayers = this.m_9236_().m_45976_(Player.class, searchBox);
            for (Player player : nearbyPlayers) {
                if (!player.m_21205_().m_150930_(Items.f_151079_) && !player.m_21206_().m_150930_(Items.f_151079_)) continue;
                isBeingTempted = true;
                break;
            }
            if (this.m_27593_() || isBeingTempted) {
                this.setFlying(true);
                this.landingFlag = false;
                this.groundedFor = 0;
            }
        }
    }

    public void tickFlight() {
        if (this.isLayingEgg()) {
            this.flyProgress = 0.0f;
            this.m_20242_(false);
            return;
        }
        if (this.m_29443_() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.m_29443_() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.m_29443_()) {
            ++this.timeFlying;
            this.m_20242_(true);
            if (this.groundedFor > 0) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.m_20242_(false);
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_29443_() && this.m_6084_() && !this.m_20160_()) {
                if (this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1, 0.0));
                }
                if ((this.f_19862_ || this.m_20072_()) && !this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                }
            }
            if (this.m_29443_() && this.timeFlying > 40 && this.m_20096_()) {
                this.setFlying(false);
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new SilkMothFlyingNavigation((Mob)this, level, 0.75f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        SpawnEggItem spawnEggItem;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof SpawnEggItem && (spawnEggItem = (SpawnEggItem)item).m_43228_(itemStack.m_41783_()) == this.m_6095_()) {
            if (!this.m_9236_().f_46443_) {
                SilkwormEntity silkworm = new SilkwormEntity((EntityType<? extends Animal>)((EntityType)FaunifyEntities.SILKWORM.get()), this.m_9236_());
                silkworm.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                silkworm.m_6863_(true);
                int roll = this.f_19796_.m_188503_(100);
                if (roll < 95) {
                    silkworm.setVariant(SilkwormEntity.Variant.NORMAL);
                } else {
                    silkworm.setVariant(SilkwormEntity.Variant.HUNGRY);
                }
                this.m_9236_().m_7967_((Entity)silkworm);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(itemStack)) {
            return super.m_6071_(player, hand);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_151079_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void m_27563_(ServerLevel level, Animal otherParent) {
        this.m_277117_(level, otherParent, null);
        this.setIsPregnant(true);
        if (otherParent instanceof SilkMothEntity) {
            SilkMothEntity otherMoth = (SilkMothEntity)otherParent;
            otherMoth.setIsPregnant(true);
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<SilkMothEntity> event) {
        if (!this.m_29443_() && this.m_20096_()) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Flying", this.m_29443_());
        tag.m_128405_("TimeFlying", this.timeFlying);
        tag.m_128405_("GroundedFor", this.groundedFor);
        tag.m_128379_("LandingFlag", this.landingFlag);
        tag.m_128379_("FromSilkworm", this.isFromSilkworm());
        tag.m_128379_("IsPregnant", this.isPregnant());
        tag.m_128379_("IsLayingEgg", this.isLayingEgg());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFlying(tag.m_128471_("Flying"));
        this.timeFlying = tag.m_128451_("TimeFlying");
        this.groundedFor = tag.m_128451_("GroundedFor");
        this.landingFlag = tag.m_128471_("LandingFlag");
        this.setFromSilkworm(tag.m_128471_("FromSilkworm"));
        this.setIsPregnant(tag.m_128471_("IsPregnant"));
        this.setLayingEgg(tag.m_128471_("IsLayingEgg"));
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(FROM_SILKWORM, (Object)false);
        this.f_19804_.m_135372_(IS_PREGNANT, (Object)false);
        this.f_19804_.m_135372_(IS_LAYING_EGG, (Object)false);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    protected void m_7840_(double fallDistance, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean m_8023_() {
        return this.isFromSilkworm() || super.m_8023_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        if (this.isFromSilkworm()) {
            return false;
        }
        return !this.m_8077_() && !this.m_21523_();
    }

    public boolean isFromSilkworm() {
        return (Boolean)this.f_19804_.m_135370_(FROM_SILKWORM);
    }

    public void setFromSilkworm(boolean fromSilkworm) {
        this.f_19804_.m_135381_(FROM_SILKWORM, (Object)fromSilkworm);
    }

    public boolean isPregnant() {
        return (Boolean)this.f_19804_.m_135370_(IS_PREGNANT);
    }

    public void setIsPregnant(boolean pregnant) {
        this.f_19804_.m_135381_(IS_PREGNANT, (Object)pregnant);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAYING_EGG);
    }

    public void setLayingEgg(boolean laying) {
        this.f_19804_.m_135381_(IS_LAYING_EGG, (Object)laying);
    }

    private static class SilkMothMoveController
    extends MoveControl {
        private final SilkMothEntity moth;

        public SilkMothMoveController(SilkMothEntity moth) {
            super((Mob)moth);
            this.moth = moth;
        }

        public void m_8126_() {
            if (this.moth.isLayingEgg()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.moth.m_20256_(Vec3.f_82478_);
                this.moth.m_20242_(false);
                return;
            }
            if (!this.moth.m_29443_() && this.moth.m_20096_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.moth.m_20185_(), this.f_24976_ - this.moth.m_20186_(), this.f_24977_ - this.moth.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.moth.m_20191_().m_82309_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.05 / d0);
                this.moth.m_20256_(this.moth.m_20184_().m_82549_(vector3d1).m_82490_(0.95).m_82520_(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width) {
                    float yaw = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
                    this.moth.m_146922_(Mth.m_14148_((float)this.moth.m_146908_(), (float)yaw, (float)8.0f));
                }
            }
        }
    }

    private static class SilkMothLayEggGoal
    extends Goal {
        private static final int LAYING_DURATION = 40;
        private static final Set<BlockPos> OCCUPIED_LEAF_POSITIONS = new HashSet<BlockPos>();
        private final SilkMothEntity moth;
        private BlockPos targetBlockPos;
        private int searchCooldown;
        private int layingTimer;
        private boolean isLaying;
        private boolean hasLanded;
        private int failedLandingAttempts;
        private int repositionTimer;

        public SilkMothLayEggGoal(SilkMothEntity moth) {
            this.moth = moth;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.layingTimer = 0;
            this.isLaying = false;
            this.hasLanded = false;
            this.searchCooldown = 0;
            this.failedLandingAttempts = 0;
            this.repositionTimer = 0;
        }

        public boolean m_8036_() {
            if (!this.moth.isPregnant()) {
                return false;
            }
            if (this.moth.m_20160_()) {
                return false;
            }
            if (this.searchCooldown > 0) {
                --this.searchCooldown;
                return false;
            }
            this.targetBlockPos = this.findNearbyLeaf();
            if (this.targetBlockPos != null) {
                OCCUPIED_LEAF_POSITIONS.add(this.targetBlockPos);
                this.failedLandingAttempts = 0;
                return true;
            }
            this.searchCooldown = 200;
            return false;
        }

        public boolean m_8045_() {
            if (this.targetBlockPos == null) {
                return false;
            }
            if (!this.moth.isPregnant()) {
                return false;
            }
            if (this.failedLandingAttempts > 15) {
                return false;
            }
            BlockState blockState = this.moth.m_9236_().m_8055_(this.targetBlockPos);
            boolean blockValid = blockState.m_204336_(BlockTags.f_13035_);
            return blockValid;
        }

        public void m_8056_() {
            this.moth.setFlying(true);
            this.moth.setLayingEgg(false);
            this.moth.landingFlag = false;
            this.layingTimer = 0;
            this.isLaying = false;
            this.hasLanded = false;
            this.failedLandingAttempts = 0;
            this.repositionTimer = 0;
            this.moth.m_21573_().m_26519_((double)this.targetBlockPos.m_123341_() + 0.5, (double)this.targetBlockPos.m_123342_() + 2.0, (double)this.targetBlockPos.m_123343_() + 0.5, 0.8);
        }

        public void m_8037_() {
            if (this.targetBlockPos == null) {
                return;
            }
            if (!this.moth.isLayingEgg() && this.hasLanded) {
                this.moth.setLayingEgg(true);
            }
            if (!this.hasLanded) {
                boolean isAtCorrectHeight;
                Vec3 exactLandingPos = new Vec3((double)this.targetBlockPos.m_123341_() + 0.5, (double)this.targetBlockPos.m_123342_() + 1.0, (double)this.targetBlockPos.m_123343_() + 0.5);
                Vec3 mothPos = this.moth.m_20182_();
                double horizontalDistance = Math.sqrt(Math.pow(mothPos.f_82479_ - exactLandingPos.f_82479_, 2.0) + Math.pow(mothPos.f_82481_ - exactLandingPos.f_82481_, 2.0));
                double verticalDistance = Math.abs(mothPos.f_82480_ - exactLandingPos.f_82480_);
                boolean isCenteredHorizontally = horizontalDistance < 0.3;
                boolean bl = isAtCorrectHeight = verticalDistance < 0.5;
                if (this.moth.m_20096_()) {
                    BlockPos mothFeetPos = this.moth.m_20183_().m_7495_();
                    if (mothFeetPos.equals((Object)this.targetBlockPos)) {
                        this.moth.setFlying(false);
                        this.moth.landingFlag = false;
                        this.moth.m_21573_().m_26573_();
                        this.moth.m_20256_(Vec3.f_82478_);
                        this.moth.m_20242_(false);
                        this.hasLanded = true;
                        this.failedLandingAttempts = 0;
                        this.repositionTimer = 0;
                    } else if (isCenteredHorizontally) {
                        this.moth.setFlying(false);
                        this.moth.landingFlag = false;
                        this.moth.m_21573_().m_26573_();
                        this.moth.m_20256_(Vec3.f_82478_);
                        this.moth.m_20242_(false);
                        this.hasLanded = true;
                        this.failedLandingAttempts = 0;
                        this.repositionTimer = 0;
                    } else {
                        ++this.failedLandingAttempts;
                        this.repositionTimer = 0;
                        this.moth.setFlying(true);
                        this.moth.m_20242_(true);
                        this.moth.m_21573_().m_26519_(exactLandingPos.f_82479_, exactLandingPos.f_82480_ + 2.0, exactLandingPos.f_82481_, 0.7);
                    }
                } else if (isCenteredHorizontally && verticalDistance < 3.0) {
                    this.moth.setFlying(false);
                    this.moth.landingFlag = true;
                    this.moth.m_20242_(false);
                    Vec3 currentVelocity = this.moth.m_20184_();
                    double targetDescentSpeed = verticalDistance > 2.0 ? -0.08 : (verticalDistance > 1.0 ? -0.05 : -0.03);
                    double smoothedYVelocity = currentVelocity.f_82480_ * 0.8 + targetDescentSpeed * 0.2;
                    this.moth.m_20334_(currentVelocity.f_82479_ * 0.3, Math.max(smoothedYVelocity, -0.5), currentVelocity.f_82481_ * 0.3);
                    if (this.moth.f_19797_ % 8 == 0 && verticalDistance < 1.5) {
                        Vec3 vel = this.moth.m_20184_();
                        this.moth.m_20334_(vel.f_82479_, vel.f_82480_ + 0.02, vel.f_82481_);
                    }
                } else {
                    this.moth.setFlying(true);
                    this.moth.landingFlag = false;
                    this.moth.m_20242_(true);
                    ++this.repositionTimer;
                    if (this.repositionTimer > 40 || this.moth.m_21573_().m_26571_()) {
                        this.moth.m_21573_().m_26519_(exactLandingPos.f_82479_, exactLandingPos.f_82480_ + 1.5, exactLandingPos.f_82481_, 0.8);
                        this.repositionTimer = 0;
                    }
                }
            } else {
                this.moth.setFlying(false);
                this.moth.setLayingEgg(true);
                this.moth.landingFlag = false;
                this.moth.m_21573_().m_26573_();
                this.moth.m_20256_(Vec3.f_82478_);
                this.moth.m_20242_(false);
                Vec3 mothPos = this.moth.m_20182_();
                Vec3 leafCenter = Vec3.m_82512_((Vec3i)this.targetBlockPos);
                double horizontalDrift = Math.sqrt(Math.pow(mothPos.f_82479_ - leafCenter.f_82479_, 2.0) + Math.pow(mothPos.f_82481_ - leafCenter.f_82481_, 2.0));
                if (horizontalDrift > 0.8) {
                    this.hasLanded = false;
                    this.moth.setLayingEgg(false);
                    ++this.failedLandingAttempts;
                    this.isLaying = false;
                    this.layingTimer = 0;
                    return;
                }
                if (!this.isLaying) {
                    this.isLaying = true;
                    this.layingTimer = 0;
                }
                ++this.layingTimer;
                if (this.layingTimer >= 40) {
                    BlockPos eggPos = this.targetBlockPos.m_7494_();
                    if (this.moth.m_9236_().m_8055_(eggPos).m_60795_()) {
                        this.moth.m_9236_().m_7731_(eggPos, ((Block)FaunifyBlocks.SILKWORM_EGGS.get()).m_49966_(), 3);
                        this.moth.setIsPregnant(false);
                        this.moth.setLayingEgg(false);
                        this.moth.m_27594_();
                    } else {
                        this.moth.setLayingEgg(false);
                        this.hasLanded = false;
                        this.isLaying = false;
                        this.layingTimer = 0;
                        ++this.failedLandingAttempts;
                    }
                }
            }
        }

        public void m_8041_() {
            this.moth.setLayingEgg(false);
            if (this.targetBlockPos != null) {
                OCCUPIED_LEAF_POSITIONS.remove(this.targetBlockPos);
            }
            this.targetBlockPos = null;
            this.searchCooldown = 100;
            this.layingTimer = 0;
            this.isLaying = false;
            this.hasLanded = false;
            this.failedLandingAttempts = 0;
            this.repositionTimer = 0;
            if (this.moth.isPregnant()) {
                this.moth.setFlying(true);
            }
        }

        @Nullable
        private BlockPos findNearbyLeaf() {
            List validLeaves;
            BlockPos mothPos = this.moth.m_20183_();
            if (this.moth.f_19797_ % 100 == 0) {
                OCCUPIED_LEAF_POSITIONS.removeIf(pos -> {
                    boolean tooFar = this.moth.m_9236_().m_6907_().stream().allMatch(player -> player.m_20183_().m_123331_((Vec3i)pos) > 4096.0);
                    return tooFar;
                });
            }
            if ((validLeaves = BlockPos.m_121990_((BlockPos)mothPos.m_7918_(-16, -8, -16), (BlockPos)mothPos.m_7918_(16, 8, 16)).map(BlockPos::m_7949_).filter(pos -> {
                if (OCCUPIED_LEAF_POSITIONS.contains(pos)) {
                    return false;
                }
                BlockState state = this.moth.m_9236_().m_8055_(pos);
                if (state.m_204336_(BlockTags.f_13035_)) {
                    BlockPos above = pos.m_7494_();
                    BlockState aboveState = this.moth.m_9236_().m_8055_(above);
                    if (!aboveState.m_60795_()) {
                        return false;
                    }
                    if (!aboveState.m_60812_((BlockGetter)this.moth.m_9236_(), above).m_83281_()) {
                        return false;
                    }
                    BlockPos aboveAbove = above.m_7494_();
                    BlockState aboveAboveState = this.moth.m_9236_().m_8055_(aboveAbove);
                    return aboveAboveState.m_60795_() || aboveAboveState.m_247087_();
                }
                return false;
            }).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            BlockPos selected = (BlockPos)validLeaves.get(this.moth.m_217043_().m_188503_(validLeaves.size()));
            return selected;
        }
    }

    private static class LightAttractionGoal
    extends Goal {
        private static final double LIGHT_PROXIMITY_DISTANCE = 3.0;
        private final SilkMothEntity moth;
        private BlockPos lightSourcePos;
        private Vec3 targetAroundLight;
        private int retargetTimer;
        private boolean nearLight;

        public LightAttractionGoal(SilkMothEntity moth) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.moth = moth;
            this.retargetTimer = 0;
            this.nearLight = false;
        }

        public boolean m_8036_() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (this.moth.m_20160_() || this.moth.m_20159_()) {
                return false;
            }
            if (!this.moth.m_9236_().m_46462_()) {
                return false;
            }
            this.lightSourcePos = this.findHighestPriorityLightSource();
            if (this.lightSourcePos != null) {
                this.targetAroundLight = this.getApproachPosition(this.lightSourcePos);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (!this.moth.m_9236_().m_46462_()) {
                return false;
            }
            if (this.lightSourcePos == null) {
                return false;
            }
            BlockState currentLightState = this.moth.m_9236_().m_8055_(this.lightSourcePos);
            if (currentLightState.m_60791_() < 8) {
                return false;
            }
            if (this.retargetTimer <= 0) {
                BlockPos newLightSource = this.findHighestPriorityLightSource();
                if (newLightSource == null) {
                    return false;
                }
                if (!newLightSource.equals((Object)this.lightSourcePos)) {
                    return false;
                }
            }
            return true;
        }

        public void m_8056_() {
            this.moth.setFlying(true);
            this.moth.landingFlag = false;
            this.moth.groundedFor = 0;
            this.retargetTimer = 15 + this.moth.m_217043_().m_188503_(10);
            this.nearLight = false;
        }

        public void m_8041_() {
            this.moth.m_21573_().m_26573_();
            this.lightSourcePos = null;
            this.targetAroundLight = null;
            this.nearLight = false;
        }

        public void m_8037_() {
            double distanceToLight;
            BlockPos brighterLight;
            --this.retargetTimer;
            if (!this.moth.m_29443_()) {
                this.moth.setFlying(true);
            }
            this.moth.landingFlag = false;
            this.moth.groundedFor = 0;
            Vec3 lightCenter = Vec3.m_82512_((Vec3i)this.lightSourcePos);
            Vec3 mothPos = this.moth.m_20182_();
            double dx = lightCenter.f_82479_ - mothPos.f_82479_;
            double dz = lightCenter.f_82481_ - mothPos.f_82481_;
            float targetYaw = -((float)Mth.m_14136_((double)dx, (double)dz)) * 57.295776f;
            this.moth.m_146922_(Mth.m_14148_((float)this.moth.m_146908_(), (float)targetYaw, (float)10.0f));
            this.moth.f_20883_ = this.moth.m_146908_();
            if (this.moth.f_19797_ % 40 == 0 && (brighterLight = this.findHighestPriorityLightSource()) != null && !brighterLight.equals((Object)this.lightSourcePos)) {
                int currentBrightness = this.moth.m_9236_().m_45517_(LightLayer.BLOCK, this.lightSourcePos);
                int newBrightness = this.moth.m_9236_().m_45517_(LightLayer.BLOCK, brighterLight);
                if (newBrightness > currentBrightness) {
                    this.lightSourcePos = brighterLight;
                    this.targetAroundLight = this.getApproachPosition(this.lightSourcePos);
                    this.nearLight = false;
                    this.retargetTimer = 30 + this.moth.m_217043_().m_188503_(20);
                }
            }
            if ((distanceToLight = this.moth.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.lightSourcePos))) < 3.0) {
                this.nearLight = true;
            }
            if (this.nearLight) {
                if (this.retargetTimer <= 0 || this.moth.m_20182_().m_82557_(this.targetAroundLight) < 1.5) {
                    this.targetAroundLight = this.getOrbitPosition(this.lightSourcePos);
                    this.moth.m_21573_().m_26519_(this.targetAroundLight.f_82479_, this.targetAroundLight.f_82480_, this.targetAroundLight.f_82481_, (double)0.4f);
                    this.retargetTimer = 10 + this.moth.m_217043_().m_188503_(15);
                }
            } else if (this.retargetTimer <= 0 || this.moth.m_21573_().m_26571_()) {
                this.targetAroundLight = this.getApproachPosition(this.lightSourcePos);
                this.moth.m_21573_().m_26519_(this.targetAroundLight.f_82479_, this.targetAroundLight.f_82480_, this.targetAroundLight.f_82481_, (double)0.6f);
                this.retargetTimer = 30 + this.moth.m_217043_().m_188503_(20);
            }
        }

        private BlockPos findHighestPriorityLightSource() {
            Level level = this.moth.m_9236_();
            BlockPos mothPos = this.moth.m_20183_();
            return BlockPos.m_121990_((BlockPos)mothPos.m_7918_(-15, -15, -15), (BlockPos)mothPos.m_7918_(15, 15, 15)).map(BlockPos::m_7949_).filter(pos -> {
                BlockState state = level.m_8055_(pos);
                return state.m_60791_() >= 8;
            }).min(Comparator.comparingInt(pos -> -level.m_45517_(LightLayer.BLOCK, pos)).thenComparingDouble(pos -> pos.m_123331_((Vec3i)mothPos))).orElse(null);
        }

        private Vec3 getApproachPosition(BlockPos lightPos) {
            int radius = 2 + this.moth.f_19796_.m_188503_(3);
            double angle = this.moth.f_19796_.m_188500_() * Math.PI * 2.0;
            int xOffset = (int)(Math.cos(angle) * (double)radius);
            int zOffset = (int)(Math.sin(angle) * (double)radius);
            int yOffset = this.moth.f_19796_.m_188503_(3) - 1;
            return Vec3.m_82512_((Vec3i)lightPos.m_7918_(xOffset, yOffset, zOffset));
        }

        private Vec3 getOrbitPosition(BlockPos lightPos) {
            int radius = 1 + this.moth.f_19796_.m_188503_(2);
            double angle = this.moth.f_19796_.m_188500_() * Math.PI * 2.0;
            double xOffset = Math.cos(angle) * (double)radius;
            double zOffset = Math.sin(angle) * (double)radius;
            int yOffset = this.moth.f_19796_.m_188503_(3) - 1;
            int finalY = Math.max(lightPos.m_123342_() + yOffset, lightPos.m_123342_());
            return new Vec3((double)lightPos.m_123341_() + xOffset + 0.5, (double)finalY + 0.5, (double)lightPos.m_123343_() + zOffset + 0.5);
        }
    }

    private static class SilkMothFlightGoal
    extends Goal {
        private final SilkMothEntity moth;
        private double x;
        private double y;
        private double z;
        private int flyDuration;
        private int restDuration;
        private int currentTimer;
        private boolean shouldRest;
        private int landingTimer;
        private Vec3 landingTarget;

        public SilkMothFlightGoal(SilkMothEntity moth) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.moth = moth;
            this.resetTimers();
            this.landingTimer = 0;
        }

        private void resetTimers() {
            this.flyDuration = 160 + this.moth.m_217043_().m_188503_(81);
            this.restDuration = 80 + this.moth.m_217043_().m_188503_(81);
            this.currentTimer = 0;
            this.shouldRest = false;
            this.landingTimer = 0;
        }

        public boolean m_8036_() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (this.moth.m_20160_() || this.moth.m_20159_()) {
                return false;
            }
            if (!this.moth.m_29443_() && this.moth.m_20096_()) {
                AABB searchBox = this.moth.m_20191_().m_82400_(4.0);
                List nearbyPlayers = this.moth.m_9236_().m_45976_(Player.class, searchBox);
                if (!nearbyPlayers.isEmpty()) {
                    this.shouldRest = false;
                    this.currentTimer = 0;
                    this.landingTimer = 0;
                    Vec3 target = this.getPosition();
                    if (target != null) {
                        this.x = target.f_82479_;
                        this.y = target.f_82480_;
                        this.z = target.f_82481_;
                        return true;
                    }
                }
            }
            if (!this.moth.m_29443_() && this.moth.m_217043_().m_188503_(80) != 0 && !this.shouldRest) {
                return false;
            }
            Vec3 target = this.getPosition();
            if (target == null) {
                return false;
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (!this.moth.m_29443_() && this.moth.m_20096_() && this.currentTimer >= this.restDuration) {
                return false;
            }
            if (this.moth.landingFlag) {
                return !this.moth.m_20096_() && this.moth.groundedFor <= 0;
            }
            return this.moth.m_29443_() && !this.moth.m_21573_().m_26571_() && this.moth.groundedFor <= 0;
        }

        public void m_8056_() {
            this.moth.setFlying(true);
            this.moth.m_21573_().m_26519_(this.x, this.y, this.z, 0.5);
        }

        public void m_8041_() {
            this.moth.m_21573_().m_26573_();
            this.moth.landingFlag = false;
            this.landingTimer = 0;
            this.landingTarget = null;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            super.m_8041_();
        }

        public void m_8037_() {
            if (!this.moth.m_29443_() && this.moth.m_20096_()) {
                ++this.currentTimer;
                BlockPos mothPos = this.moth.m_20183_();
                BlockState stateAtPos = this.moth.m_9236_().m_8055_(mothPos);
                if (!stateAtPos.m_60795_() && !stateAtPos.m_247087_()) {
                    return;
                }
                this.moth.m_20256_(Vec3.f_82478_);
                return;
            }
            ++this.currentTimer;
            if (this.moth.m_29443_()) {
                if (this.currentTimer >= this.flyDuration) {
                    this.shouldRest = true;
                    this.moth.landingFlag = true;
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                }
                if (this.moth.landingFlag) {
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                    if (this.landingTarget != null) {
                        ++this.landingTimer;
                        if (this.landingTimer % 20 == 0) {
                            Vec3 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                            this.moth.m_21573_().m_26519_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_, 0.25);
                        }
                        if (this.moth.m_20096_() || this.moth.m_20186_() - this.landingTarget.f_82480_ < 1.5 && this.landingTimer > 60) {
                            this.moth.setFlying(false);
                            this.currentTimer = 0;
                            this.shouldRest = false;
                            this.moth.landingFlag = false;
                            this.landingTarget = null;
                            this.landingTimer = 0;
                            this.resetTimers();
                        }
                    } else {
                        this.moth.landingFlag = false;
                        this.shouldRest = false;
                        this.landingTimer = 0;
                    }
                }
            }
            if (this.isOverWaterOrVoid() || this.moth.m_20072_()) {
                this.moth.setFlying(true);
                this.moth.landingFlag = false;
                this.shouldRest = false;
                this.landingTimer = 0;
                this.landingTarget = null;
            }
        }

        private Vec3 getPosition() {
            if (this.shouldRest) {
                this.landingTarget = this.findLandingPos();
                return this.getCirclingPosition(this.landingTarget);
            }
            return this.findFlightPos();
        }

        private Vec3 getCirclingPosition(Vec3 target) {
            double angle = this.moth.m_217043_().m_188500_() * Math.PI * 2.0;
            double radius = 2.0 + this.moth.m_217043_().m_188500_() * 2.0;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double yOffset = 3.0 + this.moth.m_217043_().m_188500_() * 2.0;
            return new Vec3(target.f_82479_ + xOffset, target.f_82480_ + yOffset, target.f_82481_ + zOffset);
        }

        private Vec3 getDescentPosition(Vec3 target, int timer) {
            if (target == null) {
                return this.moth.m_20182_();
            }
            double progress = Math.min((double)timer / 120.0, 1.0);
            double angle = (double)timer * 0.1 % (Math.PI * 2);
            double radius = 2.5 * (1.0 - progress * 0.6);
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double currentHeight = this.moth.m_20186_();
            double targetHeight = target.f_82480_ + 0.5;
            double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.2;
            return new Vec3(target.f_82479_ + xOffset, Math.max(descentHeight, targetHeight), target.f_82481_ + zOffset);
        }

        private Vec3 findFlightPos() {
            int range = 13;
            Vec3 heightAdjusted = this.moth.m_20182_().m_82520_((double)(this.moth.m_217043_().m_188503_(range * 2) - range), 0.0, (double)(this.moth.m_217043_().m_188503_(range * 2) - range));
            if (this.moth.m_9236_().m_45527_(BlockPos.m_274446_((Position)heightAdjusted))) {
                ground = this.groundPosition(heightAdjusted);
                heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + 4.0 + (double)this.moth.m_217043_().m_188503_(8), heightAdjusted.f_82481_);
            } else {
                ground = this.groundPosition(heightAdjusted);
                BlockPos ceiling = BlockPos.m_274446_((Position)ground).m_6630_(2);
                while (ceiling.m_123342_() < this.moth.m_9236_().m_151558_() && !this.moth.m_9236_().m_8055_(ceiling).m_60804_((BlockGetter)this.moth.m_9236_(), ceiling)) {
                    ceiling = ceiling.m_7494_();
                }
                float randCeilVal = 0.3f + this.moth.m_217043_().m_188501_() * 0.5f;
                heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + ((double)ceiling.m_123342_() - ground.f_82480_) * (double)randCeilVal, heightAdjusted.f_82481_);
            }
            BlockHitResult result = this.moth.m_9236_().m_45547_(new ClipContext(this.moth.m_146892_(), heightAdjusted, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.moth));
            if (result.m_6662_() == HitResult.Type.MISS) {
                return heightAdjusted;
            }
            return result.m_82450_();
        }

        private Vec3 findLandingPos() {
            Vec3 currentPos = this.moth.m_20182_();
            Vec3 ground = this.groundPosition(currentPos);
            BlockPos landingPos = BlockPos.m_274446_((Position)ground);
            while (landingPos.m_123342_() < this.moth.m_9236_().m_151558_() && !this.moth.m_9236_().m_8055_(landingPos).m_60795_() && !this.moth.m_9236_().m_8055_(landingPos).m_247087_()) {
                landingPos = landingPos.m_7494_();
            }
            return Vec3.m_82512_((Vec3i)landingPos);
        }

        private Vec3 groundPosition(Vec3 airPosition) {
            BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos();
            ground.m_122169_(airPosition.f_82479_, airPosition.f_82480_, airPosition.f_82481_);
            boolean flag = false;
            while (ground.m_123342_() < this.moth.m_9236_().m_151558_() && !this.moth.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.moth.m_9236_(), (BlockPos)ground) && this.moth.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
                ground.m_122184_(0, 1, 0);
                flag = true;
            }
            ground.m_122184_(0, -1, 0);
            while (ground.m_123342_() > this.moth.m_9236_().m_141937_() && !this.moth.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.moth.m_9236_(), (BlockPos)ground) && this.moth.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
                ground.m_122184_(0, -1, 0);
            }
            return Vec3.m_82512_((Vec3i)(flag ? ground.m_7494_() : ground.m_7495_()));
        }

        private boolean isOverWaterOrVoid() {
            BlockPos position = this.moth.m_20183_();
            while (position.m_123342_() > this.moth.m_9236_().m_141937_() && this.moth.m_9236_().m_46859_(position) && this.moth.m_9236_().m_6425_(position).m_76178_()) {
                position = position.m_7495_();
            }
            return !this.moth.m_9236_().m_6425_(position).m_76178_() || this.moth.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= this.moth.m_9236_().m_141937_();
        }
    }

    private static class SilkMothFlyingNavigation
    extends FlyingPathNavigation {
        private float distanceModifier;

        public SilkMothFlyingNavigation(Mob mob, Level level, float distanceModifier) {
            super(mob, level);
            this.distanceModifier = distanceModifier;
        }

        protected void m_7636_() {
            boolean flag;
            Vec3 vector3d = this.m_7475_();
            this.f_26505_ = this.f_26494_.m_20205_() * this.distanceModifier;
            BlockPos vector3i = this.f_26496_.m_77400_();
            double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vector3i.m_123341_() + 0.5));
            double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vector3i.m_123342_());
            double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vector3i.m_123343_() + 0.5));
            boolean bl = flag = d0 < (double)this.f_26505_ && d2 < (double)this.f_26505_ && d1 < 1.0;
            if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.m_26559_(vector3d)) {
                this.f_26496_.m_77374_();
            }
            this.m_6481_(vector3d);
        }

        private boolean m_26559_(Vec3 currentPosition) {
            Vec3 vector3d3;
            if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
                return false;
            }
            Vec3 vector3d = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
            if (!currentPosition.m_82509_((Position)vector3d, 2.0)) {
                return false;
            }
            Vec3 vector3d1 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
            Vec3 vector3d2 = vector3d1.m_82546_(vector3d);
            return vector3d2.m_82526_(vector3d3 = currentPosition.m_82546_(vector3d)) > 0.0;
        }
    }
}

