/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.SilkMothEntity;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeSpawnEggItem;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SilkwormEntity
extends Animal
implements GeoEntity {
    private static final float BUOYANCY = 0.03f;
    private static final double CLIMB_SPEED = 0.05;
    private static final int EATING_INTERVAL = 40;
    private static final int EATING_DURATION = 100;
    private static final int EATING_ATTEMPTS = 3;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(SilkwormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FED_LILY = SynchedEntityData.m_135353_(SilkwormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(SilkwormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int eatingAttempt = 0;
    private int growingAge = -24000;
    private BlockPos targetLeafPos = null;
    private int eatingProgress = 0;
    private int eatingSoundTimer = 0;
    private Vec3 prevPosition = Vec3.f_82478_;
    private double actualMovementSpeed = 0.0;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private BlockPos lastClimbPos;

    public SilkwormEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6){

            public boolean m_8036_() {
                return !SilkwormEntity.this.isEating() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !SilkwormEntity.this.isEating() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(SilkwormEntity.getRandomVariant(world.m_213780_()));
        return super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void m_8119_() {
        BlockPos currentPos;
        boolean shouldClimb;
        super.m_8119_();
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.03f, motion.f_82481_);
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.f_19862_ && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.isClimbing()) {
            currentPos = this.m_20183_();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.m_9236_().f_46443_) {
                    this.f_21344_.m_26573_();
                    this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
                }
            } else if (this.f_19862_) {
                boolean hasBlockAbove;
                Vec3 deltaMovement = this.m_20184_();
                boolean shouldApplyClimbMovement = true;
                if (this.m_20096_() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.m_20334_(deltaMovement.f_82479_, 0.05, deltaMovement.f_82481_);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.m_20182_();
        this.actualMovementSpeed = currentPos.m_82554_(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(shouldClimb);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6162_() && !this.isFedLily()) {
            ++this.growingAge;
            if (this.growingAge >= 0) {
                this.convertToMoth();
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, level);
        navigation.m_7008_(true);
        return navigation;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() == FaunifyItems.SILKMOTH_SPAWN_EGG.get()) {
            if (!this.m_9236_().f_46443_) {
                SilkwormEntity silkworm = new SilkwormEntity((EntityType<? extends Animal>)((EntityType)FaunifyEntities.SILKWORM.get()), this.m_9236_());
                silkworm.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                silkworm.m_6863_(true);
                int roll = this.f_19796_.m_188503_(100);
                if (roll < 95) {
                    silkworm.setVariant(Variant.NORMAL);
                } else {
                    silkworm.setVariant(Variant.HUNGRY);
                }
                this.m_9236_().m_7967_((Entity)silkworm);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_(Items.f_151079_) && this.m_6162_() && !this.isFedLily()) {
            if (!this.m_9236_().f_46443_) {
                Level roll;
                this.m_146740_(SilkwormEntity.m_216967_((int)(-this.m_146764_())), true);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                if ((roll = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)roll;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.0);
                    }
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_(Items.f_41950_) && this.m_6162_() && !this.isFedLily()) {
            if (!this.m_9236_().f_46443_) {
                this.setFedLily(true);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<SilkwormEntity> event) {
        boolean climbing = this.isClimbing();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.m_20096_();
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Age", this.growingAge);
        tag.m_128379_("FedLily", this.isFedLily());
        tag.m_128405_("EatingProgress", this.eatingProgress);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128405_("ClimbingTime", this.climbingTime);
        tag.m_128405_("ClimbCooldown", this.climbCooldown);
        if (this.targetLeafPos != null) {
            tag.m_128356_("TargetLeafPos", this.targetLeafPos.m_121878_());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.growingAge = tag.m_128451_("Age");
        if (tag.m_128441_("FedLily")) {
            this.setFedLily(tag.m_128471_("FedLily"));
            this.climbingTime = tag.m_128451_("ClimbingTime");
            this.climbCooldown = tag.m_128451_("ClimbCooldown");
        }
        if (tag.m_128441_("EatingProgress")) {
            this.eatingProgress = tag.m_128451_("EatingProgress");
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        }
        if (tag.m_128441_("TargetLeafPos")) {
            this.targetLeafPos = BlockPos.m_122022_((long)tag.m_128454_("TargetLeafPos"));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(FED_LILY, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public boolean m_6162_() {
        return this.growingAge < 0;
    }

    public void m_6863_(boolean baby) {
        this.m_146762_(baby ? -24000 : 0);
    }

    public int m_146764_() {
        return this.growingAge;
    }

    public void m_146762_(int age) {
        this.growingAge = age;
    }

    public void m_146740_(int acceleratedAgeInTicks, boolean updateForcedAge) {
        if (!this.isFedLily()) {
            this.growingAge += acceleratedAgeInTicks;
        }
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7625_(DamageSource damageSource, boolean attackedRecently) {
        super.m_7625_(damageSource, attackedRecently);
    }

    public boolean m_6125_() {
        return true;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType((EntityType)((EntityType)FaunifyEntities.SILKMOTH.get())));
    }

    public boolean isFedLily() {
        return (Boolean)this.f_19804_.m_135370_(FED_LILY);
    }

    public void setFedLily(boolean fed) {
        this.f_19804_.m_135381_(FED_LILY, (Object)fed);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        Vec3 delta = this.m_20184_();
        double horizontalSpeed = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        return horizontalSpeed > 0.003;
    }

    public boolean isEating() {
        return this.targetLeafPos != null && this.isValidLeafBlock(this.targetLeafPos) && this.eatingProgress > 0;
    }

    private void convertToMoth() {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SilkMothEntity moth = (SilkMothEntity)((EntityType)FaunifyEntities.SILKMOTH.get()).m_20615_((Level)serverLevel);
            if (moth != null) {
                moth.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                moth.setFromSilkworm(true);
                moth.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(moth.m_20183_()), MobSpawnType.CONVERSION, null, null);
                serverLevel.m_7967_((Entity)moth);
                this.m_146870_();
            }
        }
    }

    private void handleLeafEating() {
        if (this.targetLeafPos == null || !this.isValidLeafBlock(this.targetLeafPos)) {
            this.targetLeafPos = this.findNearbyLeafBlock();
            this.eatingProgress = 0;
            this.eatingSoundTimer = 0;
            this.eatingAttempt = 0;
        }
        if (this.targetLeafPos != null && this.isValidLeafBlock(this.targetLeafPos)) {
            Vec3 leafCenter = Vec3.m_82512_((Vec3i)this.targetLeafPos);
            double dx = leafCenter.f_82479_ - this.m_20185_();
            double dz = leafCenter.f_82481_ - this.m_20189_();
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            this.m_146922_(targetYaw);
            this.f_19859_ = targetYaw;
            this.m_5616_(targetYaw);
            this.f_20886_ = targetYaw;
            ++this.eatingProgress;
            ++this.eatingSoundTimer;
            if (this.eatingSoundTimer >= 40) {
                for (int i = 0; i < 3; ++i) {
                    this.m_5496_(SoundEvents.f_11912_, 0.5f, 1.0f + (this.f_19796_.m_188501_() - 0.5f) * 0.2f);
                }
                this.eatingSoundTimer = 0;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockState state = this.m_9236_().m_8055_(this.targetLeafPos);
                    for (int i = 0; i < 5; ++i) {
                        double d0 = (double)this.targetLeafPos.m_123341_() + 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                        double d1 = (double)this.targetLeafPos.m_123342_() + 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                        double d2 = (double)this.targetLeafPos.m_123343_() + 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                        double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.08;
                        double ySpeed = (this.f_19796_.m_188500_() - 0.5) * 0.08;
                        double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.08;
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), d0, d1, d2, 1, xSpeed, ySpeed, zSpeed, 0.1);
                    }
                    Vec3 lookVec = this.m_20154_();
                    double mouthOffsetDistance = 0.4;
                    double mouthX = this.m_20185_() + lookVec.f_82479_ * mouthOffsetDistance;
                    double mouthY = this.m_20186_() + 0.15;
                    double mouthZ = this.m_20189_() + lookVec.f_82481_ * mouthOffsetDistance;
                    for (int i = 0; i < 3; ++i) {
                        double xOffset = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                        double yOffset = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                        double zOffset = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                        double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.05;
                        double ySpeed = this.f_19796_.m_188500_() * 0.05;
                        double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.05;
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), mouthX + xOffset, mouthY + yOffset, mouthZ + zOffset, 1, xSpeed, ySpeed, zSpeed, 0.05);
                    }
                }
            }
            if (this.eatingProgress >= 100) {
                ++this.eatingAttempt;
                if (this.eatingAttempt >= 3) {
                    this.m_9236_().m_46961_(this.targetLeafPos, false);
                    this.targetLeafPos = null;
                    this.eatingAttempt = 0;
                }
                this.eatingProgress = 0;
                this.eatingSoundTimer = 0;
            }
        }
    }

    private BlockPos findNearbyLeafBlock() {
        BlockPos[] positions;
        BlockPos pos = this.m_20183_();
        for (BlockPos checkPos : positions = new BlockPos[]{pos, pos.m_7495_(), pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_()}) {
            if (!this.isValidLeafBlock(checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean isValidLeafBlock(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        BlockState state = this.m_9236_().m_8055_(pos);
        return state.m_204336_(BlockTags.f_13035_);
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return true;
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean bl = hasAdjacentAtCurrentLevel = !this.m_9236_().m_8055_(north).m_60795_() && !this.m_9236_().m_8055_(north).m_247087_() || !this.m_9236_().m_8055_(south).m_60795_() && !this.m_9236_().m_8055_(south).m_247087_() || !this.m_9236_().m_8055_(east).m_60795_() && !this.m_9236_().m_8055_(east).m_247087_() || !this.m_9236_().m_8055_(west).m_60795_() && !this.m_9236_().m_8055_(west).m_247087_();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockPos northBelow = posBelow.m_122012_();
        BlockPos southBelow = posBelow.m_122019_();
        BlockPos eastBelow = posBelow.m_122029_();
        BlockPos westBelow = posBelow.m_122024_();
        return !this.m_9236_().m_8055_(northBelow).m_60795_() && !this.m_9236_().m_8055_(northBelow).m_247087_() || !this.m_9236_().m_8055_(southBelow).m_60795_() && !this.m_9236_().m_8055_(southBelow).m_247087_() || !this.m_9236_().m_8055_(eastBelow).m_60795_() && !this.m_9236_().m_8055_(eastBelow).m_247087_() || !this.m_9236_().m_8055_(westBelow).m_60795_() && !this.m_9236_().m_8055_(westBelow).m_247087_();
    }

    private static Variant getRandomVariant(RandomSource random) {
        int roll = random.m_188503_(100);
        if (roll < 95) {
            return Variant.NORMAL;
        }
        return Variant.HUNGRY;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL(0, "normal"),
        HUNGRY(1, "hungry");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

