/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WeevilEntity
extends Animal
implements GeoEntity {
    private static final int EAT_DELAY = 20;
    private static final int EATING_DURATION = 80;
    private static final float BUOYANCY = 0.03f;
    private static final double CLIMB_SPEED = 0.1;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(WeevilEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(WeevilEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(WeevilEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private PathNavigation groundNavigation;
    private Vec3 prevPosition = Vec3.f_82478_;
    private double actualMovementSpeed = 0.0;
    int moreCropTicks;
    private int eatingAnimationTick;
    private BlockPos targetCropPos;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private BlockPos lastClimbPos;

    public WeevilEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RaidCropsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CropTemptGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<WeevilEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public void m_8119_() {
        BlockPos currentPos;
        boolean shouldClimb;
        super.m_8119_();
        if (this.isEating()) {
            this.m_20256_(Vec3.f_82478_);
            this.f_21344_.m_26573_();
        }
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.03f, motion.f_82481_);
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.f_19862_ && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.isClimbing()) {
            currentPos = this.m_20183_();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.m_9236_().f_46443_) {
                    this.f_21344_.m_26573_();
                    this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
                }
            } else if (this.f_19862_) {
                boolean hasBlockAbove;
                Vec3 deltaMovement = this.m_20184_();
                boolean shouldApplyClimbMovement = true;
                if (this.m_20096_() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.m_20334_(deltaMovement.f_82479_, 0.1, deltaMovement.f_82481_);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.m_20182_();
        this.actualMovementSpeed = currentPos.m_82554_(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(shouldClimb);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.moreCropTicks > 0) {
            this.moreCropTicks -= this.f_19796_.m_188503_(3);
            if (this.moreCropTicks < 0) {
                this.moreCropTicks = 0;
            }
        }
        if (this.eatingAnimationTick > 0) {
            --this.eatingAnimationTick;
            if (this.targetCropPos != null) {
                this.m_21563_().m_24946_((double)this.targetCropPos.m_123341_() + 0.5, (double)this.targetCropPos.m_123342_() + 0.5, (double)this.targetCropPos.m_123343_() + 0.5);
            }
            if (this.eatingAnimationTick == 0) {
                this.setEating(false);
                if (this.targetCropPos != null && !this.m_9236_().f_46443_) {
                    this.breakCropAtPosition(this.targetCropPos);
                    this.targetCropPos = null;
                }
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, level);
        navigation.m_7008_(true);
        this.groundNavigation = navigation;
        return navigation;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_204336_(BlockTags.f_13073_) || blockstate.m_204336_(BlockTags.f_13073_)) {
            return 15.0f;
        }
        return super.m_5610_(pos, level);
    }

    protected float m_6041_() {
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        BlockState stateBelow = this.m_9236_().m_8055_(pos.m_7495_());
        if (state.m_60713_(Blocks.f_50093_) || state.m_204336_(BlockTags.f_13073_) || stateBelow.m_60713_(Blocks.f_50093_) || stateBelow.m_204336_(BlockTags.f_13073_)) {
            return 1.0f;
        }
        return super.m_6041_();
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<WeevilEntity> event) {
        boolean eating = this.isEating();
        boolean climbing = this.isClimbing();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.m_20096_();
        if (eating) {
            event.getController().setAnimation(RawAnimation.begin().then("eat", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128405_("MoreCropTicks", this.moreCropTicks);
        tag.m_128405_("EatingAnimationTick", this.eatingAnimationTick);
        tag.m_128405_("ClimbingTime", this.climbingTime);
        tag.m_128405_("ClimbCooldown", this.climbCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.moreCropTicks = tag.m_128451_("MoreCropTicks");
        this.eatingAnimationTick = tag.m_128451_("EatingAnimationTick");
        this.climbingTime = tag.m_128451_("ClimbingTime");
        this.climbCooldown = tag.m_128451_("ClimbCooldown");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(EATING, (Object)false);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    public boolean isActuallyMoving() {
        Vec3 delta = this.m_20184_();
        double horizontalSpeed = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return true;
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean bl = hasAdjacentAtCurrentLevel = !this.m_9236_().m_8055_(north).m_60795_() && !this.m_9236_().m_8055_(north).m_247087_() || !this.m_9236_().m_8055_(south).m_60795_() && !this.m_9236_().m_8055_(south).m_247087_() || !this.m_9236_().m_8055_(east).m_60795_() && !this.m_9236_().m_8055_(east).m_247087_() || !this.m_9236_().m_8055_(west).m_60795_() && !this.m_9236_().m_8055_(west).m_247087_();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockPos northBelow = posBelow.m_122012_();
        BlockPos southBelow = posBelow.m_122019_();
        BlockPos eastBelow = posBelow.m_122029_();
        BlockPos westBelow = posBelow.m_122024_();
        return !this.m_9236_().m_8055_(northBelow).m_60795_() && !this.m_9236_().m_8055_(northBelow).m_247087_() || !this.m_9236_().m_8055_(southBelow).m_60795_() && !this.m_9236_().m_8055_(southBelow).m_247087_() || !this.m_9236_().m_8055_(eastBelow).m_60795_() && !this.m_9236_().m_8055_(eastBelow).m_247087_() || !this.m_9236_().m_8055_(westBelow).m_60795_() && !this.m_9236_().m_8055_(westBelow).m_247087_();
    }

    boolean wantsMoreFood() {
        return this.moreCropTicks <= 0;
    }

    public boolean canBlockBeSeen(BlockPos pos) {
        Vec3 eyePos = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 blockVec = Vec3.m_82512_((Vec3i)pos);
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(eyePos, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return result.m_82425_().equals((Object)pos);
    }

    private void breakCropAtPosition(BlockPos cropPos) {
        Level level = this.m_9236_();
        BlockState blockstate = level.m_8055_(cropPos);
        Block block = blockstate.m_60734_();
        if (blockstate.m_204336_(BlockTags.f_13073_)) {
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                int age = cropBlock.m_52305_(blockstate);
                if (age == 0) {
                    level.m_46953_(cropPos, true, (Entity)this);
                } else {
                    level.m_7731_(cropPos, cropBlock.m_52289_(age - 1), 2);
                    level.m_46796_(2001, cropPos, Block.m_49956_((BlockState)blockstate));
                }
            } else {
                level.m_46953_(cropPos, true, (Entity)this);
            }
            this.moreCropTicks = 20;
        }
    }

    static class RaidCropsGoal
    extends MoveToBlockGoal {
        private final WeevilEntity weevil;
        private boolean wantsToRaid;
        private boolean canRaid;
        private boolean isAtDestination;

        public RaidCropsGoal(WeevilEntity weevil) {
            super((PathfinderMob)weevil, 1.0, 32, 8);
            this.weevil = weevil;
        }

        public double m_8052_() {
            return 1.5;
        }

        private BlockPos findNearbyCrops() {
            BlockState cropState;
            BlockPos belowPos;
            BlockPos currentPos = this.weevil.m_20183_();
            Level level = this.weevil.m_9236_();
            if (level.m_8055_(belowPos = currentPos.m_7495_()).m_60713_(Blocks.f_50093_) && (cropState = level.m_8055_(currentPos)).m_204336_(BlockTags.f_13073_) && this.weevil.canBlockBeSeen(currentPos)) {
                return belowPos;
            }
            if (level.m_8055_(currentPos).m_204336_(BlockTags.f_13073_) && level.m_8055_(belowPos).m_60713_(Blocks.f_50093_) && this.weevil.canBlockBeSeen(currentPos)) {
                return belowPos;
            }
            for (BlockPos checkPos : new BlockPos[]{currentPos.m_122012_(), currentPos.m_122019_(), currentPos.m_122029_(), currentPos.m_122024_()}) {
                BlockState cropState2;
                if (!level.m_8055_(checkPos).m_60713_(Blocks.f_50093_) || !(cropState2 = level.m_8055_(checkPos.m_7494_())).m_204336_(BlockTags.f_13073_) || !this.weevil.canBlockBeSeen(checkPos.m_7494_())) continue;
                return checkPos;
            }
            return null;
        }

        public boolean m_8036_() {
            if (this.weevil.isEating()) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.weevil.m_9236_(), (Entity)this.weevil)) {
                return false;
            }
            this.wantsToRaid = this.weevil.wantsMoreFood();
            if (!this.wantsToRaid) {
                return false;
            }
            BlockPos nearbyCrop = this.findNearbyCrops();
            if (nearbyCrop != null) {
                this.f_25602_ = nearbyCrop;
                this.canRaid = true;
                this.isAtDestination = true;
                this.f_25600_ = 0;
                return true;
            }
            if (this.f_25600_ > 0) {
                return false;
            }
            this.canRaid = false;
            return super.m_8036_();
        }

        public boolean m_8045_() {
            BlockPos nearbyCrop;
            if (this.weevil.isEating()) {
                return true;
            }
            if (this.wantsToRaid && !this.canRaid && (nearbyCrop = this.findNearbyCrops()) != null) {
                this.f_25602_ = nearbyCrop;
                this.canRaid = true;
                this.isAtDestination = true;
                return true;
            }
            return this.canRaid && super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.isAtDestination = false;
        }

        public void m_8037_() {
            if (this.f_25602_ == null) {
                return;
            }
            BlockPos targetPos = this.f_25602_;
            if (!this.weevil.isEating()) {
                if (!this.isWithinXZDist(targetPos, this.f_25598_.m_20182_(), this.m_8052_())) {
                    this.isAtDestination = false;
                    ++this.f_25601_;
                    this.f_25598_.m_21573_().m_26519_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5, this.f_25599_);
                } else {
                    this.isAtDestination = true;
                    --this.f_25601_;
                }
            }
            if (this.m_25625_()) {
                Level level = this.weevil.m_9236_();
                BlockPos cropPos = targetPos.m_7494_();
                BlockState cropState = level.m_8055_(cropPos);
                if (this.canRaid && cropState.m_204336_(BlockTags.f_13073_)) {
                    if (this.weevil.eatingAnimationTick == 0 && !this.weevil.isEating()) {
                        this.weevil.setEating(true);
                        this.weevil.eatingAnimationTick = 80;
                        this.weevil.targetCropPos = cropPos;
                    }
                    if (this.weevil.eatingAnimationTick > 0) {
                        return;
                    }
                }
                this.canRaid = false;
                this.f_25600_ = 10;
            }
        }

        private boolean isWithinXZDist(BlockPos blockpos, Vec3 posVec, double dist) {
            double dz;
            double dx = (double)blockpos.m_123341_() + 0.5 - posVec.f_82479_;
            return dx * dx + (dz = (double)blockpos.m_123343_() + 0.5 - posVec.f_82481_) * dz < dist * dist;
        }

        protected boolean m_25625_() {
            return this.isAtDestination;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockState cropState;
            BlockState farmlandState = level.m_8055_(pos);
            if (farmlandState.m_60713_(Blocks.f_50093_) && this.wantsToRaid && !this.canRaid && (cropState = level.m_8055_(pos.m_7494_())).m_204336_(BlockTags.f_13073_) && this.weevil.canBlockBeSeen(pos.m_7494_())) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    static class CropTemptGoal
    extends Goal {
        private final WeevilEntity weevil;
        private final double speedModifier;
        private BlockPos targetCropPos;
        private int cooldown;
        private static final int SEARCH_RANGE = 10;
        private static final int COOLDOWN_TICKS = 100;

        public CropTemptGoal(WeevilEntity weevil, double speed) {
            this.weevil = weevil;
            this.speedModifier = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.weevil.isEating()) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.targetCropPos = this.findNearbyCrop();
            return this.targetCropPos != null;
        }

        public boolean m_8045_() {
            if (this.weevil.isEating()) {
                return false;
            }
            if (this.targetCropPos == null) {
                return false;
            }
            BlockState state = this.weevil.m_9236_().m_8055_(this.targetCropPos);
            if (!state.m_204336_(BlockTags.f_13073_)) {
                return false;
            }
            double distSq = this.weevil.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetCropPos));
            return distSq > 4.0 && distSq < 100.0;
        }

        public void m_8056_() {
            if (this.targetCropPos != null) {
                this.weevil.m_21573_().m_26519_((double)this.targetCropPos.m_123341_() + 0.5, (double)this.targetCropPos.m_123342_(), (double)this.targetCropPos.m_123343_() + 0.5, this.speedModifier);
            }
        }

        public void m_8041_() {
            this.targetCropPos = null;
            this.cooldown = 100;
            this.weevil.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.targetCropPos != null) {
                this.weevil.m_21563_().m_24946_((double)this.targetCropPos.m_123341_() + 0.5, (double)this.targetCropPos.m_123342_() + 0.5, (double)this.targetCropPos.m_123343_() + 0.5);
                if (this.weevil.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetCropPos)) < 6.25) {
                    this.weevil.m_21573_().m_26519_((double)this.targetCropPos.m_123341_() + 0.5, (double)this.targetCropPos.m_123342_(), (double)this.targetCropPos.m_123343_() + 0.5, this.speedModifier);
                }
            }
        }

        @Nullable
        private BlockPos findNearbyCrop() {
            BlockPos weevilPos = this.weevil.m_20183_();
            Level level = this.weevil.m_9236_();
            BlockPos bestCrop = null;
            double closestDist = Double.MAX_VALUE;
            for (int x = -10; x <= 10; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -10; z <= 10; ++z) {
                        double dist;
                        BlockPos checkPos = weevilPos.m_7918_(x, y, z);
                        BlockState state = level.m_8055_(checkPos);
                        if (!state.m_204336_(BlockTags.f_13073_) || !((dist = weevilPos.m_123331_((Vec3i)checkPos)) > 4.0) || !(dist < closestDist)) continue;
                        closestDist = dist;
                        bestCrop = checkPos;
                    }
                }
            }
            return bestCrop;
        }
    }

    public static enum Variant implements StringRepresentable
    {
        ACORN(0, "acorn"),
        COMMON(1, "common"),
        GROUND(2, "ground");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

