/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.entity.SilkwormEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class CaterpillarModel
extends DefaultedEntityGeoModel<SilkwormEntity> {
    private Map<Long, Boolean> wasClimbing = new HashMap<Long, Boolean>();
    private Map<Long, HeadRotation> headRotations = new HashMap<Long, HeadRotation>();

    public CaterpillarModel() {
        super(new ResourceLocation("faunify", "caterpillar"), true);
    }

    public ResourceLocation getAnimationResource(SilkwormEntity object) {
        return new ResourceLocation("faunify", "animations/caterpillar.animation.json");
    }

    public void setCustomAnimations(SilkwormEntity entity, long uniqueID, AnimationState<SilkwormEntity> animationState) {
        CoreGeoBone base = this.getAnimationProcessor().getBone("base");
        CoreGeoBone bodyRotation = this.getAnimationProcessor().getBone("body_rotation");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        boolean isClimbing = entity.isClimbing();
        if (isClimbing) {
            if (base != null) {
                float targetPitch = -270.0f;
                base.setRotX(targetPitch * ((float)Math.PI / 180));
                base.setRotY(0.0f);
                base.setRotZ(0.0f);
                base.setPosZ(-4.0f);
            }
            if (bodyRotation != null) {
                bodyRotation.setRotX(-0.6981317f);
                bodyRotation.setRotY(0.0f);
                bodyRotation.setRotZ(0.0f);
            }
        } else {
            if (base != null) {
                base.setRotX(base.getInitialSnapshot().getRotX());
                base.setRotY(base.getInitialSnapshot().getRotY());
                base.setRotZ(base.getInitialSnapshot().getRotZ());
                base.setPosX(0.0f);
                base.setPosY(0.0f);
                base.setPosZ(0.0f);
            }
            if (bodyRotation != null) {
                bodyRotation.setRotX(bodyRotation.getInitialSnapshot().getRotX());
                bodyRotation.setRotY(bodyRotation.getInitialSnapshot().getRotY());
                bodyRotation.setRotZ(bodyRotation.getInitialSnapshot().getRotZ());
            }
        }
        this.wasClimbing.put(uniqueID, isClimbing);
        if (head != null && !isClimbing && !entity.m_21525_()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float headPitch = entityData.headPitch();
            float netHeadYaw = entityData.netHeadYaw();
            HeadRotation rotation = this.headRotations.get(uniqueID);
            if (rotation == null) {
                rotation = new HeadRotation();
                rotation.lastHeadPitch = headPitch;
                rotation.lastNetHeadYaw = netHeadYaw;
                this.headRotations.put(uniqueID, rotation);
            }
            float deltaPitch = headPitch - rotation.lastHeadPitch;
            float deltaYaw = netHeadYaw - rotation.lastNetHeadYaw;
            rotation.lastHeadPitch = headPitch;
            rotation.lastNetHeadYaw = netHeadYaw;
            float addRotX = deltaPitch * 0.5f * ((float)Math.PI / 180);
            float addRotY = deltaYaw * 0.5f * ((float)Math.PI / 180);
            rotation.rotX += addRotX;
            rotation.rotY += addRotY;
            rotation.rotX = Mth.m_14036_((float)rotation.rotX, (float)-0.3926991f, (float)0.3926991f);
            rotation.rotY = Mth.m_14036_((float)rotation.rotY, (float)-0.5235988f, (float)0.5235988f);
            head.setRotX(rotation.rotX);
            head.setRotY(rotation.rotY);
        } else if (head != null) {
            this.headRotations.remove(uniqueID);
            head.setRotX(head.getInitialSnapshot().getRotX());
            head.setRotY(head.getInitialSnapshot().getRotY());
            head.setRotZ(head.getInitialSnapshot().getRotZ());
        }
    }

    private static class HeadRotation {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float lastHeadPitch = 0.0f;
        float lastNetHeadYaw = 0.0f;

        private HeadRotation() {
        }
    }
}

