/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.config.FaunifyConfig;
import com.pepper.faunify.entity.ChinchillaEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class ChinchillaModel
extends DefaultedEntityGeoModel<ChinchillaEntity> {
    public ChinchillaModel() {
        super(new ResourceLocation("faunify", "chinchilla"), true);
    }

    public ResourceLocation getAnimationResource(ChinchillaEntity object) {
        if (((Boolean)FaunifyConfig.OLD_ANIMATION.get()).booleanValue()) {
            return new ResourceLocation("faunify", "animations/chinchilla.animation.json");
        }
        return new ResourceLocation("faunify", "animations/ratchinchilla.animation.json");
    }

    public void setCustomAnimations(ChinchillaEntity entity, long uniqueID, AnimationState<ChinchillaEntity> animationState) {
        boolean isIdle;
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone neck = this.getAnimationProcessor().getBone("head_rotation");
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        boolean moving = animationState.isMoving();
        if (head != null) {
            if (entity.m_6162_()) {
                float headScale = 1.3f;
                head.setScaleX(headScale);
                head.setScaleY(headScale);
                head.setScaleZ(headScale);
            } else {
                head.setScaleX(1.0f);
                head.setScaleY(1.0f);
                head.setScaleZ(1.0f);
            }
        }
        if (entity.m_5803_()) {
            return;
        }
        boolean bl = isIdle = !moving && !entity.m_21825_();
        if (!entity.m_21825_()) {
            if (!this.turnsHead || head == null) {
                return;
            }
            if (isIdle) {
                return;
            }
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        if (entity.m_21825_()) {
            if (head != null) {
                head.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180));
            }
            return;
        }
        if (neck != null && head != null) {
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180) * -0.5f);
        }
    }
}

