/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.entity.LeafSheepEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class LeafSheepModel
extends DefaultedEntityGeoModel<LeafSheepEntity> {
    public LeafSheepModel() {
        super(new ResourceLocation("faunify", "leafsheep"), true);
    }

    public ResourceLocation getAnimationResource(LeafSheepEntity object) {
        return new ResourceLocation("faunify", "animations/leafsheep.animation.json");
    }

    public void setCustomAnimations(LeafSheepEntity entity, long uniqueID, AnimationState<LeafSheepEntity> animationState) {
        if (!this.turnsHead) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("body");
        CoreGeoBone neck = this.getAnimationProcessor().getBone("body_rotation");
        boolean isClimbing = entity.isClimbing();
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (isClimbing) {
            if (head != null) {
                head.setRotX(-4.712389f);
                head.setRotY(0.0f);
                head.setRotZ(0.0f);
            }
            if (neck != null) {
                neck.setRotX(-0.6981317f);
                neck.setRotY(0.0f);
                neck.setRotZ(0.0f);
            }
        } else {
            float netHeadYaw;
            float headPitch;
            if (head != null) {
                headPitch = entityData.headPitch();
                netHeadYaw = entityData.netHeadYaw();
                boolean isMoving = animationState.isMoving();
                if (headPitch > 20.0f && !isMoving) {
                    head.setRotX((headPitch - 30.0f) * ((float)Math.PI / 180));
                } else {
                    head.setRotX(headPitch * ((float)Math.PI / 180));
                }
                head.setRotY(netHeadYaw * ((float)Math.PI / 180));
                head.setRotZ(0.0f);
            }
            if (neck != null) {
                headPitch = entityData.headPitch();
                netHeadYaw = entityData.netHeadYaw();
                neck.setRotX(Math.min(20.0f, headPitch) * ((float)Math.PI / 180));
                neck.setRotY(0.0f);
                neck.setRotZ(netHeadYaw * ((float)Math.PI / 180) * -0.5f);
            }
        }
    }
}

