/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.entity.MantisEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class MantisModel
extends DefaultedEntityGeoModel<MantisEntity> {
    private Map<Long, Boolean> wasClimbing = new HashMap<Long, Boolean>();
    private float lastHeadPitch = 0.0f;
    private float lastNetHeadYaw = 0.0f;

    public MantisModel() {
        super(new ResourceLocation("faunify", "mantis"), true);
    }

    public ResourceLocation getAnimationResource(MantisEntity object) {
        return new ResourceLocation("faunify", "animations/mantisarmtest.animation.json");
    }

    public void setCustomAnimations(MantisEntity entity, long uniqueID, AnimationState<MantisEntity> animationState) {
        CoreGeoBone base = this.getAnimationProcessor().getBone("base");
        CoreGeoBone bodyRotation = this.getAnimationProcessor().getBone("body_rotation");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        boolean isClimbing = entity.isClimbing();
        if (isClimbing) {
            if (base != null) {
                float targetPitch = -270.0f;
                base.setRotX(targetPitch * ((float)Math.PI / 180));
                base.setRotY(0.0f);
                base.setRotZ(0.0f);
                base.setPosZ(2.0f);
            }
            if (bodyRotation != null) {
                bodyRotation.setRotX(-0.6981317f);
                bodyRotation.setRotY(0.0f);
                bodyRotation.setRotZ(0.0f);
            }
        } else {
            if (base != null) {
                base.setRotX(base.getInitialSnapshot().getRotX());
                base.setRotY(base.getInitialSnapshot().getRotY());
                base.setRotZ(base.getInitialSnapshot().getRotZ());
                base.setPosX(0.0f);
                base.setPosY(0.0f);
                base.setPosZ(0.0f);
            }
            if (bodyRotation != null) {
                bodyRotation.setRotX(bodyRotation.getInitialSnapshot().getRotX());
                bodyRotation.setRotY(bodyRotation.getInitialSnapshot().getRotY());
                bodyRotation.setRotZ(bodyRotation.getInitialSnapshot().getRotZ());
            }
        }
        this.wasClimbing.put(uniqueID, isClimbing);
        if (head != null && !isClimbing && !entity.m_21525_()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float currentRotX = head.getRotX();
            float currentRotY = head.getRotY();
            float headPitch = entityData.headPitch();
            float netHeadYaw = entityData.netHeadYaw();
            float deltaPitch = headPitch - this.lastHeadPitch;
            float deltaYaw = netHeadYaw - this.lastNetHeadYaw;
            this.lastHeadPitch = headPitch;
            this.lastNetHeadYaw = netHeadYaw;
            float addRotX = deltaPitch * 0.5f * ((float)Math.PI / 180);
            float addRotY = deltaYaw * 0.5f * ((float)Math.PI / 180);
            float newRotX = currentRotX + addRotX;
            float newRotY = currentRotY + addRotY;
            newRotX = Mth.m_14036_((float)newRotX, (float)-2.0f, (float)2.0f);
            newRotY = Mth.m_14036_((float)newRotY, (float)-3.0f, (float)3.0f);
            head.setRotX(newRotX);
            head.setRotY(newRotY);
        } else if (head != null) {
            head.setRotX(head.getInitialSnapshot().getRotX());
            head.setRotY(head.getInitialSnapshot().getRotY());
            head.setRotZ(head.getInitialSnapshot().getRotZ());
        }
    }
}

