/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.BeetleEntity;
import com.pepper.faunify.entity.client.model.BeetleModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BeetleRenderer
extends GeoEntityRenderer<BeetleEntity> {
    private static final ResourceLocation ATLAS = new ResourceLocation("faunify", "textures/entity/bigbeetle_atlas.png");
    private static final ResourceLocation DYNASTID = new ResourceLocation("faunify", "textures/entity/bigbeetle_dynastid.png");
    private static final ResourceLocation ELEPHANT = new ResourceLocation("faunify", "textures/entity/bigbeetle_elephant.png");
    private static final ResourceLocation GOLIATH = new ResourceLocation("faunify", "textures/entity/bigbeetle_goliath.png");
    private static final ResourceLocation HERCULES = new ResourceLocation("faunify", "textures/entity/bigbeetle_hercules.png");
    private static final ResourceLocation CYCLOMMATUS = new ResourceLocation("faunify", "textures/entity/smallbeetle_cyclommatus.png");
    private static final ResourceLocation GIANT = new ResourceLocation("faunify", "textures/entity/smallbeetle_giant.png");
    private static final ResourceLocation GIRAFFE = new ResourceLocation("faunify", "textures/entity/smallbeetle_giraffe.png");
    private static final ResourceLocation MIYAMA = new ResourceLocation("faunify", "textures/entity/smallbeetle_miyama.png");
    private static final ResourceLocation RAINBOW = new ResourceLocation("faunify", "textures/entity/smallbeetle_rainbow.png");
    private static final ResourceLocation SAW = new ResourceLocation("faunify", "textures/entity/smallbeetle_saw.png");
    private static final ResourceLocation GOLDEN = new ResourceLocation("faunify", "textures/entity/smallbeetle_golden.png");
    private static final ResourceLocation PHOBIA_TEXTURE = new ResourceLocation("faunify", "textures/entity/phobiafriendly/beetle.png");
    private static final ResourceLocation PEST = new ResourceLocation("faunify", "textures/entity/bigbeetle_pest.png");
    private static final int SOUND_INTERVAL_TICKS = 15;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> soundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public BeetleRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new BeetleModel());
        this.f_114477_ = 0.45f;
    }

    public ResourceLocation getTextureLocation(BeetleEntity entity) {
        if (((Boolean)FaunifyClientConfig.BEETLE_PHOBIA_FRIENDLY.get()).booleanValue()) {
            return PHOBIA_TEXTURE;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        if ("pest".equals(entityName)) {
            return PEST;
        }
        return BeetleRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(PoseStack stack, BeetleEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            BeetleRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && animatable.m_29443_() && !((Boolean)FaunifyClientConfig.BEETLE_PHOBIA_FRIENDLY.get()).booleanValue()) {
            UUID uuid = animatable.m_20148_();
            int currentTick = animatable.f_19797_;
            Integer lastSoundTick = soundTimers.get(uuid);
            if (lastSoundTick == null || currentTick - lastSoundTick >= 15) {
                animatable.m_9236_().m_7785_(animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_(), (SoundEvent)FaunifySounds.BUG_FLY_FAST_TACKY.get(), animatable.m_5720_(), 0.25f, 1.0f, false);
                soundTimers.put(uuid, currentTick);
            }
        } else if (!animatable.m_29443_()) {
            soundTimers.remove(animatable.m_20148_());
        }
        float bugScale = 0.9f;
        stack.m_85841_(bugScale, bugScale, bugScale);
    }

    public static ResourceLocation getVariantTexture(BeetleEntity.Variant variant) {
        switch (variant) {
            case ATLAS: {
                return ATLAS;
            }
            case DYNASTID: {
                return DYNASTID;
            }
            case ELEPHANT: {
                return ELEPHANT;
            }
            case GOLIATH: {
                return GOLIATH;
            }
            case HERCULES: {
                return HERCULES;
            }
            case CYCLOMMATUS: {
                return CYCLOMMATUS;
            }
            case GIANT: {
                return GIANT;
            }
            case GIRAFFE: {
                return GIRAFFE;
            }
            case MIYAMA: {
                return MIYAMA;
            }
            case RAINBOW: {
                return RAINBOW;
            }
            case SAW: {
                return SAW;
            }
            case GOLDEN: {
                return GOLDEN;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private static void cleanupStaleEntries() {
        if (soundTimers.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            soundTimers.clear();
            return;
        }
        Iterator<UUID> iterator = soundTimers.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (mc.f_91073_.m_6815_(uuid.hashCode()) != null) continue;
            iterator.remove();
        }
    }
}

