/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.DragonflyEntity;
import com.pepper.faunify.entity.client.model.DragonflyModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class DragonflyRenderer
extends GeoEntityRenderer<DragonflyEntity> {
    private static final ResourceLocation WHITETAIL = new ResourceLocation("faunify", "textures/entity/dragonfly_whitetail.png");
    private static final ResourceLocation DARNER = new ResourceLocation("faunify", "textures/entity/dragonfly_darner.png");
    private static final ResourceLocation SKIMMER = new ResourceLocation("faunify", "textures/entity/dragonfly_skimmer.png");
    private static final ResourceLocation DAMSEL = new ResourceLocation("faunify", "textures/entity/dragonfly_damsel.png");
    private static final ResourceLocation PETALTAIL = new ResourceLocation("faunify", "textures/entity/dragonfly_petaltail.png");
    private static final ResourceLocation PHOBIA_TEXTURE = new ResourceLocation("faunify", "textures/entity/phobiafriendly/dragonfly.png");
    private static final int CONTINUOUS_SOUND_INTERVAL = 10;
    private static final int FLAP_SOUND_INTERVAL = 10;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> continuousSoundTimers = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> flapSoundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public DragonflyRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DragonflyModel());
        this.f_114477_ = 0.4f;
    }

    public ResourceLocation getTextureLocation(DragonflyEntity entity) {
        if (((Boolean)FaunifyClientConfig.DRAGONFLY_PHOBIA_FRIENDLY.get()).booleanValue()) {
            return PHOBIA_TEXTURE;
        }
        return DragonflyRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(PoseStack stack, DragonflyEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            DragonflyRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && animatable.m_29443_() && !((Boolean)FaunifyClientConfig.DRAGONFLY_PHOBIA_FRIENDLY.get()).booleanValue()) {
            UUID uuid = animatable.m_20148_();
            int currentTick = animatable.f_19797_;
            Integer lastContinuousTick = continuousSoundTimers.get(uuid);
            if (lastContinuousTick == null || currentTick - lastContinuousTick >= 10) {
                animatable.m_9236_().m_7785_(animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_(), (SoundEvent)FaunifySounds.BUG_FLY_FAST_TACKY.get(), animatable.m_5720_(), 0.08f, 0.8f, false);
                continuousSoundTimers.put(uuid, currentTick);
            }
            if (!animatable.isHovering()) {
                Integer lastFlapTick = flapSoundTimers.get(uuid);
                if (lastFlapTick == null || currentTick - lastFlapTick >= 10) {
                    animatable.m_9236_().m_7785_(animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_(), (SoundEvent)FaunifySounds.BUG_FLY_FAST_TACKY.get(), animatable.m_5720_(), 0.3f, 1.5f, false);
                    flapSoundTimers.put(uuid, currentTick);
                }
            } else {
                flapSoundTimers.remove(uuid);
            }
        } else if (!animatable.m_29443_()) {
            continuousSoundTimers.remove(animatable.m_20148_());
            flapSoundTimers.remove(animatable.m_20148_());
        }
        float bugScale = 0.9f;
        stack.m_85841_(bugScale, bugScale, bugScale);
    }

    public static ResourceLocation getVariantTexture(DragonflyEntity.Variant variant) {
        switch (variant) {
            case WHITETAIL: {
                return WHITETAIL;
            }
            case DARNER: {
                return DARNER;
            }
            case SKIMMER: {
                return SKIMMER;
            }
            case DAMSEL: {
                return DAMSEL;
            }
            case PETALTAIL: {
                return PETALTAIL;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private static void cleanupStaleEntries() {
        if (continuousSoundTimers.isEmpty() && flapSoundTimers.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            continuousSoundTimers.clear();
            flapSoundTimers.clear();
            return;
        }
        Iterator<UUID> continuousIterator = continuousSoundTimers.keySet().iterator();
        while (continuousIterator.hasNext()) {
            UUID uuid = continuousIterator.next();
            if (mc.f_91073_.m_6815_(uuid.hashCode()) != null) continue;
            continuousIterator.remove();
        }
        Iterator<UUID> flapIterator = flapSoundTimers.keySet().iterator();
        while (flapIterator.hasNext()) {
            UUID uuid = flapIterator.next();
            if (mc.f_91073_.m_6815_(uuid.hashCode()) != null) continue;
            flapIterator.remove();
        }
    }
}

