/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.LadybugEntity;
import com.pepper.faunify.entity.client.model.LadybugModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class LadybugRenderer
extends GeoEntityRenderer<LadybugEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("faunify", "textures/entity/ladybug.png");
    private static final ResourceLocation PHOBIA_TEXTURE = new ResourceLocation("faunify", "textures/entity/phobiafriendly/ladybug.png");
    private static final ResourceLocation CATBUG = new ResourceLocation("faunify", "textures/entity/ladybug_catbug.png");
    private static final ResourceLocation TIKKI = new ResourceLocation("faunify", "textures/entity/ladybug_tikki.png");
    private static final int SOUND_INTERVAL_TICKS = 15;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> soundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public LadybugRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new LadybugModel());
        this.f_114477_ = 0.45f;
    }

    public ResourceLocation getTextureLocation(LadybugEntity entity) {
        if (((Boolean)FaunifyClientConfig.LADYBUG_PHOBIA_FRIENDLY.get()).booleanValue()) {
            return PHOBIA_TEXTURE;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        if ("catbug".equals(entityName)) {
            return CATBUG;
        }
        if ("tikki".equals(entityName)) {
            return TIKKI;
        }
        return TEXTURE;
    }

    public void preRender(PoseStack stack, LadybugEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            LadybugRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && animatable.m_29443_() && !((Boolean)FaunifyClientConfig.LADYBUG_PHOBIA_FRIENDLY.get()).booleanValue()) {
            UUID uuid = animatable.m_20148_();
            int currentTick = animatable.f_19797_;
            Integer lastSoundTick = soundTimers.get(uuid);
            if (lastSoundTick == null || currentTick - lastSoundTick >= 15) {
                animatable.m_9236_().m_7785_(animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_(), (SoundEvent)FaunifySounds.BUG_FLY_FAST_TACKY.get(), animatable.m_5720_(), 0.25f, 1.0f, false);
                soundTimers.put(uuid, currentTick);
            }
        } else if (!animatable.m_29443_()) {
            soundTimers.remove(animatable.m_20148_());
        }
        float bugScale = 1.1f;
        stack.m_85841_(bugScale, bugScale, bugScale);
    }

    private static void cleanupStaleEntries() {
        if (soundTimers.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            soundTimers.clear();
            return;
        }
        Iterator<UUID> iterator = soundTimers.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (mc.f_91073_.m_6815_(uuid.hashCode()) != null) continue;
            iterator.remove();
        }
    }
}

