/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.MantisEntity;
import com.pepper.faunify.entity.client.model.MantisModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MantisRenderer
extends GeoEntityRenderer<MantisEntity> {
    private static final ResourceLocation GREEN = new ResourceLocation("faunify", "textures/entity/mantis_green.png");
    private static final ResourceLocation ORCHID = new ResourceLocation("faunify", "textures/entity/mantis_orchid.png");
    private static final ResourceLocation PHOBIA_TEXTURE = new ResourceLocation("faunify", "textures/entity/phobiafriendly/mantis.png");

    public MantisRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new MantisModel());
        this.f_114477_ = 0.45f;
    }

    public ResourceLocation getTextureLocation(MantisEntity entity) {
        if (((Boolean)FaunifyClientConfig.MANTIS_PHOBIA_FRIENDLY.get()).booleanValue()) {
            return PHOBIA_TEXTURE;
        }
        if (entity.isOrchidVariant()) {
            return ORCHID;
        }
        return GREEN;
    }

    public static ResourceLocation getVariantTexture(MantisEntity.Variant variant, boolean isOrchid) {
        if (isOrchid) {
            return ORCHID;
        }
        switch (variant) {
            case GREEN: {
                return GREEN;
            }
            case ORCHID: {
                return ORCHID;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    public static ResourceLocation getVariantTexture(MantisEntity.Variant variant) {
        return MantisRenderer.getVariantTexture(variant, false);
    }

    public void preRender(PoseStack stack, MantisEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        float mantisScale = 0.9f;
        stack.m_85841_(mantisScale, mantisScale, mantisScale);
    }
}

