/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.MillipedeHeadEntity;
import com.pepper.faunify.entity.client.model.MillipedeHeadModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MillipedeHeadRenderer
extends GeoEntityRenderer<MillipedeHeadEntity> {
    private static final ResourceLocation GIANT = new ResourceLocation("faunify", "textures/entity/millipede1.png");
    private static final ResourceLocation TWISTEDCLAW = new ResourceLocation("faunify", "textures/entity/millipede2.png");
    private static final ResourceLocation NARCEUS = new ResourceLocation("faunify", "textures/entity/millipede3.png");
    private static final ResourceLocation PHOBIA_TEXTURE = new ResourceLocation("faunify", "textures/entity/phobiafriendly/millipede.png");
    private static final int SOUND_INTERVAL_TICKS = 10;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> soundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public MillipedeHeadRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new MillipedeHeadModel());
        this.f_114477_ = 0.45f;
    }

    public ResourceLocation getTextureLocation(MillipedeHeadEntity entity) {
        if (((Boolean)FaunifyClientConfig.MILLIPEDE_PHOBIA_FRIENDLY.get()).booleanValue()) {
            return PHOBIA_TEXTURE;
        }
        return MillipedeHeadRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(PoseStack stack, MillipedeHeadEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            MillipedeHeadRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && !((Boolean)FaunifyClientConfig.MILLIPEDE_PHOBIA_FRIENDLY.get()).booleanValue()) {
            boolean isMoving = animatable.m_20184_().m_165925_() > 1.0E-4;
            boolean isOnGround = animatable.m_20096_();
            if (isMoving && isOnGround) {
                UUID uuid = animatable.m_20148_();
                int currentTick = animatable.f_19797_;
                Integer lastSoundTick = soundTimers.get(uuid);
                if (lastSoundTick == null || currentTick - lastSoundTick >= 10) {
                    animatable.m_9236_().m_7785_(animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_(), (SoundEvent)FaunifySounds.MILLIPEDE_WALK.get(), animatable.m_5720_(), 0.5f, 1.0f, false);
                    soundTimers.put(uuid, currentTick);
                }
            } else if (!isMoving) {
                soundTimers.remove(animatable.m_20148_());
            }
        }
        float bugScale = 1.15f;
        stack.m_85841_(bugScale, bugScale, bugScale);
    }

    public static ResourceLocation getVariantTexture(MillipedeHeadEntity.Variant variant) {
        switch (variant) {
            case GIANT: {
                return GIANT;
            }
            case TWISTEDCLAW: {
                return TWISTEDCLAW;
            }
            case NARCEUS: {
                return NARCEUS;
            }
        }
        return GIANT;
    }

    private static void cleanupStaleEntries() {
        if (soundTimers.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            soundTimers.clear();
            return;
        }
        Iterator<UUID> iterator = soundTimers.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (mc.f_91073_.m_6815_(uuid.hashCode()) != null) continue;
            iterator.remove();
        }
    }
}

