/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.pepper.faunify.entity.OpossumEntity;
import com.pepper.faunify.entity.client.model.OpossumModel;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class OpossumRenderer
extends GeoEntityRenderer<OpossumEntity> {
    private static final ResourceLocation REGULAR = new ResourceLocation("faunify", "textures/entity/opossum1.png");
    private static final ResourceLocation LIGHT = new ResourceLocation("faunify", "textures/entity/opossum2.png");
    private static final ResourceLocation DARK = new ResourceLocation("faunify", "textures/entity/opossum2.png");
    private static final ResourceLocation REGULAR_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/opossum1.png");
    private static final ResourceLocation LIGHT_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/opossum2.png");
    private static final ResourceLocation DARK_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/opossum2.png");
    private static final String SNOUT_BONE = "snout";

    public OpossumRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new OpossumModel());
        this.f_114477_ = 0.45f;
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<OpossumEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, OpossumEntity animatable) {
                if (OpossumRenderer.SNOUT_BONE.equals(bone.getName()) && !animatable.getMouthItem().m_41619_()) {
                    return animatable.getMouthItem();
                }
                return null;
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, OpossumEntity animatable) {
                return OpossumRenderer.SNOUT_BONE.equals(bone.getName()) ? ItemDisplayContext.FIXED : ItemDisplayContext.NONE;
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, OpossumEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (OpossumRenderer.SNOUT_BONE.equals(bone.getName())) {
                    if (animatable.m_6162_()) {
                        poseStack.m_85837_(0.0, -0.03, -0.15);
                        poseStack.m_85841_(0.35f, 0.35f, 0.35f);
                    } else {
                        poseStack.m_85837_(0.0, -0.03, -0.15);
                        poseStack.m_85841_(0.35f, 0.35f, 0.35f);
                    }
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(OpossumEntity entity) {
        return OpossumRenderer.getVariantTexture(entity.getVariant(), entity.m_5803_());
    }

    public static ResourceLocation getVariantTexture(OpossumEntity.Variant variant, boolean isSleeping) {
        return switch (variant) {
            case OpossumEntity.Variant.REGULAR -> isSleeping ? REGULAR_SLEEPING : REGULAR;
            case OpossumEntity.Variant.LIGHT -> isSleeping ? LIGHT_SLEEPING : LIGHT;
            case OpossumEntity.Variant.DARK -> isSleeping ? DARK_SLEEPING : DARK;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static ResourceLocation getVariantTexture(OpossumEntity.Variant variant) {
        return OpossumRenderer.getVariantTexture(variant, false);
    }

    public void preRender(PoseStack stack, OpossumEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.m_6162_()) {
            float babyScale = 0.45f;
            stack.m_85841_(babyScale, babyScale, babyScale);
        } else {
            float adultScale = 1.1f;
            stack.m_85841_(adultScale, adultScale, adultScale);
        }
    }
}

