/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.StickbugEntity;
import com.pepper.faunify.entity.client.model.StickbugModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class StickbugRenderer
extends GeoEntityRenderer<StickbugEntity> {
    private static final ResourceLocation BROWN = new ResourceLocation("faunify", "textures/entity/stickbug1.png");
    private static final ResourceLocation DARKBROWN = new ResourceLocation("faunify", "textures/entity/stickbug2.png");
    private static final ResourceLocation GREEN = new ResourceLocation("faunify", "textures/entity/stickbug3.png");
    private static final ResourceLocation DARKGREEN = new ResourceLocation("faunify", "textures/entity/stickbug4.png");
    private static final ResourceLocation GREY = new ResourceLocation("faunify", "textures/entity/stickbug5.png");
    private static final ResourceLocation PHOBIA_TEXTURE = new ResourceLocation("faunify", "textures/entity/phobiafriendly/stickbug.png");

    public StickbugRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new StickbugModel());
        this.f_114477_ = 0.55f;
    }

    public ResourceLocation getTextureLocation(StickbugEntity entity) {
        if (((Boolean)FaunifyClientConfig.STICKBUG_PHOBIA_FRIENDLY.get()).booleanValue()) {
            return PHOBIA_TEXTURE;
        }
        return StickbugRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(PoseStack stack, StickbugEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        float bugScale = 0.9f;
        stack.m_85841_(bugScale, bugScale, bugScale);
    }

    public void actuallyRender(PoseStack poseStack, StickbugEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (((Boolean)FaunifyClientConfig.STICKBUG_PHOBIA_FRIENDLY.get()).booleanValue()) {
            float camouflageBlend = animatable.getCamouflageBlend();
            int blockColor = animatable.getBlockBelowColor();
            if (blockColor == 0 || camouflageBlend == 0.0f) {
                super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                return;
            }
            float blockRed = (float)(blockColor >> 16 & 0xFF) / 255.0f;
            float blockGreen = (float)(blockColor >> 8 & 0xFF) / 255.0f;
            float blockBlue = (float)(blockColor & 0xFF) / 255.0f;
            float maxChannel = Math.max(Math.max(blockRed, blockGreen), blockBlue);
            float minChannel = Math.min(Math.min(blockRed, blockGreen), blockBlue);
            float blockSaturation = maxChannel > 0.0f ? (maxChannel - minChannel) / maxChannel : 0.0f;
            float grey = (blockRed + blockGreen + blockBlue) / 3.0f;
            float desaturationFactor = 1.0f;
            float tintedRed = this.lerp(grey, blockRed, blockSaturation * desaturationFactor);
            float tintedGreen = this.lerp(grey, blockGreen, blockSaturation * desaturationFactor);
            float tintedBlue = this.lerp(grey, blockBlue, blockSaturation * desaturationFactor);
            float brightnessBoost = 1.5f;
            tintedRed = Math.min(1.0f, tintedRed * brightnessBoost);
            tintedGreen = Math.min(1.0f, tintedGreen * brightnessBoost);
            tintedBlue = Math.min(1.0f, tintedBlue * brightnessBoost);
            float finalRed = this.lerp(red, tintedRed, camouflageBlend);
            float finalGreen = this.lerp(green, tintedGreen, camouflageBlend);
            float finalBlue = this.lerp(blue, tintedBlue, camouflageBlend);
            super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, finalRed, finalGreen, finalBlue, alpha);
            return;
        }
        float camouflageBlend = animatable.getCamouflageBlend();
        int blockColor = animatable.getBlockBelowColor();
        if (blockColor == 0) {
            super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            return;
        }
        if (camouflageBlend < 1.0f) {
            float originalAlpha = alpha * (1.0f - camouflageBlend);
            super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, originalAlpha);
        }
        if (camouflageBlend > 0.0f) {
            float blockRed = (float)(blockColor >> 16 & 0xFF) / 255.0f;
            float blockGreen = (float)(blockColor >> 8 & 0xFF) / 255.0f;
            float blockBlue = (float)(blockColor & 0xFF) / 255.0f;
            float maxChannel = Math.max(Math.max(blockRed, blockGreen), blockBlue);
            float minChannel = Math.min(Math.min(blockRed, blockGreen), blockBlue);
            float blockSaturation = maxChannel > 0.0f ? (maxChannel - minChannel) / maxChannel : 0.0f;
            float grey = (blockRed + blockGreen + blockBlue) / 3.0f;
            float desaturationFactor = 1.0f;
            float tintedRed = this.lerp(grey, blockRed, blockSaturation * desaturationFactor);
            float tintedGreen = this.lerp(grey, blockGreen, blockSaturation * desaturationFactor);
            float tintedBlue = this.lerp(grey, blockBlue, blockSaturation * desaturationFactor);
            float brightnessBoost = 1.5f;
            tintedRed = Math.min(1.0f, tintedRed * brightnessBoost);
            tintedGreen = Math.min(1.0f, tintedGreen * brightnessBoost);
            tintedBlue = Math.min(1.0f, tintedBlue * brightnessBoost);
            ResourceLocation greyTexture = StickbugRenderer.getVariantTexture(StickbugEntity.Variant.GREY);
            RenderType greyRenderType = RenderType.m_110473_((ResourceLocation)greyTexture);
            VertexConsumer greyBuffer = bufferSource.m_6299_(greyRenderType);
            float greyAlpha = alpha * camouflageBlend;
            super.actuallyRender(poseStack, (Entity)animatable, model, greyRenderType, bufferSource, greyBuffer, isReRender, partialTick, packedLight, packedOverlay, tintedRed, tintedGreen, tintedBlue, greyAlpha);
        }
    }

    public static ResourceLocation getVariantTexture(StickbugEntity.Variant variant) {
        switch (variant) {
            case BROWN: {
                return BROWN;
            }
            case DARKBROWN: {
                return DARKBROWN;
            }
            case GREEN: {
                return GREEN;
            }
            case DARKGREEN: {
                return DARKGREEN;
            }
            case GREY: {
                return GREY;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private float lerp(float start, float end, float amount) {
        return start + (end - start) * amount;
    }
}

