/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.WeevilEntity;
import com.pepper.faunify.entity.client.model.WeevilModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class WeevilRenderer
extends GeoEntityRenderer<WeevilEntity> {
    private static final ResourceLocation ACORN = new ResourceLocation("faunify", "textures/entity/weevil_acorn.png");
    private static final ResourceLocation COMMON = new ResourceLocation("faunify", "textures/entity/weevil_common.png");
    private static final ResourceLocation GROUND = new ResourceLocation("faunify", "textures/entity/weevil_ground.png");
    private static final ResourceLocation PHOBIA_TEXTURE = new ResourceLocation("faunify", "textures/entity/phobiafriendly/weevil.png");

    public WeevilRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new WeevilModel());
        this.f_114477_ = 0.45f;
    }

    public ResourceLocation getTextureLocation(WeevilEntity entity) {
        if (((Boolean)FaunifyClientConfig.WEEVIL_PHOBIA_FRIENDLY.get()).booleanValue()) {
            return PHOBIA_TEXTURE;
        }
        return WeevilRenderer.getVariantTexture(entity.getVariant());
    }

    public static ResourceLocation getVariantTexture(WeevilEntity.Variant variant) {
        switch (variant) {
            case ACORN: {
                return ACORN;
            }
            case COMMON: {
                return COMMON;
            }
            case GROUND: {
                return GROUND;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    public void preRender(PoseStack stack, WeevilEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        float bugScale = 0.9f;
        stack.m_85841_(bugScale, bugScale, bugScale);
    }
}

