/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.goal;

import com.pepper.faunify.entity.client.IFlyingBug;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BugFlightGoal<T extends Animal & IFlyingBug>
extends Goal {
    private final T insect;
    private final int maxFlightHeight;
    private final int flightChanceModifier;
    private double x;
    private double y;
    private double z;
    private int flyDuration;
    private int restDuration;
    private int currentTimer;
    private boolean shouldRest;
    private int landingTimer;
    private Vec3 landingTarget;

    public BugFlightGoal(T insect, int maxFlightHeight, int flightChanceModifier) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.insect = insect;
        this.maxFlightHeight = maxFlightHeight;
        this.flightChanceModifier = flightChanceModifier;
        this.resetTimers();
        this.landingTimer = 0;
    }

    public boolean m_8036_() {
        if (this.insect.m_20160_() || this.insect.m_20159_()) {
            return false;
        }
        if (!((FlyingAnimal)this.insect).m_29443_() && this.insect.m_217043_().m_188503_(this.flightChanceModifier) != 0 && !this.shouldRest) {
            return false;
        }
        Vec3 target = this.getPosition();
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    public boolean m_8045_() {
        if (!((FlyingAnimal)this.insect).m_29443_() && this.insect.m_20096_() && this.currentTimer >= this.restDuration) {
            return false;
        }
        if (((IFlyingBug)this.insect).getLandingFlag()) {
            return !this.insect.m_20096_() && ((IFlyingBug)this.insect).getGroundedFor() <= 0;
        }
        return ((FlyingAnimal)this.insect).m_29443_() && !this.insect.m_21573_().m_26571_() && ((IFlyingBug)this.insect).getGroundedFor() <= 0;
    }

    public void m_8056_() {
        ((IFlyingBug)this.insect).setFlying(true);
        this.insect.m_21573_().m_26519_(this.x, this.y, this.z, 0.5);
    }

    public void m_8041_() {
        this.insect.m_21573_().m_26573_();
        ((IFlyingBug)this.insect).setLandingFlag(false);
        this.landingTimer = 0;
        this.landingTarget = null;
        if (this.insect.m_20096_()) {
            this.insect.m_20256_(Vec3.f_82478_);
        }
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        super.m_8041_();
    }

    public void m_8037_() {
        if (!((FlyingAnimal)this.insect).m_29443_() && this.insect.m_20096_()) {
            ++this.currentTimer;
            BlockPos bugPos = this.insect.m_20183_();
            BlockState stateAtPos = this.insect.m_9236_().m_8055_(bugPos);
            if (!stateAtPos.m_60795_() && !stateAtPos.m_247087_()) {
                return;
            }
            this.insect.m_20256_(Vec3.f_82478_);
            this.insect.m_21573_().m_26573_();
            return;
        }
        ++this.currentTimer;
        if (((FlyingAnimal)this.insect).m_29443_()) {
            Vec3 newTarget;
            if ((this.insect.m_21573_().m_26571_() || this.currentTimer % 40 == 0) && !((IFlyingBug)this.insect).getLandingFlag() && (newTarget = this.findFlightPos()) != null) {
                this.insect.m_21573_().m_26519_(newTarget.f_82479_, newTarget.f_82480_, newTarget.f_82481_, 0.5);
            }
            if (this.currentTimer >= this.flyDuration) {
                this.shouldRest = true;
                ((IFlyingBug)this.insect).setLandingFlag(true);
                if (this.landingTarget == null) {
                    this.landingTarget = this.findLandingPos();
                }
            }
            if (((IFlyingBug)this.insect).getLandingFlag()) {
                if (this.landingTarget == null) {
                    this.landingTarget = this.findLandingPos();
                }
                if (this.landingTarget != null) {
                    ++this.landingTimer;
                    if (this.landingTimer % 15 == 0) {
                        Vec3 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                        this.insect.m_21573_().m_26519_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_, (double)0.3f);
                    }
                    if (this.insect.m_20096_() || this.insect.m_20186_() - this.landingTarget.f_82480_ < 1.0 && this.landingTimer > 40) {
                        ((IFlyingBug)this.insect).setFlying(false);
                        this.insect.m_20256_(Vec3.f_82478_);
                        this.insect.m_21573_().m_26573_();
                        this.currentTimer = 0;
                        this.shouldRest = false;
                        ((IFlyingBug)this.insect).setLandingFlag(false);
                        this.landingTarget = null;
                        this.landingTimer = 0;
                        this.resetTimers();
                    }
                } else {
                    ((IFlyingBug)this.insect).setLandingFlag(false);
                    this.shouldRest = false;
                    this.landingTimer = 0;
                }
            }
        }
        if (this.isOverWaterOrVoid() || this.insect.m_20072_()) {
            ((IFlyingBug)this.insect).setFlying(true);
            ((IFlyingBug)this.insect).setLandingFlag(false);
            this.shouldRest = false;
            this.landingTimer = 0;
            this.landingTarget = null;
        }
    }

    private void resetTimers() {
        this.flyDuration = 100 + this.insect.m_217043_().m_188503_(100);
        this.restDuration = 120 + this.insect.m_217043_().m_188503_(100);
        this.currentTimer = 0;
        this.shouldRest = false;
        this.landingTimer = 0;
    }

    private Vec3 getPosition() {
        if (this.shouldRest) {
            this.landingTarget = this.findLandingPos();
            return this.getCirclingPosition(this.landingTarget);
        }
        return this.findFlightPos();
    }

    private Vec3 getDescentPosition(Vec3 target, int timer) {
        if (target == null) {
            return this.insect.m_20182_();
        }
        double progress = Math.min((double)timer / 80.0, 1.0);
        double angle = (double)timer * 0.15 % (Math.PI * 2);
        double radius = 1.5 * (1.0 - progress * 0.7);
        double xOffset = Math.cos(angle) * radius;
        double zOffset = Math.sin(angle) * radius;
        double currentHeight = this.insect.m_20186_();
        double targetHeight = target.f_82480_ + 0.5;
        double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.25;
        return new Vec3(target.f_82479_ + xOffset, Math.max(descentHeight, targetHeight), target.f_82481_ + zOffset);
    }

    private Vec3 getCirclingPosition(Vec3 target) {
        double angle = this.insect.m_217043_().m_188500_() * Math.PI * 2.0;
        double radius = 1.5 + this.insect.m_217043_().m_188500_() * 1.5;
        double xOffset = Math.cos(angle) * radius;
        double zOffset = Math.sin(angle) * radius;
        double yOffset = 2.0 + this.insect.m_217043_().m_188500_();
        return new Vec3(target.f_82479_ + xOffset, target.f_82480_ + yOffset, target.f_82481_ + zOffset);
    }

    private Vec3 findFlightPos() {
        int range = 10;
        int maxAttempts = 10;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            Vec3 basePos = this.insect.m_20182_().m_82520_((double)(this.insect.m_217043_().m_188503_(range * 2) - range), 0.0, (double)(this.insect.m_217043_().m_188503_(range * 2) - range));
            Vec3 ground = this.groundPosition(basePos);
            BlockPos groundBlockPos = BlockPos.m_274446_((Position)ground);
            if (!this.insect.m_9236_().m_6425_(groundBlockPos).m_76178_()) {
                continue;
            }
            int flightHeight = 1 + this.insect.m_217043_().m_188503_(this.maxFlightHeight);
            Vec3 targetPos = new Vec3(basePos.f_82479_, ground.f_82480_ + (double)flightHeight, basePos.f_82481_);
            BlockHitResult result = this.insect.m_9236_().m_45547_(new ClipContext(this.insect.m_146892_(), targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.insect));
            if (result.m_6662_() == HitResult.Type.MISS) {
                return targetPos;
            }
            return result.m_82450_();
        }
        Vec3 ground = this.groundPosition(this.insect.m_20182_());
        return new Vec3(this.insect.m_20185_(), ground.f_82480_ + 2.0, this.insect.m_20189_());
    }

    private Vec3 findLandingPos() {
        Vec3 currentPos = this.insect.m_20182_();
        Vec3 ground = this.groundPosition(currentPos);
        BlockPos landingPos = BlockPos.m_274446_((Position)ground);
        if (!this.insect.m_9236_().m_6425_(landingPos).m_76178_()) {
            for (int attempt = 0; attempt < 8; ++attempt) {
                int offsetX = this.insect.m_217043_().m_188503_(6) - 3;
                int offsetZ = this.insect.m_217043_().m_188503_(6) - 3;
                BlockPos testPos = landingPos.m_7918_(offsetX, 0, offsetZ);
                Vec3 testGround = this.groundPosition(Vec3.m_82512_((Vec3i)testPos));
                BlockPos testGroundPos = BlockPos.m_274446_((Position)testGround);
                if (!this.insect.m_9236_().m_6425_(testGroundPos).m_76178_()) continue;
                landingPos = testGroundPos;
                break;
            }
            if (!this.insect.m_9236_().m_6425_(landingPos).m_76178_()) {
                return null;
            }
        }
        while (landingPos.m_123342_() < this.insect.m_9236_().m_151558_() && !this.insect.m_9236_().m_8055_(landingPos).m_60795_() && !this.insect.m_9236_().m_8055_(landingPos).m_247087_()) {
            landingPos = landingPos.m_7494_();
        }
        return Vec3.m_82512_((Vec3i)landingPos);
    }

    private Vec3 groundPosition(Vec3 airPosition) {
        BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos();
        ground.m_122169_(airPosition.f_82479_, airPosition.f_82480_, airPosition.f_82481_);
        boolean flag = false;
        while (ground.m_123342_() < this.insect.m_9236_().m_151558_() && !this.insect.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.insect.m_9236_(), (BlockPos)ground) && this.insect.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
            ground.m_122184_(0, 1, 0);
            flag = true;
        }
        ground.m_122184_(0, -1, 0);
        while (ground.m_123342_() > this.insect.m_9236_().m_141937_() && !this.insect.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.insect.m_9236_(), (BlockPos)ground) && this.insect.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
            ground.m_122184_(0, -1, 0);
        }
        return Vec3.m_82512_((Vec3i)(flag ? ground.m_7494_() : ground.m_7495_()));
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.insect.m_20183_();
        while (position.m_123342_() > this.insect.m_9236_().m_141937_() && this.insect.m_9236_().m_46859_(position) && this.insect.m_9236_().m_6425_(position).m_76178_()) {
            position = position.m_7495_();
        }
        return !this.insect.m_9236_().m_6425_(position).m_76178_() || this.insect.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= this.insect.m_9236_().m_141937_();
    }
}

