/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class BugWanderGoal
extends Goal {
    private final Animal entity;
    private final FlyingAnimal flyingEntity;
    private double x;
    private double y;
    private double z;
    private int wanderTimer;

    public BugWanderGoal(Animal entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.entity = entity;
        this.flyingEntity = (FlyingAnimal)entity;
        this.wanderTimer = 0;
    }

    public boolean m_8036_() {
        if (this.flyingEntity.m_29443_() || this.entity.m_20160_() || this.entity.m_20159_()) {
            return false;
        }
        if (this.entity.m_217043_().m_188503_(120) != 0) {
            return false;
        }
        Vec3 target = this.getWanderPosition();
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        this.wanderTimer = 60 + this.entity.m_217043_().m_188503_(60);
        return true;
    }

    public boolean m_8045_() {
        return !this.flyingEntity.m_29443_() && !this.entity.m_21573_().m_26571_() && this.wanderTimer > 0;
    }

    public void m_8056_() {
        this.entity.m_21573_().m_26519_(this.x, this.y, this.z, (double)0.8f);
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.wanderTimer = 0;
    }

    public void m_8037_() {
        --this.wanderTimer;
    }

    private Vec3 getWanderPosition() {
        int range = 8;
        BlockPos currentPos = this.entity.m_20183_();
        BlockPos targetPos = currentPos.m_7918_(this.entity.m_217043_().m_188503_(range * 2) - range, 0, this.entity.m_217043_().m_188503_(range * 2) - range);
        BlockPos groundPos = this.findGround(targetPos);
        if (groundPos != null && this.entity.m_9236_().m_8055_(groundPos).m_60804_((BlockGetter)this.entity.m_9236_(), groundPos)) {
            return Vec3.m_82539_((Vec3i)groundPos.m_7494_());
        }
        return null;
    }

    private BlockPos findGround(BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (mutable.m_123342_() > this.entity.m_9236_().m_141937_() && this.entity.m_9236_().m_46859_((BlockPos)mutable)) {
            mutable.m_122184_(0, -1, 0);
        }
        if (mutable.m_123342_() <= this.entity.m_9236_().m_141937_()) {
            return null;
        }
        return mutable.m_7949_();
    }
}

