/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.projectile;

import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifyTriggers;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DustPowderEntity
extends ThrowableItemProjectile {
    public DustPowderEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DustPowderEntity(Level pLevel) {
        super((EntityType)FaunifyEntities.DUST_POWDER_PROJECTILE.get(), pLevel);
    }

    public DustPowderEntity(Level pLevel, LivingEntity livingEntity) {
        super((EntityType)FaunifyEntities.DUST_POWDER_PROJECTILE.get(), livingEntity, pLevel);
    }

    protected Item m_7881_() {
        return (Item)FaunifyItems.DUST_POWDER.get();
    }

    public void m_7822_(byte eventId) {
        if (eventId == 3) {
            SimpleParticleType particleOptions = ParticleTypes.f_123759_;
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)particleOptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockParticleOption gravelParticle = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49994_.m_49966_());
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)gravelParticle, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1);
            }
        }
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_ && (entity = this.m_19749_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            FaunifyTriggers.HIT_DUST.trigger(serverPlayer, result.m_82443_());
        }
        if ((entity = result.m_82443_()) instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 120, 0));
            mob.m_6710_(null);
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 2));
            mob.m_6710_(null);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            mob.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
            double knockbackStrength = 0.1;
            Vec3 direction = this.m_20184_().m_82541_();
            mob.m_5997_(direction.f_82479_ * knockbackStrength, 0.05, direction.f_82481_ * knockbackStrength);
            this.m_9236_().m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_11877_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.m_146870_();
    }
}

