/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.items;

import com.pepper.faunify.entity.MillipedeHeadEntity;
import com.pepper.faunify.entity.MillipedeSegmentEntity;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifyTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class BugNetItem
extends Item {
    public static final TagKey<EntityType<?>> CATCHABLE_ENTITIES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("faunify", "bug_net_catchable"));

    public BugNetItem(Item.Properties properties) {
        super(properties);
    }

    public static void registerItemProperties() {
        ItemProperties.register((Item)((Item)FaunifyItems.BUG_NET.get()), (ResourceLocation)new ResourceLocation("faunify", "has_entity"), (stack, level, entity, seed) -> BugNetItem.hasStoredEntity(stack) ? 1.0f : 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        ItemStack filledNet;
        if (BugNetItem.hasStoredEntity(stack)) {
            return InteractionResult.PASS;
        }
        if (!this.canCatchEntity(target)) {
            return InteractionResult.PASS;
        }
        if (player.m_9236_().f_46443_) return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        MillipedeHeadEntity headToDiscard = null;
        if (target instanceof MillipedeHeadEntity) {
            MillipedeHeadEntity millipedeHead = (MillipedeHeadEntity)target;
            filledNet = this.captureMillipede(stack, millipedeHead, player);
            headToDiscard = millipedeHead;
        } else if (target instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity segment = (MillipedeSegmentEntity)target;
            MillipedeHeadEntity head = this.findHead(segment);
            if (head == null) return InteractionResult.FAIL;
            filledNet = this.captureMillipede(stack, head, player);
            headToDiscard = head;
        } else {
            filledNet = this.getFilledNet(stack, target);
        }
        filledNet.m_41721_(stack.m_41773_());
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (player.m_150110_().f_35937_) {
            if (!player.m_150109_().m_36054_(filledNet)) {
                player.m_36176_(filledNet, false);
            }
        } else {
            player.m_21008_(hand, filledNet);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FaunifyTriggers.CATCH_ENTITY.trigger(serverPlayer, (Entity)target, stack);
            FaunifyTriggers.CATCH_ALL_BEETLES.trigger(serverPlayer, (Entity)target, stack);
        }
        if (headToDiscard != null) {
            headToDiscard.m_146870_();
        } else {
            target.m_146870_();
        }
        player.m_9236_().m_220400_((Entity)player, GameEvent.f_223708_, target.m_20182_());
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag entityTag;
        Optional entityTypeOpt;
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (!BugNetItem.hasStoredEntity(stack) || player == null) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos spawnPos = clickedPos.m_121945_(context.m_43719_());
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128441_("StoredEntity") && (entityTypeOpt = EntityType.m_20637_((CompoundTag)(entityTag = stackTag.m_128469_("StoredEntity")))).isPresent()) {
            EntityType entityType = (EntityType)entityTypeOpt.get();
            if (stackTag.m_128471_("IsMillipede")) {
                return this.spawnMillipede(stackTag, (ServerLevel)level, spawnPos, player, context, stack);
            }
            Entity entity = entityType.m_20615_((Level)((ServerLevel)level));
            if (entity != null) {
                entity.m_20258_(entityTag);
                if (player.m_150110_().f_35937_) {
                    entity.m_20084_(UUID.randomUUID());
                }
                if (entity instanceof Mob) {
                    ((Mob)entity).m_21530_();
                }
                entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), 0.0f);
                boolean spawned = level.m_7967_(entity);
                if (spawned) {
                    level.m_5594_(null, spawnPos, SoundEvents.f_12016_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    level.m_142346_((Entity)player, GameEvent.f_157810_, spawnPos);
                    if (!player.m_150110_().f_35937_) {
                        ItemStack emptyNet = new ItemStack((ItemLike)this);
                        emptyNet.m_41721_(stack.m_41773_());
                        emptyNet.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                        player.m_21008_(context.m_43724_(), emptyNet);
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    private MillipedeHeadEntity findHead(MillipedeSegmentEntity segment) {
        MillipedeSegmentEntity current = segment;
        int safety = 0;
        while (current instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity millipedeSeg = current;
            if (safety >= 20) break;
            Entity parent = millipedeSeg.getParentSegment();
            if (parent instanceof MillipedeHeadEntity) {
                MillipedeHeadEntity head = (MillipedeHeadEntity)parent;
                return head;
            }
            if (!(parent instanceof MillipedeSegmentEntity)) break;
            current = parent;
            ++safety;
        }
        return null;
    }

    private ItemStack captureMillipede(ItemStack emptyNet, MillipedeHeadEntity head, Player player) {
        Object object;
        ItemStack filledNet = new ItemStack((ItemLike)this);
        CompoundTag stackTag = filledNet.m_41784_();
        CompoundTag headTag = new CompoundTag();
        head.m_20223_(headTag);
        stackTag.m_128365_("StoredEntity", (Tag)headTag);
        stackTag.m_128359_("StoredEntityType", EntityType.m_20613_((EntityType)head.m_6095_()).toString());
        stackTag.m_128379_("IsMillipede", true);
        ArrayList<CompoundTag> segmentTags = new ArrayList<CompoundTag>();
        if (!player.m_9236_().f_46443_ && (object = player.m_9236_()) instanceof ServerLevel) {
            Entity current;
            ServerLevel serverLevel = (ServerLevel)object;
            UUID childId = head.getChildId();
            Entity entity = current = childId != null ? serverLevel.m_8791_(childId) : null;
            while (current instanceof MillipedeSegmentEntity) {
                MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
                CompoundTag segTag = new CompoundTag();
                segment.m_20223_(segTag);
                segmentTags.add(segTag);
                segment.m_146870_();
                UUID nextId = segment.getChildId();
                current = nextId != null ? serverLevel.m_8791_(nextId) : null;
            }
        }
        if (!segmentTags.isEmpty()) {
            ListTag segmentList = new ListTag();
            for (CompoundTag segTag : segmentTags) {
                segmentList.add((Object)segTag);
            }
            stackTag.m_128365_("MillipedeSegments", (Tag)segmentList);
        }
        return filledNet;
    }

    private InteractionResult spawnMillipede(CompoundTag stackTag, ServerLevel level, BlockPos spawnPos, Player player, UseOnContext context, ItemStack stack) {
        CompoundTag headTag = stackTag.m_128469_("StoredEntity");
        Optional headTypeOpt = EntityType.m_20637_((CompoundTag)headTag);
        if (headTypeOpt.isEmpty() || !(((EntityType)headTypeOpt.get()).m_20615_((Level)level) instanceof MillipedeHeadEntity)) {
            return InteractionResult.FAIL;
        }
        MillipedeHeadEntity head = (MillipedeHeadEntity)((EntityType)headTypeOpt.get()).m_20615_((Level)level);
        if (head == null) {
            return InteractionResult.FAIL;
        }
        head.m_20258_(headTag);
        if (player.m_150110_().f_35937_) {
            head.m_20084_(UUID.randomUUID());
        }
        head.m_21530_();
        head.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), 0.0f);
        boolean headSpawned = level.m_7967_((Entity)head);
        if (!headSpawned) {
            return InteractionResult.FAIL;
        }
        if (stackTag.m_128441_("MillipedeSegments")) {
            ListTag segmentList = stackTag.m_128437_("MillipedeSegments", 10);
            PathfinderMob previousEntity = head;
            for (int i = 0; i < segmentList.size(); ++i) {
                Entity segment;
                CompoundTag segTag = segmentList.m_128728_(i);
                Optional segTypeOpt = EntityType.m_20637_((CompoundTag)segTag);
                if (!segTypeOpt.isPresent() || !((segment = ((EntityType)segTypeOpt.get()).m_20615_((Level)level)) instanceof MillipedeSegmentEntity)) continue;
                MillipedeSegmentEntity millipedeSeg = (MillipedeSegmentEntity)segment;
                millipedeSeg.m_20258_(segTag);
                if (player.m_150110_().f_35937_) {
                    millipedeSeg.m_20084_(UUID.randomUUID());
                }
                millipedeSeg.m_21530_();
                millipedeSeg.setParentSegment((Entity)previousEntity);
                if (previousEntity instanceof MillipedeHeadEntity) {
                    MillipedeHeadEntity prevHead = previousEntity;
                    prevHead.setChildId(millipedeSeg.m_20148_());
                } else if (previousEntity instanceof MillipedeSegmentEntity) {
                    MillipedeSegmentEntity prevSeg = (MillipedeSegmentEntity)previousEntity;
                    prevSeg.setChildId(millipedeSeg.m_20148_());
                }
                millipedeSeg.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), 0.0f);
                level.m_7967_((Entity)millipedeSeg);
                previousEntity = millipedeSeg;
            }
        }
        level.m_5594_(null, spawnPos, SoundEvents.f_12016_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        level.m_142346_((Entity)player, GameEvent.f_157810_, spawnPos);
        if (!player.m_150110_().f_35937_) {
            ItemStack emptyNet = new ItemStack((ItemLike)this);
            emptyNet.m_41721_(stack.m_41773_());
            emptyNet.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            player.m_21008_(context.m_43724_(), emptyNet);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean canCatchEntity(LivingEntity entity) {
        return entity.m_6095_().m_204039_(CATCHABLE_ENTITIES);
    }

    private ItemStack getFilledNet(ItemStack emptyNet, LivingEntity entity) {
        ItemStack filledNet = new ItemStack((ItemLike)this);
        CompoundTag entityTag = new CompoundTag();
        entity.m_20223_(entityTag);
        CompoundTag stackTag = filledNet.m_41784_();
        stackTag.m_128365_("StoredEntity", (Tag)entityTag);
        stackTag.m_128359_("StoredEntityType", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
        return filledNet;
    }

    private static boolean hasStoredEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("StoredEntity");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String entityTypeId;
        Optional entityType;
        CompoundTag tag;
        if (BugNetItem.hasStoredEntity(stack) && (tag = stack.m_41783_()) != null && tag.m_128441_("StoredEntityType") && (entityType = EntityType.m_20632_((String)(entityTypeId = tag.m_128461_("StoredEntityType")))).isPresent()) {
            Component entityName = ((EntityType)entityType.get()).m_20676_();
            tooltip.add((Component)Component.m_237110_((String)"item.faunify.bug_net.contains", (Object[])new Object[]{entityName}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            if (tag.m_128471_("IsMillipede") && tag.m_128441_("MillipedeSegments")) {
                int segmentCount = tag.m_128437_("MillipedeSegments", 10).size();
                tooltip.add((Component)Component.m_237113_((String)("  (" + (segmentCount + 1) + " parts)")).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return BugNetItem.hasStoredEntity(stack);
    }
}

