/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.registry;

import com.pepper.faunify.blocks.BugCatcherBlock;
import com.pepper.faunify.blocks.DustBlock;
import com.pepper.faunify.blocks.InsectHabitatBlock;
import com.pepper.faunify.blocks.SilkwormEggsBlock;
import com.pepper.faunify.registry.FaunifyItems;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FaunifyBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"faunify");
    public static final RegistryObject<Block> DUST_BLOCK = FaunifyBlocks.registerBlock("dust_block", () -> new DustBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).m_60918_(SoundType.f_56746_)));
    public static final RegistryObject<Block> SILKWORM_EGGS = FaunifyBlocks.registerBlock("silkworm_eggs", () -> new SilkwormEggsBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60918_(SoundType.f_222466_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> WHITE_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("white_bug_catcher", DyeColor.WHITE);
    public static final RegistryObject<Block> ORANGE_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("orange_bug_catcher", DyeColor.ORANGE);
    public static final RegistryObject<Block> MAGENTA_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("magenta_bug_catcher", DyeColor.MAGENTA);
    public static final RegistryObject<Block> LIGHT_BLUE_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("light_blue_bug_catcher", DyeColor.LIGHT_BLUE);
    public static final RegistryObject<Block> YELLOW_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("yellow_bug_catcher", DyeColor.YELLOW);
    public static final RegistryObject<Block> LIME_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("lime_bug_catcher", DyeColor.LIME);
    public static final RegistryObject<Block> PINK_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("pink_bug_catcher", DyeColor.PINK);
    public static final RegistryObject<Block> GRAY_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("gray_bug_catcher", DyeColor.GRAY);
    public static final RegistryObject<Block> LIGHT_GRAY_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("light_gray_bug_catcher", DyeColor.LIGHT_GRAY);
    public static final RegistryObject<Block> CYAN_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("cyan_bug_catcher", DyeColor.CYAN);
    public static final RegistryObject<Block> PURPLE_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("purple_bug_catcher", DyeColor.PURPLE);
    public static final RegistryObject<Block> BLUE_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("blue_bug_catcher", DyeColor.BLUE);
    public static final RegistryObject<Block> BROWN_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("brown_bug_catcher", DyeColor.BROWN);
    public static final RegistryObject<Block> GREEN_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("green_bug_catcher", DyeColor.GREEN);
    public static final RegistryObject<Block> RED_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("red_bug_catcher", DyeColor.RED);
    public static final RegistryObject<Block> BLACK_BUG_CATCHER = FaunifyBlocks.registerBugCatcher("black_bug_catcher", DyeColor.BLACK);
    public static final RegistryObject<Block> WHITE_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("white_insect_habitat", DyeColor.WHITE);
    public static final RegistryObject<Block> ORANGE_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("orange_insect_habitat", DyeColor.ORANGE);
    public static final RegistryObject<Block> MAGENTA_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("magenta_insect_habitat", DyeColor.MAGENTA);
    public static final RegistryObject<Block> LIGHT_BLUE_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("light_blue_insect_habitat", DyeColor.LIGHT_BLUE);
    public static final RegistryObject<Block> YELLOW_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("yellow_insect_habitat", DyeColor.YELLOW);
    public static final RegistryObject<Block> LIME_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("lime_insect_habitat", DyeColor.LIME);
    public static final RegistryObject<Block> PINK_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("pink_insect_habitat", DyeColor.PINK);
    public static final RegistryObject<Block> GRAY_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("gray_insect_habitat", DyeColor.GRAY);
    public static final RegistryObject<Block> LIGHT_GRAY_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("light_gray_insect_habitat", DyeColor.LIGHT_GRAY);
    public static final RegistryObject<Block> CYAN_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("cyan_insect_habitat", DyeColor.CYAN);
    public static final RegistryObject<Block> PURPLE_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("purple_insect_habitat", DyeColor.PURPLE);
    public static final RegistryObject<Block> BLUE_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("blue_insect_habitat", DyeColor.BLUE);
    public static final RegistryObject<Block> BROWN_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("brown_insect_habitat", DyeColor.BROWN);
    public static final RegistryObject<Block> GREEN_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("green_insect_habitat", DyeColor.GREEN);
    public static final RegistryObject<Block> RED_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("red_insect_habitat", DyeColor.RED);
    public static final RegistryObject<Block> BLACK_INSECT_HABITAT = FaunifyBlocks.registerInsectHabitat("black_insect_habitat", DyeColor.BLACK);
    public static final TagKey<Block> DETECTABLE_ORES = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("faunify", "ringtailcat_detectable_ores"));

    private static RegistryObject<Block> registerBugCatcher(String name, DyeColor color) {
        return FaunifyBlocks.registerBlock(name, () -> new BugCatcherBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.25f).m_60918_(SoundType.f_154653_).m_60955_(), color));
    }

    private static RegistryObject<Block> registerInsectHabitat(String name, DyeColor color) {
        return FaunifyBlocks.registerBlock(name, () -> new InsectHabitatBlock(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_154653_).m_60955_(), color));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        FaunifyBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return FaunifyItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

