/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify;

import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.config.FaunifyConfig;
import com.pepper.faunify.event.AnvilRepairHandler;
import com.pepper.faunify.event.BrewingRecipeHandler;
import com.pepper.faunify.event.CreativeTabHandler;
import com.pepper.faunify.items.tabs.FaunifyCreativeTabs;
import com.pepper.faunify.registry.FaunifyBlockEntities;
import com.pepper.faunify.registry.FaunifyBlocks;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifyParticles;
import com.pepper.faunify.registry.FaunifyPotions;
import com.pepper.faunify.registry.FaunifySounds;
import com.pepper.faunify.registry.FaunifyTriggers;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Faunify
implements ModInitializer {
    public static final String MODID = "faunify";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"faunify");

    public void onInitialize() {
        LOGGER.info("Initializing Faunify...");
        FaunifyConfig.load();
        FaunifyClientConfig.load();
        FaunifyItems.register();
        FaunifyBlocks.register();
        FaunifyBlockEntities.register();
        FaunifySounds.register();
        FaunifyEntities.register();
        FaunifyParticles.register();
        FaunifyPotions.register();
        FaunifyCreativeTabs.register();
        FaunifyEntities.registerSpawnPlacements();
        FaunifyEntities.addBiomeSpawns();
        FaunifyTriggers.register();
        CreativeTabHandler.register();
        BrewingRecipeHandler.register();
        ServerTickEvents.END_SERVER_TICK.register(server -> server.method_3760().method_14571().forEach(AnvilRepairHandler::onPlayerTick));
        System.setProperty("logging.level.software.bernie.geckolib", "ERROR");
        Faunify.suppressSTDOUT();
        LOGGER.info("Faunify initialized successfully!");
    }

    private static void suppressSTDOUT() {
        final PrintStream originalOut = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                String output = new String(b, off, len);
                if (!output.contains("Unable to find animation:")) {
                    originalOut.write(b, off, len);
                }
            }
        }));
    }
}

