/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.blocks;

import com.pepper.faunify.blocks.entity.BugCatcherBlockEntity;
import com.pepper.faunify.items.BugNetItem;
import com.pepper.faunify.registry.FaunifyTriggers;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class BugCatcherBlock
extends class_2237 {
    private static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
    private final class_1767 color;

    public BugCatcherBlock(class_4970.class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
    }

    public class_1767 getColor() {
        return this.color;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof BugCatcherBlockEntity)) {
            return class_1269.field_5811;
        }
        BugCatcherBlockEntity bugCatcher = (BugCatcherBlockEntity)be;
        if (stack.method_7909() instanceof BugNetItem) {
            boolean isMultiPart;
            if (this.hasStoredEntity(stack) && !bugCatcher.hasBug() && (isMultiPart = this.isMultiPartEntity(stack))) {
                if (!world.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.faunify.bug_too_big"), true);
                }
                return class_1269.field_5812;
            }
            if (!world.field_9236) {
                class_2487 bugData;
                if (this.hasStoredEntity(stack) && !bugCatcher.hasBug()) {
                    class_2487 bugData2 = this.extractBugData(stack);
                    if (bugData2 != null) {
                        float snappedRotation = this.snapToCardinal(player.method_36454()) + 180.0f;
                        bugCatcher.storeBug(bugData2, snappedRotation);
                        if (player instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)player;
                            class_2487 entityTag = bugData2.method_10562("StoredEntity");
                            if (entityTag != null && world instanceof class_3218) {
                                class_1297 tempEntity;
                                class_3218 serverWorld = (class_3218)world;
                                Optional entityTypeOpt = class_1299.method_17684((class_2487)entityTag);
                                if (entityTypeOpt.isPresent() && (tempEntity = ((class_1299)entityTypeOpt.get()).method_5883((class_1937)serverWorld)) != null) {
                                    tempEntity.method_5651(entityTag);
                                    FaunifyTriggers.STORE_BUG.trigger(serverPlayer, tempEntity, stack);
                                }
                            }
                        }
                        class_1799 emptyNet = new class_1799((class_1935)stack.method_7909());
                        emptyNet.method_7974(stack.method_7919());
                        player.method_6122(hand, emptyNet);
                        world.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1.0f, 1.0f);
                        return class_1269.field_5812;
                    }
                } else if (!this.hasStoredEntity(stack) && bugCatcher.hasBug() && (bugData = bugCatcher.removeBug()) != null) {
                    class_1799 filledNet = this.createFilledBugNet(stack, bugData);
                    player.method_6122(hand, filledNet);
                    world.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BugCatcherBlockEntity(pos, state);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            BugCatcherBlockEntity bugCatcher;
            class_2586 be = world.method_8321(pos);
            if (be instanceof BugCatcherBlockEntity && (bugCatcher = (BugCatcherBlockEntity)be).hasBug() && !world.field_9236 && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_2487 bugData = bugCatcher.getStoredBugData();
                if (bugData != null) {
                    this.spawnStoredEntity(serverWorld, pos, bugData);
                }
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    private float snapToCardinal(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return 90.0f;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return 180.0f;
        }
        return 270.0f;
    }

    private void spawnStoredEntity(class_3218 world, class_2338 pos, class_2487 bugData) {
        class_1297 entity;
        if (!bugData.method_10545("StoredEntity")) {
            return;
        }
        class_2487 entityTag = bugData.method_10562("StoredEntity");
        world.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 1.0f, 1.0f);
        Optional entityTypeOpt = class_1299.method_17684((class_2487)entityTag);
        if (entityTypeOpt.isPresent() && (entity = ((class_1299)entityTypeOpt.get()).method_5883((class_1937)world)) != null) {
            entity.method_5651(entityTag);
            entity.method_5826(UUID.randomUUID());
            if (entity instanceof class_1309) {
                class_2487 nbt = new class_2487();
                entity.method_5647(nbt);
                if (nbt.method_10545("Caught")) {
                    nbt.method_10551("Caught");
                    entity.method_5651(nbt);
                }
                if (entity instanceof ICatchable) {
                    ICatchable catchable = (ICatchable)entity;
                    catchable.setCaught(false);
                }
            }
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.25, (double)pos.method_10260() + 0.5, world.field_9229.method_43057() * 360.0f, 0.0f);
            world.method_8649(entity);
        }
    }

    private boolean hasStoredEntity(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10545("StoredEntity");
    }

    private boolean isMultiPartEntity(class_1799 stack) {
        if (!stack.method_7985()) {
            return false;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545("StoredEntity")) {
            return false;
        }
        class_2487 entityTag = tag.method_10562("StoredEntity");
        boolean hasParts = entityTag.method_10545("Parts");
        boolean hasSegments = entityTag.method_10545("Segments");
        boolean hasPartEntities = entityTag.method_10545("PartEntities");
        boolean hasPartsLower = entityTag.method_10545("parts");
        boolean hasSegmentsLower = entityTag.method_10545("segments");
        boolean hasChildUUID = entityTag.method_10545("ChildUUID");
        boolean hasParentUUID = entityTag.method_10545("ParentUUID");
        String entityId = entityTag.method_10558("id");
        boolean isPartEntity = entityId.contains("_head") || entityId.contains("_body") || entityId.contains("_tail") || entityId.contains("_segment") || entityId.contains("_part");
        return hasParts || hasSegments || hasPartEntities || hasPartsLower || hasSegmentsLower || hasChildUUID || hasParentUUID || isPartEntity;
    }

    @Nullable
    private class_2487 extractBugData(class_1799 bugNet) {
        class_2487 stackTag = bugNet.method_7969();
        if (stackTag == null || !stackTag.method_10545("StoredEntity")) {
            return null;
        }
        class_2487 bugData = new class_2487();
        bugData.method_10566("StoredEntity", (class_2520)stackTag.method_10562("StoredEntity"));
        if (stackTag.method_10545("StoredEntityType")) {
            bugData.method_10582("StoredEntityType", stackTag.method_10558("StoredEntityType"));
        }
        return bugData;
    }

    private class_1799 createFilledBugNet(class_1799 emptyNet, class_2487 bugData) {
        class_1799 filledNet = new class_1799((class_1935)emptyNet.method_7909());
        filledNet.method_7974(emptyNet.method_7919());
        class_2487 stackTag = filledNet.method_7948();
        if (bugData.method_10545("StoredEntity")) {
            stackTag.method_10566("StoredEntity", (class_2520)bugData.method_10562("StoredEntity"));
        }
        if (bugData.method_10545("StoredEntityType")) {
            stackTag.method_10582("StoredEntityType", bugData.method_10558("StoredEntityType"));
        }
        return filledNet;
    }

    public static interface ICatchable {
        public void setCaught(boolean var1);

        public boolean isCaught();
    }
}

