/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.blocks;

import com.pepper.faunify.blocks.BugCatcherBlock;
import com.pepper.faunify.blocks.entity.InsectHabitatBlockEntity;
import com.pepper.faunify.items.BugNetItem;
import com.pepper.faunify.registry.FaunifyTriggers;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class InsectHabitatBlock
extends class_2237 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754<DecorationState> DECORATION = class_2754.method_11850((String)"decoration", DecorationState.class);
    private static final class_265 SHAPE_NORTH = class_2248.method_9541((double)-5.0, (double)0.0, (double)-1.0, (double)21.0, (double)15.0, (double)17.0);
    private static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)-5.0, (double)0.0, (double)-1.0, (double)21.0, (double)15.0, (double)17.0);
    private static final class_265 SHAPE_WEST = class_2248.method_9541((double)-1.0, (double)0.0, (double)-5.0, (double)17.0, (double)15.0, (double)21.0);
    private static final class_265 SHAPE_EAST = class_2248.method_9541((double)-1.0, (double)0.0, (double)-5.0, (double)17.0, (double)15.0, (double)21.0);
    private final class_1767 color;

    public InsectHabitatBlock(class_4970.class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(DECORATION, (Comparable)((Object)DecorationState.EMPTY))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DECORATION, FACING});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public class_1767 getColor() {
        return this.color;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof InsectHabitatBlockEntity)) {
            return class_1269.field_5811;
        }
        InsectHabitatBlockEntity habitat = (InsectHabitatBlockEntity)be;
        if (stack.method_7909() instanceof BugNetItem) {
            boolean isMultiPart;
            if (this.hasStoredEntity(stack) && !habitat.hasBug() && (isMultiPart = this.isMultiPartEntity(stack))) {
                if (!world.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.faunify.bug_too_big"), true);
                }
                return class_1269.field_5812;
            }
            if (!world.field_9236) {
                class_2487 bugData;
                if (this.hasStoredEntity(stack) && !habitat.hasBug()) {
                    class_2487 bugData2 = this.extractBugData(stack);
                    if (bugData2 != null) {
                        float snappedRotation = this.snapToCardinal(player.method_36454()) + 180.0f;
                        class_2350 habitatFacing = (class_2350)state.method_11654((class_2769)FACING);
                        float rotationOffset = switch (habitatFacing) {
                            case class_2350.field_11035 -> 180.0f;
                            case class_2350.field_11039 -> 270.0f;
                            case class_2350.field_11034 -> 90.0f;
                            default -> 0.0f;
                        };
                        float finalRotation = (snappedRotation - rotationOffset) % 360.0f;
                        if (finalRotation < 0.0f) {
                            finalRotation += 360.0f;
                        }
                        habitat.storeBug(bugData2, finalRotation);
                        if (player instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)player;
                            class_2487 entityTag = bugData2.method_10562("StoredEntity");
                            if (entityTag != null && world instanceof class_3218) {
                                class_1297 tempEntity;
                                class_3218 serverWorld = (class_3218)world;
                                Optional entityTypeOpt = class_1299.method_17684((class_2487)entityTag);
                                if (entityTypeOpt.isPresent() && (tempEntity = ((class_1299)entityTypeOpt.get()).method_5883((class_1937)serverWorld)) != null) {
                                    tempEntity.method_5651(entityTag);
                                    FaunifyTriggers.STORE_BUG.trigger(serverPlayer, tempEntity, stack);
                                }
                            }
                        }
                        class_1799 emptyNet = new class_1799((class_1935)stack.method_7909());
                        emptyNet.method_7974(stack.method_7919());
                        player.method_6122(hand, emptyNet);
                        world.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1.0f, 1.0f);
                        return class_1269.field_5812;
                    }
                } else if (!this.hasStoredEntity(stack) && habitat.hasBug() && (bugData = habitat.removeBug()) != null) {
                    class_1799 filledNet = this.createFilledBugNet(stack, bugData);
                    player.method_6122(hand, filledNet);
                    world.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (stack.method_31574(class_1802.field_8382)) {
            if (!habitat.hasDirt()) {
                if (!world.field_9236) {
                    habitat.setHasDirt(true);
                    this.updateDecorationState(world, pos, habitat);
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    world.method_8396(null, pos, class_3417.field_28604, class_3419.field_15245, 1.0f, 1.0f);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        } else if (stack.method_31574(class_1802.field_8600)) {
            if (habitat.hasDirt() && !habitat.hasStick()) {
                if (!world.field_9236) {
                    habitat.setHasStick(true);
                    this.updateDecorationState(world, pos, habitat);
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    world.method_8396(null, pos, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.0f);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (!habitat.hasDirt()) {
                if (!world.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.faunify.needs_dirt"), true);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        } else if (stack.method_31573(class_3489.field_15558)) {
            if (habitat.hasDirt() && !habitat.hasLeaves()) {
                if (!world.field_9236) {
                    habitat.setHasLeaves(true, stack.method_7972());
                    this.updateDecorationState(world, pos, habitat);
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    world.method_8396(null, pos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (!habitat.hasDirt()) {
                if (!world.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.faunify.needs_dirt"), true);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11034 -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11034 -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new InsectHabitatBlockEntity(pos, state);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof InsectHabitatBlockEntity) {
                InsectHabitatBlockEntity habitat = (InsectHabitatBlockEntity)be;
                if (!world.field_9236 && world instanceof class_3218) {
                    class_2487 bugData;
                    class_3218 serverWorld = (class_3218)world;
                    if (habitat.hasBug() && (bugData = habitat.getStoredBugData()) != null) {
                        this.spawnStoredEntity(serverWorld, pos, bugData);
                    }
                    if (habitat.hasDirt()) {
                        class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_1802.field_8382));
                    }
                    if (habitat.hasStick()) {
                        class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_1802.field_8600));
                    }
                    if (habitat.hasLeaves()) {
                        class_1799 leafStack = habitat.getStoredLeafType();
                        if (leafStack != null && !leafStack.method_7960()) {
                            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)leafStack);
                        } else {
                            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_1802.field_17503));
                        }
                    }
                }
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    private void updateDecorationState(class_1937 world, class_2338 pos, InsectHabitatBlockEntity habitat) {
        DecorationState newState = !habitat.hasDirt() ? DecorationState.EMPTY : (habitat.hasStick() && habitat.hasLeaves() ? DecorationState.STICKLEAVES : (habitat.hasStick() ? DecorationState.STICK : (habitat.hasLeaves() ? DecorationState.LEAVES : DecorationState.DIRT)));
        world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657(DECORATION, (Comparable)((Object)newState)), 3);
    }

    private float snapToCardinal(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return 90.0f;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return 180.0f;
        }
        return 270.0f;
    }

    private void spawnStoredEntity(class_3218 world, class_2338 pos, class_2487 bugData) {
        class_1297 entity;
        if (!bugData.method_10545("StoredEntity")) {
            return;
        }
        class_2487 entityTag = bugData.method_10562("StoredEntity");
        world.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 1.0f, 1.0f);
        Optional entityTypeOpt = class_1299.method_17684((class_2487)entityTag);
        if (entityTypeOpt.isPresent() && (entity = ((class_1299)entityTypeOpt.get()).method_5883((class_1937)world)) != null) {
            entity.method_5651(entityTag);
            entity.method_5826(UUID.randomUUID());
            if (entity instanceof class_1309) {
                class_2487 nbt = new class_2487();
                entity.method_5647(nbt);
                if (nbt.method_10545("Caught")) {
                    nbt.method_10551("Caught");
                    entity.method_5651(nbt);
                }
                if (entity instanceof BugCatcherBlock.ICatchable) {
                    BugCatcherBlock.ICatchable catchable = (BugCatcherBlock.ICatchable)entity;
                    catchable.setCaught(false);
                }
            }
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.25, (double)pos.method_10260() + 0.5, world.field_9229.method_43057() * 360.0f, 0.0f);
            world.method_8649(entity);
        }
    }

    private boolean hasStoredEntity(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10545("StoredEntity");
    }

    private boolean isMultiPartEntity(class_1799 stack) {
        if (!stack.method_7985()) {
            return false;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545("StoredEntity")) {
            return false;
        }
        class_2487 entityTag = tag.method_10562("StoredEntity");
        boolean hasParts = entityTag.method_10545("Parts");
        boolean hasSegments = entityTag.method_10545("Segments");
        boolean hasPartEntities = entityTag.method_10545("PartEntities");
        boolean hasPartsLower = entityTag.method_10545("parts");
        boolean hasSegmentsLower = entityTag.method_10545("segments");
        boolean hasChildUUID = entityTag.method_10545("ChildUUID");
        boolean hasParentUUID = entityTag.method_10545("ParentUUID");
        String entityId = entityTag.method_10558("id");
        boolean isPartEntity = entityId.contains("_head") || entityId.contains("_body") || entityId.contains("_tail") || entityId.contains("_segment") || entityId.contains("_part");
        return hasParts || hasSegments || hasPartEntities || hasPartsLower || hasSegmentsLower || hasChildUUID || hasParentUUID || isPartEntity;
    }

    @Nullable
    private class_2487 extractBugData(class_1799 bugNet) {
        class_2487 stackTag = bugNet.method_7969();
        if (stackTag == null || !stackTag.method_10545("StoredEntity")) {
            return null;
        }
        class_2487 bugData = new class_2487();
        bugData.method_10566("StoredEntity", (class_2520)stackTag.method_10562("StoredEntity"));
        if (stackTag.method_10545("StoredEntityType")) {
            bugData.method_10582("StoredEntityType", stackTag.method_10558("StoredEntityType"));
        }
        return bugData;
    }

    private class_1799 createFilledBugNet(class_1799 emptyNet, class_2487 bugData) {
        class_1799 filledNet = new class_1799((class_1935)emptyNet.method_7909());
        filledNet.method_7974(emptyNet.method_7919());
        class_2487 stackTag = filledNet.method_7948();
        if (bugData.method_10545("StoredEntity")) {
            stackTag.method_10566("StoredEntity", (class_2520)bugData.method_10562("StoredEntity"));
        }
        if (bugData.method_10545("StoredEntityType")) {
            stackTag.method_10582("StoredEntityType", bugData.method_10558("StoredEntityType"));
        }
        return filledNet;
    }

    public static enum DecorationState implements class_3542
    {
        EMPTY("empty"),
        DIRT("dirt"),
        LEAVES("leaves"),
        STICK("stick"),
        STICKLEAVES("stickleaves");

        private final String name;

        private DecorationState(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

