/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.blocks;

import com.google.common.annotations.VisibleForTesting;
import com.pepper.faunify.entity.SilkwormEntity;
import com.pepper.faunify.registry.FaunifyEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class SilkwormEggsBlock
extends class_2248 {
    private static final int MIN_SILKWORMS_SPAWN = 1;
    private static final int MAX_SILKWORMS_SPAWN = 3;
    private static final int DEFAULT_MIN_HATCH_TICK_DELAY = 3600;
    private static final int DEFAULT_MAX_HATCH_TICK_DELAY = 12000;
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
    private static int minHatchTickDelay = 3600;
    private static int maxHatchTickDelay = 12000;

    public SilkwormEggsBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return SilkwormEggsBlock.mayPlaceOn((class_1922)world, pos.method_10074());
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        world.method_39279(pos, (class_2248)this, SilkwormEggsBlock.getSilkwormEggsHatchDelay(world.method_8409()));
    }

    private static int getSilkwormEggsHatchDelay(class_5819 random) {
        return random.method_43048(maxHatchTickDelay - minHatchTickDelay) + minHatchTickDelay;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return !this.method_9558(state, (class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!this.method_9558(state, (class_4538)world, pos)) {
            this.destroyBlock((class_1937)world, pos);
        } else {
            this.hatchSilkwormEggs(world, pos, random);
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity.method_5864().equals(class_1299.field_6089)) {
            this.destroyBlock(world, pos);
        }
    }

    private static boolean mayPlaceOn(class_1922 world, class_2338 pos) {
        class_2680 blockBelow = world.method_8320(pos);
        return blockBelow.method_26204() instanceof class_2397;
    }

    private void hatchSilkwormEggs(class_3218 world, class_2338 pos, class_5819 random) {
        this.destroyBlock((class_1937)world, pos);
        world.method_8396(null, pos, class_3417.field_37310, class_3419.field_15245, 1.0f, 1.0f);
        this.spawnSilkworms(world, pos, random);
    }

    private void destroyBlock(class_1937 world, class_2338 pos) {
        world.method_22352(pos, false);
    }

    private void spawnSilkworms(class_3218 world, class_2338 pos, class_5819 random) {
        int count = random.method_43048(3) + 1;
        for (int i = 1; i <= count; ++i) {
            SilkwormEntity silkworm = (SilkwormEntity)FaunifyEntities.SILKWORM.method_5883((class_1937)world);
            if (silkworm == null) continue;
            double xOffset = this.getRandomSilkwormPositionOffset(random);
            double zOffset = this.getRandomSilkwormPositionOffset(random);
            int yaw = random.method_43048(360) + 1;
            silkworm.method_5808((double)pos.method_10263() + xOffset, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + zOffset, yaw, 0.0f);
            int roll = random.method_43048(100);
            if (roll < 99) {
                silkworm.setVariant(SilkwormEntity.Variant.NORMAL);
            } else {
                silkworm.setVariant(SilkwormEntity.Variant.HUNGRY);
            }
            silkworm.method_5971();
            world.method_8649((class_1297)silkworm);
        }
    }

    private double getRandomSilkwormPositionOffset(class_5819 random) {
        double halfWidth = 0.2;
        return class_3532.method_15350((double)random.method_43058(), (double)halfWidth, (double)(1.0 - halfWidth));
    }

    @VisibleForTesting
    public static void setHatchDelay(int min, int max) {
        minHatchTickDelay = min;
        maxHatchTickDelay = max;
    }

    @VisibleForTesting
    public static void setDefaultHatchDelay() {
        minHatchTickDelay = 3600;
        maxHatchTickDelay = 12000;
    }
}

