/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.config;

import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class FaunifyClientConfig {
    private static final String CONFIG_FILE_NAME = "faunify-client.properties";
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("faunify-client.properties");
    public static boolean silkmothPhobiaFriendly = false;
    public static boolean caterpillarPhobiaFriendly = false;
    public static boolean beetlePhobiaFriendly = false;
    public static boolean ladybugPhobiaFriendly = false;
    public static boolean weevilPhobiaFriendly = false;
    public static boolean beeflyPhobiaFriendly = false;
    public static boolean mantisPhobiaFriendly = false;
    public static boolean dragonflyPhobiaFriendly = false;
    public static boolean lacewingPhobiaFriendly = false;
    public static boolean stickbugPhobiaFriendly = false;
    public static boolean leafinsectPhobiaFriendly = false;
    public static boolean grasshopperPhobiaFriendly = false;
    public static boolean millipedePhobiaFriendly = false;
    public static boolean rolypolyPhobiaFriendly = false;
    private static final Map<String, ConfigEntry> configEntries = new HashMap<String, ConfigEntry>();

    public static void load() {
        try {
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                FaunifyClientConfig.save();
                return;
            }
            Properties properties = new Properties();
            try (InputStream input = Files.newInputStream(CONFIG_FILE, new OpenOption[0]);){
                properties.load(input);
            }
            silkmothPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "silkmothPhobiaFriendly", false);
            caterpillarPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "caterpillarPhobiaFriendly", false);
            beetlePhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "beetlePhobiaFriendly", false);
            ladybugPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "ladybugPhobiaFriendly", false);
            weevilPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "weevilPhobiaFriendly", false);
            beeflyPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "beeflyPhobiaFriendly", false);
            mantisPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "mantisPhobiaFriendly", false);
            dragonflyPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "dragonflyPhobiaFriendly", false);
            lacewingPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "lacewingPhobiaFriendly", false);
            stickbugPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "stickbugPhobiaFriendly", false);
            leafinsectPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "leafinsectPhobiaFriendly", false);
            grasshopperPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "grasshopperPhobiaFriendly", false);
            millipedePhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "millipedePhobiaFriendly", false);
            rolypolyPhobiaFriendly = FaunifyClientConfig.getBooleanProperty(properties, "rolypolyPhobiaFriendly", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]));){
                writer.println("[bug_phobia_settings]");
                writer.println();
                writer.println("\t#Enable phobia-friendly textures");
                writer.println("\t#These textures are much less realistic and extremely simple to lessen any fear of insects");
                writer.println();
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "silkmothPhobiaFriendly", silkmothPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "caterpillarPhobiaFriendly", caterpillarPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "beetlePhobiaFriendly", beetlePhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "ladybugPhobiaFriendly", ladybugPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "weevilPhobiaFriendly", weevilPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "beeflyPhobiaFriendly", beeflyPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "mantisPhobiaFriendly", mantisPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "dragonflyPhobiaFriendly", dragonflyPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "lacewingPhobiaFriendly", lacewingPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "stickbugPhobiaFriendly", stickbugPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "leafinsectPhobiaFriendly", leafinsectPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "grasshopperPhobiaFriendly", grasshopperPhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "millipedePhobiaFriendly", millipedePhobiaFriendly);
                FaunifyClientConfig.writeBooleanConfigEntry(writer, "rolypolyPhobiaFriendly", rolypolyPhobiaFriendly);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeBooleanConfigEntry(PrintWriter writer, String key, boolean value) {
        ConfigEntry entry = configEntries.get(key);
        if (entry != null) {
            writer.println("\t#" + entry.comment);
            writer.println("\t" + key + " = " + value);
            writer.println();
        }
    }

    private static boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        try {
            String value = properties.getProperty(key);
            if (value != null) {
                return Boolean.parseBoolean(value.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    static {
        configEntries.put("silkmothPhobiaFriendly", new ConfigEntry("silkmothPhobiaFriendly", false, "Use phobia-friendly texture for Silk Moths"));
        configEntries.put("caterpillarPhobiaFriendly", new ConfigEntry("caterpillarPhobiaFriendly", false, "Use phobia-friendly texture for Silkworms"));
        configEntries.put("beetlePhobiaFriendly", new ConfigEntry("beetlePhobiaFriendly", false, "Use phobia-friendly texture for Beetles"));
        configEntries.put("ladybugPhobiaFriendly", new ConfigEntry("ladybugPhobiaFriendly", false, "Use phobia-friendly texture for Ladybugs"));
        configEntries.put("weevilPhobiaFriendly", new ConfigEntry("weevilPhobiaFriendly", false, "Use phobia-friendly texture for Weevils"));
        configEntries.put("beeflyPhobiaFriendly", new ConfigEntry("beeflyPhobiaFriendly", false, "Use phobia-friendly texture for Beeflies"));
        configEntries.put("mantisPhobiaFriendly", new ConfigEntry("mantisPhobiaFriendly", false, "Use phobia-friendly texture for Mantises"));
        configEntries.put("dragonflyPhobiaFriendly", new ConfigEntry("dragonflyPhobiaFriendly", false, "Use phobia-friendly texture for Dragonflies"));
        configEntries.put("lacewingPhobiaFriendly", new ConfigEntry("lacewingPhobiaFriendly", false, "Use phobia-friendly texture for Lacewings"));
        configEntries.put("stickbugPhobiaFriendly", new ConfigEntry("stickbugPhobiaFriendly", false, "Use phobia-friendly texture for Stick Bugs"));
        configEntries.put("leafinsectPhobiaFriendly", new ConfigEntry("leafinsectPhobiaFriendly", false, "Use phobia-friendly texture for Leaf Insects"));
        configEntries.put("grasshopperPhobiaFriendly", new ConfigEntry("grasshopperPhobiaFriendly", false, "Use phobia-friendly texture for Grasshoppers"));
        configEntries.put("millipedePhobiaFriendly", new ConfigEntry("millipedePhobiaFriendly", false, "Use phobia-friendly texture for Millipedes"));
        configEntries.put("rolypolyPhobiaFriendly", new ConfigEntry("rolypolyPhobiaFriendly", false, "Use phobia-friendly texture for Roly Polys"));
    }

    private static class ConfigEntry {
        final String comment;

        ConfigEntry(String key, boolean defaultValue, String comment) {
            this.comment = comment;
        }
    }
}

