/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.config;

import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class FaunifyConfig {
    private static final String CONFIG_FILE_NAME = "faunify.properties";
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("faunify.properties");
    public static boolean oldAnimationStyle = false;
    public static boolean replaceNet = true;
    public static int weaselSpawnWeight = 10;
    public static int fennecSpawnWeight = 5;
    public static int chinchillaSpawnWeight = 15;
    public static int hedgehogSpawnWeight = 8;
    public static int ringtailcatSpawnWeight = 12;
    public static int opossumSpawnWeight = 10;
    public static int mouseSpawnWeight = 8;
    public static int silkmothSpawnWeight = 10;
    public static int leafsheepSpawnWeight = 45;
    public static int beeflySpawnWeight = 15;
    public static int beetleSpawnWeight = 15;
    public static int dragonflySpawnWeight = 20;
    public static int grasshopperSpawnWeight = 15;
    public static int lacewingSpawnWeight = 15;
    public static int ladybugSpawnWeight = 15;
    public static int leafinsectSpawnWeight = 12;
    public static int mantisSpawnWeight = 12;
    public static int millipedeSpawnWeight = 80;
    public static int rolypolySpawnWeight = 40;
    public static int stickbugSpawnWeight = 12;
    public static int weevilSpawnWeight = 12;
    private static final Map<String, ConfigEntry> configEntries = new HashMap<String, ConfigEntry>();

    public static void load() {
        try {
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                FaunifyConfig.save();
                return;
            }
            Properties properties = new Properties();
            try (InputStream input = Files.newInputStream(CONFIG_FILE, new OpenOption[0]);){
                properties.load(input);
            }
            oldAnimationStyle = FaunifyConfig.getBooleanProperty(properties, "oldAnimationStyle", false);
            replaceNet = FaunifyConfig.getBooleanProperty(properties, "replaceNet", true);
            weaselSpawnWeight = FaunifyConfig.getIntProperty(properties, "weaselSpawnWeight", 10);
            fennecSpawnWeight = FaunifyConfig.getIntProperty(properties, "fennecSpawnWeight", 5);
            chinchillaSpawnWeight = FaunifyConfig.getIntProperty(properties, "chinchillaSpawnWeight", 15);
            hedgehogSpawnWeight = FaunifyConfig.getIntProperty(properties, "hedgehogSpawnWeight", 8);
            ringtailcatSpawnWeight = FaunifyConfig.getIntProperty(properties, "ringtailcatSpawnWeight", 12);
            opossumSpawnWeight = FaunifyConfig.getIntProperty(properties, "opossumSpawnWeight", 10);
            mouseSpawnWeight = FaunifyConfig.getIntProperty(properties, "mouseSpawnWeight", 8);
            silkmothSpawnWeight = FaunifyConfig.getIntProperty(properties, "silkmothSpawnWeight", 10);
            leafsheepSpawnWeight = FaunifyConfig.getIntProperty(properties, "leafsheepSpawnWeight", 45);
            beeflySpawnWeight = FaunifyConfig.getIntProperty(properties, "beeflySpawnWeight", 15);
            beetleSpawnWeight = FaunifyConfig.getIntProperty(properties, "beetleSpawnWeight", 15);
            dragonflySpawnWeight = FaunifyConfig.getIntProperty(properties, "dragonflySpawnWeight", 20);
            grasshopperSpawnWeight = FaunifyConfig.getIntProperty(properties, "grasshopperSpawnWeight", 15);
            lacewingSpawnWeight = FaunifyConfig.getIntProperty(properties, "lacewingSpawnWeight", 15);
            ladybugSpawnWeight = FaunifyConfig.getIntProperty(properties, "ladybugSpawnWeight", 15);
            leafinsectSpawnWeight = FaunifyConfig.getIntProperty(properties, "leafinsectSpawnWeight", 12);
            mantisSpawnWeight = FaunifyConfig.getIntProperty(properties, "mantisSpawnWeight", 12);
            millipedeSpawnWeight = FaunifyConfig.getIntProperty(properties, "millipedeSpawnWeight", 50);
            rolypolySpawnWeight = FaunifyConfig.getIntProperty(properties, "rolypolySpawnWeight", 40);
            stickbugSpawnWeight = FaunifyConfig.getIntProperty(properties, "stickbugSpawnWeight", 12);
            weevilSpawnWeight = FaunifyConfig.getIntProperty(properties, "weevilSpawnWeight", 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]));){
                writer.println("[animation_settings]");
                writer.println();
                FaunifyConfig.writeBooleanConfigEntry(writer, "oldAnimationStyle", oldAnimationStyle);
                writer.println("[compatibility_settings]");
                writer.println();
                FaunifyConfig.writeBooleanConfigEntry(writer, "replaceNet", replaceNet);
                writer.println("[spawning]");
                writer.println();
                FaunifyConfig.writeIntConfigEntry(writer, "weaselSpawnWeight", weaselSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "fennecSpawnWeight", fennecSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "chinchillaSpawnWeight", chinchillaSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "hedgehogSpawnWeight", hedgehogSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "ringtailcatSpawnWeight", ringtailcatSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "opossumSpawnWeight", opossumSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "mouseSpawnWeight", mouseSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "silkmothSpawnWeight", silkmothSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "leafsheepSpawnWeight", leafsheepSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "beeflySpawnWeight", beeflySpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "beetleSpawnWeight", beetleSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "dragonflySpawnWeight", dragonflySpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "grasshopperSpawnWeight", grasshopperSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "lacewingSpawnWeight", lacewingSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "ladybugSpawnWeight", ladybugSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "leafinsectSpawnWeight", leafinsectSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "mantisSpawnWeight", mantisSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "millipedeSpawnWeight", millipedeSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "rolypolySpawnWeight", rolypolySpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "stickbugSpawnWeight", stickbugSpawnWeight);
                FaunifyConfig.writeIntConfigEntry(writer, "weevilSpawnWeight", weevilSpawnWeight);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeIntConfigEntry(PrintWriter writer, String key, int value) {
        ConfigEntry entry = configEntries.get(key);
        if (entry != null && entry.isInt) {
            writer.println("\t#" + entry.comment);
            writer.println("\t#Range: " + entry.min + " ~ " + entry.max);
            writer.println("\t" + key + " = " + value);
            writer.println();
        }
    }

    private static void writeBooleanConfigEntry(PrintWriter writer, String key, boolean value) {
        ConfigEntry entry = configEntries.get(key);
        if (entry != null && !entry.isInt) {
            writer.println("\t#" + entry.comment);
            writer.println("\t" + key + " = " + value);
            writer.println();
        }
    }

    private static int getIntProperty(Properties properties, String key, int defaultValue) {
        try {
            String value = properties.getProperty(key);
            if (value != null) {
                int parsed = Integer.parseInt(value.trim());
                ConfigEntry entry = configEntries.get(key);
                if (entry != null && entry.isInt) {
                    return Math.max(entry.min, Math.min(entry.max, parsed));
                }
                return parsed;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        try {
            String value = properties.getProperty(key);
            if (value != null) {
                return Boolean.parseBoolean(value.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    static {
        configEntries.put("oldAnimationStyle", new ConfigEntry("oldAnimationStyle", false, "Use the old animation style"));
        configEntries.put("replaceNet", new ConfigEntry("replaceNet", true, "Disable Naturalist's Bug Net to use Faunify's Bug Net"));
        configEntries.put("weaselSpawnWeight", new ConfigEntry("weaselSpawnWeight", 10, 0, 500, "Spawn Weight - How often Weasels spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("fennecSpawnWeight", new ConfigEntry("fennecSpawnWeight", 5, 0, 500, "Spawn Weight - How often Fennec Foxes spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("chinchillaSpawnWeight", new ConfigEntry("chinchillaSpawnWeight", 15, 0, 500, "Spawn Weight - How often Chinchillas spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("hedgehogSpawnWeight", new ConfigEntry("hedgehogSpawnWeight", 8, 0, 500, "Spawn Weight - How often Hedgehogs spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("ringtailcatSpawnWeight", new ConfigEntry("ringtailcatSpawnWeight", 12, 0, 500, "Spawn Weight - How often Ringtail Cats spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("opossumSpawnWeight", new ConfigEntry("opossumSpawnWeight", 10, 0, 500, "Spawn Weight - How often Opossums spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("mouseSpawnWeight", new ConfigEntry("mouseSpawnWeight", 8, 0, 500, "Spawn Weight - How often Mice spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("silkmothSpawnWeight", new ConfigEntry("silkmothSpawnWeight", 10, 0, 500, "Spawn Weight - How often Silk Moths spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("leafsheepSpawnWeight", new ConfigEntry("leafsheepSpawnWeight", 45, 0, 500, "Spawn Weight - How often Leaf Sheep spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("beeflySpawnWeight", new ConfigEntry("beeflySpawnWeight", 15, 0, 500, "Spawn Weight - How often Bee Flies spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("beetleSpawnWeight", new ConfigEntry("beetleSpawnWeight", 15, 0, 500, "Spawn Weight - How often Beetles spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("dragonflySpawnWeight", new ConfigEntry("dragonflySpawnWeight", 20, 0, 500, "Spawn Weight - How often Dragonflies spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("grasshopperSpawnWeight", new ConfigEntry("grasshopperSpawnWeight", 15, 0, 500, "Spawn Weight - How often Grasshoppers spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("lacewingSpawnWeight", new ConfigEntry("lacewingSpawnWeight", 15, 0, 500, "Spawn Weight - How often Lacewings spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("ladybugSpawnWeight", new ConfigEntry("ladybugSpawnWeight", 15, 0, 500, "Spawn Weight - How often Ladybugs spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("leafinsectSpawnWeight", new ConfigEntry("leafinsectSpawnWeight", 12, 0, 500, "Spawn Weight - How often Leaf Insects spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("mantisSpawnWeight", new ConfigEntry("mantisSpawnWeight", 12, 0, 500, "Spawn Weight - How often Mantises spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("millipedeSpawnWeight", new ConfigEntry("millipedeSpawnWeight", 80, 0, 500, "Spawn Weight - How often Millipedes spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("rolypolySpawnWeight", new ConfigEntry("rolypolySpawnWeight", 40, 0, 500, "Spawn Weight - How often Roly Polies spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("stickbugSpawnWeight", new ConfigEntry("stickbugSpawnWeight", 12, 0, 500, "Spawn Weight - How often Stick Bugs spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
        configEntries.put("weevilSpawnWeight", new ConfigEntry("weevilSpawnWeight", 12, 0, 500, "Spawn Weight - How often Weevils spawn. [Higher number = Higher chance, 0 = Disable spawns]"));
    }

    private static class ConfigEntry {
        final boolean isInt;
        final int min;
        final int max;
        final String comment;

        ConfigEntry(String key, boolean defaultValue, String comment) {
            this.isInt = false;
            this.min = 0;
            this.max = 0;
            this.comment = comment;
        }

        ConfigEntry(String key, int defaultValue, int min, int max, String comment) {
            this.isInt = true;
            this.min = min;
            this.max = max;
            this.comment = comment;
        }
    }
}

