/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3830;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BeeflyEntity
extends class_1429
implements GeoEntity {
    private static final double PLAYER_DETECTION_RANGE = 4.0;
    private static final int MAX_FLIGHT_HEIGHT = 5;
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(BeeflyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_POLLEN = class_2945.method_12791(BeeflyEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    public boolean landingFlag;
    @Nullable
    private class_2338 savedFlowerPos;
    private int remainingCooldownBeforeLocatingNewFlower = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)60);
    private int numCropsGrownSinceVisitingFlower;

    public BeeflyEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new BeeflyMoveController(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23720, 0.6);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BeeflyPollinateGoal());
        this.field_6201.method_6277(2, (class_1352)new BeeflyGoToKnownFlowerGoal());
        this.field_6201.method_6277(3, (class_1352)new BeeflySeekCropsGoal());
        this.field_6201.method_6277(4, (class_1352)new BeeflyGrowCropGoal());
        this.field_6201.method_6277(5, (class_1352)new BeeflyFlightGoal(this));
    }

    public static boolean canSpawn(class_1299<BeeflyEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        return spawnData;
    }

    public void method_5773() {
        super.method_5773();
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
        if (this.hasPollen() && this.getCropsGrownSinceVisitingFlower() < 3 && this.field_5974.method_43057() < 0.05f) {
            for (int i = 0; i < this.field_5974.method_43048(2) + 1; ++i) {
                this.spawnFluidParticle(this.method_37908(), this.method_23317() - (double)0.3f, this.method_23317() + (double)0.3f, this.method_23321() - (double)0.3f, this.method_23321() + (double)0.3f, this.method_23323(0.5), (class_2394)class_2398.field_20537);
            }
        }
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.remainingCooldownBeforeLocatingNewFlower > 0) {
            --this.remainingCooldownBeforeLocatingNewFlower;
        }
    }

    public void tickFlight() {
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isFlying()) {
            ++this.timeFlying;
            this.method_5875(true);
            if (this.groundedFor > 0) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.method_5875(false);
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.method_37908().field_9236) {
            if (this.isFlying() && this.method_5805() && !this.method_5782()) {
                if (this.landingFlag) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.1, 0.0));
                }
                if ((this.field_5976 || this.method_5799()) && !this.landingFlag) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.05, 0.0));
                }
            }
            if (this.isFlying() && this.timeFlying > 40 && this.method_24828()) {
                this.setFlying(false);
            }
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        return new BeeflyFlyingNavigation((class_1308)this, level, 0.75f);
    }

    public class_1296 method_5613(class_3218 serverLevel, class_1296 otherParent) {
        return null;
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<BeeflyEntity> event) {
        if (!this.isFlying() && this.method_24828()) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Flying", this.isFlying());
        tag.method_10556("HasPollen", this.hasPollen());
        tag.method_10569("TimeFlying", this.timeFlying);
        tag.method_10569("GroundedFor", this.groundedFor);
        tag.method_10556("LandingFlag", this.landingFlag);
        if (this.hasSavedFlowerPos()) {
            tag.method_10544("FlowerPos", this.savedFlowerPos.method_10063());
        }
        tag.method_10569("CropsGrownSinceVisitingFlower", this.numCropsGrownSinceVisitingFlower);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setFlying(tag.method_10577("Flying"));
        this.setHasPollen(tag.method_10577("HasPollen"));
        this.timeFlying = tag.method_10550("TimeFlying");
        this.groundedFor = tag.method_10550("GroundedFor");
        this.landingFlag = tag.method_10577("LandingFlag");
        if (tag.method_10545("FlowerPos")) {
            this.savedFlowerPos = class_2338.method_10092((long)tag.method_10537("FlowerPos"));
        }
        this.numCropsGrownSinceVisitingFlower = tag.method_10550("CropsGrownSinceVisitingFlower");
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(HAS_POLLEN, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
    }

    public boolean hasPollen() {
        return (Boolean)this.field_6011.method_12789(HAS_POLLEN);
    }

    public void setHasPollen(boolean hasPollen) {
        this.field_6011.method_12778(HAS_POLLEN, (Object)hasPollen);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public float method_6144(class_2338 pos, class_4538 level) {
        return level.method_8320(pos).method_26215() ? 10.0f : 0.0f;
    }

    @Nullable
    public class_2338 getSavedFlowerPos() {
        return this.savedFlowerPos;
    }

    public boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    public void setSavedFlowerPos(class_2338 pos) {
        this.savedFlowerPos = pos;
    }

    boolean isFlowerValid(class_2338 pos) {
        return this.method_37908().method_22340(pos) && this.method_37908().method_8320(pos).method_26164(class_3481.field_20339);
    }

    void pathfindRandomlyTowards(class_2338 pos) {
        class_243 targetPos;
        class_243 vec3 = class_243.method_24955((class_2382)pos);
        int verticalOffset = 0;
        class_2338 currentPos = this.method_24515();
        int heightDiff = (int)vec3.field_1351 - currentPos.method_10264();
        if (heightDiff > 2) {
            verticalOffset = 4;
        } else if (heightDiff < -2) {
            verticalOffset = -4;
        }
        int horizontalRange = 6;
        int verticalRange = 8;
        int manhattanDist = currentPos.method_19455((class_2382)pos);
        if (manhattanDist < 15) {
            horizontalRange = manhattanDist / 2;
            verticalRange = manhattanDist / 2;
        }
        if ((targetPos = this.findAirTarget(horizontalRange, verticalRange, verticalOffset, vec3, 0.31415927f)) != null) {
            this.field_6189.method_23964(0.5f);
            this.field_6189.method_6337(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
        }
    }

    private class_243 findAirTarget(int horizontalRange, int verticalRange, int verticalOffset, class_243 target, float maxAngle) {
        class_243 start = this.method_19538();
        class_5819 random = this.method_6051();
        for (int i = 0; i < 10; ++i) {
            class_243 targetDirection;
            double offsetX = random.method_43058() * 2.0 - 1.0;
            double offsetY = random.method_43058() * 2.0 - 1.0;
            double offsetZ = random.method_43058() * 2.0 - 1.0;
            class_243 normalized = new class_243(offsetX, offsetY, offsetZ).method_1029();
            class_243 scaled = normalized.method_18805((double)horizontalRange, (double)verticalRange, (double)horizontalRange);
            class_243 offset = new class_243(scaled.field_1352, scaled.field_1351 + (double)verticalOffset, scaled.field_1350);
            class_243 candidate = target.method_1019(offset);
            class_243 direction = candidate.method_1020(start).method_1029();
            double dot = direction.method_1026(targetDirection = target.method_1020(start).method_1029());
            double angle = Math.acos(class_3532.method_15350((double)dot, (double)-1.0, (double)1.0));
            if (!(angle <= (double)maxAngle)) continue;
            class_2338 blockPos = class_2338.method_49638((class_2374)candidate);
            if (!this.method_37908().method_22347(blockPos)) continue;
            return candidate;
        }
        return null;
    }

    boolean closerThan(class_2338 pos, int distance) {
        return pos.method_19771((class_2382)this.method_24515(), (double)distance);
    }

    boolean isTooFarAway(class_2338 pos) {
        return !this.closerThan(pos, 32);
    }

    int getCropsGrownSinceVisitingFlower() {
        return this.numCropsGrownSinceVisitingFlower;
    }

    void resetNumCropsGrownSinceVisitingFlower() {
        this.numCropsGrownSinceVisitingFlower = 0;
    }

    void incrementNumCropsGrownSinceVisitingFlower() {
        ++this.numCropsGrownSinceVisitingFlower;
    }

    private void spawnFluidParticle(class_1937 level, double minX, double maxX, double minZ, double maxZ, double y, class_2394 particle) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14199(particle, class_3532.method_16436((double)level.field_9229.method_43058(), (double)minX, (double)maxX), y, class_3532.method_16436((double)level.field_9229.method_43058(), (double)minZ, (double)maxZ), 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            level.method_8406(particle, class_3532.method_16436((double)level.field_9229.method_43058(), (double)minX, (double)maxX), y, class_3532.method_16436((double)level.field_9229.method_43058(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
        }
    }

    private static class BeeflyMoveController
    extends class_1335 {
        private final BeeflyEntity beefly;

        public BeeflyMoveController(BeeflyEntity beefly) {
            super((class_1308)beefly);
            this.beefly = beefly;
        }

        public void method_6240() {
            if (!this.beefly.isFlying() && this.beefly.method_24828()) {
                this.field_6374 = class_1335.class_1336.field_6377;
                return;
            }
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vector3d = new class_243(this.field_6370 - this.beefly.method_23317(), this.field_6369 - this.beefly.method_23318(), this.field_6367 - this.beefly.method_23321());
                double d0 = vector3d.method_1033();
                double width = this.beefly.method_5829().method_995();
                class_243 vector3d1 = vector3d.method_1021(this.field_6372 * 0.05 / d0);
                this.beefly.method_18799(this.beefly.method_18798().method_1019(vector3d1).method_1021(0.95).method_1031(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                } else if (d0 >= width) {
                    float yaw = -((float)class_3532.method_15349((double)vector3d1.field_1352, (double)vector3d1.field_1350)) * 57.295776f;
                    this.beefly.method_36456(class_3532.method_15388((float)this.beefly.method_36454(), (float)yaw, (float)8.0f));
                }
            }
        }
    }

    class BeeflyPollinateGoal
    extends class_1352 {
        private static final int MIN_POLLINATION_TICKS = 200;
        private final Predicate<class_2680> VALID_POLLINATION_BLOCKS = state -> {
            if (state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                return false;
            }
            if (state.method_26164(class_3481.field_20339)) {
                if (state.method_27852(class_2246.field_10583)) {
                    return state.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609;
                }
                return true;
            }
            return false;
        };
        private static final double ARRIVAL_THRESHOLD = 0.1;
        private static final float SPEED_MODIFIER = 0.35f;
        private static final float HOVER_HEIGHT_WITHIN_FLOWER = 0.6f;
        private static final float HOVER_POS_OFFSET = 0.33333334f;
        private int successfulPollinatingTicks;
        private boolean pollinating;
        @Nullable
        private class_243 hoverPos;
        private int pollinatingTicks;
        private static final int MAX_POLLINATING_TICKS = 400;

        BeeflyPollinateGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (BeeflyEntity.this.hasPollen()) {
                return false;
            }
            if (BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower > 0) {
                return false;
            }
            if (BeeflyEntity.this.method_37908().method_8419()) {
                return false;
            }
            Optional<class_2338> optional = this.findNearbyFlower();
            if (optional.isPresent()) {
                BeeflyEntity.this.savedFlowerPos = optional.get();
                BeeflyEntity.this.field_6189.method_6337((double)BeeflyEntity.this.savedFlowerPos.method_10263() + 0.5, (double)BeeflyEntity.this.savedFlowerPos.method_10264() + 0.5, (double)BeeflyEntity.this.savedFlowerPos.method_10260() + 0.5, (double)1.2f);
                return true;
            }
            BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower = class_3532.method_15395((class_5819)BeeflyEntity.this.field_5974, (int)20, (int)60);
            return false;
        }

        public boolean method_6266() {
            if (!this.pollinating) {
                return false;
            }
            if (!BeeflyEntity.this.hasSavedFlowerPos()) {
                return false;
            }
            if (BeeflyEntity.this.method_37908().method_8419()) {
                return false;
            }
            if (this.hasPollinatedLongEnough()) {
                return BeeflyEntity.this.field_5974.method_43057() < 0.2f;
            }
            if (BeeflyEntity.this.field_6012 % 20 == 0 && !BeeflyEntity.this.isFlowerValid(BeeflyEntity.this.savedFlowerPos)) {
                BeeflyEntity.this.savedFlowerPos = null;
                return false;
            }
            return true;
        }

        private boolean hasPollinatedLongEnough() {
            return this.successfulPollinatingTicks > 200;
        }

        boolean isPollinating() {
            return this.pollinating;
        }

        public void method_6269() {
            this.successfulPollinatingTicks = 0;
            this.pollinatingTicks = 0;
            this.pollinating = true;
            BeeflyEntity.this.resetNumCropsGrownSinceVisitingFlower();
            BeeflyEntity.this.setFlying(true);
            BeeflyEntity.this.landingFlag = false;
        }

        public void method_6270() {
            if (this.hasPollinatedLongEnough()) {
                BeeflyEntity.this.setHasPollen(true);
            }
            this.pollinating = false;
            BeeflyEntity.this.field_6189.method_6340();
            BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            ++this.pollinatingTicks;
            if (!BeeflyEntity.this.isFlying()) {
                BeeflyEntity.this.setFlying(true);
            }
            BeeflyEntity.this.landingFlag = false;
            BeeflyEntity.this.groundedFor = 0;
            if (this.pollinatingTicks > 400) {
                BeeflyEntity.this.savedFlowerPos = null;
            } else {
                class_243 vec3 = class_243.method_24955((class_2382)BeeflyEntity.this.savedFlowerPos).method_1031(0.0, (double)0.6f, 0.0);
                if (vec3.method_1022(BeeflyEntity.this.method_19538()) > 1.0) {
                    this.hoverPos = vec3;
                    this.setWantedPos();
                } else {
                    if (this.hoverPos == null) {
                        this.hoverPos = vec3;
                    }
                    boolean flag = BeeflyEntity.this.method_19538().method_1022(this.hoverPos) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.pollinatingTicks > 400) {
                        BeeflyEntity.this.savedFlowerPos = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = BeeflyEntity.this.field_5974.method_43048(25) == 0;
                            if (flag2) {
                                this.hoverPos = new class_243(vec3.field_1352 + (double)this.getOffset(), vec3.field_1351, vec3.field_1350 + (double)this.getOffset());
                                BeeflyEntity.this.field_6189.method_6340();
                            } else {
                                flag1 = false;
                            }
                            BeeflyEntity.this.method_5988().method_20248(vec3.field_1352, vec3.field_1351, vec3.field_1350);
                        }
                        if (flag1) {
                            this.setWantedPos();
                        }
                        ++this.successfulPollinatingTicks;
                    }
                }
            }
        }

        private void setWantedPos() {
            BeeflyEntity.this.method_5962().method_6239(this.hoverPos.field_1352, this.hoverPos.field_1351, this.hoverPos.field_1350, (double)0.35f);
        }

        private float getOffset() {
            return (BeeflyEntity.this.field_5974.method_43057() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<class_2338> findNearbyFlower() {
            return this.findNearestBlock(this.VALID_POLLINATION_BLOCKS, 5.0);
        }

        private Optional<class_2338> findNearestBlock(Predicate<class_2680> predicate, double range) {
            class_2338 blockpos = BeeflyEntity.this.method_24515();
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            int i = 0;
            while ((double)i <= range) {
                int j = 0;
                while ((double)j < range) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutablePos.method_25504((class_2382)blockpos, k, i - 1, l);
                            if (blockpos.method_19771((class_2382)mutablePos, range) && predicate.test(BeeflyEntity.this.method_37908().method_8320((class_2338)mutablePos))) {
                                return Optional.of(mutablePos.method_10062());
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    class BeeflyGoToKnownFlowerGoal
    extends class_1352 {
        private static final int MAX_TRAVELLING_TICKS = 600;
        int travellingTicks;

        BeeflyGoToKnownFlowerGoal() {
            this.travellingTicks = BeeflyEntity.this.method_37908().field_9229.method_43048(10);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return BeeflyEntity.this.savedFlowerPos != null && !BeeflyEntity.this.hasPollen() && !BeeflyEntity.this.method_18407(BeeflyEntity.this.savedFlowerPos) && BeeflyEntity.this.isFlowerValid(BeeflyEntity.this.savedFlowerPos) && !BeeflyEntity.this.closerThan(BeeflyEntity.this.savedFlowerPos, 2);
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6269() {
            this.travellingTicks = 0;
            BeeflyEntity.this.setFlying(true);
            BeeflyEntity.this.landingFlag = false;
            super.method_6269();
        }

        public void method_6270() {
            this.travellingTicks = 0;
            BeeflyEntity.this.field_6189.method_6340();
            BeeflyEntity.this.field_6189.method_23965();
        }

        public void method_6268() {
            if (BeeflyEntity.this.savedFlowerPos != null) {
                ++this.travellingTicks;
                if (!BeeflyEntity.this.isFlying()) {
                    BeeflyEntity.this.setFlying(true);
                }
                BeeflyEntity.this.landingFlag = false;
                if (this.travellingTicks > 600) {
                    BeeflyEntity.this.savedFlowerPos = null;
                } else if (!BeeflyEntity.this.field_6189.method_23966()) {
                    if (BeeflyEntity.this.isTooFarAway(BeeflyEntity.this.savedFlowerPos)) {
                        BeeflyEntity.this.savedFlowerPos = null;
                    } else {
                        BeeflyEntity.this.pathfindRandomlyTowards(BeeflyEntity.this.savedFlowerPos);
                    }
                }
            }
        }
    }

    class BeeflySeekCropsGoal
    extends class_1352 {
        private static final int MAX_TRAVELLING_TICKS = 600;
        private static final double ARRIVAL_THRESHOLD = 1.5;
        private static final float HOVER_HEIGHT_ABOVE_CROP = 1.2f;
        private static final float SPEED_MODIFIER = 0.35f;
        private static final float HOVER_POS_OFFSET = 0.33333334f;
        private int travellingTicks;
        @Nullable
        private class_2338 targetCropPos;
        @Nullable
        private class_243 hoverPos;
        private boolean isHovering;

        BeeflySeekCropsGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.travellingTicks = 0;
            this.isHovering = false;
        }

        public boolean method_6264() {
            if (!BeeflyEntity.this.hasPollen()) {
                return false;
            }
            if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() >= 3) {
                return false;
            }
            if (BeeflyEntity.this.field_5974.method_43057() < 0.7f) {
                return false;
            }
            this.targetCropPos = this.findNearbyCrop();
            return this.targetCropPos != null;
        }

        public boolean method_6266() {
            if (!BeeflyEntity.this.hasPollen()) {
                return false;
            }
            if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() >= 3) {
                return false;
            }
            if (this.travellingTicks > 600) {
                return false;
            }
            return this.targetCropPos != null;
        }

        public void method_6269() {
            this.travellingTicks = 0;
            this.isHovering = false;
            this.hoverPos = null;
            BeeflyEntity.this.setFlying(true);
            BeeflyEntity.this.landingFlag = false;
            if (this.targetCropPos != null) {
                class_243 targetVec = class_243.method_24955((class_2382)this.targetCropPos).method_1031(0.0, (double)1.2f, 0.0);
                BeeflyEntity.this.field_6189.method_6337(targetVec.field_1352, targetVec.field_1351, targetVec.field_1350, 1.0);
            }
        }

        public void method_6270() {
            this.targetCropPos = null;
            this.hoverPos = null;
            this.travellingTicks = 0;
            this.isHovering = false;
            BeeflyEntity.this.field_6189.method_6340();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_2680 state;
            ++this.travellingTicks;
            if (!BeeflyEntity.this.isFlying()) {
                BeeflyEntity.this.setFlying(true);
            }
            BeeflyEntity.this.landingFlag = false;
            BeeflyEntity.this.groundedFor = 0;
            if (this.targetCropPos == null) {
                return;
            }
            if (!(this.travellingTicks % 20 != 0 || (state = BeeflyEntity.this.method_37908().method_8320(this.targetCropPos)).method_26164(class_3481.field_20342) && this.isGrowable(state, this.targetCropPos))) {
                this.targetCropPos = this.findNearbyCrop();
                if (this.targetCropPos != null) {
                    this.isHovering = false;
                    this.hoverPos = null;
                } else {
                    return;
                }
            }
            if (this.targetCropPos == null) {
                return;
            }
            class_243 cropCenter = class_243.method_24955((class_2382)this.targetCropPos).method_1031(0.0, (double)1.2f, 0.0);
            double distance = cropCenter.method_1022(BeeflyEntity.this.method_19538());
            if (distance < 1.5) {
                if (!this.isHovering) {
                    this.isHovering = true;
                    this.hoverPos = cropCenter;
                }
                if (BeeflyEntity.this.field_5974.method_43048(25) == 0) {
                    this.hoverPos = new class_243(cropCenter.field_1352 + (double)this.getOffset(), cropCenter.field_1351, cropCenter.field_1350 + (double)this.getOffset());
                    BeeflyEntity.this.field_6189.method_6340();
                }
                BeeflyEntity.this.method_5988().method_20248(cropCenter.field_1352, cropCenter.field_1351, cropCenter.field_1350);
                this.setWantedPos();
            } else if (BeeflyEntity.this.field_6189.method_6357()) {
                BeeflyEntity.this.field_6189.method_6337(cropCenter.field_1352, cropCenter.field_1351, cropCenter.field_1350, 1.0);
            }
        }

        private void setWantedPos() {
            if (this.hoverPos != null) {
                BeeflyEntity.this.method_5962().method_6239(this.hoverPos.field_1352, this.hoverPos.field_1351, this.hoverPos.field_1350, (double)0.35f);
            }
        }

        private float getOffset() {
            return (BeeflyEntity.this.field_5974.method_43057() * 2.0f - 1.0f) * 0.33333334f;
        }

        @Nullable
        private class_2338 findNearbyCrop() {
            class_2338 beeflyPos = BeeflyEntity.this.method_24515();
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            int range = 10;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    for (int y = -3; y <= 3; ++y) {
                        mutablePos.method_10103(beeflyPos.method_10263() + x, beeflyPos.method_10264() + y, beeflyPos.method_10260() + z);
                        class_2680 state = BeeflyEntity.this.method_37908().method_8320((class_2338)mutablePos);
                        if (!state.method_26164(class_3481.field_20342) || !this.isGrowable(state, (class_2338)mutablePos)) continue;
                        return mutablePos.method_10062();
                    }
                }
            }
            return null;
        }

        private boolean isGrowable(class_2680 state, class_2338 pos) {
            class_2248 block = state.method_26204();
            if (block instanceof class_2302) {
                class_2302 cropBlock = (class_2302)block;
                return !cropBlock.method_9825(state);
            }
            if (block instanceof class_2513) {
                int age = (Integer)state.method_11654((class_2769)class_2513.field_11584);
                return age < 7;
            }
            if (state.method_27852(class_2246.field_16999)) {
                int age = (Integer)state.method_11654((class_2769)class_3830.field_17000);
                return age < 3;
            }
            return state.method_27852(class_2246.field_28675) || state.method_27852(class_2246.field_28676);
        }
    }

    class BeeflyGrowCropGoal
    extends class_1352 {
        static final int GROW_CHANCE = 30;

        BeeflyGrowCropGoal() {
        }

        public boolean method_6264() {
            if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() >= 3) {
                return false;
            }
            if (BeeflyEntity.this.field_5974.method_43057() < 0.3f) {
                return false;
            }
            return BeeflyEntity.this.hasPollen();
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6268() {
            if (BeeflyEntity.this.field_5974.method_43048(30) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    class_2338 blockpos = BeeflyEntity.this.method_24515().method_10087(i);
                    class_2680 blockstate = BeeflyEntity.this.method_37908().method_8320(blockpos);
                    class_2248 block = blockstate.method_26204();
                    class_2680 newState = null;
                    if (!blockstate.method_26164(class_3481.field_20342)) continue;
                    if (block instanceof class_2302) {
                        class_2302 cropBlock = (class_2302)block;
                        if (!cropBlock.method_9825(blockstate)) {
                            newState = (class_2680)blockstate.method_11657((class_2769)class_2302.field_10835, (Comparable)Integer.valueOf(cropBlock.method_9829(blockstate) + 1));
                        }
                    } else if (block instanceof class_2513) {
                        age = (Integer)blockstate.method_11654((class_2769)class_2513.field_11584);
                        if (age < 7) {
                            newState = (class_2680)blockstate.method_11657((class_2769)class_2513.field_11584, (Comparable)Integer.valueOf(age + 1));
                        }
                    } else if (blockstate.method_27852(class_2246.field_16999)) {
                        age = (Integer)blockstate.method_11654((class_2769)class_3830.field_17000);
                        if (age < 3) {
                            newState = (class_2680)blockstate.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(age + 1));
                        }
                    } else if (blockstate.method_27852(class_2246.field_28675) || blockstate.method_27852(class_2246.field_28676)) {
                        ((class_2256)blockstate.method_26204()).method_9652((class_3218)BeeflyEntity.this.method_37908(), BeeflyEntity.this.field_5974, blockpos, blockstate);
                        BeeflyEntity.this.incrementNumCropsGrownSinceVisitingFlower();
                    }
                    if (newState == null) continue;
                    BeeflyEntity.this.method_37908().method_20290(2005, blockpos, 0);
                    BeeflyEntity.this.method_37908().method_8501(blockpos, newState);
                    BeeflyEntity.this.incrementNumCropsGrownSinceVisitingFlower();
                    if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() < 3) continue;
                    BeeflyEntity.this.setHasPollen(false);
                    BeeflyEntity.this.resetNumCropsGrownSinceVisitingFlower();
                    BeeflyEntity.this.savedFlowerPos = null;
                    BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower = 2400;
                }
            }
        }
    }

    class BeeflyFlightGoal
    extends class_1352 {
        private final BeeflyEntity beefly;
        private double x;
        private double y;
        private double z;
        private int flyDuration;
        private int restDuration;
        private int currentTimer;
        private boolean shouldRest;
        private int landingTimer;
        private class_243 landingTarget;

        public BeeflyFlightGoal(BeeflyEntity beefly) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.beefly = beefly;
            this.resetTimers();
            this.landingTimer = 0;
        }

        private void resetTimers() {
            this.flyDuration = 160 + this.beefly.method_6051().method_43048(81);
            this.restDuration = 80 + this.beefly.method_6051().method_43048(81);
            this.currentTimer = 0;
            this.shouldRest = false;
            this.landingTimer = 0;
        }

        public boolean method_6264() {
            if (this.beefly.method_5782() || this.beefly.method_5765()) {
                return false;
            }
            if (!this.beefly.isFlying() && this.beefly.method_24828()) {
                class_238 searchBox = this.beefly.method_5829().method_1014(4.0);
                List nearbyPlayers = this.beefly.method_37908().method_18467(class_1657.class, searchBox);
                if (!nearbyPlayers.isEmpty()) {
                    this.shouldRest = false;
                    this.currentTimer = 0;
                    this.landingTimer = 0;
                    class_243 target = this.getPosition();
                    if (target != null) {
                        this.x = target.field_1352;
                        this.y = target.field_1351;
                        this.z = target.field_1350;
                        return true;
                    }
                }
            }
            if (!this.beefly.isFlying() && this.beefly.method_6051().method_43048(80) != 0 && !this.shouldRest) {
                return false;
            }
            class_243 target = this.getPosition();
            if (target == null) {
                return false;
            }
            this.x = target.field_1352;
            this.y = target.field_1351;
            this.z = target.field_1350;
            return true;
        }

        public boolean method_6266() {
            if (!this.beefly.isFlying() && this.beefly.method_24828() && this.currentTimer >= this.restDuration) {
                return false;
            }
            if (this.beefly.landingFlag) {
                return !this.beefly.method_24828() && this.beefly.groundedFor <= 0;
            }
            return this.beefly.isFlying() && !this.beefly.method_5942().method_6357() && this.beefly.groundedFor <= 0;
        }

        public void method_6269() {
            this.beefly.setFlying(true);
            this.beefly.method_5942().method_6337(this.x, this.y, this.z, 0.5);
        }

        public void method_6270() {
            this.beefly.method_5942().method_6340();
            this.beefly.landingFlag = false;
            this.landingTimer = 0;
            this.landingTarget = null;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            super.method_6270();
        }

        public void method_6268() {
            if (!this.beefly.isFlying() && this.beefly.method_24828()) {
                ++this.currentTimer;
                class_2338 beeflyPos = this.beefly.method_24515();
                class_2680 stateAtPos = this.beefly.method_37908().method_8320(beeflyPos);
                if (!stateAtPos.method_26215() && !stateAtPos.method_45474()) {
                    return;
                }
                this.beefly.method_18799(class_243.field_1353);
                return;
            }
            ++this.currentTimer;
            if (this.beefly.isFlying()) {
                if (this.currentTimer >= this.flyDuration) {
                    this.shouldRest = true;
                    this.beefly.landingFlag = true;
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                }
                if (this.beefly.landingFlag) {
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                    if (this.landingTarget != null) {
                        ++this.landingTimer;
                        if (this.landingTimer % 20 == 0) {
                            class_243 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                            this.beefly.method_5942().method_6337(nextPos.field_1352, nextPos.field_1351, nextPos.field_1350, 0.25);
                        }
                        if (this.beefly.method_24828() || this.beefly.method_23318() - this.landingTarget.field_1351 < 1.5 && this.landingTimer > 60) {
                            this.beefly.setFlying(false);
                            this.currentTimer = 0;
                            this.shouldRest = false;
                            this.beefly.landingFlag = false;
                            this.landingTarget = null;
                            this.landingTimer = 0;
                            this.resetTimers();
                        }
                    } else {
                        this.beefly.landingFlag = false;
                        this.shouldRest = false;
                        this.landingTimer = 0;
                    }
                }
            }
            if (this.isOverWaterOrVoid() || this.beefly.method_5799()) {
                this.beefly.setFlying(true);
                this.beefly.landingFlag = false;
                this.shouldRest = false;
                this.landingTimer = 0;
                this.landingTarget = null;
            }
        }

        private class_243 getPosition() {
            if (this.shouldRest) {
                this.landingTarget = this.findLandingPos();
                return this.getCirclingPosition(this.landingTarget);
            }
            return this.findFlightPos();
        }

        private class_243 getCirclingPosition(class_243 target) {
            double angle = this.beefly.method_6051().method_43058() * Math.PI * 2.0;
            double radius = 2.0 + this.beefly.method_6051().method_43058() * 2.0;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double yOffset = 3.0 + this.beefly.method_6051().method_43058() * 2.0;
            return new class_243(target.field_1352 + xOffset, target.field_1351 + yOffset, target.field_1350 + zOffset);
        }

        private class_243 getDescentPosition(class_243 target, int timer) {
            if (target == null) {
                return this.beefly.method_19538();
            }
            double progress = Math.min((double)timer / 120.0, 1.0);
            double angle = (double)timer * 0.1 % (Math.PI * 2);
            double radius = 2.5 * (1.0 - progress * 0.6);
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double currentHeight = this.beefly.method_23318();
            double targetHeight = target.field_1351 + 0.5;
            double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.2;
            return new class_243(target.field_1352 + xOffset, Math.max(descentHeight, targetHeight), target.field_1350 + zOffset);
        }

        private class_243 findFlightPos() {
            int range = 13;
            class_243 heightAdjusted = this.beefly.method_19538().method_1031((double)(this.beefly.method_6051().method_43048(range * 2) - range), 0.0, (double)(this.beefly.method_6051().method_43048(range * 2) - range));
            class_243 ground = this.groundPosition(heightAdjusted);
            int minHeight = 2;
            int heightVariation = this.beefly.method_6051().method_43048(5 - minHeight + 1);
            heightAdjusted = new class_243(heightAdjusted.field_1352, ground.field_1351 + (double)minHeight + (double)heightVariation, heightAdjusted.field_1350);
            class_3965 result = this.beefly.method_37908().method_17742(new class_3959(this.beefly.method_33571(), heightAdjusted, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.beefly));
            if (result.method_17783() == class_239.class_240.field_1333) {
                return heightAdjusted;
            }
            return result.method_17784();
        }

        private class_243 findLandingPos() {
            class_243 currentPos = this.beefly.method_19538();
            class_243 ground = this.groundPosition(currentPos);
            class_2338 landingPos = class_2338.method_49638((class_2374)ground);
            while (landingPos.method_10264() < this.beefly.method_37908().method_31600() && !this.beefly.method_37908().method_8320(landingPos).method_26215() && !this.beefly.method_37908().method_8320(landingPos).method_45474()) {
                landingPos = landingPos.method_10084();
            }
            return class_243.method_24953((class_2382)landingPos);
        }

        private class_243 groundPosition(class_243 airPosition) {
            class_2338.class_2339 ground = new class_2338.class_2339();
            ground.method_10102(airPosition.field_1352, airPosition.field_1351, airPosition.field_1350);
            boolean flag = false;
            while (ground.method_10264() < this.beefly.method_37908().method_31600() && !this.beefly.method_37908().method_8320((class_2338)ground).method_26212((class_1922)this.beefly.method_37908(), (class_2338)ground) && this.beefly.method_37908().method_8316((class_2338)ground).method_15769()) {
                ground.method_10100(0, 1, 0);
                flag = true;
            }
            ground.method_10100(0, -1, 0);
            while (ground.method_10264() > this.beefly.method_37908().method_31607() && !this.beefly.method_37908().method_8320((class_2338)ground).method_26212((class_1922)this.beefly.method_37908(), (class_2338)ground) && this.beefly.method_37908().method_8316((class_2338)ground).method_15769()) {
                ground.method_10100(0, -1, 0);
            }
            return class_243.method_24953((class_2382)(flag ? ground.method_10084() : ground.method_10074()));
        }

        private boolean isOverWaterOrVoid() {
            class_2338 position = this.beefly.method_24515();
            while (position.method_10264() > this.beefly.method_37908().method_31607() && this.beefly.method_37908().method_22347(position) && this.beefly.method_37908().method_8316(position).method_15769()) {
                position = position.method_10074();
            }
            return !this.beefly.method_37908().method_8316(position).method_15769() || this.beefly.method_37908().method_8320(position).method_27852(class_2246.field_10597) || position.method_10264() <= this.beefly.method_37908().method_31607();
        }
    }

    private static class BeeflyFlyingNavigation
    extends class_1407 {
        private float distanceModifier;

        public BeeflyFlyingNavigation(class_1308 mob, class_1937 level, float distanceModifier) {
            super(mob, level);
            this.distanceModifier = distanceModifier;
        }

        protected void method_6339() {
            boolean flag;
            class_243 vector3d = this.method_6347();
            class_2338 vector3i = this.field_6681.method_31032();
            double d0 = Math.abs(this.field_6684.method_23317() - ((double)vector3i.method_10263() + 0.5));
            double d1 = Math.abs(this.field_6684.method_23318() - (double)vector3i.method_10264());
            double d2 = Math.abs(this.field_6684.method_23321() - ((double)vector3i.method_10260() + 0.5));
            boolean bl = flag = d0 < (double)(this.field_6684.method_17681() * this.distanceModifier) && d2 < (double)(this.field_6684.method_17681() * this.distanceModifier) && d1 < 1.0;
            if (flag || this.shouldTargetNextNodeInDirection(vector3d)) {
                this.field_6681.method_44();
            }
            this.method_6346(vector3d);
        }

        private boolean shouldTargetNextNodeInDirection(class_243 currentPosition) {
            class_243 vector3d3;
            if (this.field_6681.method_39() + 1 >= this.field_6681.method_38()) {
                return false;
            }
            class_243 vector3d = class_243.method_24955((class_2382)this.field_6681.method_31032());
            if (!currentPosition.method_24802((class_2374)vector3d, 2.0)) {
                return false;
            }
            class_243 vector3d1 = class_243.method_24955((class_2382)this.field_6681.method_40(this.field_6681.method_39() + 1).method_22879());
            class_243 vector3d2 = vector3d1.method_1020(vector3d);
            return vector3d2.method_1026(vector3d3 = currentPosition.method_1020(vector3d)) > 0.0;
        }
    }
}

