/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.client.IFlyingBug;
import com.pepper.faunify.entity.goal.BugFlightGoal;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BeetleEntity
extends class_1429
implements GeoEntity,
IFlyingBug {
    private static final int FLAP_INTERVAL = 15;
    private static final double FALL_DETECTION_THRESHOLD = -0.4;
    private static final double CLIMB_SPEED = 0.08;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(BeetleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(BeetleEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(BeetleEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CAUGHT = class_2945.method_12791(BeetleEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    public boolean landingFlag;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private class_2338 lastClimbPos;
    private class_1408 groundNavigation;
    private class_1408 flyingNavigation;
    private class_243 prevPosition = class_243.field_1353;
    private double actualMovementSpeed = 0.0;

    public BeetleEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new BeetleMoveController(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(2, new BugFlightGoal<BeetleEntity>(this, 3, 150));
        this.field_6201.method_6277(3, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canSpawn(class_1299<BeetleEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant(BeetleEntity.getRandomVariant(world.method_8409()));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public void method_5773() {
        boolean shouldClimb;
        super.method_5773();
        if (this.isCaught()) {
            return;
        }
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
        class_243 currentPos = this.method_19538();
        this.actualMovementSpeed = currentPos.method_1022(this.prevPosition);
        this.prevPosition = currentPos;
        if (!(this.method_37908().field_9236 || this.isFlying() || this.method_24828() || this.method_5799())) {
            class_243 motion = this.method_18798();
            if (motion.field_1351 < -0.4) {
                this.setFlying(true);
                this.groundedFor = 0;
            }
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.field_5976 && !this.isFlying() && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.method_6101() && !this.isFlying()) {
            class_2338 currentPos2 = this.method_24515();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos2)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos2;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.method_37908().field_9236) {
                    this.field_6189.method_6340();
                    this.field_6201.method_19048().forEach(goal -> goal.method_6270());
                }
            } else {
                boolean hasBlockAbove;
                class_243 deltaMovement = this.method_18798();
                boolean shouldApplyClimbMovement = true;
                if (this.method_24828() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.method_18800(deltaMovement.field_1352, 0.08, deltaMovement.field_1350);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        if (!this.method_37908().field_9236) {
            this.setClimbing(shouldClimb);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.isCaught()) {
            return;
        }
    }

    public void tickFlight() {
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.method_5799()) {
            this.method_5875(false);
            if (!this.method_37908().field_9236) {
                class_243 motion = this.method_18798();
                if (motion.field_1351 < 0.05) {
                    this.method_18800(motion.field_1352 * 0.9, motion.field_1351 + 0.1, motion.field_1350 * 0.9);
                }
            }
        }
        if (this.isFlying()) {
            ++this.timeFlying;
            if (!this.method_5799()) {
                this.method_5875(true);
            }
            this.field_6189 = this.flyingNavigation;
            if (this.groundedFor > 0) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.method_5875(false);
            this.field_6189 = this.groundNavigation;
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.method_37908().field_9236) {
            if (this.isFlying() && this.method_5805() && !this.method_5782() && !this.method_5799()) {
                if (this.landingFlag) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.08, 0.0));
                }
                if (this.field_5976 && !this.landingFlag) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.04, 0.0));
                }
            }
            if (this.isFlying() && this.timeFlying > 40 && this.method_24828()) {
                this.setFlying(false);
            }
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        this.groundNavigation = new class_1409((class_1308)this, world);
        this.flyingNavigation = new BeetleBirdNavigation((class_1308)this, world, 0.75f);
        return this.groundNavigation;
    }

    public void method_6091(class_243 movementInput) {
        if (this.isCaught()) {
            super.method_6091(class_243.field_1353);
            return;
        }
        if (this.method_6101() && !this.isFlying()) {
            class_243 reducedVector = movementInput.method_1021(0.4);
            super.method_6091(reducedVector);
        } else {
            super.method_6091(movementInput);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 otherParent) {
        return null;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        if (!this.isFlying()) {
            return super.method_5747(fallDistance, damageMultiplier, damageSource);
        }
        return false;
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<BeetleEntity> event) {
        if (this.isCaught()) {
            event.getController().stop();
            return PlayState.STOP;
        }
        boolean flying = this.isFlying();
        boolean climbing = this.method_6101();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.method_24828();
        if (flying) {
            event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Flying", this.isFlying());
        nbt.method_10569("TimeFlying", this.timeFlying);
        nbt.method_10569("GroundedFor", this.groundedFor);
        nbt.method_10556("LandingFlag", this.landingFlag);
        nbt.method_10569("Variant", this.getVariant().id);
        nbt.method_10556("Caught", this.isCaught());
        nbt.method_10569("ClimbingTime", this.climbingTime);
        nbt.method_10569("ClimbCooldown", this.climbCooldown);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setFlying(nbt.method_10577("Flying"));
        this.timeFlying = nbt.method_10550("TimeFlying");
        this.groundedFor = nbt.method_10550("GroundedFor");
        this.landingFlag = nbt.method_10577("LandingFlag");
        this.setVariant(Variant.byId(nbt.method_10550("Variant")));
        this.setCaught(nbt.method_10577("Caught"));
        this.climbingTime = nbt.method_10550("ClimbingTime");
        this.climbCooldown = nbt.method_10550("ClimbCooldown");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
        this.field_6011.method_12784(CAUGHT, (Object)false);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public boolean method_5810() {
        return !this.isCaught();
    }

    public boolean method_6101() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)flags);
    }

    protected float method_6106() {
        return 0.0f;
    }

    public void method_6100(boolean jumping) {
        super.method_6100(false);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    @Override
    public boolean getLandingFlag() {
        return this.landingFlag;
    }

    @Override
    public void setLandingFlag(boolean flag) {
        this.landingFlag = flag;
    }

    @Override
    public int getGroundedFor() {
        return this.groundedFor;
    }

    public boolean isCaught() {
        return (Boolean)this.field_6011.method_12789(CAUGHT);
    }

    public void setCaught(boolean caught) {
        this.field_6011.method_12778(CAUGHT, (Object)caught);
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        if (!state.method_26215() && !state.method_45474()) {
            return true;
        }
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        class_2338 east = pos.method_10078();
        class_2338 west = pos.method_10067();
        boolean bl = hasAdjacentAtCurrentLevel = !this.method_37908().method_8320(north).method_26215() && !this.method_37908().method_8320(north).method_45474() || !this.method_37908().method_8320(south).method_26215() && !this.method_37908().method_8320(south).method_45474() || !this.method_37908().method_8320(east).method_26215() && !this.method_37908().method_8320(east).method_45474() || !this.method_37908().method_8320(west).method_26215() && !this.method_37908().method_8320(west).method_45474();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        class_2338 posBelow = pos.method_10074();
        class_2338 northBelow = posBelow.method_10095();
        class_2338 southBelow = posBelow.method_10072();
        class_2338 eastBelow = posBelow.method_10078();
        class_2338 westBelow = posBelow.method_10067();
        return !this.method_37908().method_8320(northBelow).method_26215() && !this.method_37908().method_8320(northBelow).method_45474() || !this.method_37908().method_8320(southBelow).method_26215() && !this.method_37908().method_8320(southBelow).method_45474() || !this.method_37908().method_8320(eastBelow).method_26215() && !this.method_37908().method_8320(eastBelow).method_45474() || !this.method_37908().method_8320(westBelow).method_26215() && !this.method_37908().method_8320(westBelow).method_45474();
    }

    private static Variant getRandomVariant(class_5819 random) {
        int roll = random.method_43048(111);
        if (roll < 10) {
            return Variant.ATLAS;
        }
        if (roll < 20) {
            return Variant.DYNASTID;
        }
        if (roll < 30) {
            return Variant.ELEPHANT;
        }
        if (roll < 40) {
            return Variant.GOLIATH;
        }
        if (roll < 50) {
            return Variant.HERCULES;
        }
        if (roll < 60) {
            return Variant.CYCLOMMATUS;
        }
        if (roll < 70) {
            return Variant.GIANT;
        }
        if (roll < 80) {
            return Variant.GIRAFFE;
        }
        if (roll < 90) {
            return Variant.MIYAMA;
        }
        if (roll < 100) {
            return Variant.RAINBOW;
        }
        if (roll < 110) {
            return Variant.SAW;
        }
        return Variant.GOLDEN;
    }

    private static class BeetleMoveController
    extends class_1335 {
        private final BeetleEntity beetle;

        public BeetleMoveController(BeetleEntity beetle) {
            super((class_1308)beetle);
            this.beetle = beetle;
        }

        public void method_6240() {
            if (this.beetle.isCaught()) {
                return;
            }
            if (this.beetle.isFlying() && !this.beetle.method_5799()) {
                if (this.field_6374 == class_1335.class_1336.field_6378) {
                    class_243 vector3d = new class_243(this.field_6370 - this.beetle.method_23317(), this.field_6369 - this.beetle.method_23318(), this.field_6367 - this.beetle.method_23321());
                    double d0 = vector3d.method_1033();
                    double width = this.beetle.method_5829().method_995();
                    if (d0 > 0.001) {
                        class_243 vector3d1 = vector3d.method_1021(this.field_6372 * 0.05 / d0);
                        this.beetle.method_18799(this.beetle.method_18798().method_1019(vector3d1).method_1021(0.95).method_1031(0.0, -0.01, 0.0));
                        if (d0 >= width) {
                            float yaw = -((float)class_3532.method_15349((double)vector3d1.field_1352, (double)vector3d1.field_1350)) * 57.295776f;
                            this.beetle.method_36456(class_3532.method_15388((float)this.beetle.method_36454(), (float)yaw, (float)8.0f));
                        }
                    }
                    if (d0 < width) {
                        this.field_6374 = class_1335.class_1336.field_6377;
                    }
                } else {
                    class_243 currentMotion = this.beetle.method_18798();
                    double horizontalSpeed = Math.sqrt(currentMotion.field_1352 * currentMotion.field_1352 + currentMotion.field_1350 * currentMotion.field_1350);
                    if (horizontalSpeed < 0.05) {
                        double yaw = Math.toRadians(this.beetle.method_36454());
                        class_243 forwardMotion = new class_243(-Math.sin(yaw) * 0.02, 0.0, Math.cos(yaw) * 0.02);
                        this.beetle.method_18799(currentMotion.method_1019(forwardMotion));
                    }
                }
            } else {
                super.method_6240();
            }
        }
    }

    public static enum Variant implements class_3542
    {
        ATLAS(0, "atlas"),
        DYNASTID(1, "dynastid"),
        ELEPHANT(2, "elephant"),
        GOLIATH(3, "goliath"),
        HERCULES(4, "hercules"),
        CYCLOMMATUS(5, "cyclommatus"),
        GIANT(6, "giant"),
        GIRAFFE(7, "giraffe"),
        MIYAMA(8, "miyama"),
        RAINBOW(9, "rainbow"),
        SAW(10, "saw"),
        GOLDEN(11, "golden");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = id -> {
                Variant[] variants = Variant.values();
                if (id < 0 || id >= variants.length) {
                    id = 0;
                }
                return variants[id];
            };
        }
    }

    private static class BeetleBirdNavigation
    extends class_1407 {
        private float distanceModifier;

        public BeetleBirdNavigation(class_1308 mob, class_1937 world, float distanceModifier) {
            super(mob, world);
            this.distanceModifier = distanceModifier;
        }

        protected void method_6339() {
            boolean flag;
            class_243 vector3d = this.method_6347();
            this.field_6678.method_20(true);
            this.field_6678.method_15(true);
            class_2338 vector3i = this.field_6681.method_31032();
            double d0 = Math.abs(this.field_6684.method_23317() - ((double)vector3i.method_10263() + 0.5));
            double d1 = Math.abs(this.field_6684.method_23318() - (double)vector3i.method_10264());
            double d2 = Math.abs(this.field_6684.method_23321() - ((double)vector3i.method_10260() + 0.5));
            boolean bl = flag = d0 < (double)(this.field_6684.method_17681() * this.distanceModifier) && d2 < (double)(this.field_6684.method_17681() * this.distanceModifier) && d1 < 1.0;
            if (flag || this.shouldTargetNextNodeInDirection(vector3d)) {
                this.field_6681.method_44();
            }
            this.method_6346(vector3d);
        }

        private boolean shouldTargetNextNodeInDirection(class_243 currentPosition) {
            class_243 vector3d3;
            if (this.field_6681.method_39() + 1 >= this.field_6681.method_38()) {
                return false;
            }
            class_243 vector3d = class_243.method_24955((class_2382)this.field_6681.method_31032());
            if (!currentPosition.method_24802((class_2374)vector3d, 2.0)) {
                return false;
            }
            if (this.field_6681.method_39() + 1 >= this.field_6681.method_38()) {
                return false;
            }
            class_243 vector3d1 = class_243.method_24955((class_2382)this.field_6681.method_40(this.field_6681.method_39() + 1).method_22879());
            class_243 vector3d2 = vector3d1.method_1020(vector3d);
            return vector3d2.method_1026(vector3d3 = currentPosition.method_1020(vector3d)) > 0.0;
        }
    }
}

