/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyBlocks;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import net.minecraft.class_8174;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ChinchillaEntity
extends class_1321
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 8.0f;
    public static final float TAMED_HEALTH = 20.0f;
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(ChinchillaEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(ChinchillaEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BATHING = class_2945.method_12791(ChinchillaEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public ChinchillaEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new ChinchillaMoveControl(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.5){

            public boolean method_6264() {
                return !ChinchillaEntity.this.method_6181() && super.method_6264();
            }
        });
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new DustBatheGoal(this));
        this.field_6201.method_6277(4, (class_1352)new DustBatheSuspiciousGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1391((class_1314)this, 1.3, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8861}), false));
        this.field_6201.method_6277(6, (class_1352)new class_1341((class_1429)this, 1.3));
        this.field_6201.method_6277(7, (class_1352)new class_1350((class_1321)this, 1.3, 10.0f, 2.0f, false));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new SleepGoal(200));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f){

            public boolean method_6264() {
                return !ChinchillaEntity.this.method_6113() && super.method_6264();
            }

            public boolean method_6266() {
                return !ChinchillaEntity.this.method_6113() && super.method_6266();
            }
        });
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this){

            public boolean method_6264() {
                return !ChinchillaEntity.this.method_6113() && super.method_6264();
            }

            public boolean method_6266() {
                return !ChinchillaEntity.this.method_6113() && super.method_6266();
            }
        });
    }

    public static boolean canSpawn(class_1299<ChinchillaEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (this.method_37908().field_9236) {
            boolean flag = this.method_6171((class_1309)player) || this.method_6181() || item == class_1802.field_8491 && !this.method_6181();
            return flag ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (this.method_6113()) {
                this.setSleeping(false);
                this.method_24346(true);
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            if (this.method_6481(itemstack) && this.method_6109()) {
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                this.method_5620(class_1296.method_41321((int)(-this.method_5618())), true);
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.field_5974.method_43059() * 0.02;
                        double d1 = this.field_5974.method_43059() * 0.02;
                        double d2 = this.field_5974.method_43059() * 0.02;
                        serverWorld.method_14199((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d0, d1, d2, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
            if (item == class_1802.field_8861 && this.method_6032() < this.method_6063()) {
                class_1937 i;
                this.method_6025(3.0f);
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                if ((i = this.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)i;
                    for (int i2 = 0; i2 < 5; ++i2) {
                        double offsetX = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetY = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetZ = (this.field_5974.method_43058() - 0.5) * 1.0;
                        serverWorld.method_14199((class_2394)FaunifyParticleTypes.HEALTH, this.method_23317() + offsetX, this.method_23318() + (double)this.method_5751() + offsetY, this.method_23321() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
            if (this.method_6481(itemstack) && this.method_5618() == 0 && !this.method_6479()) {
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                this.method_6480(player);
                return class_1269.field_5812;
            }
            class_1269 interactionresult = super.method_5992(player, hand);
            if ((!interactionresult.method_23665() || this.method_6109()) && this.method_6171((class_1309)player)) {
                this.method_24346(!this.method_24345());
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            return interactionresult;
        }
        if (item == class_1802.field_8491) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0) {
                this.method_6170(player);
                this.method_6173(true);
                this.method_24346(true);
                this.field_6189.method_6340();
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(20.0);
            this.method_6033(20.0f);
        }
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.method_6181()) {
            return false;
        }
        if (!(otherAnimal instanceof ChinchillaEntity)) {
            return false;
        }
        ChinchillaEntity otherChinchilla = (ChinchillaEntity)otherAnimal;
        if (!otherChinchilla.method_6181()) {
            return false;
        }
        if (otherChinchilla.method_6172()) {
            return false;
        }
        return this.method_6479() && otherChinchilla.method_6479();
    }

    @Nullable
    public ChinchillaEntity createChild(class_3218 serverWorld, class_1296 otherParent) {
        ChinchillaEntity babyChinchilla = (ChinchillaEntity)FaunifyEntities.CHINCHILLA.method_5883((class_1937)serverWorld);
        if (babyChinchilla != null && otherParent instanceof ChinchillaEntity) {
            ChinchillaEntity parent = (ChinchillaEntity)otherParent;
            if (this.method_6181()) {
                babyChinchilla.method_6174(this.method_6139());
                babyChinchilla.method_6173(true);
            }
            Variant selectedVariant = this.field_5974.method_43056() ? this.getVariant() : parent.getVariant();
            babyChinchilla.setVariant(selectedVariant);
            babyChinchilla.method_5971();
        }
        return babyChinchilla;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8861;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (this.method_6113()) {
            this.setSleeping(false);
        }
        if (!this.method_37908().field_9236) {
            this.method_24346(false);
        }
        if (this.method_6172()) {
            this.method_6179(false);
        }
        return result;
    }

    protected class_3414 method_5994() {
        int soundIndex = this.field_5974.method_43048(3);
        switch (soundIndex) {
            case 0: {
                return FaunifySounds.CHINCHILLA_IDLE_1;
            }
            case 1: {
                return FaunifySounds.CHINCHILLA_IDLE_2;
            }
            case 2: {
                return FaunifySounds.CHINCHILLA_IDLE_3;
            }
        }
        return FaunifySounds.CHINCHILLA_IDLE_1;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.CHINCHILLA_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<ChinchillaEntity> event) {
        class_1309 target = this.method_5968();
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
            target = null;
        }
        if (this.method_6113()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.method_6172()) {
            event.getController().setAnimation(RawAnimation.begin().then("stand", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDustBathing()) {
            class_2388 gravelParticle = new class_2388(class_2398.field_11217, class_2246.field_10255.method_9564());
            for (int i = 0; i < 3; ++i) {
                double offsetX = ((double)this.method_6051().method_43057() - 0.5) * 0.5;
                double offsetZ = ((double)this.method_6051().method_43057() - 0.5) * 0.5;
                this.method_37908().method_8406((class_2394)gravelParticle, this.method_23317() + offsetX, this.method_23318() + 0.1, this.method_23321() + offsetZ, 0.0, 0.0, 0.0);
            }
            event.getController().setAnimation(RawAnimation.begin().then("bath", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(BATHING, (Object)false);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10556("Sleeping", this.method_6113());
        tag.method_10556("Bathing", this.isDustBathing());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        this.setSleeping(tag.method_10577("Sleeping"));
        this.setDustBathing(tag.method_10577("Bathing"));
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean isDustBathing() {
        return (Boolean)this.field_6011.method_12789(BATHING);
    }

    public void setDustBathing(boolean bathing) {
        this.field_6011.method_12778(BATHING, (Object)bathing);
        if (bathing) {
            this.method_5942().method_6340();
        }
    }

    private boolean isFollowingPlayerWithFood() {
        class_1657 player = this.method_37908().method_18460((class_1297)this, 10.0);
        if (player != null) {
            class_1799 heldItem = player.method_6047();
            return heldItem.method_7909() == class_1802.field_8861;
        }
        return false;
    }

    static class ChinchillaMoveControl
    extends class_1335 {
        private final ChinchillaEntity chinchilla;

        public ChinchillaMoveControl(ChinchillaEntity chinchillaEntity) {
            super((class_1308)chinchillaEntity);
            this.chinchilla = chinchillaEntity;
        }

        public void method_6240() {
            if (!this.chinchilla.method_6113()) {
                super.method_6240();
            }
        }
    }

    public class DustBatheGoal
    extends class_1352 {
        private final ChinchillaEntity chinchilla;
        private static final int DUST_BATH_DURATION = 35;
        private int dustBathTimer = 0;
        private class_2338 bathingBlock;

        public DustBatheGoal(ChinchillaEntity chinchilla) {
            this.chinchilla = chinchilla;
        }

        public boolean method_6264() {
            if (this.chinchilla.method_6172() || this.chinchilla.method_6113()) {
                return false;
            }
            class_2338 pos = this.chinchilla.method_24515().method_10074();
            return this.chinchilla.method_37908().method_8320(pos).method_27852(class_2246.field_10255);
        }

        public void method_6269() {
            this.bathingBlock = this.chinchilla.method_24515().method_10074();
            this.chinchilla.setDustBathing(true);
            this.dustBathTimer = 35;
            this.chinchilla.method_5942().method_6340();
        }

        public void method_6268() {
            this.chinchilla.method_18799(class_243.field_1353);
            this.chinchilla.method_36456(this.chinchilla.field_5982);
            this.chinchilla.method_36457(0.0f);
            this.chinchilla.method_5783(class_3417.field_15144, 0.5f, 1.0f);
            if (this.dustBathTimer > 0) {
                --this.dustBathTimer;
            } else {
                this.chinchilla.setDustBathing(false);
                this.chinchilla.method_37908().method_8501(this.bathingBlock, FaunifyBlocks.DUST_BLOCK.method_9564());
            }
        }

        public boolean method_6266() {
            return this.chinchilla.isDustBathing() && this.chinchilla.method_37908().method_8320(this.bathingBlock).method_27852(class_2246.field_10255);
        }

        public void method_6270() {
            this.chinchilla.setDustBathing(false);
            this.chinchilla.method_5942().method_6340();
            this.chinchilla.method_18799(class_243.field_1353);
        }

        public EnumSet<class_1352.class_4134> method_6271() {
            return EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406);
        }
    }

    public class DustBatheSuspiciousGoal
    extends class_1352 {
        private final ChinchillaEntity chinchilla;
        private static final int DUST_BATH_DURATION = 35;
        private static final int BRUSH_STAGE_TIME = 5;
        private int dustBathTimer = 0;
        private int brushStageTimer = 5;
        private boolean isSuspicious = false;
        private boolean hasDroppedItem = false;
        private class_2338 bathingBlock;

        public DustBatheSuspiciousGoal(ChinchillaEntity chinchilla) {
            this.chinchilla = chinchilla;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.chinchilla.method_6172() || this.chinchilla.method_6113()) {
                return false;
            }
            class_2338 pos = this.chinchilla.method_24515().method_10074();
            return this.chinchilla.method_37908().method_8320(pos).method_27852(class_2246.field_43227);
        }

        public void method_6269() {
            this.bathingBlock = this.chinchilla.method_24515().method_10074();
            this.chinchilla.setDustBathing(true);
            this.chinchilla.method_5942().method_6340();
            this.dustBathTimer = 35;
            this.brushStageTimer = 5;
            this.isSuspicious = this.chinchilla.method_37908().method_8320(this.bathingBlock).method_27852(class_2246.field_43227);
            this.hasDroppedItem = false;
        }

        public void method_6268() {
            this.chinchilla.method_18799(class_243.field_1353);
            this.chinchilla.method_36456(this.chinchilla.field_5982);
            this.chinchilla.method_36457(0.0f);
            this.chinchilla.method_5783(class_3417.field_15144, 0.5f, 1.0f);
            if (this.dustBathTimer > 0) {
                --this.dustBathTimer;
            }
            if (this.dustBathTimer <= 0) {
                if (this.isSuspicious) {
                    if (this.brushStageTimer-- <= 0) {
                        this.dustAwaySuspiciousGravel(this.bathingBlock);
                        this.brushStageTimer = 5;
                    }
                } else {
                    this.chinchilla.method_37908().method_8501(this.bathingBlock, FaunifyBlocks.DUST_BLOCK.method_9564());
                    if (!this.hasDroppedItem) {
                        this.dropLootFromSuspiciousGravel();
                        this.hasDroppedItem = true;
                    }
                    this.chinchilla.setDustBathing(false);
                }
            }
        }

        public boolean method_6266() {
            return this.chinchilla.isDustBathing() && this.chinchilla.method_37908().method_8320(this.bathingBlock).method_27852(class_2246.field_43227);
        }

        public void method_6270() {
            this.chinchilla.setDustBathing(false);
            this.chinchilla.method_5942().method_6340();
            this.chinchilla.method_18799(class_243.field_1353);
        }

        private void dustAwaySuspiciousGravel(class_2338 pos) {
            class_2586 class_25862;
            class_3218 serverWorld;
            class_2680 state;
            class_1937 class_19372 = this.chinchilla.method_37908();
            if (class_19372 instanceof class_3218 && (state = (serverWorld = (class_3218)class_19372).method_8320(pos)).method_27852(class_2246.field_43227) && (class_25862 = serverWorld.method_8321(pos)) instanceof class_8174) {
                class_8174 blockEntity = (class_8174)class_25862;
                class_1657 nearestPlayer = serverWorld.method_18766(p -> (double)p.method_5739((class_1297)this.chinchilla) < 5.0).stream().findFirst().orElse(null);
                if (nearestPlayer != null) {
                    blockEntity.method_49215(serverWorld.method_8510(), nearestPlayer, class_2350.field_11036);
                }
            }
        }

        private void dropLootFromSuspiciousGravel() {
            class_1937 class_19372 = this.chinchilla.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)class_19372;
            class_2960 lootTableId = this.chinchilla.method_6051().method_43048(5) == 0 ? class_39.field_44649 : class_39.field_44648;
            class_52 lootTable = serverWorld.method_8503().method_3857().getLootTable(lootTableId);
            class_8567.class_8568 builder = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)this.chinchilla.method_19538()).method_51877(class_181.field_1226, (Object)this.chinchilla);
            ObjectArrayList loot = lootTable.method_51878(builder.method_51875(class_173.field_1175));
            for (class_1799 stack : loot) {
                if (stack.method_7960()) continue;
                class_1542 itemEntity = new class_1542((class_1937)serverWorld, this.chinchilla.method_23317(), this.chinchilla.method_23318(), this.chinchilla.method_23321(), stack);
                serverWorld.method_8649((class_1297)itemEntity);
            }
        }
    }

    public class SleepGoal
    extends class_1352 {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = ChinchillaEntity.this.field_5974.method_43048(SleepGoal.method_38848((int)countdownTime));
            this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
        }

        public boolean method_6264() {
            if (ChinchillaEntity.this.method_5799()) {
                return false;
            }
            if (ChinchillaEntity.this.method_6181() && !ChinchillaEntity.this.method_6172()) {
                return false;
            }
            if (ChinchillaEntity.this.field_6212 == 0.0f && ChinchillaEntity.this.field_6227 == 0.0f && ChinchillaEntity.this.field_6250 == 0.0f) {
                return this.canSleep() || ChinchillaEntity.this.method_6113();
            }
            return false;
        }

        public boolean method_6266() {
            if (ChinchillaEntity.this.method_5799()) {
                return false;
            }
            if (ChinchillaEntity.this.method_6181() && !ChinchillaEntity.this.method_6172()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return ChinchillaEntity.this.method_37908().method_23886();
        }

        public void method_6270() {
            ChinchillaEntity.this.setSleeping(false);
            this.countdown = ChinchillaEntity.this.field_5974.method_43048(this.countdownTime);
        }

        public void method_6269() {
            ChinchillaEntity.this.method_6100(false);
            ChinchillaEntity.this.setSleeping(true);
            ChinchillaEntity.this.method_5942().method_6340();
            ChinchillaEntity.this.method_5962().method_6239(ChinchillaEntity.this.method_23317(), ChinchillaEntity.this.method_23318(), ChinchillaEntity.this.method_23321(), 0.0);
        }
    }

    public static enum Variant implements class_3542
    {
        GREY(0, "grey"),
        BROWN(1, "brown"),
        BLACK(2, "black"),
        WHITE(3, "white");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

