/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DragonflyEntity
extends class_1429
implements GeoEntity {
    private static final int CONTINUOUS_FLAP_INTERVAL = 10;
    private static final double PLAYER_DETECTION_RANGE = 4.0;
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(DragonflyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(DragonflyEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HOVERING = class_2945.method_12791(DragonflyEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    private int continuousFlapTimer = 0;
    public boolean landingFlag;

    public DragonflyEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new DragonflyMoveController(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23719, 0.6);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new DartingGoal(this));
        this.field_6201.method_6277(2, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canSpawn(class_1299<DragonflyEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public void method_5773() {
        super.method_5773();
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
    }

    public void tickFlight() {
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isFlying()) {
            ++this.timeFlying;
            this.method_5875(true);
            if (this.groundedFor > 0 && !this.landingFlag) {
                this.setFlying(false);
            }
            if (!this.method_37908().field_9236) {
                ++this.continuousFlapTimer;
                if (this.continuousFlapTimer >= 10) {
                    if (!FaunifyClientConfig.dragonflyPhobiaFriendly) {
                        this.method_5783(FaunifySounds.BUG_FLY_FAST_TACKY, 0.1f, 0.8f);
                    }
                    this.continuousFlapTimer = 0;
                }
            }
        } else {
            this.timeFlying = 0;
            this.method_5875(false);
            this.continuousFlapTimer = 0;
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.method_37908().field_9236 && this.isFlying() && this.method_5805() && !this.method_5782()) {
            if (this.landingFlag) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.06, 0.0));
            }
            if ((this.field_5976 || this.method_5799()) && !this.landingFlag) {
                this.method_18799(this.method_18798().method_1031(0.0, 0.05, 0.0));
            }
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        return new DragonflyBirdNavigation((class_1308)this, world, 0.75f);
    }

    public boolean method_5810() {
        return true;
    }

    protected float method_6106() {
        return 0.0f;
    }

    public void method_6100(boolean jumping) {
        super.method_6100(false);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 otherParent) {
        return null;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<DragonflyEntity> event) {
        if (!this.isFlying()) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Flying", this.isFlying());
        nbt.method_10569("TimeFlying", this.timeFlying);
        nbt.method_10569("GroundedFor", this.groundedFor);
        nbt.method_10556("LandingFlag", this.landingFlag);
        nbt.method_10569("ContinuousFlapTimer", this.continuousFlapTimer);
        nbt.method_10569("Variant", this.getVariant().id);
        nbt.method_10556("Hovering", this.isHovering());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setFlying(nbt.method_10577("Flying"));
        this.timeFlying = nbt.method_10550("TimeFlying");
        this.groundedFor = nbt.method_10550("GroundedFor");
        this.landingFlag = nbt.method_10577("LandingFlag");
        this.continuousFlapTimer = nbt.method_10550("ContinuousFlapTimer");
        this.setVariant(Variant.byId(nbt.method_10550("Variant")));
        this.setHovering(nbt.method_10577("Hovering"));
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
        this.field_6011.method_12784(HOVERING, (Object)false);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
    }

    public boolean isHovering() {
        return (Boolean)this.field_6011.method_12789(HOVERING);
    }

    public void setHovering(boolean hovering) {
        this.field_6011.method_12778(HOVERING, (Object)hovering);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    private static class DragonflyMoveController
    extends class_1335 {
        private final DragonflyEntity dragonfly;

        public DragonflyMoveController(DragonflyEntity dragonfly) {
            super((class_1308)dragonfly);
            this.dragonfly = dragonfly;
        }

        public void method_6240() {
            if (!this.dragonfly.isFlying() && this.dragonfly.method_24828()) {
                this.field_6374 = class_1335.class_1336.field_6377;
                this.dragonfly.method_18799(class_243.field_1353);
                return;
            }
            if (this.dragonfly.isHovering()) {
                this.dragonfly.method_18799(this.dragonfly.method_18798().method_18805(0.6, 0.8, 0.6));
                this.field_6374 = class_1335.class_1336.field_6377;
                return;
            }
            if (this.dragonfly.landingFlag) {
                this.field_6374 = class_1335.class_1336.field_6377;
                return;
            }
        }
    }

    private static class DartingGoal
    extends class_1352 {
        private final DragonflyEntity dragonfly;
        private class_243 dartTarget;
        private class_243 dartDirection;
        private int hoverTimer;
        private int dartTimer;
        private int maxDartTime;
        private boolean isDarting;
        private int flyDuration;
        private int restDuration;
        private int currentTimer;
        private boolean shouldRest;
        private int landingTimer;
        private class_243 landingTarget;
        private float targetYaw;
        private boolean hasPickedDirection;
        private class_1657 nearestPlayer;
        private int fleeTimer;
        private static final int MIN_HOVER_TIME = 20;
        private static final int MAX_HOVER_TIME = 40;
        private static final int MIN_HOVER_TIME_SCARED = 2;
        private static final int MAX_HOVER_TIME_SCARED = 5;
        private static final int MIN_DART_TIME = 8;
        private static final int MAX_DART_TIME = 20;
        private static final int MIN_DART_TIME_SCARED = 5;
        private static final int MAX_DART_TIME_SCARED = 12;
        private static final double PLAYER_SCARE_RANGE = 6.0;
        private static final double MAX_HEIGHT_ABOVE_GROUND = 3.0;
        private static final double MIN_HEIGHT_ABOVE_GROUND = 1.5;
        private static final double DART_SPEED_INITIAL = 0.55;
        private static final double DART_SPEED_FINAL = 0.08;
        private static final double DART_SPEED_SCARED = 0.7;
        private static final double VELOCITY_STOP_THRESHOLD = 0.03;
        private static final float ROTATION_SPEED = 6.0f;
        private static final float ROTATION_SPEED_SCARED = 12.0f;

        public DartingGoal(DragonflyEntity dragonfly) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.dragonfly = dragonfly;
            this.flyDuration = 200 + dragonfly.method_6051().method_43048(160);
            this.restDuration = 30 + dragonfly.method_6051().method_43048(30);
            this.currentTimer = 0;
            this.shouldRest = false;
            this.landingTimer = 0;
            this.hoverTimer = 0;
            this.dartTimer = 0;
            this.maxDartTime = 0;
            this.isDarting = false;
            this.dartDirection = null;
            this.hasPickedDirection = false;
            this.nearestPlayer = null;
            this.fleeTimer = 0;
        }

        public boolean method_6264() {
            if (this.dragonfly.method_5782() || this.dragonfly.method_5765()) {
                return false;
            }
            if (!this.dragonfly.isFlying() && this.dragonfly.method_24828()) {
                class_238 searchBox = this.dragonfly.method_5829().method_1014(4.0);
                List nearbyPlayers = this.dragonfly.method_37908().method_8390(class_1657.class, searchBox, p -> true);
                boolean hasSurvivalPlayers = false;
                for (class_1657 player : nearbyPlayers) {
                    if (player.method_7337() || player.method_7325()) continue;
                    hasSurvivalPlayers = true;
                    break;
                }
                if (hasSurvivalPlayers) {
                    this.shouldRest = false;
                    this.currentTimer = 0;
                    this.landingTimer = 0;
                    return true;
                }
                if (this.shouldRest && this.currentTimer < this.restDuration) {
                    return false;
                }
                if (!this.shouldRest && this.dragonfly.method_6051().method_43048(100) != 0) {
                    return false;
                }
            }
            return true;
        }

        public void method_6269() {
            if (!this.dragonfly.landingFlag) {
                this.dragonfly.setFlying(true);
                this.dragonfly.setHovering(false);
                this.isDarting = true;
                boolean isScared = this.isPlayerNearby();
                this.dartTimer = isScared ? 5 + this.dragonfly.method_6051().method_43048(7) : 8 + this.dragonfly.method_6051().method_43048(12);
                this.maxDartTime = this.dartTimer;
                this.hasPickedDirection = false;
                float yaw = this.dragonfly.method_36454();
                float pitch = -10.0f + this.dragonfly.method_6051().method_43057() * 20.0f;
                this.dartDirection = this.getDirectionFromRotation(yaw, pitch);
                double distance = 4.0 + this.dragonfly.method_6051().method_43058() * 4.0;
                this.dartTarget = this.dragonfly.method_19538().method_1019(this.dartDirection.method_1021(distance));
                this.dartTarget = this.validateDartTarget(this.dartTarget);
            }
        }

        public void method_6270() {
            this.dragonfly.method_5942().method_6340();
            if (!this.dragonfly.landingFlag) {
                this.dragonfly.setHovering(false);
                this.isDarting = false;
                this.hoverTimer = 0;
                this.dartTimer = 0;
                this.maxDartTime = 0;
                this.landingTimer = 0;
                this.landingTarget = null;
                this.dartTarget = null;
                this.dartDirection = null;
                this.hasPickedDirection = false;
                this.nearestPlayer = null;
                this.fleeTimer = 0;
            }
            super.method_6270();
        }

        public void method_6268() {
            if (!this.dragonfly.isFlying() && this.dragonfly.method_24828()) {
                ++this.currentTimer;
                class_2338 bugPos = this.dragonfly.method_24515();
                class_2680 stateAtPos = this.dragonfly.method_37908().method_8320(bugPos);
                if (!stateAtPos.method_26215() && !stateAtPos.method_45474()) {
                    return;
                }
                this.dragonfly.method_18799(class_243.field_1353);
                return;
            }
            ++this.currentTimer;
            if (this.dragonfly.field_5976 && this.dragonfly.isFlying() && !this.dragonfly.landingFlag) {
                this.handleCollisionRecovery();
            }
            if (this.dragonfly.method_5799()) {
                this.dragonfly.method_18799(this.dragonfly.method_18798().method_1031(0.0, 0.15, 0.0));
                this.dragonfly.setFlying(true);
                this.dragonfly.method_5875(true);
            }
            this.enforceHeightLimits();
            this.nearestPlayer = this.findNearestPlayer();
            if (this.nearestPlayer != null && this.dragonfly.isFlying() && !this.dragonfly.landingFlag) {
                this.currentTimer = 0;
            }
            if (this.dragonfly.isFlying() && !this.dragonfly.landingFlag && this.currentTimer >= this.flyDuration) {
                if (!this.isOverWaterOrVoid()) {
                    this.shouldRest = true;
                    this.dragonfly.landingFlag = true;
                    this.dragonfly.setHovering(false);
                    this.isDarting = false;
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                    return;
                }
                this.currentTimer = this.flyDuration / 2;
            }
            if (this.dragonfly.isFlying() && !this.dragonfly.landingFlag) {
                boolean isScared;
                boolean bl = isScared = this.nearestPlayer != null;
                if (this.isDarting) {
                    --this.dartTimer;
                    this.dragonfly.setHovering(false);
                    if (this.dartDirection != null) {
                        class_243 avoidDirection;
                        if (this.dartTimer > this.maxDartTime / 2 && this.isObstacleAhead(this.dartDirection, 2.0) && (avoidDirection = this.findAvoidanceDirection(this.dartDirection)) != null) {
                            this.dartDirection = avoidDirection;
                            this.dartTarget = this.dragonfly.method_19538().method_1019(this.dartDirection.method_1021(4.0));
                            this.dartTarget = this.validateDartTarget(this.dartTarget);
                        }
                        double progress = 1.0 - (double)this.dartTimer / (double)this.maxDartTime;
                        double smoothProgress = progress * progress * (3.0 - 2.0 * progress);
                        double currentSpeed = isScared ? 0.7 : 0.55 + -0.47000000000000003 * smoothProgress;
                        class_243 dartVelocity = this.dartDirection.method_1021(currentSpeed);
                        this.dragonfly.method_18799(dartVelocity);
                        float targetYaw = (float)(class_3532.method_15349((double)dartVelocity.field_1350, (double)dartVelocity.field_1352) * 57.29577951308232) - 90.0f;
                        float rotSpeed = isScared ? 12.0f : 15.0f;
                        this.dragonfly.method_36456(class_3532.method_15388((float)this.dragonfly.method_36454(), (float)targetYaw, (float)rotSpeed));
                        if (this.dartTarget != null) {
                            double distanceToTarget = this.dragonfly.method_19538().method_1022(this.dartTarget);
                            if (distanceToTarget < 0.5 || this.dartTimer <= 0) {
                                this.isDarting = false;
                                this.dartDirection = null;
                                this.hasPickedDirection = false;
                                this.dragonfly.setHovering(true);
                                this.hoverTimer = isScared ? 2 + this.dragonfly.method_6051().method_43048(3) : 20 + this.dragonfly.method_6051().method_43048(20);
                                this.dartTarget = null;
                            }
                        } else if (this.dartTimer <= 0) {
                            this.isDarting = false;
                            this.dartDirection = null;
                            this.hasPickedDirection = false;
                            this.dragonfly.setHovering(true);
                            this.hoverTimer = isScared ? 2 + this.dragonfly.method_6051().method_43048(3) : 20 + this.dragonfly.method_6051().method_43048(20);
                        }
                    }
                } else {
                    --this.hoverTimer;
                    this.dragonfly.setHovering(true);
                    class_243 vel = this.dragonfly.method_18798();
                    this.dragonfly.method_18799(vel.method_18805(0.75, 0.88, 0.75));
                    double speed = Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350);
                    if (!this.hasPickedDirection && this.hoverTimer < (isScared ? 3 : 30)) {
                        this.targetYaw = isScared && this.nearestPlayer != null ? this.getFleeYaw(this.nearestPlayer) : this.dragonfly.method_6051().method_43057() * 360.0f;
                        this.hasPickedDirection = true;
                    }
                    if (this.hasPickedDirection) {
                        float currentYaw = this.dragonfly.method_36454();
                        float yawDifference = Math.abs(class_3532.method_15393((float)(this.targetYaw - currentYaw)));
                        float rotSpeed = isScared ? 12.0f : 6.0f;
                        this.dragonfly.method_36456(class_3532.method_15388((float)currentYaw, (float)this.targetYaw, (float)rotSpeed));
                        if (this.hoverTimer <= 0 && speed < 0.03 && yawDifference < 20.0f) {
                            class_243 avoidDirection;
                            this.isDarting = true;
                            this.dragonfly.setHovering(false);
                            this.dartTimer = isScared ? 5 + this.dragonfly.method_6051().method_43048(7) : 8 + this.dragonfly.method_6051().method_43048(12);
                            this.maxDartTime = this.dartTimer;
                            this.hasPickedDirection = false;
                            float pitch = -10.0f + this.dragonfly.method_6051().method_43057() * 20.0f;
                            this.dartDirection = this.getDirectionFromRotation(this.targetYaw, pitch);
                            if (this.isObstacleAhead(this.dartDirection, 3.0) && (avoidDirection = this.findAvoidanceDirection(this.dartDirection)) != null) {
                                float avoidYaw;
                                this.dartDirection = avoidDirection;
                                this.targetYaw = avoidYaw = (float)(class_3532.method_15349((double)this.dartDirection.field_1350, (double)this.dartDirection.field_1352) * 57.29577951308232) - 90.0f;
                            }
                            double distance = isScared ? 6.0 + this.dragonfly.method_6051().method_43058() * 4.0 : 4.0 + this.dragonfly.method_6051().method_43058() * 4.0;
                            this.dartTarget = this.dragonfly.method_19538().method_1019(this.dartDirection.method_1021(distance));
                            this.dartTarget = this.validateDartTarget(this.dartTarget);
                        }
                    }
                    if (isScared && !this.hasPickedDirection) {
                        this.targetYaw = this.getFleeYaw(this.nearestPlayer);
                        this.hasPickedDirection = true;
                        if (this.hoverTimer > 3) {
                            this.hoverTimer = 1 + this.dragonfly.method_6051().method_43048(3);
                        }
                    }
                }
            }
            if (this.dragonfly.landingFlag) {
                if (this.landingTarget == null) {
                    this.landingTarget = this.findLandingPos();
                }
                if (this.landingTarget != null) {
                    ++this.landingTimer;
                    if (this.landingTimer % 12 == 0) {
                        class_243 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                        this.dragonfly.method_5942().method_6337(nextPos.field_1352, nextPos.field_1351, nextPos.field_1350, (double)0.4f);
                    }
                    double distanceToLanding = this.dragonfly.method_23318() - this.landingTarget.field_1351;
                    if (this.dragonfly.method_24828() || distanceToLanding < 0.5 && this.landingTimer > 60) {
                        this.dragonfly.method_18799(class_243.field_1353);
                        this.dragonfly.setFlying(false);
                        this.dragonfly.setHovering(false);
                        this.dragonfly.method_5875(false);
                        this.dragonfly.landingFlag = false;
                        this.landingTarget = null;
                        this.landingTimer = 0;
                        this.isDarting = false;
                        this.hoverTimer = 0;
                        this.dartTimer = 0;
                        this.maxDartTime = 0;
                        this.dartDirection = null;
                        this.hasPickedDirection = false;
                        this.nearestPlayer = null;
                        this.fleeTimer = 0;
                        this.currentTimer = 0;
                        this.shouldRest = true;
                        this.flyDuration = 200 + this.dragonfly.method_6051().method_43048(160);
                        this.restDuration = 30 + this.dragonfly.method_6051().method_43048(30);
                    }
                } else {
                    this.dragonfly.landingFlag = false;
                    this.shouldRest = false;
                    this.landingTimer = 0;
                }
            }
        }

        public boolean method_6266() {
            if (this.dragonfly.landingFlag) {
                return !this.dragonfly.method_24828();
            }
            if (!this.dragonfly.isFlying() && this.dragonfly.method_24828() && this.shouldRest) {
                return this.currentTimer < this.restDuration;
            }
            return this.dragonfly.isFlying();
        }

        private class_1657 findNearestPlayer() {
            class_238 searchBox = this.dragonfly.method_5829().method_1014(6.0);
            List nearbyPlayers = this.dragonfly.method_37908().method_8390(class_1657.class, searchBox, p -> true);
            if (nearbyPlayers.isEmpty()) {
                return null;
            }
            class_1657 nearest = null;
            double nearestDist = Double.MAX_VALUE;
            for (class_1657 player : nearbyPlayers) {
                double dist;
                if (player.method_7337() || player.method_7325() || !((dist = this.dragonfly.method_5858((class_1297)player)) < nearestDist)) continue;
                nearestDist = dist;
                nearest = player;
            }
            return nearest;
        }

        private float getFleeYaw(class_1657 player) {
            class_243 toPlayer = player.method_19538().method_1020(this.dragonfly.method_19538());
            float yawToPlayer = (float)(class_3532.method_15349((double)toPlayer.field_1350, (double)toPlayer.field_1352) * 57.29577951308232) - 90.0f;
            return class_3532.method_15393((float)(yawToPlayer + 180.0f));
        }

        private class_243 getDirectionFromRotation(float yaw, float pitch) {
            float yawRad = yaw * ((float)Math.PI / 180);
            float pitchRad = pitch * ((float)Math.PI / 180);
            double xDir = -Math.sin(yawRad) * Math.cos(pitchRad);
            double yDir = -Math.sin(pitchRad);
            double zDir = Math.cos(yawRad) * Math.cos(pitchRad);
            return new class_243(xDir, yDir, zDir).method_1029();
        }

        private class_243 validateDartTarget(class_243 target) {
            class_243 currentPos = this.dragonfly.method_19538();
            class_243 targetGround = this.groundPosition(target);
            double targetHeightAboveGround = target.field_1351 - targetGround.field_1351;
            if (targetHeightAboveGround < 1.5) {
                target = new class_243(target.field_1352, targetGround.field_1351 + 1.5 + 0.3, target.field_1350);
            } else if (targetHeightAboveGround > 3.0) {
                target = new class_243(target.field_1352, targetGround.field_1351 + 3.0 - 0.3, target.field_1350);
            }
            class_3965 result = this.dragonfly.method_37908().method_17742(new class_3959(this.dragonfly.method_33571(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.dragonfly));
            if (result.method_17783() != class_239.class_240.field_1333) {
                class_243 hitPos = result.method_17784();
                class_243 direction = target.method_1020(currentPos).method_1029();
                target = hitPos.method_1020(direction.method_1021(1.5));
                class_243 safeGround = this.groundPosition(target);
                double heightAtHit = hitPos.field_1351 - safeGround.field_1351;
                target = heightAtHit < 2.0 ? new class_243(target.field_1352, safeGround.field_1351 + 3.0 - 0.3, target.field_1350) : new class_243(target.field_1352, safeGround.field_1351 + 1.5 + 0.3, target.field_1350);
                class_3965 recheck = this.dragonfly.method_37908().method_17742(new class_3959(this.dragonfly.method_33571(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.dragonfly));
                if (recheck.method_17783() != class_239.class_240.field_1333) {
                    class_243 shortDirection = direction.method_1021(2.0);
                    target = currentPos.method_1019(shortDirection);
                    class_243 shortGround = this.groundPosition(target);
                    target = new class_243(target.field_1352, shortGround.field_1351 + 1.5 + 0.5, target.field_1350);
                }
            }
            return target;
        }

        private void enforceHeightLimits() {
            class_243 currentPos = this.dragonfly.method_19538();
            class_243 groundPos = this.groundPosition(currentPos);
            double heightAboveGround = currentPos.field_1351 - groundPos.field_1351;
            if (heightAboveGround > 3.5) {
                this.dragonfly.method_18799(this.dragonfly.method_18798().method_1031(0.0, -0.12, 0.0));
                if (this.isDarting && this.dartTarget != null && this.dartTarget.field_1351 > currentPos.field_1351) {
                    this.isDarting = false;
                    this.dartDirection = null;
                    this.hasPickedDirection = false;
                    this.dragonfly.setHovering(true);
                    this.hoverTimer = 20;
                    this.dartTarget = null;
                }
            } else if (heightAboveGround < 1.3 && !this.dragonfly.landingFlag) {
                this.dragonfly.method_18799(this.dragonfly.method_18798().method_1031(0.0, 0.08, 0.0));
            }
        }

        private class_243 getDescentPosition(class_243 target, int timer) {
            if (target == null) {
                return this.dragonfly.method_19538();
            }
            double progress = Math.min((double)timer / 120.0, 1.0);
            double angle = (double)timer * 0.1 % (Math.PI * 2);
            double radius = 2.5 * (1.0 - progress * 0.6);
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double currentHeight = this.dragonfly.method_23318();
            double targetHeight = target.field_1351 + 0.5;
            double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.2;
            return new class_243(target.field_1352 + xOffset, Math.max(descentHeight, targetHeight), target.field_1350 + zOffset);
        }

        private class_243 findLandingPos() {
            class_243 currentPos = this.dragonfly.method_19538();
            class_243 ground = this.groundPosition(currentPos);
            class_2338 landingPos = class_2338.method_49638((class_2374)ground);
            while (landingPos.method_10264() < this.dragonfly.method_37908().method_31600() && !this.dragonfly.method_37908().method_8320(landingPos).method_26215() && !this.dragonfly.method_37908().method_8320(landingPos).method_45474()) {
                landingPos = landingPos.method_10084();
            }
            return new class_243((double)landingPos.method_10263() + 0.5, (double)landingPos.method_10264(), (double)landingPos.method_10260() + 0.5);
        }

        private boolean isPlayerNearby() {
            return this.nearestPlayer != null;
        }

        private void handleCollisionRecovery() {
            this.isDarting = false;
            this.dragonfly.setHovering(true);
            this.dartDirection = null;
            this.hasPickedDirection = false;
            this.dartTarget = null;
            class_243 currentPos = this.dragonfly.method_19538();
            class_243 downPos = currentPos.method_1031(0.0, -1.5, 0.0);
            class_3965 downCheck = this.dragonfly.method_37908().method_17742(new class_3959(currentPos, downPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.dragonfly));
            if (downCheck.method_17783() == class_239.class_240.field_1333) {
                this.dragonfly.method_18799(this.dragonfly.method_18798().method_18805(0.3, 0.3, 0.3).method_1031(0.0, -0.15, 0.0));
            } else {
                float newYaw = this.dragonfly.method_36454() + 90.0f + this.dragonfly.method_6051().method_43057() * 180.0f;
                this.dragonfly.method_36456(newYaw);
                this.dragonfly.method_18799(this.dragonfly.method_18798().method_18805(-0.5, 0.5, -0.5));
            }
            this.hoverTimer = 5 + this.dragonfly.method_6051().method_43048(10);
        }

        private boolean isObstacleAhead(class_243 direction, double distance) {
            class_243 startPos = this.dragonfly.method_33571();
            class_243 endPos = startPos.method_1019(direction.method_1021(distance));
            class_3965 result = this.dragonfly.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.dragonfly));
            return result.method_17783() != class_239.class_240.field_1333;
        }

        private class_243 findAvoidanceDirection(class_243 currentDirection) {
            float baseYaw = (float)(class_3532.method_15349((double)currentDirection.field_1350, (double)currentDirection.field_1352) * 57.29577951308232) - 90.0f;
            float[] yawOffsets = new float[]{-45.0f, 45.0f, -90.0f, 90.0f, -135.0f, 135.0f};
            float[] pitchOffsets = new float[]{-20.0f, 20.0f, -30.0f, 30.0f};
            for (float yawOffset : yawOffsets) {
                float[] fArray = pitchOffsets;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    float testYaw = baseYaw + yawOffset;
                    float pitchOffset = fArray[i];
                    float testPitch = pitchOffset;
                    class_243 testDirection = this.getDirectionFromRotation(testYaw, testPitch);
                    if (this.isObstacleAhead(testDirection, 3.0)) continue;
                    return testDirection;
                }
            }
            class_243 downDirection = this.getDirectionFromRotation(baseYaw, -45.0f);
            if (!this.isObstacleAhead(downDirection, 2.0)) {
                return downDirection;
            }
            return this.getDirectionFromRotation(baseYaw + 180.0f, 0.0f);
        }

        private class_243 groundPosition(class_243 airPosition) {
            class_2338.class_2339 ground = new class_2338.class_2339();
            ground.method_10102(airPosition.field_1352, airPosition.field_1351, airPosition.field_1350);
            boolean flag = false;
            while (ground.method_10264() < this.dragonfly.method_37908().method_31600() && !this.dragonfly.method_37908().method_8320((class_2338)ground).method_26216((class_1922)this.dragonfly.method_37908(), (class_2338)ground) && this.dragonfly.method_37908().method_8316((class_2338)ground).method_15769()) {
                ground.method_10100(0, 1, 0);
                flag = true;
            }
            ground.method_10100(0, -1, 0);
            while (ground.method_10264() > this.dragonfly.method_37908().method_31607() && !this.dragonfly.method_37908().method_8320((class_2338)ground).method_26216((class_1922)this.dragonfly.method_37908(), (class_2338)ground) && this.dragonfly.method_37908().method_8316((class_2338)ground).method_15769()) {
                ground.method_10100(0, -1, 0);
            }
            return class_243.method_24953((class_2382)(flag ? ground.method_10084() : ground.method_10074()));
        }

        private boolean isOverWaterOrVoid() {
            class_2338 position = this.dragonfly.method_24515();
            while (position.method_10264() > this.dragonfly.method_37908().method_31607() && this.dragonfly.method_37908().method_22347(position) && this.dragonfly.method_37908().method_8316(position).method_15769()) {
                position = position.method_10074();
            }
            return !this.dragonfly.method_37908().method_8316(position).method_15769() || this.dragonfly.method_37908().method_8320(position).method_27852(class_2246.field_10597) || position.method_10264() <= this.dragonfly.method_37908().method_31607();
        }
    }

    public static enum Variant implements class_3542
    {
        WHITETAIL(0, "whitetail"),
        DARNER(1, "darner"),
        SKIMMER(2, "skimmer"),
        DAMSEL(3, "damsel"),
        PETALTAIL(4, "petaltail");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }

    private static class DragonflyBirdNavigation
    extends class_1407 {
        private float distanceModifier;

        public DragonflyBirdNavigation(class_1308 mob, class_1937 world, float distanceModifier) {
            super(mob, world);
            this.distanceModifier = distanceModifier;
        }

        protected void method_6339() {
            boolean flag;
            class_243 vector3d = this.method_6347();
            this.field_6678.method_20(true);
            this.field_6678.method_15(true);
            class_2338 vector3i = this.field_6681.method_31032();
            double d0 = Math.abs(this.field_6684.method_23317() - ((double)vector3i.method_10263() + 0.5));
            double d1 = Math.abs(this.field_6684.method_23318() - (double)vector3i.method_10264());
            double d2 = Math.abs(this.field_6684.method_23321() - ((double)vector3i.method_10260() + 0.5));
            boolean bl = flag = d0 < (double)(this.field_6684.method_17681() * this.distanceModifier) && d2 < (double)(this.field_6684.method_17681() * this.distanceModifier) && d1 < 1.0;
            if (flag || this.shouldTargetNextNodeInDirection(vector3d)) {
                this.field_6681.method_44();
            }
            this.method_6346(vector3d);
        }

        private boolean shouldTargetNextNodeInDirection(class_243 currentPosition) {
            class_243 vector3d3;
            if (this.field_6681.method_39() + 1 >= this.field_6681.method_38()) {
                return false;
            }
            class_243 vector3d = class_243.method_24955((class_2382)this.field_6681.method_31032());
            if (!currentPosition.method_24802((class_2374)vector3d, 2.0)) {
                return false;
            }
            class_243 vector3d1 = class_243.method_24955((class_2382)this.field_6681.method_40(this.field_6681.method_39() + 1).method_22879());
            class_243 vector3d2 = vector3d1.method_1020(vector3d);
            return vector3d2.method_1026(vector3d3 = currentPosition.method_1020(vector3d)) > 0.0;
        }
    }
}

