/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GrasshopperEntity
extends class_1429
implements GeoEntity {
    private static final float BUOYANCY = 0.03f;
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(GrasshopperEntity.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private class_243 prevPosition = class_243.field_1353;
    private boolean isJumping = false;
    private int globalJumpCooldown = 0;

    public GrasshopperEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, 16.0f);
        this.method_5941(class_7.field_3, -1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new GrasshopperJumpGoal(this));
        this.field_6201.method_6277(2, (class_1352)new GrasshopperWalkGoal(this, 0.8));
        this.field_6201.method_6277(3, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canSpawn(class_1299<GrasshopperEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5799()) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, motion.field_1351 + (double)0.03f, motion.field_1350);
        }
        class_243 currentPos = this.method_19538();
        currentPos.method_1022(this.prevPosition);
        this.prevPosition = currentPos;
        if (this.globalJumpCooldown > 0) {
            --this.globalJumpCooldown;
        }
        if (this.method_24828() && this.isJumping) {
            this.isJumping = false;
        }
    }

    public void method_6007() {
        super.method_6007();
    }

    public void method_6091(class_243 travelVector) {
        super.method_6091(travelVector);
    }

    public void method_5784(class_1313 moverType, class_243 movement) {
        super.method_5784(moverType, movement);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1409 navigation = new class_1409((class_1308)this, world);
        navigation.method_6354(true);
        return navigation;
    }

    protected void method_6043() {
        class_243 velocity = this.method_18798();
        double jumpPower = this.method_6106();
        if (this.isJumping) {
            this.method_18800(velocity.field_1352, jumpPower, velocity.field_1350);
        } else {
            this.method_18800(velocity.field_1352, jumpPower * 1.5, velocity.field_1350);
        }
        this.field_6007 = true;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 otherParent) {
        return null;
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
    }

    private PlayState predicate(AnimationState<GrasshopperEntity> event) {
        boolean moving = this.isActuallyMoving();
        if (!this.method_24828()) {
            event.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (moving && this.method_24828()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().id);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variant.byId(nbt.method_10550("Variant")));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public boolean method_5810() {
        return true;
    }

    protected float method_6106() {
        return 0.42f * this.method_23313();
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    public void method_6100(boolean jumping) {
        this.isJumping = jumping;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public int getGlobalJumpCooldown() {
        return this.globalJumpCooldown;
    }

    public void setGlobalJumpCooldown(int ticks) {
        this.globalJumpCooldown = ticks;
    }

    public static class GrasshopperJumpGoal
    extends class_1352 {
        private final GrasshopperEntity grasshopper;
        private int jumpDuration = 0;
        private int pauseBetweenJumps = 0;
        private int jumpsInSequence = 0;
        private double targetX;
        private double targetZ;

        public GrasshopperJumpGoal(GrasshopperEntity grasshopper) {
            this.grasshopper = grasshopper;
        }

        public boolean method_6264() {
            if (!this.grasshopper.method_24828() || this.grasshopper.getGlobalJumpCooldown() > 0 || this.pauseBetweenJumps > 0) {
                return false;
            }
            return this.grasshopper.method_6051().method_43057() < 0.7f;
        }

        public boolean method_6266() {
            return !this.grasshopper.method_24828() || this.jumpDuration > 0 || this.pauseBetweenJumps > 0;
        }

        public void method_6269() {
            this.jumpsInSequence = 0;
            this.executeJump();
        }

        private boolean isWaterAt(double x, double z) {
            class_2338 targetPos = new class_2338((int)x, (int)this.grasshopper.method_23318(), (int)z);
            class_2680 state = this.grasshopper.method_37908().method_8320(targetPos);
            class_2680 stateBelow = this.grasshopper.method_37908().method_8320(targetPos.method_10074());
            return state.method_26227().method_15771() || stateBelow.method_26227().method_15771();
        }

        private void executeJump() {
            int attempts = 0;
            int maxAttempts = 8;
            double chosenX = 0.0;
            double chosenZ = 0.0;
            boolean foundGround = false;
            while (attempts < maxAttempts && !foundGround) {
                double angle;
                double distance = 2.0 + this.grasshopper.method_6051().method_43058() * 3.0;
                if (this.grasshopper.isActuallyMoving()) {
                    class_243 velocity = this.grasshopper.method_18798();
                    angle = Math.atan2(velocity.field_1350, velocity.field_1352);
                } else {
                    angle = this.grasshopper.method_6051().method_43058() * Math.PI * 2.0;
                }
                chosenX = this.grasshopper.method_23317() + Math.cos(angle) * distance;
                chosenZ = this.grasshopper.method_23321() + Math.sin(angle) * distance;
                if (!this.isWaterAt(chosenX, chosenZ)) {
                    foundGround = true;
                    continue;
                }
                ++attempts;
            }
            if (!foundGround) {
                this.method_6270();
                return;
            }
            this.jumpDuration = 15;
            ++this.jumpsInSequence;
            this.targetX = chosenX;
            this.targetZ = chosenZ;
            float yaw = (float)(Math.atan2(this.targetZ - this.grasshopper.method_23321(), this.targetX - this.grasshopper.method_23317()) * 180.0 / Math.PI) - 90.0f;
            this.grasshopper.method_36456(yaw);
            this.grasshopper.field_5982 = yaw;
            this.grasshopper.method_5847(yaw);
            this.grasshopper.field_6259 = yaw;
            double jumpHeight = 1.5 + this.grasshopper.method_6051().method_43058() * 1.5;
            double verticalVelocity = Math.sqrt(0.16 * jumpHeight);
            class_243 currentPos = this.grasshopper.method_19538();
            double dx = this.targetX - currentPos.field_1352;
            double dz = this.targetZ - currentPos.field_1350;
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            double horizontalVelocity = 0.35;
            double vx = dx / horizontalDistance * horizontalVelocity;
            double vz = dz / horizontalDistance * horizontalVelocity;
            this.grasshopper.method_18800(vx, verticalVelocity, vz);
            this.grasshopper.field_6007 = true;
            this.grasshopper.method_6100(true);
            this.grasshopper.method_5783(FaunifySounds.BOING, 2.5f, 1.5f);
        }

        public void method_6268() {
            if (this.pauseBetweenJumps > 0) {
                --this.pauseBetweenJumps;
                return;
            }
            if (this.jumpDuration > 0) {
                --this.jumpDuration;
                if (!this.grasshopper.method_24828()) {
                    double dz;
                    class_243 velocity = this.grasshopper.method_18798();
                    double dx = this.targetX - this.grasshopper.method_23317();
                    double horizontalDistance = Math.sqrt(dx * dx + (dz = this.targetZ - this.grasshopper.method_23321()) * dz);
                    if (horizontalDistance > 0.1) {
                        double speed = 0.04;
                        this.grasshopper.method_18800(velocity.field_1352 + dx / horizontalDistance * speed, velocity.field_1351, velocity.field_1350 + dz / horizontalDistance * speed);
                    }
                }
            } else if (this.grasshopper.method_24828() && this.jumpsInSequence < 3) {
                if (this.grasshopper.method_6051().method_43057() < 0.6f) {
                    this.pauseBetweenJumps = 10 + this.grasshopper.method_6051().method_43048(10);
                    this.grasshopper.method_6100(false);
                } else {
                    this.method_6270();
                }
            } else if (this.grasshopper.method_24828() && this.jumpsInSequence >= 3) {
                this.method_6270();
            }
            if (this.pauseBetweenJumps == 1 && this.grasshopper.method_24828()) {
                this.executeJump();
            }
        }

        public void method_6270() {
            this.jumpDuration = 0;
            this.pauseBetweenJumps = 0;
            this.jumpsInSequence = 0;
            this.grasshopper.method_6100(false);
            this.grasshopper.setGlobalJumpCooldown(60 + this.grasshopper.method_6051().method_43048(60));
        }
    }

    public static class GrasshopperWalkGoal
    extends class_1394 {
        private final GrasshopperEntity grasshopper;

        public GrasshopperWalkGoal(GrasshopperEntity grasshopper, double speedModifier) {
            super((class_1314)grasshopper, speedModifier);
            this.grasshopper = grasshopper;
        }

        public boolean method_6264() {
            return (this.grasshopper.method_5799() || this.grasshopper.getGlobalJumpCooldown() > 0) && super.method_6264();
        }

        public boolean method_6266() {
            return (this.grasshopper.method_5799() || this.grasshopper.getGlobalJumpCooldown() > 0) && super.method_6266();
        }
    }

    public static enum Variant implements class_3542
    {
        GREEN(0, "green"),
        BROWN(1, "brown"),
        GREENBROWN(2, "greenbrown");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

