/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.SilkwormEntity;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyDamageTypes;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7924;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HedgehogEntity
extends class_1321
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 5.0f;
    public static final float TAMED_HEALTH = 15.0f;
    private static final long DAMAGE_COOLDOWN = 20L;
    private static final Random RANDOM = new Random();
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(HedgehogEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(HedgehogEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CURLED = class_2945.method_12791(HedgehogEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean hurt;
    private int hurtCooldown = 100;
    private int quillDropTime = 0;
    private int quillDropInterval;
    private Map<class_1309, Long> lastDamageTime = new HashMap<class_1309, Long>();

    public HedgehogEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new HedgehogMoveControl(this);
        this.resetQuillDropInterval();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23721, 1.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.2, true));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.5, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8706}), false));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.5));
        this.field_6201.method_6277(6, (class_1352)new class_1350((class_1321)this, 1.3, 10.0f, 2.0f, false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new SleepGoal(200));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f){

            public boolean method_6264() {
                return !HedgehogEntity.this.method_6113() && super.method_6264();
            }

            public boolean method_6266() {
                return !HedgehogEntity.this.method_6113() && super.method_6266();
            }
        });
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this){

            public boolean method_6264() {
                return !HedgehogEntity.this.method_6113() && super.method_6264();
            }

            public boolean method_6266() {
                return !HedgehogEntity.this.method_6113() && super.method_6266();
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, SilkwormEntity.class, true));
    }

    public static boolean canSpawn(class_1299<HedgehogEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        class_5425 serverLevel;
        class_6880 biome;
        if (level instanceof class_5425 && (((class_1959)(biome = (serverLevel = (class_5425)level).method_23753(position)).comp_349()).method_8712() <= 0.2f || biome.method_40220(class_6908.field_41753))) {
            return false;
        }
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public void method_5773() {
        super.method_5773();
        if (this.hurt) {
            --this.hurtCooldown;
            if (this.hurtCooldown <= 0) {
                this.hurt = false;
                this.field_6011.method_12778(CURLED, (Object)false);
            }
        }
        ++this.quillDropTime;
        if (this.quillDropTime >= this.quillDropInterval) {
            this.quillDropTime = 0;
            this.resetQuillDropInterval();
            if (this.method_37908().method_8409().method_43057() < 1.0f) {
                this.method_5706((class_1935)FaunifyItems.QUILL);
            }
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(CURLED, (Object)false);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (this.method_37908().field_9236) {
            boolean flag = this.method_6171((class_1309)player) || this.method_6181() || item == FaunifyItems.INSECT_FLESH && !this.method_6181();
            return flag ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (this.method_6113()) {
                this.setSleeping(false);
                this.method_24346(true);
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            if (this.method_6481(itemstack) && this.method_6109()) {
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                this.method_5620(class_1296.method_41321((int)(-this.method_5618())), true);
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.field_5974.method_43059() * 0.02;
                        double d1 = this.field_5974.method_43059() * 0.02;
                        double d2 = this.field_5974.method_43059() * 0.02;
                        serverWorld.method_14199((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d0, d1, d2, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
            if (item == class_1802.field_8706 && this.method_6032() < this.method_6063()) {
                class_1937 i;
                this.method_6025(3.0f);
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                if ((i = this.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)i;
                    for (int i2 = 0; i2 < 5; ++i2) {
                        double offsetX = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetY = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetZ = (this.field_5974.method_43058() - 0.5) * 1.0;
                        serverWorld.method_14199((class_2394)FaunifyParticleTypes.HEALTH, this.method_23317() + offsetX, this.method_23318() + (double)this.method_5751() + offsetY, this.method_23321() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
            if (this.method_6481(itemstack) && this.method_5618() == 0 && !this.method_6479()) {
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                this.method_6480(player);
                return class_1269.field_5812;
            }
            class_1269 interactionresult = super.method_5992(player, hand);
            if ((!interactionresult.method_23665() || this.method_6109()) && this.method_6171((class_1309)player)) {
                this.method_24346(!this.method_24345());
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            return interactionresult;
        }
        if (item == FaunifyItems.INSECT_FLESH) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0) {
                this.method_6170(player);
                this.method_6173(true);
                this.method_24346(true);
                this.field_6189.method_6340();
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(15.0);
            this.method_6033(15.0f);
        }
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.method_6181()) {
            return false;
        }
        if (!(otherAnimal instanceof HedgehogEntity)) {
            return false;
        }
        HedgehogEntity otherHedgehog = (HedgehogEntity)otherAnimal;
        if (!otherHedgehog.method_6181()) {
            return false;
        }
        if (otherHedgehog.method_6172()) {
            return false;
        }
        return this.method_6479() && otherHedgehog.method_6479();
    }

    @Nullable
    public HedgehogEntity createChild(class_3218 serverWorld, class_1296 otherParent) {
        HedgehogEntity babyHedgehog = (HedgehogEntity)FaunifyEntities.HEDGEHOG.method_5883((class_1937)serverWorld);
        if (babyHedgehog != null && otherParent instanceof HedgehogEntity) {
            HedgehogEntity parent = (HedgehogEntity)otherParent;
            if (this.method_6181()) {
                babyHedgehog.method_6174(this.method_6139());
                babyHedgehog.method_6173(true);
            }
            Variant selectedVariant = this.field_5974.method_43056() ? this.getVariant() : parent.getVariant();
            babyHedgehog.setVariant(selectedVariant);
            babyHedgehog.method_5971();
        }
        return babyHedgehog;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8706;
    }

    public void method_5980(@Nullable class_1309 target) {
        if (this.method_6181() && this.method_35057() != null && target == this.method_35057()) {
            return;
        }
        super.method_5980(target);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (this.method_6113()) {
            this.setSleeping(false);
        }
        if (!this.method_37908().field_9236) {
            this.method_24346(false);
        }
        if (this.method_6172()) {
            this.method_6179(false);
        }
        if (result) {
            class_1309 pushingEntity;
            class_1297 class_12972;
            this.hurt = true;
            this.hurtCooldown = 100;
            if (!(source.method_5529() instanceof HedgehogEntity)) {
                this.field_6201.method_6277(1, (class_1352)new CurlUpGoal(this));
            }
            if ((class_12972 = source.method_5529()) instanceof class_1309 && (pushingEntity = (class_1309)class_12972) != this) {
                if (pushingEntity instanceof class_1657) {
                    class_1657 player = (class_1657)pushingEntity;
                    if (player.method_31549().field_7477) {
                        return result;
                    }
                }
                long currentTime = this.method_37908().method_8510();
                if (!this.lastDamageTime.containsKey(pushingEntity) || currentTime - this.lastDamageTime.get(pushingEntity) >= 20L) {
                    class_1282 prickDamage = new class_1282((class_6880)this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(FaunifyDamageTypes.HEDGEHOG_PRICK), (class_1297)this);
                    pushingEntity.method_6015(null);
                    pushingEntity.method_5643(prickDamage, 1.0f);
                    pushingEntity.method_6015(null);
                    this.method_5783(class_3417.field_14940, 0.5f, 1.0f);
                    this.lastDamageTime.put(pushingEntity, currentTime);
                }
            }
        }
        return result;
    }

    public void method_5697(class_1297 entity) {
        class_1309 pushingEntity;
        super.method_5697(entity);
        if (entity instanceof class_1309 && (pushingEntity = (class_1309)entity) != this) {
            class_1657 player;
            if (pushingEntity instanceof class_1657) {
                player = (class_1657)pushingEntity;
                if (player.method_31549().field_7477) {
                    return;
                }
            }
            if (pushingEntity instanceof HedgehogEntity) {
                return;
            }
            if (this.method_6181() && pushingEntity instanceof class_1657 && this.method_6171((class_1309)(player = (class_1657)pushingEntity))) {
                return;
            }
            long currentTime = this.method_37908().method_8510();
            if (!this.lastDamageTime.containsKey(pushingEntity) || currentTime - this.lastDamageTime.get(pushingEntity) >= 20L) {
                class_1282 prickDamage = new class_1282((class_6880)this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(FaunifyDamageTypes.HEDGEHOG_PRICK), (class_1297)this);
                pushingEntity.method_6015(null);
                pushingEntity.method_5643(prickDamage, 1.0f);
                pushingEntity.method_6015(null);
                this.method_5783(class_3417.field_14940, 0.5f, 1.0f);
                this.lastDamageTime.put(pushingEntity, currentTime);
            }
        }
    }

    protected class_3414 method_5994() {
        int soundIndex = this.field_5974.method_43048(3);
        switch (soundIndex) {
            case 0: {
                return FaunifySounds.HEDGEHOG_IDLE_1;
            }
            case 1: {
                return FaunifySounds.HEDGEHOG_IDLE_2;
            }
            case 2: {
                return FaunifySounds.HEDGEHOG_IDLE_3;
            }
        }
        return FaunifySounds.HEDGEHOG_IDLE_1;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.HEDGEHOG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<HedgehogEntity> event) {
        class_1309 target = this.method_5968();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.method_24828();
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
            target = null;
        }
        if (this.method_6113()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.method_6172()) {
            event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isCurledUp()) {
            event.getController().setAnimation(RawAnimation.begin().then("curl", Animation.LoopType.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        if (target instanceof SilkwormEntity) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10556("Sleeping", this.method_6113());
        tag.method_10556("Curled", this.isCurledUp());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        this.setSleeping(tag.method_10577("Sleeping"));
        this.setCurled(tag.method_10577("Curled"));
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean isCurledUp() {
        return (Boolean)this.field_6011.method_12789(CURLED);
    }

    public void setCurled(boolean curled) {
        this.field_6011.method_12778(CURLED, (Object)curled);
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    private boolean isFollowingPlayerWithFood() {
        class_1657 player = this.method_37908().method_18460((class_1297)this, 10.0);
        if (player != null) {
            class_1799 heldItem = player.method_6047();
            return heldItem.method_7909() == class_1802.field_8706;
        }
        return false;
    }

    private void resetQuillDropInterval() {
        this.quillDropInterval = 6000 + RANDOM.nextInt(6001);
    }

    static class HedgehogMoveControl
    extends class_1335 {
        private final HedgehogEntity hedgehog;

        public HedgehogMoveControl(HedgehogEntity hedgehogEntity) {
            super((class_1308)hedgehogEntity);
            this.hedgehog = hedgehogEntity;
        }

        public void method_6240() {
            if (!this.hedgehog.method_6113() && !this.hedgehog.isCurledUp()) {
                super.method_6240();
            }
        }
    }

    public class SleepGoal
    extends class_1352 {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = HedgehogEntity.this.field_5974.method_43048(SleepGoal.method_38848((int)countdownTime));
            this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
        }

        public boolean method_6264() {
            if (HedgehogEntity.this.method_5799()) {
                return false;
            }
            if (HedgehogEntity.this.method_6181() && !HedgehogEntity.this.method_6172()) {
                return false;
            }
            if (HedgehogEntity.this.isCurledUp()) {
                return false;
            }
            if (HedgehogEntity.this.field_6212 == 0.0f && HedgehogEntity.this.field_6227 == 0.0f && HedgehogEntity.this.field_6250 == 0.0f) {
                return this.canSleep() || HedgehogEntity.this.method_6113();
            }
            return false;
        }

        public boolean method_6266() {
            if (HedgehogEntity.this.method_5799()) {
                return false;
            }
            if (HedgehogEntity.this.isCurledUp()) {
                return false;
            }
            if (HedgehogEntity.this.method_6181() && !HedgehogEntity.this.method_6172()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return HedgehogEntity.this.method_37908().method_23886();
        }

        public void method_6270() {
            HedgehogEntity.this.setSleeping(false);
            this.countdown = HedgehogEntity.this.field_5974.method_43048(this.countdownTime);
        }

        public void method_6269() {
            HedgehogEntity.this.method_6100(false);
            HedgehogEntity.this.setSleeping(true);
            HedgehogEntity.this.method_5942().method_6340();
            HedgehogEntity.this.method_5962().method_6239(HedgehogEntity.this.method_23317(), HedgehogEntity.this.method_23318(), HedgehogEntity.this.method_23321(), 0.0);
        }
    }

    public static enum Variant implements class_3542
    {
        LIGHT(0, "light"),
        DARK(1, "dark"),
        ALBINO(2, "albino");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }

    public class CurlUpGoal
    extends class_1352 {
        private final HedgehogEntity hedgehog;
        private int timer;

        public CurlUpGoal(HedgehogEntity hedgehog) {
            this.hedgehog = hedgehog;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.hedgehog.hurt && !this.hedgehog.isCurledUp();
        }

        public void method_6269() {
            if (this.hedgehog.method_6113()) {
                return;
            }
            this.hedgehog.setCurled(true);
            this.timer = 0;
            this.hedgehog.method_5942().method_6340();
            this.hedgehog.method_5988().method_20248(this.hedgehog.method_23317(), this.hedgehog.method_23318(), this.hedgehog.method_23321());
        }

        public void method_6268() {
            ++this.timer;
            if (this.timer >= 40) {
                this.uncurlHedgehog();
                this.method_6270();
            }
        }

        private void uncurlHedgehog() {
            if (this.hedgehog.isCurledUp()) {
                this.hedgehog.setCurled(false);
            }
        }
    }
}

