/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LeafInsectEntity
extends class_1429
implements GeoEntity {
    private static final float BUOYANCY = 0.03f;
    private static final double CLIMB_SPEED = 0.1;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(LeafInsectEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(LeafInsectEntity.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private class_1408 groundNavigation;
    private class_243 prevPosition = class_243.field_1353;
    private double actualMovementSpeed = 0.0;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private class_2338 lastClimbPos;

    public LeafInsectEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, 16.0f);
        this.method_5941(class_7.field_3, -1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1394((class_1314)this, 0.7));
        this.field_6201.method_6277(2, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canSpawn(class_1299<LeafInsectEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public void method_5773() {
        class_2338 currentPos;
        boolean shouldClimb;
        super.method_5773();
        if (this.method_20232()) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, motion.field_1351 + (double)0.03f, motion.field_1350);
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.field_5976 && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.method_6101()) {
            currentPos = this.method_24515();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.method_37908().field_9236) {
                    this.field_6189.method_6340();
                    this.field_6201.method_19048().forEach(goal -> goal.method_6270());
                }
            } else if (this.field_5976) {
                boolean hasBlockAbove;
                class_243 deltaMovement = this.method_18798();
                boolean shouldApplyClimbMovement = true;
                if (this.method_24828() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.method_18800(deltaMovement.field_1352, 0.1, deltaMovement.field_1350);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.method_19538();
        this.actualMovementSpeed = currentPos.method_1022(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.method_37908().field_9236) {
            this.setClimbing(shouldClimb);
        }
    }

    public void method_6007() {
        super.method_6007();
    }

    public void method_6091(class_243 travelVector) {
        super.method_6091(travelVector);
    }

    public void method_5784(class_1313 moverType, class_243 movement) {
        super.method_5784(moverType, movement);
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1409 navigation = new class_1409((class_1308)this, level);
        navigation.method_6354(true);
        this.groundNavigation = navigation;
        return navigation;
    }

    public class_1296 method_5613(class_3218 serverLevel, class_1296 otherParent) {
        return null;
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
    }

    private PlayState predicate(AnimationState<LeafInsectEntity> event) {
        boolean climbing = this.method_6101();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.method_24828();
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10569("ClimbingTime", this.climbingTime);
        tag.method_10569("ClimbCooldown", this.climbCooldown);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        this.climbingTime = tag.method_10550("ClimbingTime");
        this.climbCooldown = tag.method_10550("ClimbCooldown");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_6101() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)flags);
    }

    protected float method_6106() {
        return 0.0f;
    }

    public void method_6100(boolean jumping) {
        super.method_6100(false);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        if (!state.method_26215() && !state.method_45474()) {
            return true;
        }
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        class_2338 east = pos.method_10078();
        class_2338 west = pos.method_10067();
        boolean bl = hasAdjacentAtCurrentLevel = !this.method_37908().method_8320(north).method_26215() && !this.method_37908().method_8320(north).method_45474() || !this.method_37908().method_8320(south).method_26215() && !this.method_37908().method_8320(south).method_45474() || !this.method_37908().method_8320(east).method_26215() && !this.method_37908().method_8320(east).method_45474() || !this.method_37908().method_8320(west).method_26215() && !this.method_37908().method_8320(west).method_45474();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        class_2338 posBelow = pos.method_10074();
        class_2338 northBelow = posBelow.method_10095();
        class_2338 southBelow = posBelow.method_10072();
        class_2338 eastBelow = posBelow.method_10078();
        class_2338 westBelow = posBelow.method_10067();
        return !this.method_37908().method_8320(northBelow).method_26215() && !this.method_37908().method_8320(northBelow).method_45474() || !this.method_37908().method_8320(southBelow).method_26215() && !this.method_37908().method_8320(southBelow).method_45474() || !this.method_37908().method_8320(eastBelow).method_26215() && !this.method_37908().method_8320(eastBelow).method_45474() || !this.method_37908().method_8320(westBelow).method_26215() && !this.method_37908().method_8320(westBelow).method_45474();
    }

    public static enum Variant implements class_3542
    {
        GREEN(0, "green"),
        YELLOW(1, "yellow"),
        BROWN(2, "brown");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

