/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifySounds;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LeafSheepEntity
extends class_1480
implements GeoEntity,
class_5761 {
    private static final double CLIMB_SPEED = 0.1;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private class_243 prevPosition = class_243.field_1353;
    private double actualMovementSpeed = 0.0;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private class_2338 lastClimbPos;
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(LeafSheepEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(LeafSheepEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public LeafSheepEntity(class_1299<? extends class_1480> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new WaterBoundRandomWanderGoal(this, 0.5));
    }

    public static boolean canLeafSheepSpawn(class_1299<LeafSheepEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (world instanceof class_5425) {
            class_5425 serverWorld = (class_5425)world;
            return world.method_8316(pos).method_15767(class_3486.field_15517) && pos.method_10264() >= serverWorld.method_8615() - 64 && pos.method_10264() <= serverWorld.method_8615();
        }
        return false;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public void method_5773() {
        class_2338 currentPos;
        boolean shouldClimb;
        super.method_5773();
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.field_5976 && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.method_6101()) {
            currentPos = this.method_24515();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.method_37908().field_9236) {
                    this.field_6189.method_6340();
                    this.field_6201.method_19048().forEach(goal -> goal.method_6270());
                }
            } else if (this.field_5976) {
                boolean hasBlockAbove;
                class_243 deltaMovement = this.method_18798();
                boolean shouldApplyClimbMovement = true;
                if (this.method_24828() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.method_18800(deltaMovement.field_1352, 0.1, deltaMovement.field_1350);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.method_19538();
        this.actualMovementSpeed = currentPos.method_1022(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.method_37908().field_9236) {
            this.setClimbing(shouldClimb);
        }
        if (!this.method_37908().field_9236) {
            this.setClimbing(this.field_5976 && this.method_5799() && this.isCollidingWithBlock());
        }
        if (!this.method_5799()) {
            this.method_5855(this.method_5669() - 1);
            if (this.method_5669() <= -20) {
                this.method_5855(0);
                this.method_5643(this.method_37908().method_48963().method_48824(), 2.0f);
            }
        } else {
            this.method_5855(300);
        }
    }

    public void method_6007() {
        super.method_6007();
    }

    public void method_6091(class_243 travelVector) {
        if (this.method_6101() && this.method_5799()) {
            class_243 reducedVector = travelVector.method_1021(0.4);
            super.method_6091(reducedVector);
        } else {
            super.method_6091(travelVector);
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1412((class_1308)this, world);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return class_5761.method_35169((class_1657)player, (class_1268)hand, (class_1309)this).orElse(super.method_5992(player, hand));
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.LEAFSHEEP_HURT;
    }

    protected class_3414 method_6002() {
        return FaunifySounds.LEAFSHEEP_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<LeafSheepEntity> event) {
        boolean climbing = this.method_6101();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.method_24828();
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10549("PosX", this.method_23317());
        tag.method_10549("PosY", this.method_23318());
        tag.method_10549("PosZ", this.method_23321());
        tag.method_10556("FromBucket", this.method_6453());
        tag.method_10569("ClimbingTime", this.climbingTime);
        tag.method_10569("ClimbCooldown", this.climbCooldown);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.climbingTime = tag.method_10550("ClimbingTime");
        this.climbCooldown = tag.method_10550("ClimbCooldown");
        if (tag.method_10545("PosX") && tag.method_10545("PosY") && tag.method_10545("PosZ")) {
            double posX = tag.method_10574("PosX");
            double posY = tag.method_10574("PosY");
            double posZ = tag.method_10574("PosZ");
            this.method_23327(posX, posY, posZ);
        }
        this.method_6454(tag.method_10577("FromBucket"));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(FROM_BUCKET, (Object)false);
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_6101() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)flags);
    }

    protected float method_6106() {
        return 0.0f;
    }

    public void method_6100(boolean jumping) {
        super.method_6100(false);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_6455(class_1799 bucket) {
        class_5761.method_35167((class_1308)this, (class_1799)bucket);
    }

    public void method_35170(class_2487 tag) {
        class_5761.method_35168((class_1308)this, (class_2487)tag);
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)FaunifyItems.LEAF_SHEEP_BUCKET);
    }

    public class_3414 method_35171() {
        return class_3417.field_14568;
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        if (!state.method_26215() && !state.method_45474()) {
            return true;
        }
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        class_2338 east = pos.method_10078();
        class_2338 west = pos.method_10067();
        boolean bl = hasAdjacentAtCurrentLevel = !this.method_37908().method_8320(north).method_26215() && !this.method_37908().method_8320(north).method_45474() || !this.method_37908().method_8320(south).method_26215() && !this.method_37908().method_8320(south).method_45474() || !this.method_37908().method_8320(east).method_26215() && !this.method_37908().method_8320(east).method_45474() || !this.method_37908().method_8320(west).method_26215() && !this.method_37908().method_8320(west).method_45474();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        class_2338 posBelow = pos.method_10074();
        class_2338 northBelow = posBelow.method_10095();
        class_2338 southBelow = posBelow.method_10072();
        class_2338 eastBelow = posBelow.method_10078();
        class_2338 westBelow = posBelow.method_10067();
        return !this.method_37908().method_8320(northBelow).method_26215() && !this.method_37908().method_8320(northBelow).method_45474() || !this.method_37908().method_8320(southBelow).method_26215() && !this.method_37908().method_8320(southBelow).method_45474() || !this.method_37908().method_8320(eastBelow).method_26215() && !this.method_37908().method_8320(eastBelow).method_45474() || !this.method_37908().method_8320(westBelow).method_26215() && !this.method_37908().method_8320(westBelow).method_45474();
    }

    static class WaterBoundRandomWanderGoal
    extends class_1352 {
        private final LeafSheepEntity leafSheep;
        private final double speedModifier;

        public WaterBoundRandomWanderGoal(LeafSheepEntity mob, double speedModifier) {
            this.leafSheep = mob;
            this.speedModifier = speedModifier;
        }

        public boolean method_6264() {
            if (!this.leafSheep.method_5942().method_6357()) {
                return false;
            }
            class_243 targetPos = this.getWaterPosition();
            if (targetPos == null) {
                return false;
            }
            this.leafSheep.method_5942().method_6337(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, this.speedModifier);
            return true;
        }

        public boolean method_6266() {
            return !this.leafSheep.method_5942().method_6357();
        }

        @Nullable
        protected class_243 getWaterPosition() {
            class_5819 random = this.leafSheep.method_6051();
            for (int i = 0; i < 10; ++i) {
                int xOffset = random.method_43048(21) - 10;
                int yOffset = random.method_43048(15) - 7;
                int zOffset = random.method_43048(21) - 10;
                class_2338 targetPos = this.leafSheep.method_24515().method_10069(xOffset, yOffset, zOffset);
                if (!this.leafSheep.method_37908().method_8316(targetPos).method_15767(class_3486.field_15517)) continue;
                return class_243.method_24953((class_2382)targetPos);
            }
            return null;
        }
    }
}

