/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.MillipedeBodyEntity;
import com.pepper.faunify.entity.MillipedeSegmentEntity;
import com.pepper.faunify.entity.MillipedeTailEntity;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MillipedeHeadEntity
extends class_1296
implements GeoEntity {
    private static final int BODY_SEGMENT_COUNT = 5;
    private static final float BUOYANCY = 0.03f;
    private static final class_2940<Optional<UUID>> CHILD_UUID = class_2945.method_12791(MillipedeHeadEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(MillipedeHeadEntity.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private class_1408 groundNavigation;
    private MillipedeSegmentEntity[] segments;
    private int segmentSpawnDelay = 0;
    public final float[] ringBuffer = new float[64];
    public int ringBufferIndex = -1;

    public MillipedeHeadEntity(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canMillipedeSpawn(class_1299<? extends MillipedeHeadEntity> entity, class_1936 level, class_3730 type, class_2338 pos, class_5819 random) {
        int seaLevel;
        int yLevel = pos.method_10264();
        if (yLevel >= (seaLevel = level.method_8615())) {
            return false;
        }
        int maxLightLevel = random.method_43048(8);
        int actualLightLevel = level.method_22339(pos);
        boolean lightCheck = actualLightLevel <= maxLightLevel;
        class_2338 blockBelow = pos.method_10074();
        boolean allowsSpawning = level.method_8320(blockBelow).method_26170((class_1922)level, blockBelow, entity);
        boolean canSpawn = lightCheck && allowsSpawning;
        return canSpawn;
    }

    public boolean method_5979(class_1936 worldIn, class_3730 spawnReasonIn) {
        return super.method_5979(worldIn, spawnReasonIn);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.segmentSpawnDelay = 5;
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        return super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void method_5773() {
        super.method_5773();
        this.field_5963 = false;
        this.field_6241 = this.field_6283 = class_3532.method_15363((float)this.method_36454(), (float)(this.field_6283 - 2.0f), (float)(this.field_6283 + 2.0f));
        if (this.method_5799()) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, motion.field_1351 + (double)0.03f, motion.field_1350);
        }
        if (this.ringBufferIndex < 0) {
            Arrays.fill(this.ringBuffer, this.field_6283);
        }
        if (this.updateRingBuffer() || this.ringBufferIndex < 0) {
            ++this.ringBufferIndex;
        }
        if (this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        this.ringBuffer[this.ringBufferIndex] = this.method_36454();
        if (!this.method_37908().field_9236) {
            if (this.shouldRebuildSegments()) {
                this.rebuildSegmentsArray();
            }
            if (this.segmentSpawnDelay > 0) {
                --this.segmentSpawnDelay;
                if (this.segmentSpawnDelay == 0) {
                    this.spawnSegments();
                }
            }
            if (this.field_6012 > 1 && this.segments != null) {
                class_243 prev = this.method_19538();
                float xRot = this.method_36455();
                float parentYRot = this.method_36454();
                float backOffset = 0.08f;
                for (int i = 0; i < this.segments.length; ++i) {
                    if (this.segments[i] == null || !this.segments[i].method_5805()) continue;
                    float reqRot = this.getYawForPart(i);
                    prev = this.segments[i].tickMultipartPosition(backOffset, prev, xRot, reqRot, true);
                    xRot = this.segments[i].method_36455();
                    parentYRot = this.segments[i].method_36454();
                    backOffset = this.segments[i].getBackOffset();
                }
            }
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        this.groundNavigation = new class_1409((class_1308)this, level);
        return this.groundNavigation;
    }

    public boolean method_5679(class_1282 source) {
        return source.method_49708(class_8111.field_42340) || super.method_5679(source);
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<MillipedeHeadEntity> event) {
        boolean isMoving;
        boolean bl = isMoving = this.method_18798().method_37268() > 1.0E-4;
        if (isMoving && this.method_24828()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        UUID childId = this.getChildId();
        if (childId != null) {
            tag.method_25927("ChildUUID", childId);
        }
        tag.method_10569("Variant", this.getVariant().id);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_25928("ChildUUID")) {
            UUID childUUID = tag.method_25926("ChildUUID");
            this.field_6011.method_12778(CHILD_UUID, Optional.of(childUUID));
        }
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CHILD_UUID, Optional.empty());
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (!this.method_37908().field_9236 && this.segments != null) {
            for (MillipedeSegmentEntity segment : this.segments) {
                if (segment == null) continue;
                segment.method_31472();
            }
        }
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_6087(class_1297 entity) {
        MillipedeSegmentEntity segment;
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfThisMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.method_6087(entity);
    }

    public void method_5697(class_1297 entity) {
        MillipedeSegmentEntity segment;
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfThisMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.method_5697(entity);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.field_6011.method_12789(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_6011.method_12778(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    private boolean updateRingBuffer() {
        return this.method_18798().method_1027() >= 0.005;
    }

    private float getYawForPart(int i) {
        return this.getRingBuffer(4 + i * 4, 1.0f);
    }

    public float getRingBuffer(int bufferOffset, float partialTicks) {
        if (this.method_29504()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int bufferIndex = this.ringBufferIndex - bufferOffset & 0x3F;
        int j = this.ringBufferIndex - bufferOffset - 1 & 0x3F;
        float d0 = this.ringBuffer[bufferIndex];
        float d1 = this.ringBuffer[j] - d0;
        return class_3532.method_15393((float)(d0 + d1 * partialTicks));
    }

    private void spawnSegments() {
        if (this.method_37908().field_9236 || this.segments != null) {
            return;
        }
        GeoEntity partParent = this;
        this.segments = new MillipedeSegmentEntity[6];
        class_243 prevPos = this.method_19538();
        float backOffset = 0.3f;
        float parentYRot = this.method_36454();
        float parentXRot = this.method_36455();
        for (int i = 0; i < 5; ++i) {
            MillipedeBodyEntity bodySegment = new MillipedeBodyEntity(FaunifyEntities.MILLIPEDE_BODY, this.method_37908());
            bodySegment.setParentSegment((class_1297)partParent);
            bodySegment.setBodyIndex(i);
            if (partParent == this) {
                bodySegment.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                this.setChildId(bodySegment.method_5667());
            }
            if (partParent instanceof MillipedeSegmentEntity) {
                MillipedeSegmentEntity prevSegment = (MillipedeSegmentEntity)partParent;
                prevSegment.setChildId(bodySegment.method_5667());
            }
            class_243 segmentPos = bodySegment.tickMultipartPosition(backOffset, prevPos, parentXRot, parentYRot, false);
            bodySegment.method_23327(segmentPos.field_1352, segmentPos.field_1351, segmentPos.field_1350);
            this.method_37908().method_8649((class_1297)bodySegment);
            this.segments[i] = bodySegment;
            partParent = bodySegment;
            backOffset = bodySegment.getBackOffset();
            prevPos = bodySegment.method_19538();
            parentYRot = bodySegment.method_36454();
            parentXRot = bodySegment.method_36455();
        }
        MillipedeTailEntity tailSegment = new MillipedeTailEntity(FaunifyEntities.MILLIPEDE_TAIL, this.method_37908());
        tailSegment.setParentSegment((class_1297)partParent);
        tailSegment.setBodyIndex(5);
        if (partParent instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity prevSegment = (MillipedeSegmentEntity)partParent;
            prevSegment.setChildId(tailSegment.method_5667());
        }
        class_243 tailPos = tailSegment.tickMultipartPosition(backOffset, prevPos, this.method_36455(), parentYRot, false);
        tailSegment.method_23327(tailPos.field_1352, tailPos.field_1351, tailPos.field_1350);
        this.method_37908().method_8649((class_1297)tailSegment);
        this.segments[5] = tailSegment;
    }

    private boolean shouldRebuildSegments() {
        if (this.segmentSpawnDelay > 0) {
            return false;
        }
        if (this.segments == null) {
            return this.getChildId() != null;
        }
        if (this.segments.length != 6) {
            return true;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] != null && this.segments[i].method_5805()) continue;
            return true;
        }
        return false;
    }

    private void rebuildSegmentsArray() {
        this.segments = new MillipedeSegmentEntity[6];
        UUID childId = this.getChildId();
        if (childId == null || this.method_37908().field_9236) {
            return;
        }
        class_1297 current = ((class_3218)this.method_37908()).method_14190(childId);
        if (current == null) {
            return;
        }
        int index = 0;
        while (current instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
            if (index >= this.segments.length) break;
            this.segments[index] = segment;
            segment.setParentSegment((class_1297)(index == 0 ? this : this.segments[index - 1]));
            ++index;
            UUID nextChildId = segment.getChildId();
            if (nextChildId != null && (current = ((class_3218)this.method_37908()).method_14190(nextChildId)) != null) continue;
            break;
        }
    }

    private boolean isPartOfThisMillipede(MillipedeSegmentEntity segment) {
        if (this.segments == null) {
            return false;
        }
        for (MillipedeSegmentEntity s : this.segments) {
            if (s != segment) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 otherParent) {
        return null;
    }

    public static enum Variant implements class_3542
    {
        GIANT(0, "giant"),
        TWISTEDCLAW(1, "twistedclaw"),
        NARCEUS(2, "narceus");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

