/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.MillipedeHeadEntity;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;

public abstract class MillipedeSegmentEntity
extends class_1314
implements GeoEntity {
    private static final float WATER_BUOYANCY = 0.03f;
    private static final class_2940<Optional<UUID>> PARENT_UUID = class_2945.method_12791(MillipedeSegmentEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> CHILD_UUID = class_2945.method_12791(MillipedeSegmentEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Float> BODY_XROT = class_2945.method_12791(MillipedeSegmentEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> BODY_INDEX = class_2945.method_12791(MillipedeSegmentEntity.class, (class_2941)class_2943.field_13327);
    private class_1297 parentSegment;
    private double prevHeight = 0.0;
    private float smoothedPitch = 0.0f;

    public MillipedeSegmentEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5960 = false;
    }

    public void method_5773() {
        super.method_5773();
        this.method_18799(class_243.field_1353);
        this.field_5963 = false;
        if (this.method_5799()) {
            class_243 motion = this.method_18798();
            if (motion.field_1351 <= 0.05) {
                this.method_18800(motion.field_1352, motion.field_1351 + (double)0.03f, motion.field_1350);
            }
        }
        if (this.field_6012 > 1) {
            class_1297 parent = this.getParentSegment();
            if (parent != null && !this.method_37908().field_9236) {
                if (parent instanceof class_1309) {
                    class_1309 parentEntity = (class_1309)parent;
                    if (parentEntity.field_6235 > 0 || parentEntity.field_6213 > 0) {
                        this.field_6235 = parentEntity.field_6235;
                        this.field_6213 = parentEntity.field_6213;
                    }
                }
                if (parent.method_31481()) {
                    this.method_31472();
                }
            } else if (!this.method_37908().field_9236 && this.field_6012 > 20) {
                this.method_31472();
            }
        }
    }

    public boolean method_5679(class_1282 source) {
        return source.method_49708(class_8111.field_42340) || source.method_48789(class_8103.field_42250) || source.method_48789(class_8103.field_42241) || super.method_5679(source);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 parent = this.getParentSegment();
        if (parent instanceof class_1308) {
            class_1308 mob = (class_1308)parent;
            return mob.method_5643(source, amount);
        }
        return false;
    }

    public void method_5652(class_2487 tag) {
        UUID childId;
        super.method_5652(tag);
        UUID parentId = ((Optional)this.field_6011.method_12789(PARENT_UUID)).orElse(null);
        if (parentId != null) {
            tag.method_25927("ParentUUID", parentId);
        }
        if ((childId = (UUID)((Optional)this.field_6011.method_12789(CHILD_UUID)).orElse(null)) != null) {
            tag.method_25927("ChildUUID", childId);
        }
        tag.method_10569("BodyIndex", this.getBodyIndex());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_25928("ParentUUID")) {
            this.field_6011.method_12778(PARENT_UUID, Optional.of(tag.method_25926("ParentUUID")));
        }
        if (tag.method_25928("ChildUUID")) {
            this.field_6011.method_12778(CHILD_UUID, Optional.of(tag.method_25926("ChildUUID")));
        }
        this.setBodyIndex(tag.method_10550("BodyIndex"));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PARENT_UUID, Optional.empty());
        this.field_6011.method_12784(CHILD_UUID, Optional.empty());
        this.field_6011.method_12784(BODY_XROT, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(BODY_INDEX, (Object)0);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public float method_36455() {
        return ((Float)this.field_6011.method_12789(BODY_XROT)).floatValue();
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_30949(class_1297 entity) {
        return false;
    }

    protected void method_6087(class_1297 entity) {
        MillipedeSegmentEntity segment;
        MillipedeHeadEntity head;
        if (entity instanceof MillipedeHeadEntity && this.isPartOfMillipede(head = (MillipedeHeadEntity)entity)) {
            return;
        }
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfSameMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.method_6087(entity);
    }

    public void method_5697(class_1297 entity) {
        MillipedeSegmentEntity segment;
        MillipedeHeadEntity head;
        if (entity instanceof MillipedeHeadEntity && this.isPartOfMillipede(head = (MillipedeHeadEntity)entity)) {
            return;
        }
        if (entity instanceof MillipedeSegmentEntity && this.isPartOfSameMillipede(segment = (MillipedeSegmentEntity)entity)) {
            return;
        }
        super.method_5697(entity);
    }

    public void setParentSegment(class_1297 parent) {
        this.parentSegment = parent;
        if (parent != null) {
            this.field_6011.method_12778(PARENT_UUID, Optional.ofNullable(parent.method_5667()));
        }
    }

    @Nullable
    public class_1297 getParentSegment() {
        if (this.parentSegment != null && this.parentSegment.method_5805()) {
            return this.parentSegment;
        }
        UUID parentId = ((Optional)this.field_6011.method_12789(PARENT_UUID)).orElse(null);
        if (parentId != null) {
            if (this.method_37908().field_9236) {
                List entities = this.method_37908().method_8333(null, this.method_5829().method_1014(50.0), entity -> entity.method_5667().equals(parentId));
                Iterator iterator = entities.iterator();
                if (iterator.hasNext()) {
                    class_1297 entity2;
                    this.parentSegment = entity2 = (class_1297)iterator.next();
                    return entity2;
                }
            } else {
                class_1297 parent = ((class_3218)this.method_37908()).method_14190(parentId);
                if (parent != null && parent.method_5805()) {
                    this.parentSegment = parent;
                    return parent;
                }
            }
        }
        return null;
    }

    public MillipedeHeadEntity.Variant getMillipedeVariant() {
        MillipedeHeadEntity head = this.getMillipedeHead();
        if (head != null) {
            return head.getVariant();
        }
        return MillipedeHeadEntity.Variant.GIANT;
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_6011.method_12778(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.field_6011.method_12789(CHILD_UUID)).orElse(null);
    }

    public class_1297 getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.method_37908().field_9236) {
            return ((class_3218)this.method_37908()).method_14190(id);
        }
        return null;
    }

    public void setBodyIndex(int index) {
        this.field_6011.method_12778(BODY_INDEX, (Object)index);
    }

    public int getBodyIndex() {
        return (Integer)this.field_6011.method_12789(BODY_INDEX);
    }

    public class_243 tickMultipartPosition(float parentOffset, class_243 parentPosition, float parentXRot, float parentYRot, boolean doHeight) {
        boolean parentInWater = false;
        class_1297 parent = this.getParentSegment();
        if (parent instanceof class_1309) {
            class_1309 livingParent = (class_1309)parent;
            parentInWater = livingParent.method_5799();
        }
        float yDif = doHeight && !parentInWater ? 1.0f - 0.95f * (float)Math.min(Math.abs(parentPosition.field_1351 - this.method_23318()), 1.0) : 1.0f;
        float segmentSpacing = (this.getBackOffset() + 0.5f * this.method_17681()) * this.getScale();
        class_243 parentButt = parentPosition.method_1019(this.calcOffsetVec(yDif * parentOffset * this.getScale(), 0.0f, parentYRot));
        class_243 desiredPos = parentButt.method_1019(this.calcOffsetVec(yDif * segmentSpacing, 0.0f, parentYRot));
        double d0 = parentButt.field_1352 - desiredPos.field_1352;
        double d2 = parentButt.field_1350 - desiredPos.field_1350;
        double horizontalDist = Math.sqrt(d0 * d0 + d2 * d2);
        class_243 finalPos = new class_243(desiredPos.field_1352, desiredPos.field_1351, desiredPos.field_1350);
        if (doHeight && !this.method_5799() && !parentInWater) {
            double heightCheck;
            double groundCheck;
            double checkY = finalPos.field_1351;
            if (this.isOpaqueBlockAt(finalPos.field_1352, checkY + 0.1, finalPos.field_1350)) {
                for (groundCheck = 0.0; groundCheck < 1.0 && this.isOpaqueBlockAt(finalPos.field_1352, checkY + groundCheck, finalPos.field_1350); groundCheck += 0.1) {
                }
            } else {
                double airGap;
                for (airGap = 0.0; airGap < 1.0 && !this.isOpaqueBlockAt(finalPos.field_1352, checkY - airGap - 0.1, finalPos.field_1350); airGap += 0.1) {
                }
                if (airGap > 0.5) {
                    groundCheck = -Math.min(airGap - 0.3, 0.3);
                }
            }
            double segmentHeight = this.method_17682();
            boolean hasVerticalClearance = true;
            for (heightCheck = 0.2; heightCheck < segmentHeight; heightCheck += 0.2) {
                if (!this.isOpaqueBlockAt(finalPos.field_1352, checkY + groundCheck + heightCheck, finalPos.field_1350)) continue;
                hasVerticalClearance = false;
                break;
            }
            block3: while (!hasVerticalClearance && groundCheck > -1.0) {
                groundCheck -= 0.1;
                hasVerticalClearance = true;
                for (heightCheck = 0.2; heightCheck < segmentHeight; heightCheck += 0.2) {
                    if (!this.isOpaqueBlockAt(finalPos.field_1352, checkY + groundCheck + heightCheck, finalPos.field_1350)) continue;
                    hasVerticalClearance = false;
                    continue block3;
                }
            }
            double heightDiff = groundCheck - this.prevHeight;
            this.prevHeight = Math.abs(heightDiff) > 0.2 ? (this.prevHeight += class_3532.method_15350((double)heightDiff, (double)-0.05, (double)0.05)) : (this.prevHeight += heightDiff * 0.5);
            if (Math.abs(groundCheck) < 0.1 && Math.abs(this.prevHeight) > 0.05) {
                this.prevHeight *= 0.9;
            }
            double clampedHeight = class_3532.method_15350((double)this.prevHeight, (double)-0.3f, (double)0.3f);
            finalPos = new class_243(finalPos.field_1352, finalPos.field_1351 + clampedHeight, finalPos.field_1350);
        }
        double actualVerticalDist = parentButt.field_1351 - finalPos.field_1351;
        float rawAngle = this.method_5799() || parentInWater ? class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)actualVerticalDist, (double)horizontalDist) * 57.29577951308232)))) * 0.3f : class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)actualVerticalDist, (double)horizontalDist) * 57.29577951308232))));
        float parentPitch = parentXRot;
        class_1297 class_12972 = this.getParentSegment();
        if (class_12972 instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity parentSeg = (MillipedeSegmentEntity)class_12972;
            parentPitch = parentSeg.getSmoothedPitch();
        }
        float interpolationFactor = this.method_5799() || parentInWater ? 0.5f : 0.3f;
        float targetPitch = class_3532.method_16439((float)interpolationFactor, (float)rawAngle, (float)parentPitch);
        float maxPitchChange = 50.0f;
        this.smoothedPitch = this.limitAngle(this.smoothedPitch, targetPitch, maxPitchChange);
        float yaw = (float)(class_3532.method_15349((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        this.method_36457(this.smoothedPitch);
        this.field_6011.method_12778(BODY_XROT, (Object)Float.valueOf(this.smoothedPitch));
        this.method_36456(yaw);
        this.field_6241 = yaw;
        this.method_5808(finalPos.field_1352, finalPos.field_1351, finalPos.field_1350, yaw, this.smoothedPitch);
        class_243 returnPos = new class_243(finalPos.field_1352, finalPos.field_1351, finalPos.field_1350);
        return returnPos;
    }

    public float getSmoothedPitch() {
        return this.smoothedPitch;
    }

    public float getScale() {
        return 1.0f;
    }

    public float getBackOffset() {
        return 0.115f;
    }

    public double getLowPartHeight(double x, double yIn, double z) {
        double checkAt;
        if (this.isFluidAt(x, yIn, z)) {
            return 0.0;
        }
        for (checkAt = 0.0; checkAt > -0.5 && !this.isOpaqueBlockAt(x, yIn + checkAt, z); checkAt -= 0.1) {
        }
        return checkAt;
    }

    public double getHighPartHeight(double x, double yIn, double z) {
        double checkAt;
        if (this.isFluidAt(x, yIn, z)) {
            return 0.0;
        }
        for (checkAt = 0.0; checkAt <= 0.5 && this.isOpaqueBlockAt(x, yIn + checkAt, z); checkAt += 0.1) {
        }
        return checkAt;
    }

    protected class_243 calcOffsetVec(float distance, float xRot, float yRot) {
        float f = class_3532.method_15362((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = class_3532.method_15374((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = class_3532.method_15362((float)(-xRot * ((float)Math.PI / 180)));
        float f3 = class_3532.method_15374((float)(-xRot * ((float)Math.PI / 180)));
        return new class_243((double)(f1 * f2 * distance), (double)(f3 * distance), (double)(f * f2 * distance));
    }

    protected float limitAngle(float sourceAngle, float targetAngle, float maximumChange) {
        float f = class_3532.method_15393((float)(targetAngle - sourceAngle));
        if (f > maximumChange) {
            f = maximumChange;
        }
        if (f < -maximumChange) {
            f = -maximumChange;
        }
        return sourceAngle + f;
    }

    public boolean isFluidAt(double x, double y, double z) {
        if (this.field_5960) {
            return false;
        }
        return !this.method_37908().method_8316(class_2338.method_49637((double)x, (double)y, (double)z)).method_15769();
    }

    public boolean isOpaqueBlockAt(double x, double y, double z) {
        if (this.field_5960) {
            return false;
        }
        class_2338 blockpos = class_2338.method_49637((double)x, (double)y, (double)z);
        class_2680 blockState = this.method_37908().method_8320(blockpos);
        if (blockState.method_26215()) {
            return false;
        }
        return !blockState.method_26220((class_1922)this.method_37908(), blockpos).method_1110();
    }

    private boolean isPartOfMillipede(MillipedeHeadEntity head) {
        class_1297 current = this.getParentSegment();
        while (current != null) {
            if (current == head) {
                return true;
            }
            if (current instanceof MillipedeSegmentEntity) {
                MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
                current = segment.getParentSegment();
                continue;
            }
            if (!(current instanceof MillipedeHeadEntity)) break;
            return current == head;
        }
        return false;
    }

    private boolean isPartOfSameMillipede(MillipedeSegmentEntity otherSegment) {
        MillipedeHeadEntity myHead = this.getMillipedeHead();
        MillipedeHeadEntity otherHead = otherSegment.getMillipedeHead();
        return myHead != null && myHead == otherHead;
    }

    private MillipedeHeadEntity getMillipedeHead() {
        class_1297 current = this.getParentSegment();
        while (current != null) {
            if (current instanceof MillipedeHeadEntity) {
                MillipedeHeadEntity head = (MillipedeHeadEntity)current;
                return head;
            }
            if (!(current instanceof MillipedeSegmentEntity)) break;
            MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
            current = segment.getParentSegment();
        }
        return null;
    }
}

