/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MouseEntity
extends class_1321
implements GeoEntity {
    private static final int STEAL_RADIUS = 10;
    private static final int COOLDOWN_TICKS = 100;
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(MouseEntity.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private long lastStealTime = 0L;
    private class_1799 stolenSeed = class_1799.field_8037;
    private boolean isRunning = false;

    public MouseEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new StealSeedGoal(this));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.5));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.35, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_16998}), false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
    }

    public static boolean canSpawn(class_1299<MouseEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant(Variant.getCommonSpawnVariant(world.method_8409()));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public void method_5773() {
        super.method_5773();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (item == class_1802.field_16998) {
            if (this.method_6109()) {
                if (!this.method_37908().field_9236) {
                    if (!player.method_31549().field_7477) {
                        itemstack.method_7934(1);
                    }
                    this.method_5620(MouseEntity.method_41321((int)(-this.method_5618())), true);
                    class_1937 class_19372 = this.method_37908();
                    if (class_19372 instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)class_19372;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.field_5974.method_43059() * 0.02;
                            double d1 = this.field_5974.method_43059() * 0.02;
                            double d2 = this.field_5974.method_43059() * 0.02;
                            serverLevel.method_14199((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d0, d1, d2, 0.0);
                        }
                    }
                }
                return class_1269.field_5812;
            }
            if (!this.method_6479() && this.method_5618() == 0) {
                if (!this.method_37908().field_9236) {
                    this.method_6480(player);
                    if (!player.method_31549().field_7477) {
                        itemstack.method_7934(1);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_16998;
    }

    public MouseEntity createChild(class_3218 serverLevel, class_1296 otherParent) {
        MouseEntity babyMouse = (MouseEntity)FaunifyEntities.MOUSE.method_5883((class_1937)serverLevel);
        if (babyMouse != null && otherParent instanceof MouseEntity) {
            MouseEntity parent = (MouseEntity)otherParent;
            class_5819 random = this.method_6051();
            Variant selectedVariant = random.method_43057() < 0.05f ? Variant.getRareBreedVariant(random) : (random.method_43056() ? this.getVariant() : parent.getVariant());
            babyMouse.setVariant(selectedVariant);
        }
        return babyMouse;
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        if (!this.stolenSeed.method_7960()) {
            this.method_5775(this.stolenSeed);
        }
    }

    protected class_3414 method_5994() {
        int soundIndex = this.field_5974.method_43048(2);
        switch (soundIndex) {
            case 0: {
                return FaunifySounds.MOUSE_IDLE_1;
            }
            case 1: {
                return FaunifySounds.MOUSE_IDLE_2;
            }
        }
        return FaunifySounds.MOUSE_IDLE_1;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.MOUSE_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<MouseEntity> event) {
        class_1309 target = this.method_5968();
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
            target = null;
        }
        if (this.isRunning) {
            event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10549("PosX", this.method_23317());
        tag.method_10549("PosY", this.method_23318());
        tag.method_10549("PosZ", this.method_23321());
        if (!this.stolenSeed.method_7960()) {
            class_2487 seedTag = new class_2487();
            this.stolenSeed.method_7953(seedTag);
            tag.method_10566("StolenSeed", (class_2520)seedTag);
        }
        tag.method_10544("LastStealTime", this.lastStealTime);
        tag.method_10556("IsRunning", this.isRunning);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        if (tag.method_10545("PosX") && tag.method_10545("PosY") && tag.method_10545("PosZ")) {
            double posX = tag.method_10574("PosX");
            double posY = tag.method_10574("PosY");
            double posZ = tag.method_10574("PosZ");
            this.method_23327(posX, posY, posZ);
        }
        if (tag.method_10545("StolenSeed")) {
            this.stolenSeed = class_1799.method_7915((class_2487)tag.method_10562("StolenSeed"));
        }
        this.lastStealTime = tag.method_10537("LastStealTime");
        this.isRunning = tag.method_10577("IsRunning");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean canSteal() {
        return this.method_37908().method_8510() - this.lastStealTime > 100L;
    }

    public void setLastStealTime() {
        this.lastStealTime = this.method_37908().method_8510();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private boolean isFollowingPlayerWithFood() {
        class_1657 player = this.method_37908().method_18460((class_1297)this, 10.0);
        if (player != null) {
            class_1799 heldItem = player.method_6047();
            return MouseEntity.isSeed(heldItem);
        }
        return false;
    }

    private static boolean isSeed(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8317 || stack.method_7909() == class_1802.field_8309 || stack.method_7909() == class_1802.field_8706 || stack.method_7909() == class_1802.field_8188;
    }

    private static class StealSeedGoal
    extends class_1352 {
        private final MouseEntity mouse;
        private class_1657 targetPlayer;

        public StealSeedGoal(MouseEntity mouse) {
            this.mouse = mouse;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (!this.mouse.canSteal()) {
                return false;
            }
            List players = this.mouse.method_37908().method_8390(class_1657.class, this.mouse.method_5829().method_1014(10.0), player -> true);
            for (class_1657 player2 : players) {
                if (!this.hasSeeds(player2)) continue;
                this.targetPlayer = player2;
                return true;
            }
            return false;
        }

        public void method_6269() {
            if (this.targetPlayer != null) {
                this.mouse.method_5942().method_6335((class_1297)this.targetPlayer, 0.75);
            }
        }

        public void method_6268() {
            if (this.targetPlayer == null || !this.targetPlayer.method_5805()) {
                return;
            }
            double distance = this.mouse.method_5739((class_1297)this.targetPlayer);
            if (distance > 1.5) {
                this.mouse.method_5942().method_6335((class_1297)this.targetPlayer, 0.75);
            } else {
                this.stealSeed(this.targetPlayer);
                this.mouse.setLastStealTime();
                this.fleeFrom(this.targetPlayer);
            }
        }

        private boolean hasSeeds(class_1657 player) {
            for (class_1799 stack : player.method_31548().field_7547) {
                if (!MouseEntity.isSeed(stack)) continue;
                return true;
            }
            return false;
        }

        private void stealSeed(class_1657 player) {
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                class_1799 stolen;
                class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
                if (!MouseEntity.isSeed(stack)) continue;
                this.mouse.stolenSeed = stolen = stack.method_7971(1);
                this.mouse.method_5783(FaunifySounds.MOUSE_STEAL, 1.0f, 1.0f);
                break;
            }
        }

        private void fleeFrom(class_1657 player) {
            this.mouse.isRunning = true;
            class_243 fleeDirection = this.mouse.method_19538().method_1020(player.method_19538()).method_1029().method_1021(20.0);
            this.mouse.method_5942().method_6337(this.mouse.method_23317() + fleeDirection.field_1352, this.mouse.method_23318(), this.mouse.method_23321() + fleeDirection.field_1350, 2.0);
            if (this.mouse.method_5739((class_1297)player) > 25.0f) {
                this.mouse.isRunning = false;
            }
        }
    }

    public static enum Variant implements class_3542
    {
        FIELD(0, "field", true),
        GREY(1, "grey", true),
        WOOD(2, "wood", true),
        WHITE(3, "white", true),
        BLACK(4, "black", true),
        BROWNBELLY(5, "brownbelly", true),
        ALBINO(6, "albino", false);

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;
        private final boolean common;

        private Variant(int id, String name, boolean common) {
            this.id = id;
            this.name = name;
            this.common = common;
        }

        public int getId() {
            return this.id;
        }

        public String method_15434() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public static Variant getCommonSpawnVariant(class_5819 random) {
            return Variant.getSpawnVariant(random, true);
        }

        public static Variant getRareBreedVariant(class_5819 random) {
            return Variant.getSpawnVariant(random, false);
        }

        private static Variant getSpawnVariant(class_5819 random, boolean isCommon) {
            Variant[] validVariants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.common == isCommon).toArray(Variant[]::new);
            return (Variant)((Object)class_156.method_27173((Object[])validVariants, (class_5819)random));
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

