/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_3962;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RolyPolyEntity
extends class_1296
implements GeoEntity {
    private static final float BUOYANCY = 0.02f;
    private static final double CLIMB_SPEED = 0.06;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final long DAMAGE_COOLDOWN = 20L;
    private static final int BLOCK_PROCESS_INTERVAL = 100;
    private static final int CROP_GROWTH_INTERVAL = 400;
    private static final int CROP_RADIUS = 2;
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(RolyPolyEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(RolyPolyEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CURLED = class_2945.method_12791(RolyPolyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FLIPPED = class_2945.method_12791(RolyPolyEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private class_1408 groundNavigation;
    private class_243 prevPosition = class_243.field_1353;
    private double actualMovementSpeed = 0.0;
    private boolean hurt;
    private int hurtCooldown = 100;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private class_2338 lastClimbPos;
    private Map<class_1309, Long> lastDamageTime = new HashMap<class_1309, Long>();
    private boolean hasFlipped = false;
    private int blockProcessTimer = 0;
    private int cropGrowthTimer = 0;

    public RolyPolyEntity(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new RolyPolyMoveControl(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 0.125).method_26868(class_5134.field_23724, 0.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new CurlUpGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canSpawn(class_1299<RolyPolyEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        int yLevel = position.method_10264();
        int seaLevel = level.method_8615();
        int deepCave = seaLevel - 35;
        if (yLevel >= seaLevel) {
            return false;
        }
        if (yLevel > deepCave) {
            return false;
        }
        if (level.method_8311(position)) {
            return false;
        }
        if (level.method_22339(position) > 7) {
            return false;
        }
        boolean randomCheck = random.method_43056();
        boolean mobRules = class_1308.method_20636(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
        boolean canSpawn = randomCheck && mobRules;
        return canSpawn;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        Variant selectedVariant = (Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409()));
        this.setVariant(selectedVariant);
        return super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void method_5773() {
        class_2338 currentPos;
        boolean shouldClimb;
        super.method_5773();
        if (this.hurt) {
            --this.hurtCooldown;
            if (this.hurtCooldown <= 0) {
                this.hurt = false;
                this.field_6011.method_12778(CURLED, (Object)false);
            }
        }
        if (this.isFlipped() && !this.method_37908().field_9236) {
            ++this.blockProcessTimer;
            if (this.blockProcessTimer >= 100) {
                this.blockProcessTimer = 0;
                this.processBlocksBelow();
            }
            ++this.cropGrowthTimer;
            if (this.cropGrowthTimer >= 400) {
                this.cropGrowthTimer = 0;
                this.accelerateCropGrowth();
            }
        } else {
            this.blockProcessTimer = 0;
            this.cropGrowthTimer = 0;
        }
        if (this.method_5799()) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, motion.field_1351 + (double)0.02f, motion.field_1350);
            if (this.isFlipped() && !this.method_37908().field_9236) {
                this.setFlipped(false);
                this.hasFlipped = false;
            }
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = !this.isFlipped() && this.field_5976 && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.method_6101()) {
            currentPos = this.method_24515();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.method_37908().field_9236) {
                    this.field_6189.method_6340();
                    this.field_6201.method_19048().forEach(goal -> goal.method_6270());
                }
            } else if (this.field_5976) {
                class_243 deltaMovement = this.method_18798();
                boolean shouldApplyClimbMovement = true;
                if (this.method_24828()) {
                    class_2338 above = this.method_24515().method_10084();
                    boolean hasBlockAbove = this.isCollidingWithBlock();
                    if (!hasBlockAbove) {
                        shouldApplyClimbMovement = false;
                    }
                }
                if (shouldApplyClimbMovement) {
                    this.method_18800(deltaMovement.field_1352, 0.06, deltaMovement.field_1350);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.method_19538();
        this.actualMovementSpeed = currentPos.method_1022(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.method_37908().field_9236) {
            this.setClimbing(shouldClimb);
        }
    }

    public void method_6007() {
        super.method_6007();
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1409 navigation = new class_1409((class_1308)this, level);
        navigation.method_6354(true);
        this.groundNavigation = navigation;
        return navigation;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236 && this.isFlipped()) {
            this.setFlipped(false);
            this.hasFlipped = false;
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (result && !(source.method_5529() instanceof RolyPolyEntity)) {
            this.hurt = true;
            this.hurtCooldown = 100;
        }
        return result;
    }

    public void method_5697(class_1297 entity) {
        class_1657 player;
        super.method_5697(entity);
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_5624() && !this.method_37908().field_9236) {
            if (this.isFlipped()) {
                this.setFlipped(false);
                this.hasFlipped = false;
            } else {
                this.setFlipped(true);
                this.hasFlipped = false;
            }
        }
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<RolyPolyEntity> event) {
        boolean climbing = this.method_6101();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.method_24828();
        if (this.isCurledUp()) {
            event.getController().setAnimation(RawAnimation.begin().then("curl", Animation.LoopType.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        if (this.isFlipped()) {
            if (!this.hasFlipped) {
                event.getController().setAnimation(RawAnimation.begin().then("flip", Animation.LoopType.PLAY_ONCE));
                if (event.getController().hasAnimationFinished()) {
                    this.hasFlipped = true;
                }
            } else {
                event.getController().setAnimation(RawAnimation.begin().then("struggle", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10556("Curled", this.isCurledUp());
        tag.method_10556("Flipped", this.isFlipped());
        tag.method_10569("ClimbingTime", this.climbingTime);
        tag.method_10569("ClimbCooldown", this.climbCooldown);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        this.setCurled(tag.method_10577("Curled"));
        this.setFlipped(tag.method_10577("Flipped"));
        this.climbingTime = tag.method_10550("ClimbingTime");
        this.climbCooldown = tag.method_10550("ClimbCooldown");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
        this.field_6011.method_12784(CURLED, (Object)false);
        this.field_6011.method_12784(FLIPPED, (Object)false);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_6101() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)flags);
    }

    public boolean isCurledUp() {
        return (Boolean)this.field_6011.method_12789(CURLED);
    }

    public void setCurled(boolean curled) {
        this.field_6011.method_12778(CURLED, (Object)curled);
        if (!this.method_37908().field_9236) {
            if (curled) {
                this.method_5996(class_5134.field_23724).method_6192(15.0);
            } else {
                this.method_5996(class_5134.field_23724).method_6192(0.0);
            }
        }
    }

    public boolean isFlipped() {
        return (Boolean)this.field_6011.method_12789(FLIPPED);
    }

    public void setFlipped(boolean flipped) {
        this.field_6011.method_12778(FLIPPED, (Object)flipped);
        if (!this.method_37908().field_9236 && flipped) {
            this.method_5942().method_6340();
            this.setClimbing(false);
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        if (!state.method_26215() && !state.method_45474()) {
            return true;
        }
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        class_2338 east = pos.method_10078();
        class_2338 west = pos.method_10067();
        boolean bl = hasAdjacentAtCurrentLevel = !this.method_37908().method_8320(north).method_26215() && !this.method_37908().method_8320(north).method_45474() || !this.method_37908().method_8320(south).method_26215() && !this.method_37908().method_8320(south).method_45474() || !this.method_37908().method_8320(east).method_26215() && !this.method_37908().method_8320(east).method_45474() || !this.method_37908().method_8320(west).method_26215() && !this.method_37908().method_8320(west).method_45474();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        class_2338 posBelow = pos.method_10074();
        class_2338 northBelow = posBelow.method_10095();
        class_2338 southBelow = posBelow.method_10072();
        class_2338 eastBelow = posBelow.method_10078();
        class_2338 westBelow = posBelow.method_10067();
        return !this.method_37908().method_8320(northBelow).method_26215() && !this.method_37908().method_8320(northBelow).method_45474() || !this.method_37908().method_8320(southBelow).method_26215() && !this.method_37908().method_8320(southBelow).method_45474() || !this.method_37908().method_8320(eastBelow).method_26215() && !this.method_37908().method_8320(eastBelow).method_45474() || !this.method_37908().method_8320(westBelow).method_26215() && !this.method_37908().method_8320(westBelow).method_45474();
    }

    private void processBlocksBelow() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2338 centerPos = this.method_24515().method_10074();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 targetPos;
                class_2680 currentState;
                class_2680 newState;
                if (!(this.field_5974.method_43057() < 0.15f) || (newState = this.getDecomposedBlock(currentState = serverLevel.method_8320(targetPos = centerPos.method_10069(x, 0, z)))) == null || newState == currentState) continue;
                serverLevel.method_8652(targetPos, newState, 3);
                double particleX = (double)targetPos.method_10263() + 0.5;
                double particleY = (double)targetPos.method_10264() + 1.0;
                double particleZ = (double)targetPos.method_10260() + 0.5;
                for (int i = 0; i < 3; ++i) {
                    double offsetX = (this.field_5974.method_43058() - 0.5) * 0.5;
                    double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.5;
                    serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, currentState), particleX + offsetX, particleY, particleZ + offsetZ, 1, 0.0, 0.05, 0.0, 0.0);
                }
                serverLevel.method_8396(null, targetPos, class_3417.field_28601, this.method_5634(), 0.3f, 0.8f + this.field_5974.method_43057() * 0.4f);
            }
        }
    }

    private void accelerateCropGrowth() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2338 centerPos = this.method_24515();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    int currentLevel;
                    class_2256 fertilizable;
                    class_2248 class_22482;
                    class_2338 targetPos = centerPos.method_10069(x, y, z);
                    class_2680 state = serverLevel.method_8320(targetPos);
                    if (this.field_5974.method_43057() < 0.03f && state.method_26164(class_3481.field_20341) && (class_22482 = state.method_26204()) instanceof class_2256 && (fertilizable = (class_2256)class_22482).method_9651((class_4538)serverLevel, targetPos, state, serverLevel.field_9236)) {
                        class_2680 beforeState = state;
                        fertilizable.method_9652(serverLevel, this.field_5974, targetPos, state);
                        class_2680 afterState = serverLevel.method_8320(targetPos);
                        if (!beforeState.equals(afterState)) {
                            double particleX = (double)targetPos.method_10263() + 0.5;
                            double particleY = (double)targetPos.method_10264() + 0.5;
                            double particleZ = (double)targetPos.method_10260() + 0.5;
                            for (int i = 0; i < 5; ++i) {
                                double offsetX = (this.field_5974.method_43058() - 0.5) * 0.4;
                                double offsetY = this.field_5974.method_43058() * 0.5;
                                double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.4;
                                serverLevel.method_14199((class_2394)class_2398.field_11211, particleX + offsetX, particleY + offsetY, particleZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                    if (!(this.field_5974.method_43057() < 0.02f) || !(state.method_26204() instanceof class_3962) || (currentLevel = ((Integer)state.method_11654((class_2769)class_3962.field_17565)).intValue()) >= 8) continue;
                    class_2680 newState = (class_2680)state.method_11657((class_2769)class_3962.field_17565, (Comparable)Integer.valueOf(currentLevel + 1));
                    serverLevel.method_8652(targetPos, newState, 3);
                    double particleX = (double)targetPos.method_10263() + 0.5;
                    double particleY = (double)targetPos.method_10264() + 0.7;
                    double particleZ = (double)targetPos.method_10260() + 0.5;
                    for (int i = 0; i < 3; ++i) {
                        double offsetX = (this.field_5974.method_43058() - 0.5) * 0.3;
                        double offsetY = this.field_5974.method_43058() * 0.3;
                        double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.3;
                        serverLevel.method_14199((class_2394)class_2398.field_17741, particleX + offsetX, particleY + offsetY, particleZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    serverLevel.method_8396(null, targetPos, class_3417.field_17608, this.method_5634(), 0.5f, 0.8f + this.field_5974.method_43057() * 0.4f);
                }
            }
        }
    }

    @Nullable
    private class_2680 getDecomposedBlock(class_2680 currentState) {
        if (currentState.method_26164(class_3481.field_29822) && !currentState.method_27852(class_2246.field_10253) && !currentState.method_27852(class_2246.field_28685)) {
            if (currentState.method_27852(class_2246.field_10566)) {
                return class_2246.field_10253.method_9564();
            }
            return class_2246.field_10566.method_9564();
        }
        if (currentState.method_27852(class_2246.field_10253)) {
            return class_2246.field_28685.method_9564();
        }
        if (currentState.method_27852(class_2246.field_28685)) {
            return class_2246.field_10566.method_9564();
        }
        return null;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 otherParent) {
        return null;
    }

    static class RolyPolyMoveControl
    extends class_1335 {
        private final RolyPolyEntity rolyPoly;

        public RolyPolyMoveControl(RolyPolyEntity rolyPolyEntity) {
            super((class_1308)rolyPolyEntity);
            this.rolyPoly = rolyPolyEntity;
        }

        public void method_6240() {
            if (!this.rolyPoly.isCurledUp() && !this.rolyPoly.isFlipped()) {
                super.method_6240();
            }
        }
    }

    public class CurlUpGoal
    extends class_1352 {
        private final RolyPolyEntity rolyPoly;
        private int timer;

        public CurlUpGoal(RolyPolyEntity rolyPoly) {
            this.rolyPoly = rolyPoly;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            return this.rolyPoly.hurt && !this.rolyPoly.isCurledUp() && !this.rolyPoly.isFlipped();
        }

        public boolean method_6266() {
            return this.rolyPoly.hurt && this.rolyPoly.isCurledUp();
        }

        public void method_6269() {
            this.rolyPoly.setCurled(true);
            this.timer = 0;
            this.rolyPoly.method_5942().method_6340();
            this.rolyPoly.method_5988().method_20248(this.rolyPoly.method_23317(), this.rolyPoly.method_23318(), this.rolyPoly.method_23321());
        }

        public void method_6268() {
            ++this.timer;
            if (this.timer >= 300) {
                this.uncurlRolyPoly();
            }
        }

        public void method_6270() {
            this.uncurlRolyPoly();
        }

        private void uncurlRolyPoly() {
            if (this.rolyPoly.isCurledUp()) {
                this.rolyPoly.setCurled(false);
            }
        }
    }

    public static enum Variant implements class_3542
    {
        BLACK(0, "black"),
        WHITE(1, "white"),
        RUBBERDUCKY(2, "rubberducky"),
        DAIRYCOW(3, "dairycow"),
        WHITESHARK(4, "whiteshark"),
        CAPPUCCINO(5, "cappuccino");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

