/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.SilkwormEntity;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifyBlocks;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SilkMothEntity
extends class_1429
implements GeoEntity {
    private static final double PLAYER_DETECTION_RANGE = 4.0;
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(SilkMothEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FROM_SILKWORM = class_2945.method_12791(SilkMothEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_PREGNANT = class_2945.method_12791(SilkMothEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_LAYING_EGG = class_2945.method_12791(SilkMothEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    public boolean landingFlag;

    public SilkMothEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new SilkMothMoveController(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23719, 0.5);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new SilkMothLayEggGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 0.8));
        this.field_6201.method_6277(3, (class_1352)new LightAttractionGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 0.8, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_28659}), false));
        this.field_6201.method_6277(5, (class_1352)new SilkMothFlightGoal(this));
        this.field_6201.method_6277(6, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canSpawn(class_1299<SilkMothEntity> entityType, class_5425 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        boolean isDay = level.method_8410().method_8530();
        if (isDay) {
            return false;
        }
        boolean canSeeSky = level.method_8311(position);
        if (!canSeeSky) {
            return false;
        }
        int blockLight = level.method_8314(class_1944.field_9282, position);
        if (blockLight > 7) {
            return false;
        }
        class_2338 below = position.method_10074();
        class_2680 belowState = level.method_8320(below);
        boolean validSpawn = belowState.method_26170((class_1922)level, below, entityType);
        return validSpawn;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        return super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void method_5773() {
        super.method_5773();
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
        if (!this.method_37908().field_9236 && !this.isLayingEgg() && !this.isFlying() && this.method_24828()) {
            boolean isBeingTempted = false;
            class_238 searchBox = this.method_5829().method_1014(10.0);
            List nearbyPlayers = this.method_37908().method_8390(class_1657.class, searchBox, e -> true);
            for (class_1657 player : nearbyPlayers) {
                if (!player.method_6047().method_31574(class_1802.field_28659) && !player.method_6079().method_31574(class_1802.field_28659)) continue;
                isBeingTempted = true;
                break;
            }
            if (this.method_6479() || isBeingTempted) {
                this.setFlying(true);
                this.landingFlag = false;
                this.groundedFor = 0;
            }
        }
    }

    public void tickFlight() {
        if (this.isLayingEgg()) {
            this.flyProgress = 0.0f;
            this.method_5875(false);
            return;
        }
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isFlying()) {
            ++this.timeFlying;
            this.method_5875(true);
            if (this.groundedFor > 0) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.method_5875(false);
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.method_37908().field_9236) {
            if (this.isFlying() && this.method_5805() && !this.method_5782()) {
                if (this.landingFlag) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.1, 0.0));
                }
                if ((this.field_5976 || this.method_5799()) && !this.landingFlag) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.05, 0.0));
                }
            }
            if (this.isFlying() && this.timeFlying > 40 && this.method_24828()) {
                this.setFlying(false);
            }
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        return new SilkMothFlyingNavigation((class_1308)this, level, 0.75f);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1826 spawnEggItem;
        class_1799 itemStack = player.method_5998(hand);
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1826 && (spawnEggItem = (class_1826)class_17922).method_8015(itemStack.method_7969()) == this.method_5864()) {
            if (!this.method_37908().field_9236) {
                SilkwormEntity silkworm = new SilkwormEntity(FaunifyEntities.SILKWORM, this.method_37908());
                silkworm.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), 0.0f);
                silkworm.method_7217(true);
                int roll = this.field_5974.method_43048(100);
                if (roll < 95) {
                    silkworm.setVariant(SilkwormEntity.Variant.NORMAL);
                } else {
                    silkworm.setVariant(SilkwormEntity.Variant.HUNGRY);
                }
                this.method_37908().method_8649((class_1297)silkworm);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        if (this.method_6481(itemStack)) {
            return super.method_5992(player, hand);
        }
        return class_1269.field_5811;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_28659;
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 otherParent) {
        return null;
    }

    public void method_24650(class_3218 level, class_1429 otherParent) {
        this.method_49794(level, otherParent, null);
        this.setIsPregnant(true);
        if (otherParent instanceof SilkMothEntity) {
            SilkMothEntity otherMoth = (SilkMothEntity)otherParent;
            otherMoth.setIsPregnant(true);
        }
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<SilkMothEntity> event) {
        if (!this.isFlying() && this.method_24828()) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Flying", this.isFlying());
        tag.method_10569("TimeFlying", this.timeFlying);
        tag.method_10569("GroundedFor", this.groundedFor);
        tag.method_10556("LandingFlag", this.landingFlag);
        tag.method_10556("FromSilkworm", this.isFromSilkworm());
        tag.method_10556("IsPregnant", this.isPregnant());
        tag.method_10556("IsLayingEgg", this.isLayingEgg());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setFlying(tag.method_10577("Flying"));
        this.timeFlying = tag.method_10550("TimeFlying");
        this.groundedFor = tag.method_10550("GroundedFor");
        this.landingFlag = tag.method_10577("LandingFlag");
        this.setFromSilkworm(tag.method_10577("FromSilkworm"));
        this.setIsPregnant(tag.method_10577("IsPregnant"));
        this.setLayingEgg(tag.method_10577("IsLayingEgg"));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(FROM_SILKWORM, (Object)false);
        this.field_6011.method_12784(IS_PREGNANT, (Object)false);
        this.field_6011.method_12784(IS_LAYING_EGG, (Object)false);
    }

    public boolean method_5810() {
        return true;
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    protected void method_5623(double fallDistance, boolean onGround, class_2680 state, class_2338 pos) {
    }

    public boolean method_5974(double distanceSquared) {
        return !this.isFromSilkworm() && !this.method_16914() && !this.method_5934();
    }

    public boolean isFromSilkworm() {
        return (Boolean)this.field_6011.method_12789(FROM_SILKWORM);
    }

    public void setFromSilkworm(boolean fromSilkworm) {
        this.field_6011.method_12778(FROM_SILKWORM, (Object)fromSilkworm);
    }

    public boolean isPregnant() {
        return (Boolean)this.field_6011.method_12789(IS_PREGNANT);
    }

    public void setIsPregnant(boolean pregnant) {
        this.field_6011.method_12778(IS_PREGNANT, (Object)pregnant);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.field_6011.method_12789(IS_LAYING_EGG);
    }

    public void setLayingEgg(boolean laying) {
        this.field_6011.method_12778(IS_LAYING_EGG, (Object)laying);
    }

    private static class SilkMothMoveController
    extends class_1335 {
        private final SilkMothEntity moth;

        public SilkMothMoveController(SilkMothEntity moth) {
            super((class_1308)moth);
            this.moth = moth;
        }

        public void method_6240() {
            if (this.moth.isLayingEgg()) {
                this.field_6374 = class_1335.class_1336.field_6377;
                this.moth.method_18799(class_243.field_1353);
                this.moth.method_5875(false);
                return;
            }
            if (!this.moth.isFlying() && this.moth.method_24828()) {
                this.field_6374 = class_1335.class_1336.field_6377;
                return;
            }
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vector3d = new class_243(this.field_6370 - this.moth.method_23317(), this.field_6369 - this.moth.method_23318(), this.field_6367 - this.moth.method_23321());
                double d0 = vector3d.method_1033();
                double width = this.moth.method_5829().method_995();
                class_243 vector3d1 = vector3d.method_1021(this.field_6372 * 0.05 / d0);
                this.moth.method_18799(this.moth.method_18798().method_1019(vector3d1).method_1021(0.95).method_1031(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                } else if (d0 >= width) {
                    float yaw = -((float)class_3532.method_15349((double)vector3d1.field_1352, (double)vector3d1.field_1350)) * 57.295776f;
                    this.moth.method_36456(class_3532.method_15388((float)this.moth.method_36454(), (float)yaw, (float)8.0f));
                }
            }
        }
    }

    private static class SilkMothLayEggGoal
    extends class_1352 {
        private static final int LAYING_DURATION = 40;
        private static final Set<class_2338> OCCUPIED_LEAF_POSITIONS = new HashSet<class_2338>();
        private final SilkMothEntity moth;
        private class_2338 targetBlockPos;
        private int searchCooldown;
        private int layingTimer;
        private boolean isLaying;
        private boolean hasLanded;
        private int failedLandingAttempts;
        private int repositionTimer;

        public SilkMothLayEggGoal(SilkMothEntity moth) {
            this.moth = moth;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
            this.layingTimer = 0;
            this.isLaying = false;
            this.hasLanded = false;
            this.searchCooldown = 0;
            this.failedLandingAttempts = 0;
            this.repositionTimer = 0;
        }

        public boolean method_6264() {
            if (!this.moth.isPregnant()) {
                return false;
            }
            if (this.moth.method_5782()) {
                return false;
            }
            if (this.searchCooldown > 0) {
                --this.searchCooldown;
                return false;
            }
            this.targetBlockPos = this.findNearbyLeaf();
            if (this.targetBlockPos != null) {
                OCCUPIED_LEAF_POSITIONS.add(this.targetBlockPos);
                this.failedLandingAttempts = 0;
                return true;
            }
            this.searchCooldown = 200;
            return false;
        }

        public boolean method_6266() {
            if (this.targetBlockPos == null) {
                return false;
            }
            if (!this.moth.isPregnant()) {
                return false;
            }
            if (this.failedLandingAttempts > 15) {
                return false;
            }
            class_2680 blockState = this.moth.method_37908().method_8320(this.targetBlockPos);
            boolean blockValid = blockState.method_26164(class_3481.field_15503);
            return blockValid;
        }

        public void method_6269() {
            this.moth.setFlying(true);
            this.moth.setLayingEgg(false);
            this.moth.landingFlag = false;
            this.layingTimer = 0;
            this.isLaying = false;
            this.hasLanded = false;
            this.failedLandingAttempts = 0;
            this.repositionTimer = 0;
            this.moth.method_5942().method_6337((double)this.targetBlockPos.method_10263() + 0.5, (double)this.targetBlockPos.method_10264() + 2.0, (double)this.targetBlockPos.method_10260() + 0.5, 0.8);
        }

        public void method_6268() {
            if (this.targetBlockPos == null) {
                return;
            }
            if (!this.moth.isLayingEgg() && this.hasLanded) {
                this.moth.setLayingEgg(true);
            }
            if (!this.hasLanded) {
                boolean isAtCorrectHeight;
                class_243 exactLandingPos = new class_243((double)this.targetBlockPos.method_10263() + 0.5, (double)this.targetBlockPos.method_10264() + 1.0, (double)this.targetBlockPos.method_10260() + 0.5);
                class_243 mothPos = this.moth.method_19538();
                double horizontalDistance = Math.sqrt(Math.pow(mothPos.field_1352 - exactLandingPos.field_1352, 2.0) + Math.pow(mothPos.field_1350 - exactLandingPos.field_1350, 2.0));
                double verticalDistance = Math.abs(mothPos.field_1351 - exactLandingPos.field_1351);
                boolean isCenteredHorizontally = horizontalDistance < 0.3;
                boolean bl = isAtCorrectHeight = verticalDistance < 0.5;
                if (this.moth.method_24828()) {
                    class_2338 mothFeetPos = this.moth.method_24515().method_10074();
                    if (mothFeetPos.equals((Object)this.targetBlockPos)) {
                        this.moth.setFlying(false);
                        this.moth.landingFlag = false;
                        this.moth.method_5942().method_6340();
                        this.moth.method_18799(class_243.field_1353);
                        this.moth.method_5875(false);
                        this.hasLanded = true;
                        this.failedLandingAttempts = 0;
                        this.repositionTimer = 0;
                    } else if (isCenteredHorizontally) {
                        this.moth.setFlying(false);
                        this.moth.landingFlag = false;
                        this.moth.method_5942().method_6340();
                        this.moth.method_18799(class_243.field_1353);
                        this.moth.method_5875(false);
                        this.hasLanded = true;
                        this.failedLandingAttempts = 0;
                        this.repositionTimer = 0;
                    } else {
                        ++this.failedLandingAttempts;
                        this.repositionTimer = 0;
                        this.moth.setFlying(true);
                        this.moth.method_5875(true);
                        this.moth.method_5942().method_6337(exactLandingPos.field_1352, exactLandingPos.field_1351 + 2.0, exactLandingPos.field_1350, 0.7);
                    }
                } else if (isCenteredHorizontally && verticalDistance < 3.0) {
                    this.moth.setFlying(false);
                    this.moth.landingFlag = true;
                    this.moth.method_5875(false);
                    class_243 currentVelocity = this.moth.method_18798();
                    double targetDescentSpeed = verticalDistance > 2.0 ? -0.08 : (verticalDistance > 1.0 ? -0.05 : -0.03);
                    double smoothedYVelocity = currentVelocity.field_1351 * 0.8 + targetDescentSpeed * 0.2;
                    this.moth.method_18800(currentVelocity.field_1352 * 0.3, Math.max(smoothedYVelocity, -0.5), currentVelocity.field_1350 * 0.3);
                    if (this.moth.field_6012 % 8 == 0 && verticalDistance < 1.5) {
                        class_243 vel = this.moth.method_18798();
                        this.moth.method_18800(vel.field_1352, vel.field_1351 + 0.02, vel.field_1350);
                    }
                } else {
                    this.moth.setFlying(true);
                    this.moth.landingFlag = false;
                    this.moth.method_5875(true);
                    ++this.repositionTimer;
                    if (this.repositionTimer > 40 || this.moth.method_5942().method_6357()) {
                        this.moth.method_5942().method_6337(exactLandingPos.field_1352, exactLandingPos.field_1351 + 1.5, exactLandingPos.field_1350, 0.8);
                        this.repositionTimer = 0;
                    }
                }
            } else {
                this.moth.setFlying(false);
                this.moth.setLayingEgg(true);
                this.moth.landingFlag = false;
                this.moth.method_5942().method_6340();
                this.moth.method_18799(class_243.field_1353);
                this.moth.method_5875(false);
                class_243 mothPos = this.moth.method_19538();
                class_243 leafCenter = class_243.method_24953((class_2382)this.targetBlockPos);
                double horizontalDrift = Math.sqrt(Math.pow(mothPos.field_1352 - leafCenter.field_1352, 2.0) + Math.pow(mothPos.field_1350 - leafCenter.field_1350, 2.0));
                if (horizontalDrift > 0.8) {
                    this.hasLanded = false;
                    this.moth.setLayingEgg(false);
                    ++this.failedLandingAttempts;
                    this.isLaying = false;
                    this.layingTimer = 0;
                    return;
                }
                if (!this.isLaying) {
                    this.isLaying = true;
                    this.layingTimer = 0;
                }
                ++this.layingTimer;
                if (this.layingTimer >= 40) {
                    class_2338 eggPos = this.targetBlockPos.method_10084();
                    if (this.moth.method_37908().method_8320(eggPos).method_26215()) {
                        this.moth.method_37908().method_8652(eggPos, FaunifyBlocks.SILKWORM_EGGS.method_9564(), 3);
                        this.moth.setIsPregnant(false);
                        this.moth.setLayingEgg(false);
                        this.moth.method_6476(0);
                    } else {
                        this.moth.setLayingEgg(false);
                        this.hasLanded = false;
                        this.isLaying = false;
                        this.layingTimer = 0;
                        ++this.failedLandingAttempts;
                    }
                }
            }
        }

        public void method_6270() {
            this.moth.setLayingEgg(false);
            if (this.targetBlockPos != null) {
                OCCUPIED_LEAF_POSITIONS.remove(this.targetBlockPos);
            }
            this.targetBlockPos = null;
            this.searchCooldown = 100;
            this.layingTimer = 0;
            this.isLaying = false;
            this.hasLanded = false;
            this.failedLandingAttempts = 0;
            this.repositionTimer = 0;
            if (this.moth.isPregnant()) {
                this.moth.setFlying(true);
            }
        }

        @Nullable
        private class_2338 findNearbyLeaf() {
            List validLeaves;
            class_2338 mothPos = this.moth.method_24515();
            if (this.moth.field_6012 % 100 == 0) {
                OCCUPIED_LEAF_POSITIONS.removeIf(pos -> {
                    boolean tooFar = this.moth.method_37908().method_18456().stream().allMatch(player -> player.method_24515().method_10262((class_2382)pos) > 4096.0);
                    return tooFar;
                });
            }
            if ((validLeaves = class_2338.method_25998((class_2338)mothPos, (int)16, (int)8, (int)16).map(class_2338::method_10062).filter(pos -> {
                if (OCCUPIED_LEAF_POSITIONS.contains(pos)) {
                    return false;
                }
                class_2680 state = this.moth.method_37908().method_8320(pos);
                if (state.method_26164(class_3481.field_15503)) {
                    class_2338 above = pos.method_10084();
                    class_2680 aboveState = this.moth.method_37908().method_8320(above);
                    if (!aboveState.method_26215()) {
                        return false;
                    }
                    if (!aboveState.method_26220((class_1922)this.moth.method_37908(), above).method_1110()) {
                        return false;
                    }
                    class_2338 aboveAbove = above.method_10084();
                    class_2680 aboveAboveState = this.moth.method_37908().method_8320(aboveAbove);
                    return aboveAboveState.method_26215() || aboveAboveState.method_45474();
                }
                return false;
            }).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            class_2338 selected = (class_2338)validLeaves.get(this.moth.method_6051().method_43048(validLeaves.size()));
            return selected;
        }
    }

    private static class LightAttractionGoal
    extends class_1352 {
        private static final double LIGHT_PROXIMITY_DISTANCE = 3.0;
        private final SilkMothEntity moth;
        private class_2338 lightSourcePos;
        private class_243 targetAroundLight;
        private int retargetTimer;
        private boolean nearLight;

        public LightAttractionGoal(SilkMothEntity moth) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.moth = moth;
            this.retargetTimer = 0;
            this.nearLight = false;
        }

        public boolean method_6264() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (this.moth.method_5782() || this.moth.method_5765()) {
                return false;
            }
            if (!this.moth.method_37908().method_23886()) {
                return false;
            }
            this.lightSourcePos = this.findHighestPriorityLightSource();
            if (this.lightSourcePos != null) {
                this.targetAroundLight = this.getApproachPosition(this.lightSourcePos);
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (!this.moth.method_37908().method_23886()) {
                return false;
            }
            if (this.lightSourcePos == null) {
                return false;
            }
            class_2680 currentLightState = this.moth.method_37908().method_8320(this.lightSourcePos);
            if (currentLightState.method_26213() < 8) {
                return false;
            }
            if (this.retargetTimer <= 0) {
                class_2338 newLightSource = this.findHighestPriorityLightSource();
                if (newLightSource == null) {
                    return false;
                }
                if (!newLightSource.equals((Object)this.lightSourcePos)) {
                    return false;
                }
            }
            return true;
        }

        public void method_6269() {
            this.moth.setFlying(true);
            this.moth.landingFlag = false;
            this.moth.groundedFor = 0;
            this.retargetTimer = 15 + this.moth.method_6051().method_43048(10);
            this.nearLight = false;
        }

        public void method_6270() {
            this.moth.method_5942().method_6340();
            this.lightSourcePos = null;
            this.targetAroundLight = null;
            this.nearLight = false;
        }

        public void method_6268() {
            double distanceToLight;
            class_2338 brighterLight;
            --this.retargetTimer;
            if (!this.moth.isFlying()) {
                this.moth.setFlying(true);
            }
            this.moth.landingFlag = false;
            this.moth.groundedFor = 0;
            class_243 lightCenter = class_243.method_24953((class_2382)this.lightSourcePos);
            class_243 mothPos = this.moth.method_19538();
            double dx = lightCenter.field_1352 - mothPos.field_1352;
            double dz = lightCenter.field_1350 - mothPos.field_1350;
            float targetYaw = -((float)class_3532.method_15349((double)dx, (double)dz)) * 57.295776f;
            this.moth.method_36456(class_3532.method_15388((float)this.moth.method_36454(), (float)targetYaw, (float)10.0f));
            this.moth.field_6283 = this.moth.method_36454();
            if (this.moth.field_6012 % 40 == 0 && (brighterLight = this.findHighestPriorityLightSource()) != null && !brighterLight.equals((Object)this.lightSourcePos)) {
                int currentBrightness = this.moth.method_37908().method_8314(class_1944.field_9282, this.lightSourcePos);
                int newBrightness = this.moth.method_37908().method_8314(class_1944.field_9282, brighterLight);
                if (newBrightness > currentBrightness) {
                    this.lightSourcePos = brighterLight;
                    this.targetAroundLight = this.getApproachPosition(this.lightSourcePos);
                    this.nearLight = false;
                    this.retargetTimer = 30 + this.moth.method_6051().method_43048(20);
                }
            }
            if ((distanceToLight = this.moth.method_19538().method_1022(class_243.method_24953((class_2382)this.lightSourcePos))) < 3.0) {
                this.nearLight = true;
            }
            if (this.nearLight) {
                if (this.retargetTimer <= 0 || this.moth.method_19538().method_1025(this.targetAroundLight) < 1.5) {
                    this.targetAroundLight = this.getOrbitPosition(this.lightSourcePos);
                    this.moth.method_5942().method_6337(this.targetAroundLight.field_1352, this.targetAroundLight.field_1351, this.targetAroundLight.field_1350, (double)0.4f);
                    this.retargetTimer = 10 + this.moth.method_6051().method_43048(15);
                }
            } else if (this.retargetTimer <= 0 || this.moth.method_5942().method_6357()) {
                this.targetAroundLight = this.getApproachPosition(this.lightSourcePos);
                this.moth.method_5942().method_6337(this.targetAroundLight.field_1352, this.targetAroundLight.field_1351, this.targetAroundLight.field_1350, (double)0.6f);
                this.retargetTimer = 30 + this.moth.method_6051().method_43048(20);
            }
        }

        private class_2338 findHighestPriorityLightSource() {
            class_1937 level = this.moth.method_37908();
            class_2338 mothPos = this.moth.method_24515();
            return class_2338.method_25998((class_2338)mothPos, (int)15, (int)15, (int)15).map(class_2338::method_10062).filter(pos -> {
                class_2680 state = level.method_8320(pos);
                return state.method_26213() >= 8;
            }).min(Comparator.comparingInt(pos -> -level.method_8314(class_1944.field_9282, pos)).thenComparingDouble(pos -> pos.method_10262((class_2382)mothPos))).orElse(null);
        }

        private class_243 getApproachPosition(class_2338 lightPos) {
            int radius = 2 + this.moth.field_5974.method_43048(3);
            double angle = this.moth.field_5974.method_43058() * Math.PI * 2.0;
            int xOffset = (int)(Math.cos(angle) * (double)radius);
            int zOffset = (int)(Math.sin(angle) * (double)radius);
            int yOffset = this.moth.field_5974.method_43048(3) - 1;
            return class_243.method_24953((class_2382)lightPos.method_10069(xOffset, yOffset, zOffset));
        }

        private class_243 getOrbitPosition(class_2338 lightPos) {
            int radius = 1 + this.moth.field_5974.method_43048(2);
            double angle = this.moth.field_5974.method_43058() * Math.PI * 2.0;
            double xOffset = Math.cos(angle) * (double)radius;
            double zOffset = Math.sin(angle) * (double)radius;
            int yOffset = this.moth.field_5974.method_43048(3) - 1;
            int finalY = Math.max(lightPos.method_10264() + yOffset, lightPos.method_10264());
            return new class_243((double)lightPos.method_10263() + xOffset + 0.5, (double)finalY + 0.5, (double)lightPos.method_10260() + zOffset + 0.5);
        }
    }

    private static class SilkMothFlightGoal
    extends class_1352 {
        private final SilkMothEntity moth;
        private double x;
        private double y;
        private double z;
        private int flyDuration;
        private int restDuration;
        private int currentTimer;
        private boolean shouldRest;
        private int landingTimer;
        private class_243 landingTarget;

        public SilkMothFlightGoal(SilkMothEntity moth) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.moth = moth;
            this.resetTimers();
            this.landingTimer = 0;
        }

        private void resetTimers() {
            this.flyDuration = 160 + this.moth.method_6051().method_43048(81);
            this.restDuration = 80 + this.moth.method_6051().method_43048(81);
            this.currentTimer = 0;
            this.shouldRest = false;
            this.landingTimer = 0;
        }

        public boolean method_6264() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (this.moth.method_5782() || this.moth.method_5765()) {
                return false;
            }
            if (!this.moth.isFlying() && this.moth.method_24828()) {
                class_238 searchBox = this.moth.method_5829().method_1014(4.0);
                List nearbyPlayers = this.moth.method_37908().method_8390(class_1657.class, searchBox, e -> true);
                if (!nearbyPlayers.isEmpty()) {
                    this.shouldRest = false;
                    this.currentTimer = 0;
                    this.landingTimer = 0;
                    class_243 target = this.getPosition();
                    if (target != null) {
                        this.x = target.field_1352;
                        this.y = target.field_1351;
                        this.z = target.field_1350;
                        return true;
                    }
                }
            }
            if (!this.moth.isFlying() && this.moth.method_6051().method_43048(80) != 0 && !this.shouldRest) {
                return false;
            }
            class_243 target = this.getPosition();
            if (target == null) {
                return false;
            }
            this.x = target.field_1352;
            this.y = target.field_1351;
            this.z = target.field_1350;
            return true;
        }

        public boolean method_6266() {
            if (this.moth.isLayingEgg()) {
                return false;
            }
            if (!this.moth.isFlying() && this.moth.method_24828() && this.currentTimer >= this.restDuration) {
                return false;
            }
            if (this.moth.landingFlag) {
                return !this.moth.method_24828() && this.moth.groundedFor <= 0;
            }
            return this.moth.isFlying() && !this.moth.method_5942().method_6357() && this.moth.groundedFor <= 0;
        }

        public void method_6269() {
            this.moth.setFlying(true);
            this.moth.method_5942().method_6337(this.x, this.y, this.z, 0.5);
        }

        public void method_6270() {
            this.moth.method_5942().method_6340();
            this.moth.landingFlag = false;
            this.landingTimer = 0;
            this.landingTarget = null;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            super.method_6270();
        }

        public void method_6268() {
            if (!this.moth.isFlying() && this.moth.method_24828()) {
                ++this.currentTimer;
                class_2338 mothPos = this.moth.method_24515();
                class_2680 stateAtPos = this.moth.method_37908().method_8320(mothPos);
                if (!stateAtPos.method_26215() && !stateAtPos.method_45474()) {
                    return;
                }
                this.moth.method_18799(class_243.field_1353);
                return;
            }
            ++this.currentTimer;
            if (this.moth.isFlying()) {
                if (this.currentTimer >= this.flyDuration) {
                    this.shouldRest = true;
                    this.moth.landingFlag = true;
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                }
                if (this.moth.landingFlag) {
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                    if (this.landingTarget != null) {
                        ++this.landingTimer;
                        if (this.landingTimer % 20 == 0) {
                            class_243 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                            this.moth.method_5942().method_6337(nextPos.field_1352, nextPos.field_1351, nextPos.field_1350, 0.25);
                        }
                        if (this.moth.method_24828() || this.moth.method_23318() - this.landingTarget.field_1351 < 1.5 && this.landingTimer > 60) {
                            this.moth.setFlying(false);
                            this.currentTimer = 0;
                            this.shouldRest = false;
                            this.moth.landingFlag = false;
                            this.landingTarget = null;
                            this.landingTimer = 0;
                            this.resetTimers();
                        }
                    } else {
                        this.moth.landingFlag = false;
                        this.shouldRest = false;
                        this.landingTimer = 0;
                    }
                }
            }
            if (this.isOverWaterOrVoid() || this.moth.method_5799()) {
                this.moth.setFlying(true);
                this.moth.landingFlag = false;
                this.shouldRest = false;
                this.landingTimer = 0;
                this.landingTarget = null;
            }
        }

        private class_243 getPosition() {
            if (this.shouldRest) {
                this.landingTarget = this.findLandingPos();
                return this.getCirclingPosition(this.landingTarget);
            }
            return this.findFlightPos();
        }

        private class_243 getCirclingPosition(class_243 target) {
            double angle = this.moth.method_6051().method_43058() * Math.PI * 2.0;
            double radius = 2.0 + this.moth.method_6051().method_43058() * 2.0;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double yOffset = 3.0 + this.moth.method_6051().method_43058() * 2.0;
            return new class_243(target.field_1352 + xOffset, target.field_1351 + yOffset, target.field_1350 + zOffset);
        }

        private class_243 getDescentPosition(class_243 target, int timer) {
            if (target == null) {
                return this.moth.method_19538();
            }
            double progress = Math.min((double)timer / 120.0, 1.0);
            double angle = (double)timer * 0.1 % (Math.PI * 2);
            double radius = 2.5 * (1.0 - progress * 0.6);
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double currentHeight = this.moth.method_23318();
            double targetHeight = target.field_1351 + 0.5;
            double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.2;
            return new class_243(target.field_1352 + xOffset, Math.max(descentHeight, targetHeight), target.field_1350 + zOffset);
        }

        private class_243 findFlightPos() {
            int range = 13;
            class_243 heightAdjusted = this.moth.method_19538().method_1031((double)(this.moth.method_6051().method_43048(range * 2) - range), 0.0, (double)(this.moth.method_6051().method_43048(range * 2) - range));
            if (this.moth.method_37908().method_8311(class_2338.method_49638((class_2374)heightAdjusted))) {
                ground = this.groundPosition(heightAdjusted);
                heightAdjusted = new class_243(heightAdjusted.field_1352, ground.field_1351 + 4.0 + (double)this.moth.method_6051().method_43048(8), heightAdjusted.field_1350);
            } else {
                ground = this.groundPosition(heightAdjusted);
                class_2338 ceiling = class_2338.method_49638((class_2374)ground).method_10086(2);
                while (ceiling.method_10264() < this.moth.method_37908().method_31600() && !this.moth.method_37908().method_8320(ceiling).method_26216((class_1922)this.moth.method_37908(), ceiling)) {
                    ceiling = ceiling.method_10084();
                }
                float randCeilVal = 0.3f + this.moth.method_6051().method_43057() * 0.5f;
                heightAdjusted = new class_243(heightAdjusted.field_1352, ground.field_1351 + ((double)ceiling.method_10264() - ground.field_1351) * (double)randCeilVal, heightAdjusted.field_1350);
            }
            class_3965 result = this.moth.method_37908().method_17742(new class_3959(this.moth.method_33571(), heightAdjusted, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.moth));
            if (result.method_17783() == class_239.class_240.field_1333) {
                return heightAdjusted;
            }
            return result.method_17784();
        }

        private class_243 findLandingPos() {
            class_243 currentPos = this.moth.method_19538();
            class_243 ground = this.groundPosition(currentPos);
            class_2338 landingPos = class_2338.method_49638((class_2374)ground);
            while (landingPos.method_10264() < this.moth.method_37908().method_31600() && !this.moth.method_37908().method_8320(landingPos).method_26215() && !this.moth.method_37908().method_8320(landingPos).method_45474()) {
                landingPos = landingPos.method_10084();
            }
            return class_243.method_24953((class_2382)landingPos);
        }

        private class_243 groundPosition(class_243 airPosition) {
            class_2338.class_2339 ground = new class_2338.class_2339();
            ground.method_10102(airPosition.field_1352, airPosition.field_1351, airPosition.field_1350);
            boolean flag = false;
            while (ground.method_10264() < this.moth.method_37908().method_31600() && !this.moth.method_37908().method_8320((class_2338)ground).method_26216((class_1922)this.moth.method_37908(), (class_2338)ground) && this.moth.method_37908().method_8316((class_2338)ground).method_15769()) {
                ground.method_10100(0, 1, 0);
                flag = true;
            }
            ground.method_10100(0, -1, 0);
            while (ground.method_10264() > this.moth.method_37908().method_31607() && !this.moth.method_37908().method_8320((class_2338)ground).method_26216((class_1922)this.moth.method_37908(), (class_2338)ground) && this.moth.method_37908().method_8316((class_2338)ground).method_15769()) {
                ground.method_10100(0, -1, 0);
            }
            return class_243.method_24953((class_2382)(flag ? ground.method_10084() : ground.method_10074()));
        }

        private boolean isOverWaterOrVoid() {
            class_2338 position = this.moth.method_24515();
            while (position.method_10264() > this.moth.method_37908().method_31607() && this.moth.method_37908().method_22347(position) && this.moth.method_37908().method_8316(position).method_15769()) {
                position = position.method_10074();
            }
            return !this.moth.method_37908().method_8316(position).method_15769() || this.moth.method_37908().method_8320(position).method_27852(class_2246.field_10597) || position.method_10264() <= this.moth.method_37908().method_31607();
        }
    }

    private static class SilkMothFlyingNavigation
    extends class_1407 {
        private float distanceModifier;

        public SilkMothFlyingNavigation(class_1308 mob, class_1937 level, float distanceModifier) {
            super(mob, level);
            this.distanceModifier = distanceModifier;
        }

        protected void method_6359() {
            boolean flag;
            class_243 vector3d = this.method_6347();
            float maxDistanceToWaypoint = this.field_6684.method_17681() * this.distanceModifier;
            class_2338 vector3i = this.field_6681.method_31032();
            double d0 = Math.abs(this.field_6684.method_23317() - ((double)vector3i.method_10263() + 0.5));
            double d1 = Math.abs(this.field_6684.method_23318() - (double)vector3i.method_10264());
            double d2 = Math.abs(this.field_6684.method_23321() - ((double)vector3i.method_10260() + 0.5));
            boolean bl = flag = d0 < (double)maxDistanceToWaypoint && d2 < (double)maxDistanceToWaypoint && d1 < 1.0;
            if (flag || this.method_48158(this.field_6681.method_40((int)this.field_6681.method_39()).field_41) && this.shouldTargetNextNodeInDirection(vector3d)) {
                this.field_6681.method_44();
            }
            this.method_6346(vector3d);
        }

        private boolean shouldTargetNextNodeInDirection(class_243 currentPosition) {
            class_243 vector3d3;
            if (this.field_6681.method_39() + 1 >= this.field_6681.method_38()) {
                return false;
            }
            class_243 vector3d = class_243.method_24955((class_2382)this.field_6681.method_31032());
            if (!currentPosition.method_24802((class_2374)vector3d, 2.0)) {
                return false;
            }
            class_243 vector3d1 = class_243.method_24955((class_2382)this.field_6681.method_40(this.field_6681.method_39() + 1).method_22879());
            class_243 vector3d2 = vector3d1.method_1020(vector3d);
            return vector3d2.method_1026(vector3d3 = currentPosition.method_1020(vector3d)) > 0.0;
        }
    }
}

