/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.SilkMothEntity;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SilkwormEntity
extends class_1429
implements GeoEntity {
    private static final float BUOYANCY = 0.03f;
    private static final double CLIMB_SPEED = 0.05;
    private static final int EATING_INTERVAL = 40;
    private static final int EATING_DURATION = 100;
    private static final int EATING_ATTEMPTS = 3;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(SilkwormEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> FED_LILY = class_2945.method_12791(SilkwormEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(SilkwormEntity.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int eatingAttempt = 0;
    private int growingAge = -24000;
    private class_2338 targetLeafPos = null;
    private int eatingProgress = 0;
    private int eatingSoundTimer = 0;
    private class_243 prevPosition = class_243.field_1353;
    private double actualMovementSpeed = 0.0;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private class_2338 lastClimbPos;

    public SilkwormEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, 16.0f);
        this.method_5941(class_7.field_3, -1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, 0.15);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 0.6){

            public boolean method_6264() {
                return !SilkwormEntity.this.isEating() && super.method_6264();
            }

            public boolean method_6266() {
                return !SilkwormEntity.this.isEating() && super.method_6266();
            }
        });
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant(SilkwormEntity.getRandomVariant(world.method_8409()));
        return super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
    }

    public void method_5773() {
        class_2338 currentPos;
        boolean shouldClimb;
        super.method_5773();
        if (this.method_5799()) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, motion.field_1351 + (double)0.03f, motion.field_1350);
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.field_5976 && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.method_6101()) {
            currentPos = this.method_24515();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.method_37908().field_9236) {
                    this.field_6189.method_6340();
                    this.field_6201.method_19048().forEach(goal -> goal.method_6270());
                }
            } else if (this.field_5976) {
                boolean hasBlockAbove;
                class_243 deltaMovement = this.method_18798();
                boolean shouldApplyClimbMovement = true;
                if (this.method_24828() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.method_18800(deltaMovement.field_1352, 0.05, deltaMovement.field_1350);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.method_19538();
        this.actualMovementSpeed = currentPos.method_1022(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.method_37908().field_9236) {
            this.setClimbing(shouldClimb);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.method_6109() && !this.isFedLily()) {
            ++this.growingAge;
            if (this.growingAge >= 0) {
                this.convertToMoth();
            }
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1409 navigation = new class_1409((class_1308)this, world);
        navigation.method_6354(true);
        return navigation;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == FaunifyItems.SILKMOTH_SPAWN_EGG) {
            if (!this.method_37908().field_9236) {
                SilkwormEntity silkworm = new SilkwormEntity(FaunifyEntities.SILKWORM, this.method_37908());
                silkworm.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), 0.0f);
                silkworm.method_7217(true);
                int roll = this.field_5974.method_43048(100);
                if (roll < 95) {
                    silkworm.setVariant(Variant.NORMAL);
                } else {
                    silkworm.setVariant(Variant.HUNGRY);
                }
                this.method_37908().method_8649((class_1297)silkworm);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        if (itemStack.method_31574(class_1802.field_28659) && this.method_6109() && !this.isFedLily()) {
            if (!this.method_37908().field_9236) {
                class_1937 roll;
                this.method_5620(class_1296.method_41321((int)(-this.method_5618())), true);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                if ((roll = this.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)roll;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.field_5974.method_43059() * 0.02;
                        double d1 = this.field_5974.method_43059() * 0.02;
                        double d2 = this.field_5974.method_43059() * 0.02;
                        serverWorld.method_14199((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d0, d1, d2, 0.0);
                    }
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (itemStack.method_31574(class_1802.field_17514) && this.method_6109() && !this.isFedLily()) {
            if (!this.method_37908().field_9236) {
                this.setFedLily(true);
                this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
            }
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)FaunifyItems.SILKMOTH_SPAWN_EGG);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 otherParent) {
        return null;
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<SilkwormEntity> event) {
        boolean climbing = this.method_6101();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.method_24828();
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Age", this.growingAge);
        nbt.method_10556("FedLily", this.isFedLily());
        nbt.method_10569("EatingProgress", this.eatingProgress);
        nbt.method_10569("Variant", this.getVariant().id);
        nbt.method_10569("ClimbingTime", this.climbingTime);
        nbt.method_10569("ClimbCooldown", this.climbCooldown);
        if (this.targetLeafPos != null) {
            nbt.method_10544("TargetLeafPos", this.targetLeafPos.method_10063());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.growingAge = nbt.method_10550("Age");
        if (nbt.method_10545("FedLily")) {
            this.setFedLily(nbt.method_10577("FedLily"));
            this.climbingTime = nbt.method_10550("ClimbingTime");
            this.climbCooldown = nbt.method_10550("ClimbCooldown");
        }
        if (nbt.method_10545("EatingProgress")) {
            this.eatingProgress = nbt.method_10550("EatingProgress");
        }
        if (nbt.method_10545("Variant")) {
            this.setVariant(Variant.byId(nbt.method_10550("Variant")));
        }
        if (nbt.method_10545("TargetLeafPos")) {
            this.targetLeafPos = class_2338.method_10092((long)nbt.method_10537("TargetLeafPos"));
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(FED_LILY, (Object)false);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_6101() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    protected float method_6106() {
        return 0.0f;
    }

    public void method_6100(boolean jumping) {
        super.method_6100(false);
    }

    public boolean method_6109() {
        return this.growingAge < 0;
    }

    public void method_7217(boolean baby) {
        this.method_5614(baby ? -24000 : 0);
    }

    public int method_5618() {
        return this.growingAge;
    }

    public void method_5614(int age) {
        this.growingAge = age;
    }

    public void method_5620(int acceleratedAgeInTicks, boolean updateForcedAge) {
        if (!this.isFedLily()) {
            this.growingAge += acceleratedAgeInTicks;
        }
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public boolean isFedLily() {
        return (Boolean)this.field_6011.method_12789(FED_LILY);
    }

    public void setFedLily(boolean fed) {
        this.field_6011.method_12778(FED_LILY, (Object)fed);
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)flags);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    public boolean isEating() {
        return this.targetLeafPos != null && this.isValidLeafBlock(this.targetLeafPos) && this.eatingProgress > 0;
    }

    private void convertToMoth() {
        class_3218 serverWorld;
        SilkMothEntity moth;
        class_1937 class_19372;
        if (!this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218 && (moth = (SilkMothEntity)FaunifyEntities.SILKMOTH.method_5883((class_1937)(serverWorld = (class_3218)class_19372))) != null) {
            moth.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            moth.setFromSilkworm(true);
            moth.method_5943((class_5425)serverWorld, serverWorld.method_8404(moth.method_24515()), class_3730.field_16468, null, null);
            serverWorld.method_8649((class_1297)moth);
            this.method_31472();
        }
    }

    private void handleLeafEating() {
        if (this.targetLeafPos == null || !this.isValidLeafBlock(this.targetLeafPos)) {
            this.targetLeafPos = this.findNearbyLeafBlock();
            this.eatingProgress = 0;
            this.eatingSoundTimer = 0;
            this.eatingAttempt = 0;
        }
        if (this.targetLeafPos != null && this.isValidLeafBlock(this.targetLeafPos)) {
            class_243 leafCenter = class_243.method_24953((class_2382)this.targetLeafPos);
            double dx = leafCenter.field_1352 - this.method_23317();
            double dz = leafCenter.field_1350 - this.method_23321();
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            this.method_36456(targetYaw);
            this.field_5982 = targetYaw;
            this.method_5847(targetYaw);
            this.field_6259 = targetYaw;
            ++this.eatingProgress;
            ++this.eatingSoundTimer;
            if (this.eatingSoundTimer >= 40) {
                for (int i = 0; i < 3; ++i) {
                    this.method_5783(class_3417.field_20614, 0.5f, 1.0f + (this.field_5974.method_43057() - 0.5f) * 0.2f);
                }
                this.eatingSoundTimer = 0;
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_2680 state = this.method_37908().method_8320(this.targetLeafPos);
                    for (int i = 0; i < 5; ++i) {
                        double d0 = (double)this.targetLeafPos.method_10263() + 0.5 + (this.field_5974.method_43058() - 0.5) * 0.5;
                        double d1 = (double)this.targetLeafPos.method_10264() + 0.5 + (this.field_5974.method_43058() - 0.5) * 0.5;
                        double d2 = (double)this.targetLeafPos.method_10260() + 0.5 + (this.field_5974.method_43058() - 0.5) * 0.5;
                        double xSpeed = (this.field_5974.method_43058() - 0.5) * 0.08;
                        double ySpeed = (this.field_5974.method_43058() - 0.5) * 0.08;
                        double zSpeed = (this.field_5974.method_43058() - 0.5) * 0.08;
                        serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, state), d0, d1, d2, 1, xSpeed, ySpeed, zSpeed, 0.1);
                    }
                    class_243 lookVec = this.method_5720();
                    double mouthOffsetDistance = 0.4;
                    double mouthX = this.method_23317() + lookVec.field_1352 * mouthOffsetDistance;
                    double mouthY = this.method_23318() + 0.15;
                    double mouthZ = this.method_23321() + lookVec.field_1350 * mouthOffsetDistance;
                    for (int i = 0; i < 3; ++i) {
                        double xOffset = (this.field_5974.method_43058() - 0.5) * 0.2;
                        double yOffset = (this.field_5974.method_43058() - 0.5) * 0.2;
                        double zOffset = (this.field_5974.method_43058() - 0.5) * 0.2;
                        double xSpeed = (this.field_5974.method_43058() - 0.5) * 0.05;
                        double ySpeed = this.field_5974.method_43058() * 0.05;
                        double zSpeed = (this.field_5974.method_43058() - 0.5) * 0.05;
                        serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, state), mouthX + xOffset, mouthY + yOffset, mouthZ + zOffset, 1, xSpeed, ySpeed, zSpeed, 0.05);
                    }
                }
            }
            if (this.eatingProgress >= 100) {
                ++this.eatingAttempt;
                if (this.eatingAttempt >= 3) {
                    this.method_37908().method_22352(this.targetLeafPos, false);
                    this.targetLeafPos = null;
                    this.eatingAttempt = 0;
                }
                this.eatingProgress = 0;
                this.eatingSoundTimer = 0;
            }
        }
    }

    private class_2338 findNearbyLeafBlock() {
        class_2338[] positions;
        class_2338 pos = this.method_24515();
        for (class_2338 checkPos : positions = new class_2338[]{pos, pos.method_10074(), pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067()}) {
            if (!this.isValidLeafBlock(checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean isValidLeafBlock(class_2338 pos) {
        if (pos == null) {
            return false;
        }
        class_2680 state = this.method_37908().method_8320(pos);
        return state.method_26164(class_3481.field_15503);
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        if (!state.method_26215() && !state.method_45474()) {
            return true;
        }
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        class_2338 east = pos.method_10078();
        class_2338 west = pos.method_10067();
        boolean bl = hasAdjacentAtCurrentLevel = !this.method_37908().method_8320(north).method_26215() && !this.method_37908().method_8320(north).method_45474() || !this.method_37908().method_8320(south).method_26215() && !this.method_37908().method_8320(south).method_45474() || !this.method_37908().method_8320(east).method_26215() && !this.method_37908().method_8320(east).method_45474() || !this.method_37908().method_8320(west).method_26215() && !this.method_37908().method_8320(west).method_45474();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        class_2338 posBelow = pos.method_10074();
        class_2338 northBelow = posBelow.method_10095();
        class_2338 southBelow = posBelow.method_10072();
        class_2338 eastBelow = posBelow.method_10078();
        class_2338 westBelow = posBelow.method_10067();
        return !this.method_37908().method_8320(northBelow).method_26215() && !this.method_37908().method_8320(northBelow).method_45474() || !this.method_37908().method_8320(southBelow).method_26215() && !this.method_37908().method_8320(southBelow).method_45474() || !this.method_37908().method_8320(eastBelow).method_26215() && !this.method_37908().method_8320(eastBelow).method_45474() || !this.method_37908().method_8320(westBelow).method_26215() && !this.method_37908().method_8320(westBelow).method_45474();
    }

    private static Variant getRandomVariant(class_5819 random) {
        int roll = random.method_43048(100);
        if (roll < 95) {
            return Variant.NORMAL;
        }
        return Variant.HUNGRY;
    }

    public static enum Variant implements class_3542
    {
        NORMAL(0, "normal"),
        HUNGRY(1, "hungry");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

