/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.HedgehogEntity;
import com.pepper.faunify.entity.MouseEntity;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WeaselEntity
extends class_1321
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 8.0f;
    public static final float TAMED_HEALTH = 20.0f;
    private static final long DIG_COOLDOWN = TimeUnit.MINUTES.toMillis(3L);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(WeaselEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(WeaselEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DIGGING = class_2945.method_12791(WeaselEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SNOWY_VARIANT = class_2945.method_12791(WeaselEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean hasBittenPlayer = false;
    private long lastDigTime = 0L;

    public WeaselEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new WeaselMoveControl(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 3.0);
    }

    public static boolean canSpawn(class_1299<WeaselEntity> entityType, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random);
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(20.0);
            this.method_6033(20.0f);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setVariant(Variant.getCommonSpawnVariant(world.method_8409()));
        super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        if (this.isInSnowyBiome()) {
            this.setSnowVariant(true);
        } else {
            this.setSnowVariant(false);
        }
        if (entityData == null) {
            entityData = new class_1296.class_4697(false);
        }
        return entityData;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DIGGING, (Object)false);
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(SNOWY_VARIANT, (Object)false);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().id);
        nbt.method_10556("IsSnowVariant", ((Boolean)this.field_6011.method_12789(SNOWY_VARIANT)).booleanValue());
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("Digging", this.isDigging());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variant.byId(nbt.method_10550("Variant")));
        this.field_6011.method_12778(SNOWY_VARIANT, (Object)nbt.method_10577("IsSnowVariant"));
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setDigging(nbt.method_10577("Digging"));
    }

    public boolean isDigging() {
        return (Boolean)this.field_6011.method_12789(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.field_6011.method_12778(DIGGING, (Object)digging);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean isInSnowyBiome() {
        class_6880 biomeEntry = this.method_37908().method_23753(this.method_24515());
        return biomeEntry.method_40220(ConventionalBiomeTags.SNOWY);
    }

    public boolean isSnowVariant() {
        return this.field_6011.method_12789(SNOWY_VARIANT) != null && (Boolean)this.field_6011.method_12789(SNOWY_VARIANT) != false;
    }

    public void setSnowVariant(boolean isSnowy) {
        this.field_6011.method_12778(SNOWY_VARIANT, (Object)isSnowy);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.05, true));
        this.field_6201.method_6277(4, (class_1352)new DigGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1391((class_1314)this, 1.15, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8726}), false));
        this.field_6201.method_6277(6, (class_1352)new class_1341((class_1429)this, 1.05));
        this.field_6201.method_6277(7, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f, false));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new SleepGoal(200));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f){

            public boolean method_6264() {
                return !WeaselEntity.this.method_6113() && super.method_6264();
            }

            public boolean method_6266() {
                return !WeaselEntity.this.method_6113() && super.method_6266();
            }
        });
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this){

            public boolean method_6264() {
                return !WeaselEntity.this.method_6113() && super.method_6264();
            }

            public boolean method_6266() {
                return !WeaselEntity.this.method_6113() && super.method_6266();
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, new UntamedActiveTargetGoal<class_1428>(this, class_1428.class, true, null));
        this.field_6185.method_6277(5, new UntamedActiveTargetGoal<class_1463>(this, class_1463.class, true, null));
        this.field_6185.method_6277(6, new UntamedActiveTargetGoal<MouseEntity>(this, MouseEntity.class, true, null));
        this.field_6185.method_6277(7, new UntamedActiveTargetGoal<HedgehogEntity>(this, HedgehogEntity.class, true, null));
    }

    public void method_5980(@Nullable class_1309 target) {
        if (this.method_6181() && this.method_35057() != null && target == this.method_35057()) {
            return;
        }
        super.method_5980(target);
    }

    public boolean method_6121(class_1297 target) {
        boolean flag = target.method_5643(this.method_48923().method_48812((class_1309)this), (float)((int)this.method_26825(class_5134.field_23721)));
        if (target instanceof class_1428 || target instanceof class_1463 || target instanceof HedgehogEntity || target instanceof MouseEntity) {
            return super.method_6121(target);
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            if (!this.hasBittenPlayer) {
                if (this.method_6181() && this.method_6171((class_1309)player)) {
                    return false;
                }
                this.method_18799(this.method_18798().method_1031(0.0, 0.4, 0.0));
                this.method_5783(FaunifySounds.WEASEL_BITE, 1.0f, 1.0f);
                this.hasBittenPlayer = true;
                this.method_5980(null);
                this.method_6015(null);
                return super.method_6121(target);
            }
        }
        return flag;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        boolean result = super.method_5643(source, amount);
        if (this.method_6113()) {
            this.setSleeping(false);
        }
        if (!this.method_37908().field_9236) {
            this.method_24346(false);
        }
        if (this.method_6172()) {
            this.method_6179(false);
        }
        if ((class_12972 = source.method_5529()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!this.method_6181() || !this.method_6171((class_1309)player)) {
                this.method_5980((class_1309)source.method_5529());
            }
            this.hasBittenPlayer = false;
        }
        return result;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (this.method_37908().field_9236) {
            boolean flag = this.method_6171((class_1309)player) || this.method_6181() || item == class_1802.field_8504 && !this.method_6181();
            return flag ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (this.isDigging()) {
                return class_1269.field_5811;
            }
            if (this.method_6113()) {
                this.setSleeping(false);
                this.method_24346(true);
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            if (item == class_1802.field_8726 && this.method_6032() < this.method_6063()) {
                class_1937 class_19372;
                this.method_6025(3.0f);
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                if ((class_19372 = this.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    for (int i = 0; i < 5; ++i) {
                        double offsetX = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetY = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetZ = (this.field_5974.method_43058() - 0.5) * 1.0;
                        serverWorld.method_14199((class_2394)FaunifyParticleTypes.HEALTH, this.method_23317() + offsetX, this.method_23318() + (double)this.method_5751() + offsetY, this.method_23321() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
            if (this.method_6481(itemstack) && this.method_5618() == 0 && !this.method_6479()) {
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                this.method_6480(player);
                return class_1269.field_5812;
            }
            if (this.method_6481(itemstack) && this.method_6109()) {
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
                this.method_5620(class_1296.method_41321((int)(-this.method_5618())), true);
                class_1937 i = this.method_37908();
                if (i instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)i;
                    for (int i2 = 0; i2 < 7; ++i2) {
                        double d0 = this.field_5974.method_43059() * 0.02;
                        double d1 = this.field_5974.method_43059() * 0.02;
                        double d2 = this.field_5974.method_43059() * 0.02;
                        serverWorld.method_14199((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d0, d1, d2, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
            class_1269 interactionresult = super.method_5992(player, hand);
            if ((!interactionresult.method_23665() || this.method_6109()) && this.method_6171((class_1309)player)) {
                this.method_24346(!this.method_24345());
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            return interactionresult;
        }
        if (item == class_1802.field_8504) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0) {
                this.method_6170(player);
                this.method_6173(true);
                this.field_6189.method_6340();
                this.method_5980(null);
                this.method_24346(true);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8726;
    }

    @Nullable
    public WeaselEntity createChild(class_3218 world, class_1296 entity) {
        WeaselEntity babyWeasel = (WeaselEntity)FaunifyEntities.WEASEL.method_5883((class_1937)world);
        if (babyWeasel != null && entity instanceof WeaselEntity) {
            Variant selectedVariant;
            WeaselEntity parent = (WeaselEntity)entity;
            if (this.method_6181()) {
                babyWeasel.method_6174(this.method_6139());
                babyWeasel.method_6173(true);
            }
            boolean thisIsSnowy = this.isSnowVariant();
            boolean parentIsSnowy = parent.isSnowVariant();
            if (thisIsSnowy && parentIsSnowy) {
                babyWeasel.setSnowVariant(true);
                selectedVariant = Variant.STOAT;
            } else if (thisIsSnowy || parentIsSnowy) {
                babyWeasel.setSnowVariant(false);
                selectedVariant = thisIsSnowy ? parent.getVariant() : this.getVariant();
            } else {
                selectedVariant = this.method_6181() && parent.method_6181() && this.field_5974.method_43056() ? Variant.getRareBreedVariant(this.field_5974) : (this.field_5974.method_43056() ? this.getVariant() : parent.getVariant());
            }
            babyWeasel.setVariant(selectedVariant);
            babyWeasel.method_5971();
        }
        return babyWeasel;
    }

    protected class_3414 method_5994() {
        int soundIndex = this.field_5974.method_43048(3);
        switch (soundIndex) {
            case 0: {
                return FaunifySounds.WEASEL_IDLE_1;
            }
            case 1: {
                return FaunifySounds.WEASEL_IDLE_2;
            }
            case 2: {
                return FaunifySounds.WEASEL_IDLE_3;
            }
        }
        return FaunifySounds.WEASEL_IDLE_1;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.WEASEL_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<WeaselEntity> event) {
        class_1309 target = this.method_5968();
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
            target = null;
        }
        if (this.method_6113()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.method_6172()) {
            event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDigging()) {
            event.getController().setAnimation(RawAnimation.begin().then("dig", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (target instanceof class_1428 || target instanceof class_1463 || target instanceof HedgehogEntity || target instanceof MouseEntity) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        class_1657 player = this.method_37908().method_18460((class_1297)this, 10.0);
        if (player != null) {
            class_1799 heldItem = player.method_6047();
            return heldItem.method_7909() == class_1802.field_8726;
        }
        return false;
    }

    static class WeaselMoveControl
    extends class_1335 {
        private final WeaselEntity weasel;

        public WeaselMoveControl(WeaselEntity weaselEntity) {
            super((class_1308)weaselEntity);
            this.weasel = weaselEntity;
        }

        public void method_6240() {
            if (!this.weasel.method_6113()) {
                super.method_6240();
            }
        }
    }

    public static enum Variant implements class_3542
    {
        STOAT(0, "stoat", true),
        STEPPE(1, "steppe", true),
        EUROPEAN(2, "european", true),
        SIBERIAN(3, "siberian", true),
        YELLOWBELLIED(4, "yellowbellied", true),
        FERRETDARK(5, "ferretdark", false),
        FERRETLIGHT(6, "ferretlight", false);

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;
        private final boolean common;

        private Variant(int id, String name, boolean common) {
            this.id = id;
            this.name = name;
            this.common = common;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        public static Variant getCommonSpawnVariant(class_5819 random) {
            return Variant.getSpawnVariant(random, true);
        }

        public static Variant getRareBreedVariant(class_5819 random) {
            return Variant.getSpawnVariant(random, false);
        }

        private static Variant getSpawnVariant(class_5819 random, boolean isCommon) {
            Variant[] validVariants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.common == isCommon).toArray(Variant[]::new);
            return (Variant)((Object)class_156.method_27173((Object[])validVariants, (class_5819)random));
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }

    private class DigGoal
    extends class_1352 {
        private final WeaselEntity weasel;
        private class_1542 targetEgg;
        private static final double SEARCH_RADIUS = 5.0;
        private int diggingTime;
        private static final int DIGGING_DURATION = 25;
        private boolean hasPickedUpEgg = false;

        public DigGoal(WeaselEntity weasel) {
            this.weasel = weasel;
        }

        public boolean method_6264() {
            if (this.weasel.method_6172() || this.weasel.method_6113() || this.weasel.method_24345()) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.weasel.lastDigTime < DIG_COOLDOWN) {
                return false;
            }
            List nearbyItems = this.weasel.method_37908().method_8390(class_1542.class, this.weasel.method_5829().method_1014(5.0), itemEntity -> itemEntity.method_6983().method_31573(FaunifyItems.EGGS));
            if (!nearbyItems.isEmpty()) {
                this.targetEgg = (class_1542)nearbyItems.get(0);
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            return this.targetEgg != null && !this.weasel.method_6172() && !this.weasel.method_6113() && !this.weasel.method_24345();
        }

        public void method_6269() {
            this.diggingTime = 0;
            this.hasPickedUpEgg = false;
            this.weasel.method_5942().method_6335((class_1297)this.targetEgg, 1.0);
        }

        public void method_6268() {
            class_2338 weaselPos = this.weasel.method_24515().method_10074();
            class_2680 blockState = this.weasel.method_37908().method_8320(weaselPos);
            if (this.weasel.isDigging() && !blockState.method_26164(class_3481.field_29822) && !blockState.method_27852(class_2246.field_10255) && !blockState.method_26164(class_3481.field_15466)) {
                this.weasel.setDigging(false);
                this.weasel.method_5875(false);
                this.targetEgg = null;
                return;
            }
            if (blockState.method_26164(class_3481.field_29822) || blockState.method_27852(class_2246.field_10255) || blockState.method_26164(class_3481.field_15466)) {
                if (this.targetEgg != null && (double)this.weasel.method_5739((class_1297)this.targetEgg) < 1.0) {
                    this.targetEgg.method_31472();
                    if (!this.hasPickedUpEgg) {
                        this.weasel.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                        this.hasPickedUpEgg = true;
                    }
                    if (this.diggingTime == 0) {
                        this.weasel.method_5942().method_6340();
                        this.weasel.setDigging(true);
                    }
                    ++this.diggingTime;
                    class_1937 class_19372 = this.weasel.method_37908();
                    if (class_19372 instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)class_19372;
                        double d0 = WeaselEntity.this.field_5974.method_43059() * 0.01;
                        double d1 = WeaselEntity.this.field_5974.method_43059() * 0.01;
                        double d2 = WeaselEntity.this.field_5974.method_43059() * 0.01;
                        double offsetX = -Math.sin(Math.toRadians(this.weasel.method_36454())) * 0.5;
                        double offsetZ = Math.cos(Math.toRadians(this.weasel.method_36454())) * 0.5;
                        serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), this.weasel.method_23317() + offsetX, this.weasel.method_23318(), this.weasel.method_23321() + offsetZ, 2, d0, d1, d2, 0.1);
                        this.weasel.method_5783(class_3417.field_15211, 0.5f, 1.0f);
                    }
                    this.weasel.method_5875(true);
                    this.weasel.method_18800(0.0, 0.0, 0.0);
                    if (this.diggingTime >= 25) {
                        this.dropRandomLoot();
                        this.weasel.lastDigTime = System.currentTimeMillis();
                        this.targetEgg = null;
                        this.weasel.method_5875(false);
                        this.weasel.setDigging(false);
                    }
                } else if (this.targetEgg != null) {
                    this.weasel.method_5942().method_6335((class_1297)this.targetEgg, 1.0);
                }
            }
        }

        private void dropRandomLoot() {
            this.weasel.method_5783(class_3417.field_15211, 1.0f, 1.0f);
            class_1937 class_19372 = this.weasel.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_2960 lootTableLocation = new class_2960("faunify", "gameplay/weasel_dig");
                class_52 lootTable = serverWorld.method_8503().method_3857().getLootTable(lootTableLocation);
                class_8567 lootParams = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)this.weasel.method_19538()).method_51874(class_181.field_1226, (Object)this.weasel).method_51875(class_173.field_16235);
                lootTable.method_51878(lootParams).forEach(itemStack -> this.weasel.method_5775((class_1799)itemStack));
            }
        }
    }

    public class SleepGoal
    extends class_1352 {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = WeaselEntity.this.field_5974.method_43048(SleepGoal.method_38848((int)countdownTime));
            this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
        }

        public boolean method_6264() {
            if (WeaselEntity.this.method_5799()) {
                return false;
            }
            if (WeaselEntity.this.field_6212 == 0.0f && WeaselEntity.this.field_6227 == 0.0f && WeaselEntity.this.field_6250 == 0.0f) {
                return this.canSleep() || WeaselEntity.this.method_6113();
            }
            return false;
        }

        public boolean method_6266() {
            if (WeaselEntity.this.method_5799()) {
                return false;
            }
            if (WeaselEntity.this.method_6181() && !WeaselEntity.this.method_6172()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return WeaselEntity.this.method_37908().method_23886();
        }

        public void method_6270() {
            WeaselEntity.this.setSleeping(false);
            this.countdown = WeaselEntity.this.field_5974.method_43048(this.countdownTime);
        }

        public void method_6269() {
            WeaselEntity.this.method_6100(false);
            WeaselEntity.this.setSleeping(true);
            WeaselEntity.this.method_5942().method_6340();
            WeaselEntity.this.method_5962().method_6239(WeaselEntity.this.method_23317(), WeaselEntity.this.method_23318(), WeaselEntity.this.method_23321(), 0.0);
        }
    }

    public static class UntamedActiveTargetGoal<T extends class_1309>
    extends class_1400<T> {
        private final class_1321 tameable;

        public UntamedActiveTargetGoal(class_1321 tameable, Class<T> targetClass, boolean checkVisibility, @Nullable Predicate<class_1309> targetPredicate) {
            super((class_1308)tameable, targetClass, checkVisibility, targetPredicate);
            this.tameable = tameable;
        }

        public boolean method_6264() {
            return !this.tameable.method_6181() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.tameable.method_6181() && super.method_6266();
        }
    }
}

