/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1367;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WeevilEntity
extends class_1429
implements GeoEntity {
    private static final int EAT_DELAY = 20;
    private static final int EATING_DURATION = 80;
    private static final float BUOYANCY = 0.03f;
    private static final double CLIMB_SPEED = 0.1;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(WeevilEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(WeevilEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> EATING = class_2945.method_12791(WeevilEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private class_1408 groundNavigation;
    private class_243 prevPosition = class_243.field_1353;
    private double actualMovementSpeed = 0.0;
    int moreCropTicks;
    private int eatingAnimationTick;
    private class_2338 targetCropPos;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private class_2338 lastClimbPos;

    public WeevilEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, 16.0f);
        this.method_5941(class_7.field_3, -1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.2);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new RaidCropsGoal(this));
        this.field_6201.method_6277(2, (class_1352)new CropTemptGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(4, (class_1352)new GroundLookAroundGoal((class_1308)this));
    }

    public static boolean canSpawn(class_1299<WeevilEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_20663(entityType, (class_1936)level, (class_3730)spawnType, (class_2338)position, (class_5819)random);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return spawnData;
    }

    public void method_5773() {
        class_2338 currentPos;
        boolean shouldClimb;
        super.method_5773();
        if (this.isEating()) {
            this.method_18799(class_243.field_1353);
            this.field_6189.method_6340();
        }
        if (this.method_5799()) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, motion.field_1351 + (double)0.03f, motion.field_1350);
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.field_5976 && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.method_6101()) {
            currentPos = this.method_24515();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.method_37908().field_9236) {
                    this.field_6189.method_6340();
                    this.field_6201.method_19048().forEach(goal -> goal.method_6270());
                }
            } else if (this.field_5976) {
                boolean hasBlockAbove;
                class_243 deltaMovement = this.method_18798();
                boolean shouldApplyClimbMovement = true;
                if (this.method_24828() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.method_18800(deltaMovement.field_1352, 0.1, deltaMovement.field_1350);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.method_19538();
        this.actualMovementSpeed = currentPos.method_1022(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.method_37908().field_9236) {
            this.setClimbing(shouldClimb);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.moreCropTicks > 0) {
            this.moreCropTicks -= this.field_5974.method_43048(3);
            if (this.moreCropTicks < 0) {
                this.moreCropTicks = 0;
            }
        }
        if (this.eatingAnimationTick > 0) {
            --this.eatingAnimationTick;
            if (this.targetCropPos != null) {
                this.method_5988().method_20248((double)this.targetCropPos.method_10263() + 0.5, (double)this.targetCropPos.method_10264() + 0.5, (double)this.targetCropPos.method_10260() + 0.5);
            }
            if (this.eatingAnimationTick == 0) {
                this.setEating(false);
                if (this.targetCropPos != null && !this.method_37908().field_9236) {
                    this.breakCropAtPosition(this.targetCropPos);
                    this.targetCropPos = null;
                }
            }
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1409 navigation = new class_1409((class_1308)this, level);
        navigation.method_6354(true);
        this.groundNavigation = navigation;
        return navigation;
    }

    public float method_6144(class_2338 pos, class_4538 level) {
        class_2680 blockstate = level.method_8320(pos.method_10074());
        class_2680 currentState = level.method_8320(pos);
        if (currentState.method_26164(class_3481.field_20341) || blockstate.method_26164(class_3481.field_20341)) {
            return 15.0f;
        }
        return super.method_6144(pos, level);
    }

    protected float method_23326() {
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        class_2680 stateBelow = this.method_37908().method_8320(pos.method_10074());
        if (state.method_27852(class_2246.field_10362) || state.method_26164(class_3481.field_20341) || stateBelow.method_27852(class_2246.field_10362) || stateBelow.method_26164(class_3481.field_20341)) {
            return 1.0f;
        }
        return super.method_23326();
    }

    public class_1296 method_5613(class_3218 serverLevel, class_1296 otherParent) {
        return null;
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.BUG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return FaunifySounds.BUG_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<WeevilEntity> event) {
        boolean eating = this.isEating();
        boolean climbing = this.method_6101();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.method_24828();
        if (eating) {
            event.getController().setAnimation(RawAnimation.begin().then("eat", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10569("MoreCropTicks", this.moreCropTicks);
        tag.method_10569("EatingAnimationTick", this.eatingAnimationTick);
        tag.method_10569("ClimbingTime", this.climbingTime);
        tag.method_10569("ClimbCooldown", this.climbCooldown);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        this.moreCropTicks = tag.method_10550("MoreCropTicks");
        this.eatingAnimationTick = tag.method_10550("EatingAnimationTick");
        this.climbingTime = tag.method_10550("ClimbingTime");
        this.climbCooldown = tag.method_10550("ClimbCooldown");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
        this.field_6011.method_12784(EATING, (Object)false);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_6101() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)flags);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    protected float method_6106() {
        return 0.0f;
    }

    public void method_6100(boolean jumping) {
        super.method_6100(false);
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(EATING);
    }

    public void setEating(boolean eating) {
        this.field_6011.method_12778(EATING, (Object)eating);
    }

    public boolean isActuallyMoving() {
        class_243 delta = this.method_18798();
        double horizontalSpeed = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        if (!state.method_26215() && !state.method_45474()) {
            return true;
        }
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        class_2338 east = pos.method_10078();
        class_2338 west = pos.method_10067();
        boolean bl = hasAdjacentAtCurrentLevel = !this.method_37908().method_8320(north).method_26215() && !this.method_37908().method_8320(north).method_45474() || !this.method_37908().method_8320(south).method_26215() && !this.method_37908().method_8320(south).method_45474() || !this.method_37908().method_8320(east).method_26215() && !this.method_37908().method_8320(east).method_45474() || !this.method_37908().method_8320(west).method_26215() && !this.method_37908().method_8320(west).method_45474();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        class_2338 posBelow = pos.method_10074();
        class_2338 northBelow = posBelow.method_10095();
        class_2338 southBelow = posBelow.method_10072();
        class_2338 eastBelow = posBelow.method_10078();
        class_2338 westBelow = posBelow.method_10067();
        return !this.method_37908().method_8320(northBelow).method_26215() && !this.method_37908().method_8320(northBelow).method_45474() || !this.method_37908().method_8320(southBelow).method_26215() && !this.method_37908().method_8320(southBelow).method_45474() || !this.method_37908().method_8320(eastBelow).method_26215() && !this.method_37908().method_8320(eastBelow).method_45474() || !this.method_37908().method_8320(westBelow).method_26215() && !this.method_37908().method_8320(westBelow).method_45474();
    }

    boolean wantsMoreFood() {
        return this.moreCropTicks <= 0;
    }

    public boolean canBlockBeSeen(class_2338 pos) {
        class_243 eyePos = new class_243(this.method_23317(), this.method_23320(), this.method_23321());
        class_243 blockVec = class_243.method_24953((class_2382)pos);
        class_3965 result = this.method_37908().method_17742(new class_3959(eyePos, blockVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        return result.method_17777().equals((Object)pos);
    }

    private void breakCropAtPosition(class_2338 cropPos) {
        class_1937 level = this.method_37908();
        class_2680 blockstate = level.method_8320(cropPos);
        class_2248 block = blockstate.method_26204();
        if (blockstate.method_26164(class_3481.field_20341)) {
            if (block instanceof class_2302) {
                class_2302 cropBlock = (class_2302)block;
                int age = cropBlock.method_9829(blockstate);
                if (age == 0) {
                    level.method_8651(cropPos, true, (class_1297)this);
                } else {
                    level.method_8652(cropPos, cropBlock.method_9828(age - 1), 2);
                    level.method_20290(2001, cropPos, class_2248.method_9507((class_2680)blockstate));
                }
            } else {
                level.method_8651(cropPos, true, (class_1297)this);
            }
            this.moreCropTicks = 20;
        }
    }

    static class RaidCropsGoal
    extends class_1367 {
        private final WeevilEntity weevil;
        private boolean wantsToRaid;
        private boolean canRaid;
        private boolean isAtDestination;

        public RaidCropsGoal(WeevilEntity weevil) {
            super((class_1314)weevil, 1.0, 32, 8);
            this.weevil = weevil;
        }

        private class_2338 findNearbyCrops() {
            class_2680 cropState;
            class_2338 belowPos;
            class_2338 currentPos = this.weevil.method_24515();
            class_1937 level = this.weevil.method_37908();
            if (level.method_8320(belowPos = currentPos.method_10074()).method_27852(class_2246.field_10362) && (cropState = level.method_8320(currentPos)).method_26164(class_3481.field_20341) && this.weevil.canBlockBeSeen(currentPos)) {
                return belowPos;
            }
            if (level.method_8320(currentPos).method_26164(class_3481.field_20341) && level.method_8320(belowPos).method_27852(class_2246.field_10362) && this.weevil.canBlockBeSeen(currentPos)) {
                return belowPos;
            }
            for (class_2338 checkPos : new class_2338[]{currentPos.method_10095(), currentPos.method_10072(), currentPos.method_10078(), currentPos.method_10067()}) {
                class_2680 cropState2;
                if (!level.method_8320(checkPos).method_27852(class_2246.field_10362) || !(cropState2 = level.method_8320(checkPos.method_10084())).method_26164(class_3481.field_20341) || !this.weevil.canBlockBeSeen(checkPos.method_10084())) continue;
                return checkPos;
            }
            return null;
        }

        public boolean method_6264() {
            if (this.weevil.isEating()) {
                return false;
            }
            if (!this.weevil.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                return false;
            }
            this.wantsToRaid = this.weevil.wantsMoreFood();
            if (!this.wantsToRaid) {
                return false;
            }
            class_2338 nearbyCrop = this.findNearbyCrops();
            if (nearbyCrop != null) {
                this.field_6512 = nearbyCrop;
                this.canRaid = true;
                this.isAtDestination = true;
                this.field_6518 = 0;
                return true;
            }
            if (this.field_6518 > 0) {
                return false;
            }
            this.canRaid = false;
            return super.method_6264();
        }

        public boolean method_6266() {
            class_2338 nearbyCrop;
            if (this.weevil.isEating()) {
                return true;
            }
            if (this.wantsToRaid && !this.canRaid && (nearbyCrop = this.findNearbyCrops()) != null) {
                this.field_6512 = nearbyCrop;
                this.canRaid = true;
                this.isAtDestination = true;
                return true;
            }
            return this.canRaid && super.method_6266();
        }

        public void method_6270() {
            super.method_6270();
            this.isAtDestination = false;
        }

        public void method_6268() {
            if (this.field_6512 == null) {
                return;
            }
            class_2338 targetPos = this.field_6512;
            if (!this.weevil.isEating()) {
                if (!this.isWithinXZDist(targetPos, this.field_6516.method_19538(), 1.5)) {
                    this.isAtDestination = false;
                    ++this.field_6517;
                    this.field_6516.method_5942().method_6337((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264(), (double)targetPos.method_10260() + 0.5, this.field_6514);
                } else {
                    this.isAtDestination = true;
                    --this.field_6517;
                }
            }
            if (this.method_6295()) {
                class_1937 level = this.weevil.method_37908();
                class_2338 cropPos = targetPos.method_10084();
                class_2680 cropState = level.method_8320(cropPos);
                if (this.canRaid && cropState.method_26164(class_3481.field_20341)) {
                    if (this.weevil.eatingAnimationTick == 0 && !this.weevil.isEating()) {
                        this.weevil.setEating(true);
                        this.weevil.eatingAnimationTick = 80;
                        this.weevil.targetCropPos = cropPos;
                    }
                    if (this.weevil.eatingAnimationTick > 0) {
                        return;
                    }
                }
                this.canRaid = false;
                this.field_6518 = 10;
            }
        }

        private boolean isWithinXZDist(class_2338 blockpos, class_243 posVec, double dist) {
            double dz;
            double dx = (double)blockpos.method_10263() + 0.5 - posVec.field_1352;
            return dx * dx + (dz = (double)blockpos.method_10260() + 0.5 - posVec.field_1350) * dz < dist * dist;
        }

        protected boolean method_6295() {
            return this.isAtDestination;
        }

        protected boolean method_6296(class_4538 level, class_2338 pos) {
            class_2680 cropState;
            class_2680 farmlandState = level.method_8320(pos);
            if (farmlandState.method_27852(class_2246.field_10362) && this.wantsToRaid && !this.canRaid && (cropState = level.method_8320(pos.method_10084())).method_26164(class_3481.field_20341) && this.weevil.canBlockBeSeen(pos.method_10084())) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    static class CropTemptGoal
    extends class_1352 {
        private final WeevilEntity weevil;
        private final double speedModifier;
        private class_2338 targetCropPos;
        private int cooldown;
        private static final int SEARCH_RANGE = 10;
        private static final int COOLDOWN_TICKS = 100;

        public CropTemptGoal(WeevilEntity weevil, double speed) {
            this.weevil = weevil;
            this.speedModifier = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.weevil.isEating()) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.targetCropPos = this.findNearbyCrop();
            return this.targetCropPos != null;
        }

        public boolean method_6266() {
            if (this.weevil.isEating()) {
                return false;
            }
            if (this.targetCropPos == null) {
                return false;
            }
            class_2680 state = this.weevil.method_37908().method_8320(this.targetCropPos);
            if (!state.method_26164(class_3481.field_20341)) {
                return false;
            }
            double distSq = this.weevil.method_19538().method_1025(class_243.method_24953((class_2382)this.targetCropPos));
            return distSq > 4.0 && distSq < 100.0;
        }

        public void method_6269() {
            if (this.targetCropPos != null) {
                this.weevil.method_5942().method_6337((double)this.targetCropPos.method_10263() + 0.5, (double)this.targetCropPos.method_10264(), (double)this.targetCropPos.method_10260() + 0.5, this.speedModifier);
            }
        }

        public void method_6270() {
            this.targetCropPos = null;
            this.cooldown = 100;
            this.weevil.method_5942().method_6340();
        }

        public void method_6268() {
            if (this.targetCropPos != null) {
                this.weevil.method_5988().method_20248((double)this.targetCropPos.method_10263() + 0.5, (double)this.targetCropPos.method_10264() + 0.5, (double)this.targetCropPos.method_10260() + 0.5);
                if (this.weevil.method_19538().method_1025(class_243.method_24953((class_2382)this.targetCropPos)) < 6.25) {
                    this.weevil.method_5942().method_6337((double)this.targetCropPos.method_10263() + 0.5, (double)this.targetCropPos.method_10264(), (double)this.targetCropPos.method_10260() + 0.5, this.speedModifier);
                }
            }
        }

        @Nullable
        private class_2338 findNearbyCrop() {
            class_2338 weevilPos = this.weevil.method_24515();
            class_1937 level = this.weevil.method_37908();
            class_2338 bestCrop = null;
            double closestDist = Double.MAX_VALUE;
            for (int x = -10; x <= 10; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -10; z <= 10; ++z) {
                        double dist;
                        class_2338 checkPos = weevilPos.method_10069(x, y, z);
                        class_2680 state = level.method_8320(checkPos);
                        if (!state.method_26164(class_3481.field_20341) || !((dist = weevilPos.method_10262((class_2382)checkPos)) > 4.0) || !(dist < closestDist)) continue;
                        closestDist = dist;
                        bestCrop = checkPos;
                    }
                }
            }
            return bestCrop;
        }
    }

    public static enum Variant implements class_3542
    {
        ACORN(0, "acorn"),
        COMMON(1, "common"),
        GROUND(2, "ground");

        public static final class_3542.class_7292<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }
}

