/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.BeeflyEntity;
import com.pepper.faunify.entity.client.model.BeeflyModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BeeflyRenderer
extends GeoEntityRenderer<BeeflyEntity> {
    private static final class_2960 TEXTURE = new class_2960("faunify", "textures/entity/beefly.png");
    private static final class_2960 PHOBIA_TEXTURE = new class_2960("faunify", "textures/entity/phobiafriendly/beefly.png");
    private static final int SOUND_INTERVAL_TICKS = 6;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> soundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public BeeflyRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, (GeoModel)new BeeflyModel());
        this.field_4673 = 0.4f;
    }

    public class_2960 getTextureLocation(BeeflyEntity entity) {
        return FaunifyClientConfig.beeflyPhobiaFriendly ? PHOBIA_TEXTURE : TEXTURE;
    }

    public void preRender(class_4587 poseStack, BeeflyEntity animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            BeeflyRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && animatable.isFlying() && !FaunifyClientConfig.beeflyPhobiaFriendly) {
            UUID uuid = animatable.method_5667();
            int currentTick = animatable.field_6012;
            Integer lastSoundTick = soundTimers.get(uuid);
            if (lastSoundTick == null || currentTick - lastSoundTick >= 6) {
                animatable.method_37908().method_8486(animatable.method_23317(), animatable.method_23318(), animatable.method_23321(), FaunifySounds.BUG_FLY_FAST, animatable.method_5634(), 0.1f, 1.75f, false);
                soundTimers.put(uuid, currentTick);
            }
        } else if (!animatable.isFlying()) {
            soundTimers.remove(animatable.method_5667());
        }
        float bugScale = 1.0f;
        poseStack.method_22905(bugScale, bugScale, bugScale);
    }

    private static void cleanupStaleEntries() {
        if (soundTimers.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            soundTimers.clear();
            return;
        }
        Iterator<UUID> iterator = soundTimers.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (mc.field_1687.method_8469(uuid.hashCode()) != null) continue;
            iterator.remove();
        }
    }
}

