/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.BeetleEntity;
import com.pepper.faunify.entity.client.model.BeetleModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BeetleRenderer
extends GeoEntityRenderer<BeetleEntity> {
    private static final class_2960 ATLAS = new class_2960("faunify", "textures/entity/bigbeetle_atlas.png");
    private static final class_2960 DYNASTID = new class_2960("faunify", "textures/entity/bigbeetle_dynastid.png");
    private static final class_2960 ELEPHANT = new class_2960("faunify", "textures/entity/bigbeetle_elephant.png");
    private static final class_2960 GOLIATH = new class_2960("faunify", "textures/entity/bigbeetle_goliath.png");
    private static final class_2960 HERCULES = new class_2960("faunify", "textures/entity/bigbeetle_hercules.png");
    private static final class_2960 CYCLOMMATUS = new class_2960("faunify", "textures/entity/smallbeetle_cyclommatus.png");
    private static final class_2960 GIANT = new class_2960("faunify", "textures/entity/smallbeetle_giant.png");
    private static final class_2960 GIRAFFE = new class_2960("faunify", "textures/entity/smallbeetle_giraffe.png");
    private static final class_2960 MIYAMA = new class_2960("faunify", "textures/entity/smallbeetle_miyama.png");
    private static final class_2960 RAINBOW = new class_2960("faunify", "textures/entity/smallbeetle_rainbow.png");
    private static final class_2960 SAW = new class_2960("faunify", "textures/entity/smallbeetle_saw.png");
    private static final class_2960 GOLDEN = new class_2960("faunify", "textures/entity/smallbeetle_golden.png");
    private static final class_2960 PHOBIA_TEXTURE = new class_2960("faunify", "textures/entity/phobiafriendly/beetle.png");
    private static final class_2960 PEST = new class_2960("faunify", "textures/entity/bigbeetle_pest.png");
    private static final int SOUND_INTERVAL_TICKS = 15;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> soundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public BeetleRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, (GeoModel)new BeetleModel());
        this.field_4673 = 0.45f;
    }

    public class_2960 getTextureLocation(BeetleEntity entity) {
        if (FaunifyClientConfig.beetlePhobiaFriendly) {
            return PHOBIA_TEXTURE;
        }
        String entityName = entity.method_5477().getString().toLowerCase();
        if ("pest".equals(entityName)) {
            return PEST;
        }
        return BeetleRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(class_4587 poseStack, BeetleEntity animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            BeetleRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && animatable.isFlying() && !FaunifyClientConfig.beetlePhobiaFriendly) {
            UUID uuid = animatable.method_5667();
            int currentTick = animatable.field_6012;
            Integer lastSoundTick = soundTimers.get(uuid);
            if (lastSoundTick == null || currentTick - lastSoundTick >= 15) {
                animatable.method_37908().method_8486(animatable.method_23317(), animatable.method_23318(), animatable.method_23321(), FaunifySounds.BUG_FLY_FAST_TACKY, animatable.method_5634(), 0.25f, 1.0f, false);
                soundTimers.put(uuid, currentTick);
            }
        } else if (!animatable.isFlying()) {
            soundTimers.remove(animatable.method_5667());
        }
        float bugScale = 0.9f;
        poseStack.method_22905(bugScale, bugScale, bugScale);
    }

    public static class_2960 getVariantTexture(BeetleEntity.Variant variant) {
        switch (variant) {
            case ATLAS: {
                return ATLAS;
            }
            case DYNASTID: {
                return DYNASTID;
            }
            case ELEPHANT: {
                return ELEPHANT;
            }
            case GOLIATH: {
                return GOLIATH;
            }
            case HERCULES: {
                return HERCULES;
            }
            case CYCLOMMATUS: {
                return CYCLOMMATUS;
            }
            case GIANT: {
                return GIANT;
            }
            case GIRAFFE: {
                return GIRAFFE;
            }
            case MIYAMA: {
                return MIYAMA;
            }
            case RAINBOW: {
                return RAINBOW;
            }
            case SAW: {
                return SAW;
            }
            case GOLDEN: {
                return GOLDEN;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private static void cleanupStaleEntries() {
        if (soundTimers.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            soundTimers.clear();
            return;
        }
        Iterator<UUID> iterator = soundTimers.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (mc.field_1687.method_8469(uuid.hashCode()) != null) continue;
            iterator.remove();
        }
    }
}

