/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.DragonflyEntity;
import com.pepper.faunify.entity.client.model.DragonflyModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class DragonflyRenderer
extends GeoEntityRenderer<DragonflyEntity> {
    private static final class_2960 WHITETAIL = new class_2960("faunify", "textures/entity/dragonfly_whitetail.png");
    private static final class_2960 DARNER = new class_2960("faunify", "textures/entity/dragonfly_darner.png");
    private static final class_2960 SKIMMER = new class_2960("faunify", "textures/entity/dragonfly_skimmer.png");
    private static final class_2960 DAMSEL = new class_2960("faunify", "textures/entity/dragonfly_damsel.png");
    private static final class_2960 PETALTAIL = new class_2960("faunify", "textures/entity/dragonfly_petaltail.png");
    private static final class_2960 PHOBIA_TEXTURE = new class_2960("faunify", "textures/entity/phobiafriendly/dragonfly.png");
    private static final int CONTINUOUS_SOUND_INTERVAL = 10;
    private static final int FLAP_SOUND_INTERVAL = 10;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> continuousSoundTimers = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> flapSoundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public DragonflyRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, (GeoModel)new DragonflyModel());
        this.field_4673 = 0.4f;
    }

    public class_2960 getTextureLocation(DragonflyEntity entity) {
        if (FaunifyClientConfig.dragonflyPhobiaFriendly) {
            return PHOBIA_TEXTURE;
        }
        return DragonflyRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(class_4587 poseStack, DragonflyEntity animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            DragonflyRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && animatable.isFlying() && !FaunifyClientConfig.dragonflyPhobiaFriendly) {
            UUID uuid = animatable.method_5667();
            int currentTick = animatable.field_6012;
            Integer lastContinuousTick = continuousSoundTimers.get(uuid);
            if (lastContinuousTick == null || currentTick - lastContinuousTick >= 10) {
                animatable.method_37908().method_8486(animatable.method_23317(), animatable.method_23318(), animatable.method_23321(), FaunifySounds.BUG_FLY_FAST_TACKY, animatable.method_5634(), 0.08f, 0.8f, false);
                continuousSoundTimers.put(uuid, currentTick);
            }
            if (!animatable.isHovering()) {
                Integer lastFlapTick = flapSoundTimers.get(uuid);
                if (lastFlapTick == null || currentTick - lastFlapTick >= 10) {
                    animatable.method_37908().method_8486(animatable.method_23317(), animatable.method_23318(), animatable.method_23321(), FaunifySounds.BUG_FLY_FAST_TACKY, animatable.method_5634(), 0.3f, 1.5f, false);
                    flapSoundTimers.put(uuid, currentTick);
                }
            } else {
                flapSoundTimers.remove(uuid);
            }
        } else if (!animatable.isFlying()) {
            continuousSoundTimers.remove(animatable.method_5667());
            flapSoundTimers.remove(animatable.method_5667());
        }
        float bugScale = 0.9f;
        poseStack.method_22905(bugScale, bugScale, bugScale);
    }

    public static class_2960 getVariantTexture(DragonflyEntity.Variant variant) {
        switch (variant) {
            case WHITETAIL: {
                return WHITETAIL;
            }
            case DARNER: {
                return DARNER;
            }
            case SKIMMER: {
                return SKIMMER;
            }
            case DAMSEL: {
                return DAMSEL;
            }
            case PETALTAIL: {
                return PETALTAIL;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private static void cleanupStaleEntries() {
        if (continuousSoundTimers.isEmpty() && flapSoundTimers.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            continuousSoundTimers.clear();
            flapSoundTimers.clear();
            return;
        }
        Iterator<UUID> continuousIterator = continuousSoundTimers.keySet().iterator();
        while (continuousIterator.hasNext()) {
            UUID uuid = continuousIterator.next();
            if (mc.field_1687.method_8469(uuid.hashCode()) != null) continue;
            continuousIterator.remove();
        }
        Iterator<UUID> flapIterator = flapSoundTimers.keySet().iterator();
        while (flapIterator.hasNext()) {
            UUID uuid = flapIterator.next();
            if (mc.field_1687.method_8469(uuid.hashCode()) != null) continue;
            flapIterator.remove();
        }
    }
}

